/*
 * Decompiled with CFR 0.152.
 */
package net.kaneka.planttech2.addons.jei;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.kaneka.planttech2.addons.jei.PT2SimpleJeiRecipe;
import net.kaneka.planttech2.blocks.GrowingBlock;
import net.kaneka.planttech2.crops.CropConfiguration;
import net.kaneka.planttech2.crops.CropTypes;
import net.kaneka.planttech2.crops.ParentPair;
import net.kaneka.planttech2.items.KnowledgeChip;
import net.kaneka.planttech2.items.MachineBulbItem;
import net.kaneka.planttech2.recipes.ModRecipeTypes;
import net.kaneka.planttech2.recipes.recipeclasses.ChipalyzerRecipe;
import net.kaneka.planttech2.recipes.recipeclasses.CompressorRecipe;
import net.kaneka.planttech2.recipes.recipeclasses.InfuserRecipe;
import net.kaneka.planttech2.registries.ModBlocks;
import net.kaneka.planttech2.registries.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.RegistryObject;

public class PlantTech2JEI {
    public static List<ChipalyzerRecipe> chipalyzerRecipes() {
        return PlantTech2JEI.getRecipes((RecipeType)ModRecipeTypes.CHIPALYZER.get());
    }

    public static List<CompressorRecipe> compressorRecipes() {
        return PlantTech2JEI.getRecipes((RecipeType)ModRecipeTypes.COMPRESSING.get());
    }

    public static List<InfuserRecipe> infuserRecipes() {
        return PlantTech2JEI.getRecipes((RecipeType)ModRecipeTypes.INFUSING.get());
    }

    public static List<PT2SimpleJeiRecipe> getCrossbreedingRecipes() {
        ArrayList<PT2SimpleJeiRecipe> recipes = new ArrayList<PT2SimpleJeiRecipe>();
        for (CropConfiguration config : CropTypes.configs()) {
            if (!config.shouldBeInGame() || config.getParents().isEmpty()) continue;
            ItemStack output = config.getPrimarySeed().getItemStack();
            for (ParentPair parent : config.getParents()) {
                recipes.add(PT2SimpleJeiRecipe.of().inputs(parent.getFirstParent().getConfig().getPrimarySeed().getItemStack(), parent.getSecondParent().getConfig().getPrimarySeed().getItemStack()).outputs(output).build());
            }
        }
        return recipes;
    }

    public static List<PT2SimpleJeiRecipe> getCarverRecipes() {
        return ImmutableList.of((Object)PT2SimpleJeiRecipe.of().inputs(new ItemStack((ItemLike)Blocks.f_50075_)).outputs(new ItemStack((ItemLike)ModBlocks.MACHINESHELL_IRON.get())).build(), (Object)PT2SimpleJeiRecipe.of().inputs(new ItemStack((ItemLike)ModBlocks.PLANTIUM_BLOCK.get())).outputs(new ItemStack((ItemLike)ModBlocks.MACHINESHELL_PLANTIUM.get())).build());
    }

    public static List<PT2SimpleJeiRecipe> getMachinebulbReprocessorRecipes() {
        ArrayList<PT2SimpleJeiRecipe> recipes = new ArrayList<PT2SimpleJeiRecipe>();
        for (RegistryObject<Item> obj : ModItems.MACHINE_BULBS) {
            MachineBulbItem bulb = (MachineBulbItem)((Object)obj.get());
            recipes.add(PT2SimpleJeiRecipe.of().inputs(KnowledgeChip.getByTier(bulb.getTier())).outputs(new ItemStack((ItemLike)bulb)).biomass(bulb.getNeededBiomass()).build());
        }
        return recipes;
    }

    public static List<PT2SimpleJeiRecipe> getMachineGrowingRecipes() {
        ArrayList<PT2SimpleJeiRecipe> recipes = new ArrayList<PT2SimpleJeiRecipe>();
        for (RegistryObject<Item> obj : ModItems.MACHINE_BULBS) {
            MachineBulbItem bulb = (MachineBulbItem)((Object)obj.get());
            recipes.add(PT2SimpleJeiRecipe.of().inputs(new ItemStack((ItemLike)bulb), new ItemStack((ItemLike)bulb.getHull())).outputs(new ItemStack((ItemLike)((GrowingBlock)bulb.getMachine()).blockSupplier.get())).build());
        }
        return recipes;
    }

    public static <R extends Recipe<?>> List<R> getRecipes(RecipeType<R> recipeType) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return Collections.emptyList();
        }
        List recipes = level.m_7465_().m_44051_().stream().filter(recipe -> recipe.m_6671_() == recipeType).collect(ArrayList::new, (list, recipe) -> list.add(recipe), ArrayList::addAll);
        recipes.sort(Comparator.comparing(recipe -> recipe.m_6423_().m_135815_()));
        return recipes;
    }
}

