/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mowmaster.mowlib.MowLibUtils.MowLibCompoundTagUtils;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import com.mowmaster.pedestals.Registry.DeferredRegisterItems;
import java.util.Collection;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ObjectHolder;
import org.jetbrains.annotations.Nullable;

public class UpgradeModificationRecipe
implements Recipe<Container> {
    @ObjectHolder(registryName="forge:recipe_serializer", value="pedestals:upgrademodification")
    private final String group;
    private final ResourceLocation id;
    @Nullable
    private final Ingredient upgradeInput;
    private final Ingredient infusionInputIngredients;
    private final String resultModificationName;
    private final int resultModificationValue;
    private final int resultModificationMaxValue;

    public UpgradeModificationRecipe(ResourceLocation id, String group, @Nullable Ingredient upgradeInput, @Nullable Ingredient infusionInputIngredients, String resultModificationName, int resultModificationValue, int resultModificationMaxValue) {
        this.group = group;
        this.id = id;
        this.upgradeInput = upgradeInput;
        this.infusionInputIngredients = infusionInputIngredients;
        this.resultModificationName = resultModificationName;
        this.resultModificationValue = resultModificationValue;
        this.resultModificationMaxValue = resultModificationMaxValue;
    }

    public boolean m_5598_() {
        return true;
    }

    public static Collection<UpgradeModificationRecipe> getAllRecipes(Level world) {
        return world.m_7465_().m_44013_((RecipeType)Type.INSTANCE);
    }

    public String m_6076_() {
        return this.group;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList allIngredients = NonNullList.m_122779_();
        allIngredients.add((Object)(this.upgradeInput != null ? this.upgradeInput : Ingredient.f_43901_));
        allIngredients.add((Object)(this.infusionInputIngredients != null ? this.infusionInputIngredients : Ingredient.f_43901_));
        return allIngredients;
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        int i;
        ItemStack[] stacks = this.infusionInputIngredients.m_43908_();
        if (inv.m_6643_() < stacks.length) {
            return false;
        }
        int matchCounter = 0;
        for (i = 0; i < stacks.length; ++i) {
            if (stacks[i].m_41619_() && inv.m_8020_(i + 1).m_41619_()) {
                ++matchCounter;
                continue;
            }
            if (!stacks[i].m_150930_(inv.m_8020_(i + 1).m_41720_())) continue;
            ++matchCounter;
        }
        if (stacks.length < inv.m_6643_()) {
            for (i = stacks.length + 1; i < inv.m_6643_(); ++i) {
                if (inv.m_8020_(i).m_41619_()) continue;
                ++matchCounter;
            }
        }
        return this.upgradeInput.test(inv.m_8020_(0)) && matchCounter == stacks.length;
    }

    public ItemStack m_5874_(Container p_44001_, RegistryAccess p_267165_) {
        return this.getResultItem().m_41777_();
    }

    public ItemStack m_8043_(RegistryAccess p_267052_) {
        return new ItemStack((ItemLike)Items.f_42127_);
    }

    public ItemStack getResultItem() {
        return new ItemStack((ItemLike)Items.f_42127_);
    }

    public String getResultModificationName() {
        return this.resultModificationName;
    }

    public int getResultModificationAmount() {
        return this.resultModificationValue;
    }

    public int getResultModificationMaxAmount() {
        return this.resultModificationMaxValue;
    }

    public boolean getResultingModifiedItem(ItemStack inputUpgradeStack) {
        ItemUpgradeBase baseUpgrade;
        Item item = inputUpgradeStack.m_41720_();
        if (item instanceof ItemUpgradeBase && (baseUpgrade = (ItemUpgradeBase)item).canAddModifierToUpgrade(inputUpgradeStack, this.getResultModificationName())) {
            int value = MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)inputUpgradeStack.m_41784_(), (String)this.getResultModificationName());
            if (value >= this.getResultModificationMaxAmount()) {
                return false;
            }
            int newValue = value + this.getResultModificationAmount();
            if (newValue > this.getResultModificationMaxAmount()) {
                newValue = this.getResultModificationMaxAmount();
            }
            MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)inputUpgradeStack.m_41784_(), (int)newValue, (String)this.getResultModificationName());
            return true;
        }
        return false;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)DeferredRegisterItems.PEDESTAL_UPGRADE_MODIFICATIONS.get());
    }

    public Ingredient getPattern() {
        return this.upgradeInput != null ? this.upgradeInput : Ingredient.f_43901_;
    }

    public static class Type
    implements RecipeType<UpgradeModificationRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "upgrademodification";

        private Type() {
        }
    }

    public static class Serializer
    implements RecipeSerializer<UpgradeModificationRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("pedestals", "upgrademodification");

        protected UpgradeModificationRecipe createRecipe(ResourceLocation recipeId, String group, Ingredient upgradeInput, Ingredient infusionInputIngredients, String resultModificationName, int resultModificationValue, int resultModificationMaxValue) {
            return new UpgradeModificationRecipe(recipeId, group, upgradeInput, infusionInputIngredients, resultModificationName, resultModificationValue, resultModificationMaxValue);
        }

        public UpgradeModificationRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            Ingredient upgradeInput = json.has("upgradeInput") ? CraftingHelper.getIngredient((JsonElement)json.get("upgradeInput"), (boolean)false) : null;
            Ingredient infusionInputIngredients = json.has("ingredients") ? CraftingHelper.getIngredient((JsonElement)json.get("ingredients"), (boolean)false) : null;
            String resultModificationName = GsonHelper.m_13851_((JsonObject)json, (String)"resultModificationName", (String)"");
            int resultModificationValue = json.has("resultModificationValue") ? GsonHelper.m_13927_((JsonObject)json, (String)"resultModificationValue") : 0;
            int resultModificationMaxValue = json.has("resultModificationMaxValue") ? GsonHelper.m_13927_((JsonObject)json, (String)"resultModificationMaxValue") : 0;
            return this.createRecipe(recipeId, group, upgradeInput, infusionInputIngredients, resultModificationName, resultModificationValue, resultModificationMaxValue);
        }

        public UpgradeModificationRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(Short.MAX_VALUE);
            boolean hasUpgradeInput = buffer.readBoolean();
            Ingredient upgradeInput = hasUpgradeInput ? Ingredient.m_43940_((FriendlyByteBuf)buffer) : null;
            boolean hasInfusionInputIngredients = buffer.readBoolean();
            Ingredient infusionInputIngredients = hasInfusionInputIngredients ? Ingredient.m_43940_((FriendlyByteBuf)buffer) : null;
            String resultModificationName = buffer.m_130136_(Short.MAX_VALUE);
            int resultModificationValue = buffer.readInt();
            int resultModificationMaxValue = buffer.readInt();
            return this.createRecipe(recipeId, group, upgradeInput, infusionInputIngredients, resultModificationName, resultModificationValue, resultModificationMaxValue);
        }

        public void toNetwork(FriendlyByteBuf buffer, UpgradeModificationRecipe recipe) {
            buffer.m_130070_(recipe.group);
            boolean hasUpgradeInput = recipe.upgradeInput != null;
            buffer.writeBoolean(hasUpgradeInput);
            if (hasUpgradeInput) {
                recipe.upgradeInput.m_43923_(buffer);
            }
            boolean hasInfusionInputIngredients = recipe.infusionInputIngredients != null;
            buffer.writeBoolean(hasInfusionInputIngredients);
            if (hasInfusionInputIngredients) {
                recipe.infusionInputIngredients.m_43923_(buffer);
            }
            buffer.m_130070_(recipe.resultModificationName);
            buffer.writeInt(recipe.resultModificationValue);
            buffer.writeInt(recipe.resultModificationMaxValue);
        }

        public RecipeSerializer<?> setRegistryName(ResourceLocation name) {
            return INSTANCE;
        }

        @Nullable
        public ResourceLocation getRegistryName() {
            return ID;
        }

        public Class<RecipeSerializer<?>> getRegistryType() {
            return Serializer.castClass(RecipeSerializer.class);
        }

        private static <G> Class<G> castClass(Class<?> cls) {
            return cls;
        }
    }
}

