/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mowmaster.mowlib.MowLibUtils.MowLibCompoundTagUtils;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import com.mowmaster.pedestals.Registry.DeferredRegisterItems;
import java.util.Collection;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ObjectHolder;
import org.jetbrains.annotations.Nullable;

public class UpgradeModificationGlobalRecipe
implements Recipe<Container> {
    @ObjectHolder(registryName="forge:recipe_serializer", value="pedestals:upgrademodification_global")
    private final String group;
    private final ResourceLocation id;
    private final NonNullList<Ingredient> inputIngredients;
    private final String resultModificationName;
    private final int resultModificationValue;
    private final int resultModificationMinValue;
    private final int resultModificationMaxValue;

    public UpgradeModificationGlobalRecipe(ResourceLocation id, String group, NonNullList<Ingredient> inputIngredients, String resultModificationName, int resultModificationValue, int resultModificationMinValue, int resultModificationMaxValue) {
        this.group = group;
        this.id = id;
        this.inputIngredients = inputIngredients;
        this.resultModificationName = resultModificationName;
        this.resultModificationValue = resultModificationValue;
        this.resultModificationMinValue = resultModificationMinValue;
        this.resultModificationMaxValue = resultModificationMaxValue;
    }

    public boolean m_5598_() {
        return true;
    }

    public static Collection<UpgradeModificationGlobalRecipe> getAllRecipes(Level world) {
        return world.m_7465_().m_44013_((RecipeType)Type.INSTANCE);
    }

    public String m_6076_() {
        return this.group;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList allIngredients = NonNullList.m_122779_();
        if (this.inputIngredients.size() > 0) {
            return this.inputIngredients;
        }
        return allIngredients;
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        ItemUpgradeBase baseUpgrade;
        Item item;
        int unmatching = 0;
        if (this.inputIngredients.size() >= inv.m_6643_()) {
            int i;
            for (i = 0; i < inv.m_6643_(); ++i) {
                if (((Ingredient)this.inputIngredients.get(i)).test(inv.m_8020_(i))) continue;
                ++unmatching;
            }
            if (this.inputIngredients.size() > inv.m_6643_()) {
                for (i = inv.m_6643_(); i < this.inputIngredients.size(); ++i) {
                    if (((Ingredient)this.inputIngredients.get(i)).test(ItemStack.f_41583_)) continue;
                    ++unmatching;
                }
            }
        }
        boolean hasUpgrade = inv.m_8020_(0).m_41720_() instanceof ItemUpgradeBase && ((Ingredient)this.inputIngredients.get(0)).m_43908_()[0].m_41720_() instanceof ItemUpgradeBase;
        boolean canAddModifier = false;
        if (hasUpgrade && (item = inv.m_8020_(0).m_41720_()) instanceof ItemUpgradeBase && (baseUpgrade = (ItemUpgradeBase)item).canAddModifierToUpgrade(inv.m_8020_(0), this.getResultModificationName())) {
            canAddModifier = true;
        }
        return this.inputIngredients.size() >= inv.m_6643_() && canAddModifier && unmatching <= 0;
    }

    public ItemStack m_5874_(Container p_44001_, RegistryAccess p_267165_) {
        return this.getResultItem().m_41777_();
    }

    public ItemStack m_8043_(RegistryAccess p_267052_) {
        return new ItemStack((ItemLike)Items.f_42127_);
    }

    public ItemStack getResultItem() {
        return new ItemStack((ItemLike)Items.f_42127_);
    }

    public String getResultModificationName() {
        return this.resultModificationName;
    }

    public int getResultModificationAmount() {
        return this.resultModificationValue;
    }

    public int getResultModificationMinAmount() {
        return this.resultModificationMinValue;
    }

    public int getResultModificationMaxAmount() {
        return this.resultModificationMaxValue;
    }

    public boolean getResultingModifiedItem(ItemStack inputUpgradeStack, boolean simulate) {
        ItemUpgradeBase baseUpgrade;
        Item item = inputUpgradeStack.m_41720_();
        if (item instanceof ItemUpgradeBase && (baseUpgrade = (ItemUpgradeBase)item).canAddModifierToUpgrade(inputUpgradeStack, this.getResultModificationName())) {
            int value = MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)inputUpgradeStack.m_41784_(), (String)this.getResultModificationName());
            if (value >= this.getResultModificationMaxAmount()) {
                return false;
            }
            if (value < this.getResultModificationMinAmount()) {
                return false;
            }
            int newValue = value + this.getResultModificationAmount();
            if (newValue > this.getResultModificationMaxAmount()) {
                newValue = this.getResultModificationMaxAmount();
            }
            if (!simulate) {
                MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)inputUpgradeStack.m_41784_(), (int)newValue, (String)this.getResultModificationName());
            }
            return true;
        }
        return false;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)DeferredRegisterItems.PEDESTAL_UPGRADE_MODIFICATIONS.get());
    }

    public static class Type
    implements RecipeType<UpgradeModificationGlobalRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "upgrademodification_global";

        private Type() {
        }
    }

    public static class Serializer
    implements RecipeSerializer<UpgradeModificationGlobalRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("pedestals", "upgrademodification_global");

        protected UpgradeModificationGlobalRecipe createRecipe(ResourceLocation recipeId, String group, NonNullList<Ingredient> inputIngredients, String resultModificationName, int resultModificationValue, int resultModificationMinValue, int resultModificationMaxValue) {
            return new UpgradeModificationGlobalRecipe(recipeId, group, inputIngredients, resultModificationName, resultModificationValue, resultModificationMinValue, resultModificationMaxValue);
        }

        public UpgradeModificationGlobalRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            int sizeMax = ingredients.size() >= 10 ? 10 : ingredients.size();
            NonNullList inputIngredients = NonNullList.m_122780_((int)sizeMax, (Object)Ingredient.f_43901_);
            for (int i = 0; i < sizeMax; ++i) {
                inputIngredients.set(i, (Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            String resultModificationName = GsonHelper.m_13851_((JsonObject)json, (String)"resultModificationName", (String)"");
            int resultModificationValue = json.has("resultModificationValue") ? GsonHelper.m_13927_((JsonObject)json, (String)"resultModificationValue") : 0;
            int resultModificationMinValue = json.has("resultModificationMinValue") ? GsonHelper.m_13927_((JsonObject)json, (String)"resultModificationMinValue") : 0;
            int resultModificationMaxValue = json.has("resultModificationMaxValue") ? GsonHelper.m_13927_((JsonObject)json, (String)"resultModificationMaxValue") : 0;
            return this.createRecipe(recipeId, group, (NonNullList<Ingredient>)inputIngredients, resultModificationName, resultModificationValue, resultModificationMinValue, resultModificationMaxValue);
        }

        public UpgradeModificationGlobalRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(Short.MAX_VALUE);
            NonNullList inputIngredients = NonNullList.m_122780_((int)buffer.readInt(), (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputIngredients.size(); ++i) {
                inputIngredients.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            String resultModificationName = buffer.m_130136_(Short.MAX_VALUE);
            int resultModificationValue = buffer.readInt();
            int resultModificationMinValue = buffer.readInt();
            int resultModificationMaxValue = buffer.readInt();
            return this.createRecipe(recipeId, group, (NonNullList<Ingredient>)inputIngredients, resultModificationName, resultModificationValue, resultModificationMinValue, resultModificationMaxValue);
        }

        public void toNetwork(FriendlyByteBuf buffer, UpgradeModificationGlobalRecipe recipe) {
            buffer.m_130070_(recipe.group);
            buffer.writeInt(recipe.m_7527_().size());
            for (Ingredient ing : recipe.m_7527_()) {
                ing.m_43923_(buffer);
            }
            buffer.m_130070_(recipe.resultModificationName);
            buffer.writeInt(recipe.resultModificationValue);
            buffer.writeInt(recipe.resultModificationMinValue);
            buffer.writeInt(recipe.resultModificationMaxValue);
        }

        public RecipeSerializer<?> setRegistryName(ResourceLocation name) {
            return INSTANCE;
        }

        @Nullable
        public ResourceLocation getRegistryName() {
            return ID;
        }

        public Class<RecipeSerializer<?>> getRegistryType() {
            return Serializer.castClass(RecipeSerializer.class);
        }

        private static <G> Class<G> castClass(Class<?> cls) {
            return cls;
        }
    }
}

