/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Recipes;

import com.google.gson.JsonObject;
import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.MowLibUtils.MowLibMultiContainer;
import com.mowmaster.mowlib.MowLibUtils.MowLibRecipeUtils;
import com.mowmaster.mowlib.Recipes.Ingredients.DustIngredient;
import com.mowmaster.mowlib.Recipes.Ingredients.EnergyIngredient;
import com.mowmaster.mowlib.Recipes.Ingredients.ExperienceIngredient;
import com.mowmaster.mowlib.Recipes.Ingredients.FluidTagIngredient;
import com.mowmaster.pedestals.Registry.DeferredRegisterItems;
import java.util.Collection;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ObjectHolder;
import org.jetbrains.annotations.Nullable;

public class FluidConverterRecipe
implements Recipe<MowLibMultiContainer> {
    @ObjectHolder(registryName="forge:recipe_serializer", value="pedestals:fluidconverter")
    private final String group;
    private final ResourceLocation id;
    public final FluidTagIngredient fluidIng;
    private final EnergyIngredient energy;
    private final ExperienceIngredient experience;
    private final DustIngredient dust;
    private final ItemStack generatedItemOrBlock;

    public FluidConverterRecipe(ResourceLocation id, String group, @Nullable FluidTagIngredient fluidIng, @Nullable EnergyIngredient energy, @Nullable ExperienceIngredient experience, @Nullable DustIngredient dust, @Nullable ItemStack generatedItemOrBlock) {
        this.group = group;
        this.id = id;
        this.fluidIng = fluidIng;
        this.energy = energy;
        this.experience = experience;
        this.dust = dust;
        this.generatedItemOrBlock = generatedItemOrBlock;
    }

    public boolean m_5598_() {
        return true;
    }

    public static Collection<FluidConverterRecipe> getAllRecipes(Level world) {
        return world.m_7465_().m_44013_((RecipeType)Type.INSTANCE);
    }

    public String m_6076_() {
        return this.group;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList allIngredients = NonNullList.m_122779_();
        allIngredients.add((Object)Ingredient.f_43901_);
        return allIngredients;
    }

    public boolean matches(MowLibMultiContainer p_44002_, Level p_44003_) {
        MowLibMultiContainer cont = p_44002_;
        if (this.fluidIng == null && this.energy == null && this.experience == null && this.dust == null && this.generatedItemOrBlock == null) {
            return false;
        }
        if (this.energy.getEnergyNeeded() <= 0 && this.experience.getExperienceRequired() <= 0 && this.dust.getDustMagic().isEmpty() && this.generatedItemOrBlock.m_41619_()) {
            return false;
        }
        if (this.fluidIng != null && !this.fluidIng.getFluidStack().isEmpty()) {
            if (cont.getFluidStack().isEmpty()) {
                return false;
            }
            if (this.fluidIng.getFluidStack().isFluidEqual(cont.getFluidStack())) {
                return true;
            }
        }
        return false;
    }

    public ItemStack assemble(MowLibMultiContainer p_44001_, RegistryAccess p_267165_) {
        return this.getResultItem().m_41777_();
    }

    public ItemStack m_8043_(RegistryAccess p_267052_) {
        if (this.generatedItemOrBlock == null) {
            return ItemStack.f_41583_;
        }
        if (this.generatedItemOrBlock != null || !this.generatedItemOrBlock.m_41619_()) {
            return this.generatedItemOrBlock;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack getResultItem() {
        if (this.generatedItemOrBlock == null) {
            return ItemStack.f_41583_;
        }
        if (this.generatedItemOrBlock != null || !this.generatedItemOrBlock.m_41619_()) {
            return this.generatedItemOrBlock;
        }
        return ItemStack.f_41583_;
    }

    public FluidStack getFluidRequired() {
        return this.fluidIng != null ? this.fluidIng.getFluidStack() : FluidStack.EMPTY;
    }

    public int getEnergyReturned() {
        return this.energy.getEnergyNeeded();
    }

    public int getExperienceReturned() {
        return this.experience.getExperienceRequired();
    }

    public DustMagic getDustReturned() {
        return this.dust.getDustMagic();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)DeferredRegisterItems.PEDESTAL_UPGRADE_FLUIDCONVERTER.get());
    }

    public FluidStack getFluidStack() {
        return this.fluidIng != null ? this.fluidIng.getFluidStack() : FluidStack.EMPTY;
    }

    public int getEnergy() {
        return this.energy.getEnergyNeeded();
    }

    public int getExperience() {
        return this.experience.getExperienceRequired();
    }

    public DustMagic getDustMagic() {
        return this.dust.getDustMagic();
    }

    public FluidStack getPattern() {
        return this.fluidIng != null ? this.fluidIng.getFluidStack() : FluidStack.EMPTY;
    }

    public static class Type
    implements RecipeType<FluidConverterRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "fluidconverter";

        private Type() {
        }
    }

    public static class Serializer
    implements RecipeSerializer<FluidConverterRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("pedestals", "fluidconverter");

        protected FluidConverterRecipe createRecipe(ResourceLocation recipeId, String group, @Nullable FluidTagIngredient fluidIng, @Nullable EnergyIngredient energy, @Nullable ExperienceIngredient experience, @Nullable DustIngredient dust, ItemStack generatedItemOrBlock) {
            return new FluidConverterRecipe(recipeId, group, fluidIng, energy, experience, dust, generatedItemOrBlock);
        }

        public FluidConverterRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            FluidTagIngredient fluidTagIngredient = json.has("inputFluidStack") ? MowLibRecipeUtils.parseFluid((JsonObject)json, (String)"inputFluidStack") : null;
            EnergyIngredient energyIngredient = new EnergyIngredient(json);
            ExperienceIngredient experienceIngredient = new ExperienceIngredient(json);
            DustIngredient dustIngredient = DustIngredient.parseData((JsonObject)json);
            ItemStack result = json.has("result") ? CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (boolean)true) : null;
            return this.createRecipe(recipeId, group, fluidTagIngredient, energyIngredient, experienceIngredient, dustIngredient, result);
        }

        public FluidConverterRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(Short.MAX_VALUE);
            boolean hasInputFluid = buffer.readBoolean();
            FluidTagIngredient ingredientFluid = hasInputFluid ? FluidTagIngredient.readFromPacket((FriendlyByteBuf)buffer) : null;
            EnergyIngredient energyIngredient = new EnergyIngredient(buffer.readInt());
            ExperienceIngredient experienceIngredient = new ExperienceIngredient(buffer.readInt());
            DustIngredient dustIngredient = new DustIngredient(buffer.readInt(), buffer.readInt());
            boolean hasResult = buffer.readBoolean();
            ItemStack result = hasResult ? buffer.m_130267_() : null;
            return this.createRecipe(recipeId, group, ingredientFluid, energyIngredient, experienceIngredient, dustIngredient, result);
        }

        public void toNetwork(FriendlyByteBuf buffer, FluidConverterRecipe recipe) {
            buffer.m_130070_(recipe.group);
            boolean hasInputFluid = recipe.fluidIng != null;
            buffer.writeBoolean(hasInputFluid);
            if (hasInputFluid) {
                recipe.fluidIng.writeToPacket(buffer);
            }
            buffer.writeInt(recipe.energy.getEnergyNeeded());
            buffer.writeInt(recipe.experience.getExperienceRequired());
            buffer.writeInt(recipe.dust.getDustMagic().getDustColor());
            buffer.writeInt(recipe.dust.getDustMagic().getDustAmount());
            boolean hasResultItem = recipe.generatedItemOrBlock != null;
            buffer.writeBoolean(hasResultItem);
            if (hasResultItem) {
                buffer.m_130055_(recipe.generatedItemOrBlock);
            }
        }

        public RecipeSerializer<?> setRegistryName(ResourceLocation name) {
            return INSTANCE;
        }

        @Nullable
        public ResourceLocation getRegistryName() {
            return ID;
        }

        public Class<RecipeSerializer<?>> getRegistryType() {
            return Serializer.castClass(RecipeSerializer.class);
        }

        private static <G> Class<G> castClass(Class<?> cls) {
            return cls;
        }
    }
}

