/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.MowLibUtils.MowLibRecipeUtils;
import com.mowmaster.mowlib.Recipes.Ingredients.DustIngredient;
import com.mowmaster.mowlib.Recipes.Ingredients.EnergyIngredient;
import com.mowmaster.mowlib.Recipes.Ingredients.ExperienceIngredient;
import com.mowmaster.mowlib.Recipes.Ingredients.FluidTagIngredient;
import com.mowmaster.pedestals.Registry.DeferredRegisterItems;
import java.util.Collection;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ObjectHolder;
import org.jetbrains.annotations.Nullable;

public class CobbleGenRecipe
implements Recipe<Container> {
    @ObjectHolder(registryName="forge:recipe_serializer", value="pedestals:cobblegen")
    private final String group;
    private final ResourceLocation id;
    @Nullable
    private final Ingredient blockBelow;
    private final ItemStack generatedItemOrBlock;
    public final FluidTagIngredient fluidIng;
    private final EnergyIngredient energy;
    private final ExperienceIngredient experience;
    private final DustIngredient dust;

    public CobbleGenRecipe(ResourceLocation id, String group, @Nullable Ingredient blockBelow, ItemStack generatedItemOrBlock, @Nullable FluidTagIngredient fluidIng, @Nullable EnergyIngredient energy, @Nullable ExperienceIngredient experience, @Nullable DustIngredient dust) {
        this.group = group;
        this.id = id;
        this.blockBelow = blockBelow;
        this.generatedItemOrBlock = generatedItemOrBlock;
        this.fluidIng = fluidIng;
        this.energy = energy;
        this.experience = experience;
        this.dust = dust;
    }

    public boolean m_5598_() {
        return true;
    }

    public static Collection<CobbleGenRecipe> getAllRecipes(Level world) {
        return world.m_7465_().m_44013_((RecipeType)Type.INSTANCE);
    }

    public String m_6076_() {
        return this.group;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList allIngredients = NonNullList.m_122779_();
        allIngredients.add((Object)(this.blockBelow != null ? this.blockBelow : Ingredient.f_43901_));
        return allIngredients;
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        ItemStack inputStack = inv.m_8020_(0);
        return inputStack.m_41619_() && this.blockBelow == null ? true : this.blockBelow.test(inputStack);
    }

    public ItemStack m_5874_(Container p_44001_, RegistryAccess p_267165_) {
        return this.getResultItem().m_41777_();
    }

    public ItemStack m_8043_(RegistryAccess p_267052_) {
        return this.generatedItemOrBlock;
    }

    public ItemStack getResultItem() {
        return this.generatedItemOrBlock;
    }

    public int getResultEnergyNeeded() {
        return this.getEnergy();
    }

    public int getResultExperienceNeeded() {
        return this.getExperience();
    }

    public FluidStack getResultFluidNeeded() {
        return this.getFluidStack();
    }

    public DustMagic getResultDustNeeded() {
        return this.getDustMagic();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)DeferredRegisterItems.PEDESTAL_UPGRADE_COBBLEGEN.get());
    }

    public FluidStack getFluidStack() {
        if (this.fluidIng != null) {
            return this.fluidIng.getFluidStack();
        }
        return FluidStack.EMPTY;
    }

    public int getEnergy() {
        return this.energy.getEnergyNeeded();
    }

    public int getExperience() {
        return this.experience.getExperienceRequired();
    }

    public DustMagic getDustMagic() {
        return this.dust.getDustMagic();
    }

    public Ingredient getPattern() {
        return this.blockBelow != null ? this.blockBelow : Ingredient.f_43901_;
    }

    public static class Type
    implements RecipeType<CobbleGenRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "cobblegen";

        private Type() {
        }
    }

    public static class Serializer
    implements RecipeSerializer<CobbleGenRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("pedestals", "cobblegen");

        protected CobbleGenRecipe createRecipe(ResourceLocation recipeId, String group, Ingredient blockBelow, ItemStack result, @Nullable FluidTagIngredient fluidIng, @Nullable EnergyIngredient energy, @Nullable ExperienceIngredient experience, @Nullable DustIngredient dust) {
            return new CobbleGenRecipe(recipeId, group, blockBelow, result, fluidIng, energy, experience, dust);
        }

        public CobbleGenRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            Ingredient blockBelow = json.has("blockBelow") ? CraftingHelper.getIngredient((JsonElement)json.get("blockBelow"), (boolean)false) : null;
            ItemStack result = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (boolean)true);
            FluidTagIngredient fluidTagIngredient = json.has("inputFluidStack") ? MowLibRecipeUtils.parseFluid((JsonObject)json, (String)"inputFluidStack") : null;
            EnergyIngredient energyIngredient = new EnergyIngredient(json);
            ExperienceIngredient experienceIngredient = new ExperienceIngredient(json);
            DustIngredient dustIngredient = DustIngredient.parseData((JsonObject)json);
            return this.createRecipe(recipeId, group, blockBelow, result, fluidTagIngredient, energyIngredient, experienceIngredient, dustIngredient);
        }

        public CobbleGenRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(Short.MAX_VALUE);
            boolean hasInput = buffer.readBoolean();
            Ingredient blockBelow = hasInput ? Ingredient.m_43940_((FriendlyByteBuf)buffer) : null;
            ItemStack result = buffer.m_130267_();
            boolean hasInputFluid = buffer.readBoolean();
            FluidTagIngredient fluidTagIngredient = hasInputFluid ? FluidTagIngredient.readFromPacket((FriendlyByteBuf)buffer) : null;
            EnergyIngredient energyIngredient = new EnergyIngredient(buffer.readInt());
            ExperienceIngredient experienceIngredient = new ExperienceIngredient(buffer.readInt());
            DustIngredient dustIngredient = new DustIngredient(buffer.readInt(), buffer.readInt());
            return this.createRecipe(recipeId, group, blockBelow, result, fluidTagIngredient, energyIngredient, experienceIngredient, dustIngredient);
        }

        public void toNetwork(FriendlyByteBuf buffer, CobbleGenRecipe recipe) {
            buffer.m_130070_(recipe.group);
            boolean hasInput = recipe.blockBelow != null;
            buffer.writeBoolean(hasInput);
            if (hasInput) {
                recipe.blockBelow.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.generatedItemOrBlock);
            boolean hasInputFluid = recipe.fluidIng != null;
            buffer.writeBoolean(hasInputFluid);
            if (hasInputFluid) {
                recipe.fluidIng.writeToPacket(buffer);
            }
            buffer.writeInt(recipe.energy.getEnergyNeeded());
            buffer.writeInt(recipe.experience.getExperienceRequired());
            buffer.writeInt(recipe.dust.getDustMagic().getDustColor());
            buffer.writeInt(recipe.dust.getDustMagic().getDustAmount());
        }

        public RecipeSerializer<?> setRegistryName(ResourceLocation name) {
            return INSTANCE;
        }

        @Nullable
        public ResourceLocation getRegistryName() {
            return ID;
        }

        public Class<RecipeSerializer<?>> getRegistryType() {
            return Serializer.castClass(RecipeSerializer.class);
        }

        private static <G> Class<G> castClass(Class<?> cls) {
            return cls;
        }
    }
}

