/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Upgrades.Pedestal;

import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.Capabilities.Dust.IDustHandler;
import com.mowmaster.mowlib.MowLibUtils.MowLibBlockPosUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibContainerUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibItemUtils;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import com.mowmaster.pedestals.Recipes.UnBottlerRecipe;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemUpgradeUnBottler
extends ItemUpgradeBase {
    public ItemUpgradeUnBottler(Item.Properties p_41383_) {
        super(new Item.Properties());
    }

    @Override
    public boolean canModifySpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public int getUpgradeWorkRange(ItemStack coinUpgrade) {
        return 0;
    }

    @Override
    public void actionOnRemovedFromPedestal(BasePedestalBlockEntity pedestal, ItemStack coinInPedestal) {
    }

    @Nullable
    protected UnBottlerRecipe getNormalRecipe(BasePedestalBlockEntity pedestal, ItemStack stackIn) {
        Level level = pedestal.m_58904_();
        Container cont = MowLibContainerUtils.getContainer((int)1);
        cont.m_6836_(-1, stackIn);
        if (level == null) {
            return null;
        }
        RecipeManager recipeManager = level.m_7465_();
        Optional optional = recipeManager.m_44015_((RecipeType)UnBottlerRecipe.Type.INSTANCE, cont, level);
        if (optional.isPresent()) {
            return optional.orElse(null);
        }
        return null;
    }

    protected Collection<ItemStack> getNormalResults(UnBottlerRecipe recipe) {
        return recipe == null ? Arrays.asList(ItemStack.f_41583_) : Collections.singleton(recipe.getResultItem());
    }

    protected FluidStack getFluidResult(UnBottlerRecipe recipe) {
        return recipe == null ? FluidStack.EMPTY : recipe.getFluidReturned();
    }

    protected int getEnergyResult(UnBottlerRecipe recipe) {
        return recipe == null ? 0 : recipe.getEnergyReturned();
    }

    protected int getExperienceResult(UnBottlerRecipe recipe) {
        return recipe == null ? 0 : recipe.getExperienceReturned();
    }

    protected DustMagic getDustResult(UnBottlerRecipe recipe) {
        return recipe == null ? DustMagic.EMPTY : recipe.getDustReturned();
    }

    @Override
    public void upgradeAction(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, ItemStack coin) {
        BlockPos posInventory = MowLibBlockPosUtils.getPosOfBlockBelow((Level)level, (BlockPos)pedestalPos, (int)1);
        ItemStack itemFromInv = ItemStack.f_41583_;
        LazyOptional cap = MowLibItemUtils.findItemHandlerAtPos((Level)level, (BlockPos)posInventory, (Direction)this.getPedestalFacing(level, pedestalPos), (boolean)true);
        if (!this.isInventoryEmpty((LazyOptional<IItemHandler>)cap) && cap.isPresent()) {
            int i;
            IItemHandler handler = (IItemHandler)cap.orElse(null);
            BlockEntity invToPullFrom = level.m_7702_(posInventory);
            if (invToPullFrom instanceof BasePedestalBlockEntity) {
                itemFromInv = ItemStack.f_41583_;
            } else if (handler != null && (i = this.getNextSlotWithItemsCapFiltered(pedestal, (LazyOptional<IItemHandler>)cap)) >= 0) {
                itemFromInv = handler.getStackInSlot(i);
                ItemStack copyIncoming = itemFromInv.m_41777_();
                copyIncoming.m_41764_(1);
                if (itemFromInv != null && !itemFromInv.m_41619_()) {
                    UnBottlerRecipe recipe = this.getNormalRecipe(pedestal, copyIncoming);
                    ItemStack returnedStack = this.getNormalResults(recipe).stream().findFirst().orElse(ItemStack.f_41583_);
                    boolean fluid = true;
                    FluidStack getReturnedFluid = this.getFluidResult(recipe);
                    boolean energy = true;
                    int getReturnedEnergy = this.getEnergyResult(recipe);
                    boolean exp = true;
                    int getReturnedExperience = this.getExperienceResult(recipe);
                    boolean dust = true;
                    DustMagic getReturnedDust = this.getDustResult(recipe);
                    if (!(getReturnedFluid.isEmpty() && getReturnedEnergy <= 0 && getReturnedExperience <= 0 && getReturnedDust.isEmpty() || handler.extractItem(i, 1, true).m_41619_())) {
                        boolean allowed = true;
                        if (!returnedStack.m_41619_() && !pedestal.addItem(returnedStack, true)) {
                            allowed = false;
                        }
                        if (!getReturnedFluid.isEmpty() && pedestal.addFluid(getReturnedFluid, IFluidHandler.FluidAction.SIMULATE) < getReturnedFluid.getAmount()) {
                            allowed = false;
                        }
                        if (getReturnedEnergy > 0 && pedestal.addEnergy(getReturnedEnergy, true) < getReturnedEnergy) {
                            allowed = false;
                        }
                        if (getReturnedExperience > 0 && pedestal.addExperience(getReturnedExperience, true) < getReturnedExperience) {
                            allowed = false;
                        }
                        if (!getReturnedDust.isEmpty() && pedestal.addDust(getReturnedDust, IDustHandler.DustAction.SIMULATE) < getReturnedDust.getDustAmount()) {
                            allowed = false;
                        }
                        if (allowed) {
                            handler.extractItem(i, 1, false);
                            if (!getReturnedFluid.isEmpty()) {
                                pedestal.addFluid(getReturnedFluid, IFluidHandler.FluidAction.EXECUTE);
                            }
                            if (getReturnedEnergy > 0) {
                                pedestal.addEnergy(getReturnedEnergy, false);
                            }
                            if (getReturnedExperience > 0) {
                                pedestal.addExperience(getReturnedExperience, false);
                            }
                            if (!getReturnedDust.isEmpty()) {
                                pedestal.addDust(getReturnedDust, IDustHandler.DustAction.EXECUTE);
                            }
                            if (!returnedStack.m_41619_()) {
                                pedestal.addItem(returnedStack, false);
                            }
                        }
                    }
                }
            }
        }
    }
}

