/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Upgrades.Pedestal;

import com.mowmaster.mowlib.MowLibUtils.MowLibBlockPosUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibCompoundTagUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibItemUtils;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.IHasModeTypes;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemUpgradeRecycler
extends ItemUpgradeBase
implements IHasModeTypes {
    public ItemUpgradeRecycler(Item.Properties p_41383_) {
        super(p_41383_);
    }

    @Override
    public boolean canModifySpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public int getUpgradeWorkRange(ItemStack coinUpgrade) {
        return 0;
    }

    @Override
    public void actionOnRemovedFromPedestal(BasePedestalBlockEntity pedestal, ItemStack coinInPedestal) {
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_storedExpUnderOne");
    }

    private boolean canProcess(ItemStack toProcess) {
        List cannotProcessItems = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation("pedestals", "pedestals_cannot_recycle"))).stream().toList();
        Item toProcessItem = toProcess.m_41720_();
        return !toProcess.m_41619_() && !cannotProcessItems.contains(toProcessItem) && (toProcess.m_41793_() || toProcessItem instanceof EnchantedBookItem || toProcessItem instanceof ArmorItem || toProcessItem instanceof TieredItem);
    }

    public Optional<Integer> getFirstSlotWithItemThatCanBeProcessed(BasePedestalBlockEntity pedestal, IItemHandler itemHandler) {
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(i);
            if (!this.canProcess(stackInSlot) || itemHandler.extractItem(i, 1, true).equals(ItemStack.f_41583_) || !ItemUpgradeRecycler.passesItemFilter(pedestal, stackInSlot) || !this.canProcess(stackInSlot)) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    protected Optional<? extends AbstractCookingRecipe> getNormalRecipe(Level level, ItemStack input) {
        SimpleContainer container = new SimpleContainer(new ItemStack[]{input});
        RecipeManager recipeManager = level.m_7465_();
        Optional blastingRecipeMaybe = recipeManager.m_44015_(RecipeType.f_44109_, (Container)container, level);
        if (blastingRecipeMaybe.isPresent()) {
            return blastingRecipeMaybe;
        }
        return recipeManager.m_44015_(RecipeType.f_44108_, (Container)container, level);
    }

    private void addExperienceFromProcessing(BasePedestalBlockEntity pedestal, ItemStack upgrade, float experience) {
        int getExperienceStored = MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)upgrade.m_41784_(), (String)"_storedExpUnderOne");
        int convertFloatDecimal = (int)(experience * 100.0f);
        int sum = getExperienceStored + convertFloatDecimal;
        int expToAdd = sum / 100;
        int remainingExp = sum % 100;
        pedestal.addExperience(expToAdd, false);
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)upgrade.m_41783_(), (int)remainingExp, (String)"_storedExpUnderOne");
    }

    @Override
    public void upgradeAction(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, ItemStack coin) {
        BlockPos inventoryPos = MowLibBlockPosUtils.getPosOfBlockBelow((Level)level, (BlockPos)pedestal.getPos(), (int)1);
        BlockEntity invToPullFrom = level.m_7702_(inventoryPos);
        if (invToPullFrom instanceof BasePedestalBlockEntity) {
            return;
        }
        MowLibItemUtils.findItemHandlerAtPos((Level)level, (BlockPos)inventoryPos, (Direction)this.getPedestalFacing(level, pedestalPos), (boolean)true).ifPresent(handler -> {
            boolean shouldStop;
            Optional<Integer> slotToHandle = this.getFirstSlotWithItemThatCanBeProcessed(pedestal, (IItemHandler)handler);
            if (this.canTransferXP(coin) && (shouldStop = slotToHandle.map(i -> {
                int grindedExpAmount;
                ItemStack itemFromInv = handler.getStackInSlot(i.intValue());
                if (itemFromInv.m_41720_() instanceof EnchantedBookItem) {
                    int grindedExpAmount2 = this.getItemsExpDisenchantAmount(itemFromInv);
                    if (grindedExpAmount2 <= pedestal.spaceForExperience()) {
                        ItemStack stackToReturn = new ItemStack((ItemLike)Items.f_42517_, itemFromInv.m_41613_());
                        if (!handler.extractItem(i.intValue(), 1, true).m_41619_() && pedestal.addItem(stackToReturn, true) && pedestal.addExperience(grindedExpAmount2, true) > 0) {
                            handler.extractItem(i.intValue(), 1, false);
                            pedestal.addExperience(grindedExpAmount2, false);
                            pedestal.addItem(stackToReturn, false);
                            return true;
                        }
                    }
                } else if (itemFromInv.m_41793_() && (grindedExpAmount = this.getItemsExpDisenchantAmount(itemFromInv)) <= pedestal.spaceForExperience()) {
                    if (this.canTransferItems(coin)) {
                        if (pedestal.addExperience(grindedExpAmount, true) > 0) {
                            EnchantmentHelper.m_44865_(Map.of(), (ItemStack)itemFromInv);
                            pedestal.addExperience(grindedExpAmount, false);
                        }
                    } else {
                        ItemStack stackToReturn = itemFromInv.m_41777_();
                        EnchantmentHelper.m_44865_(Map.of(), (ItemStack)stackToReturn);
                        if (!handler.extractItem(i.intValue(), 1, true).m_41619_() && pedestal.addItem(stackToReturn, true) && pedestal.addExperience(grindedExpAmount, true) > 0) {
                            handler.extractItem(i.intValue(), 1, false);
                            pedestal.addExperience(grindedExpAmount, false);
                            pedestal.addItem(stackToReturn, false);
                            return true;
                        }
                    }
                }
                return false;
            }).orElse(false).booleanValue())) {
                slotToHandle = Optional.empty();
            }
            if (this.canTransferItems(coin)) {
                slotToHandle.ifPresent(i -> {
                    ItemStack itemFromInv = handler.getStackInSlot(i.intValue());
                    if (!itemFromInv.m_41619_()) {
                        Optional<? extends AbstractCookingRecipe> recipeMaybe = this.getNormalRecipe(level, itemFromInv);
                        ItemStack returnedStack = recipeMaybe.map(recipe -> recipe.m_8043_(level.m_9598_())).orElse(ItemStack.f_41583_);
                        if (!returnedStack.m_41619_()) {
                            if (!handler.extractItem(i.intValue(), 1, true).m_41619_() && pedestal.addItem(returnedStack, true)) {
                                float expAmount = recipeMaybe.map(AbstractCookingRecipe::m_43750_).orElse(Float.valueOf(0.0f)).floatValue();
                                if (expAmount > 0.0f) {
                                    this.addExperienceFromProcessing(pedestal, coin, expAmount);
                                }
                                handler.extractItem(i.intValue(), 1, false);
                                pedestal.addItem(returnedStack, false);
                            }
                        } else {
                            ItemStack toAdd = itemFromInv.m_41777_();
                            toAdd.m_41764_(1);
                            if (!handler.extractItem(i.intValue(), 1, true).m_41619_() && pedestal.addItem(toAdd, true)) {
                                handler.extractItem(i.intValue(), 1, false);
                                pedestal.addItem(toAdd, false);
                            }
                        }
                    }
                });
            }
        });
    }

    public int getItemsExpDisenchantAmount(ItemStack stack) {
        int exp = 0;
        Map map = EnchantmentHelper.m_44831_((ItemStack)stack);
        for (Map.Entry entry : map.entrySet()) {
            Enchantment enchantment = (Enchantment)entry.getKey();
            Integer integer = (Integer)entry.getValue();
            exp += enchantment.m_6183_(integer.intValue());
        }
        return exp * stack.m_41613_();
    }
}

