/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Upgrades.Pedestal;

import com.mowmaster.mowlib.BlockEntities.MowLibBaseBlockEntity;
import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.Items.WorkCards.WorkCardArea;
import com.mowmaster.mowlib.MowLibUtils.MowLibBlockPosUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibCompoundTagUtils;
import com.mowmaster.mowlib.Networking.MowLibPacketHandler;
import com.mowmaster.mowlib.Networking.MowLibPacketParticles;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Configs.PedestalConfig;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChorusFlowerBlock;
import net.minecraft.world.level.block.GrowingPlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemUpgradePump
extends ItemUpgradeBase {
    public ItemUpgradePump(Item.Properties p_41383_) {
        super(p_41383_);
    }

    @Override
    public boolean canModifySpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyBlockCapacity(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyRange(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyArea(ItemStack upgradeItemStack) {
        return (Boolean)PedestalConfig.COMMON.upgrade_require_sized_selectable_area.get();
    }

    @Override
    public boolean canModifyOperateToBedrock(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean needsWorkCard(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public int getWorkCardType() {
        return 1;
    }

    @Override
    public int baseEnergyCostPerDistance() {
        return (Integer)PedestalConfig.COMMON.upgrade_pump_baseEnergyCost.get();
    }

    @Override
    public boolean energyDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_pump_energy_distance_multiplier.get();
    }

    @Override
    public double energyCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_pump_energyMultiplier.get();
    }

    @Override
    public int baseXpCostPerDistance() {
        return (Integer)PedestalConfig.COMMON.upgrade_pump_baseXpCost.get();
    }

    @Override
    public boolean xpDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_pump_xp_distance_multiplier.get();
    }

    @Override
    public double xpCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_pump_xpMultiplier.get();
    }

    @Override
    public DustMagic baseDustCostPerDistance() {
        return new DustMagic(((Integer)PedestalConfig.COMMON.upgrade_pump_dustColor.get()).intValue(), ((Integer)PedestalConfig.COMMON.upgrade_pump_baseDustAmount.get()).intValue());
    }

    @Override
    public boolean dustDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_pump_dust_distance_multiplier.get();
    }

    @Override
    public double dustCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_pump_dustMultiplier.get();
    }

    @Override
    public boolean hasSelectedAreaModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_pump_selectedAllowed.get();
    }

    @Override
    public double selectedAreaCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_pump_selectedMultiplier.get();
    }

    public boolean removeWaterFromLoggedBlocks() {
        return (Boolean)PedestalConfig.COMMON.upgrade_pump_waterlogged.get();
    }

    @Override
    public List<String> getUpgradeHUD(BasePedestalBlockEntity pedestal) {
        List<String> messages = super.getUpgradeHUD(pedestal);
        if (messages.isEmpty()) {
            if (this.baseEnergyCostPerDistance() > 0 && pedestal.getStoredEnergy() < this.baseEnergyCostPerDistance()) {
                messages.add(ChatFormatting.RED + "Needs Energy");
                messages.add(ChatFormatting.RED + "To Operate");
            }
            if (this.baseXpCostPerDistance() > 0 && pedestal.getStoredExperience() < this.baseXpCostPerDistance()) {
                messages.add(ChatFormatting.GREEN + "Needs Experience");
                messages.add(ChatFormatting.GREEN + "To Operate");
            }
            if (this.baseDustCostPerDistance().getDustAmount() > 0 && pedestal.getStoredEnergy() < this.baseEnergyCostPerDistance()) {
                messages.add(ChatFormatting.LIGHT_PURPLE + "Needs Dust");
                messages.add(ChatFormatting.LIGHT_PURPLE + "To Operate");
            }
        }
        return messages;
    }

    @Override
    public void actionOnRemovedFromPedestal(BasePedestalBlockEntity pedestal, ItemStack coinInPedestal) {
        super.actionOnRemovedFromPedestal(pedestal, coinInPedestal);
        this.resetCachedValidWorkCardPositions("pedestals", coinInPedestal);
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_numposition");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_numheight");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_boolstop");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_miny");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_numdelay");
    }

    private boolean getStopped(ItemStack upgrade) {
        return MowLibCompoundTagUtils.readBooleanFromNBT((String)"pedestals", (CompoundTag)upgrade.m_41784_(), (String)"_boolstop");
    }

    private void setStopped(ItemStack upgrade) {
        MowLibCompoundTagUtils.writeBooleanToNBT((String)"pedestals", (CompoundTag)upgrade.m_41784_(), (boolean)true, (String)"_boolstop");
    }

    private int getNumBlocksPerOperation(ItemStack upgrade) {
        return (Integer)PedestalConfig.COMMON.upgrade_pump_baseBlocksPumped.get() + this.getBlockCapacityIncrease(upgrade);
    }

    private int getCurrentHeight(ItemStack upgrade) {
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)upgrade.m_41784_(), (String)"_numheight");
    }

    private void setCurrentHeight(ItemStack upgrade, int num) {
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)upgrade.m_41784_(), (int)num, (String)"_numheight");
    }

    private int getMinY(ItemStack upgrade) {
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)upgrade.m_41784_(), (String)"_miny");
    }

    private void setMinY(ItemStack upgrade, int minY) {
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)upgrade.m_41784_(), (int)minY, (String)"_miny");
    }

    private int getCurrentPosition(ItemStack upgrade) {
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)upgrade.m_41784_(), (String)"_numposition");
    }

    private void setCurrentPosition(ItemStack upgrade, int num) {
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)upgrade.m_41784_(), (int)num, (String)"_numposition");
    }

    private boolean canPump(BasePedestalBlockEntity pedestal, Block targetBlock, FluidStack targetFluidStack) {
        List cannotPumpBlocks = ForgeRegistries.BLOCKS.tags().getTag(BlockTags.create((ResourceLocation)new ResourceLocation("pedestals", "pedestals_cant_pump"))).stream().toList();
        return !cannotPumpBlocks.contains(targetBlock) && pedestal.addFluid(targetFluidStack, IFluidHandler.FluidAction.SIMULATE) > 0;
    }

    private FluidStack getFluidStackForTarget(Block targetBlock, FluidState targetFluidState) {
        if (targetBlock instanceof AbstractCauldronBlock) {
            if (targetBlock.equals(Blocks.f_152476_)) {
                return new FluidStack((Fluid)Fluids.f_76193_, 1000);
            }
            if (targetBlock.equals(Blocks.f_152477_)) {
                return new FluidStack((Fluid)Fluids.f_76195_, 1000);
            }
        }
        if (targetFluidState.m_76170_()) {
            return new FluidStack(targetFluidState.m_76152_(), 1000);
        }
        return FluidStack.EMPTY;
    }

    private boolean canPlace(ItemStack toPlace) {
        Block possibleBlock = Block.m_49814_((Item)toPlace.m_41720_());
        List cannotPlaceBlocks = ForgeRegistries.BLOCKS.tags().getTag(BlockTags.create((ResourceLocation)new ResourceLocation("pedestals", "pedestals_cannot_place"))).stream().toList();
        return possibleBlock != Blocks.f_50016_ && !cannotPlaceBlocks.contains(possibleBlock) && !(possibleBlock instanceof IPlantable) && !(possibleBlock instanceof ChorusFlowerBlock) && !(possibleBlock instanceof GrowingPlantBlock);
    }

    public List<BlockPos> getValidWorkCardPositionsPump(Level level, BasePedestalBlockEntity pedestal, ItemStack upgrade) {
        List cached = MowLibBlockPosUtils.readBlockPosListCustomFromNBT((String)"pedestals", (String)"_validlist", (ItemStack)upgrade);
        if (cached.size() == 0 && !MowLibBlockPosUtils.hasBlockListCustomNBTTags((String)"pedestals", (String)"_validlist", (ItemStack)upgrade) && pedestal.hasWorkCard()) {
            ItemStack workCardItemStack = pedestal.getWorkCardInPedestal();
            if (workCardItemStack.m_41720_() instanceof WorkCardArea) {
                cached = WorkCardArea.getAABBIfDefinedAndInRange((ItemStack)workCardItemStack, (MowLibBaseBlockEntity)pedestal, (int)this.getUpgradeWorkRange(upgrade)).map(area -> {
                    ArrayList<BlockPos> locations = new ArrayList<BlockPos>();
                    int minY = (int)area.f_82289_;
                    int maxY = (int)area.f_82292_;
                    if (this.hasOperateToBedrock(upgrade)) {
                        if (minY != maxY) {
                            return locations;
                        }
                        this.setCurrentHeight(upgrade, maxY);
                        this.setMinY(upgrade, level.m_141937_());
                    } else {
                        this.setMinY(upgrade, minY);
                    }
                    for (int x = (int)area.f_82291_; x >= (int)area.f_82288_; --x) {
                        for (int z = (int)area.f_82293_; z >= (int)area.f_82290_; --z) {
                            for (int y = maxY; y >= minY; y -= this.getNumBlocksPerOperation(upgrade)) {
                                locations.add(new BlockPos(x, y, z));
                            }
                        }
                    }
                    return locations;
                }).orElse(List.of());
            }
            MowLibBlockPosUtils.saveBlockPosListCustomToNBT((String)"pedestals", (String)"_validlist", (ItemStack)upgrade, (List)cached);
        }
        return cached;
    }

    @Override
    public void upgradeAction(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, ItemStack coin) {
        if (level.m_5776_()) {
            return;
        }
        if (this.getStopped(coin)) {
            if (pedestal.canSpawnParticles()) {
                MowLibPacketHandler.sendToNearby((Level)level, (BlockPos)pedestalPos, (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)pedestalPos.m_123341_(), (double)((float)pedestalPos.m_123342_() + 1.0f), (double)pedestalPos.m_123343_(), new int[]{255, 55, 55}));
            }
            return;
        }
        List<BlockPos> allPositions = this.getValidWorkCardPositionsPump(level, pedestal, coin);
        if (allPositions.isEmpty()) {
            return;
        }
        int currentPosition = this.getCurrentPosition(coin);
        BlockPos currentPoint = allPositions.get(currentPosition);
        int currentY = this.hasOperateToBedrock(coin) ? this.getCurrentHeight(coin) : currentPoint.m_123342_();
        int currentMinY = Math.max(currentY - this.getNumBlocksPerOperation(coin) + 1, this.getMinY(coin));
        List<BlockPos> adjustedPoints = IntStream.rangeClosed(currentMinY, currentY).mapToObj(y -> new BlockPos(currentPoint.m_123341_(), y, currentPoint.m_123343_())).toList();
        if (pedestal.spaceForFluid() >= 1000 * adjustedPoints.size() && this.pumpAction(level, pedestal, pedestalPos, adjustedPoints)) {
            if (currentPosition + 1 >= allPositions.size()) {
                this.setCurrentPosition(coin, 0);
                if (this.hasOperateToBedrock(coin)) {
                    this.setCurrentHeight(coin, currentMinY - 1);
                    if (currentMinY <= this.getMinY(coin)) {
                        this.setStopped(coin);
                    }
                }
            } else {
                this.setCurrentPosition(coin, currentPosition + 1);
            }
        }
    }

    public boolean pumpAction(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, List<BlockPos> adjustedPoints) {
        WeakReference<FakePlayer> fakePlayerReference = pedestal.getPedestalPlayer(pedestal);
        if (fakePlayerReference != null && fakePlayerReference.get() != null) {
            FakePlayer fakePlayer = (FakePlayer)fakePlayerReference.get();
            List<Integer> distances = adjustedPoints.stream().map(point -> MowLibBlockPosUtils.getDistanceBetweenPoints((BlockPos)pedestalPos, (BlockPos)point)).toList();
            if (this.removeFuelForActionMultiple(pedestal, distances, true)) {
                for (BlockPos adjustedPoint : adjustedPoints) {
                    FluidStack targetFluidStack;
                    BlockState targetBlockState;
                    Block targetBlock;
                    if (adjustedPoint.equals((Object)pedestalPos) || !this.canPump(pedestal, targetBlock = (targetBlockState = level.m_8055_(adjustedPoint)).m_60734_(), targetFluidStack = this.getFluidStackForTarget(targetBlock, level.m_6425_(adjustedPoint))) || !ItemUpgradePump.passesMachineFilterFluids(pedestal, targetFluidStack) || !pedestal.canAcceptFluid(targetFluidStack) || pedestal.spaceForFluid() < 1000) continue;
                    if (this.removeFuelForAction(pedestal, MowLibBlockPosUtils.getDistanceBetweenPoints((BlockPos)pedestalPos, (BlockPos)adjustedPoint), false)) {
                        pedestal.addFluid(targetFluidStack, IFluidHandler.FluidAction.EXECUTE);
                        if (targetBlockState.m_61138_((Property)BlockStateProperties.f_61362_)) {
                            if (!this.removeWaterFromLoggedBlocks()) continue;
                            level.m_46597_(adjustedPoint, (BlockState)targetBlockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
                            continue;
                        }
                        if (targetBlock instanceof AbstractCauldronBlock) {
                            level.m_46597_(adjustedPoint, Blocks.f_50256_.m_49966_());
                            continue;
                        }
                        level.m_46597_(adjustedPoint, Blocks.f_50016_.m_49966_());
                        ItemStack toPlace = pedestal.getItemInPedestal().m_41777_();
                        if (pedestal.removeItemStack(toPlace, true).m_41619_() || !this.canPlace(toPlace) || !ItemUpgradePump.passesMachineFilterItems(pedestal, toPlace)) continue;
                        ItemStack toRemove = toPlace.m_41777_();
                        UseOnContext blockContext = new UseOnContext(level, (Player)fakePlayer, InteractionHand.MAIN_HAND, toPlace, new BlockHitResult(Vec3.f_82478_, this.getPedestalFacing(level, pedestalPos), adjustedPoint, false));
                        InteractionResult resultPlace = ForgeHooks.onPlaceItemIntoWorld((UseOnContext)blockContext);
                        if (resultPlace != InteractionResult.CONSUME) continue;
                        toRemove.m_41764_(1);
                        pedestal.removeItemStack(toRemove, false);
                        continue;
                    }
                    return false;
                }
                return true;
            }
            if (pedestal.canSpawnParticles()) {
                MowLibPacketHandler.sendToNearby((Level)level, (BlockPos)pedestalPos, (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)pedestalPos.m_123341_(), (double)((float)pedestalPos.m_123342_() + 1.0f), (double)pedestalPos.m_123343_(), new int[]{55, 55, 55}));
            }
            return false;
        }
        return false;
    }
}

