/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Upgrades.Pedestal;

import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.Capabilities.Dust.IDustHandler;
import com.mowmaster.mowlib.MowLibUtils.MowLibBlockPosUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibDustUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibEnergyUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibFluidUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibItemUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibMessageUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibXpUtils;
import com.mowmaster.mowlib.Networking.MowLibPacketHandler;
import com.mowmaster.mowlib.Networking.MowLibPacketParticles;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Configs.PedestalConfig;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.IHasModeTypes;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemUpgradeImport
extends ItemUpgradeBase
implements IHasModeTypes {
    public ItemUpgradeImport(Item.Properties p_41383_) {
        super(p_41383_);
    }

    @Override
    public boolean canModifySpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyItemCapacity(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyFluidCapacity(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyEnergyCapacity(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyXPCapacity(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyDustCapacity(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyEntityContainers(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyRemoteStorage(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean needsWorkCard(ItemStack upgradeItemStack) {
        return this.hasRemoteStorage(upgradeItemStack);
    }

    @Override
    public int getWorkCardType() {
        return 2;
    }

    @Override
    public int getUpgradeWorkRange(ItemStack upgradeItemStack) {
        if (this.hasRemoteStorage(upgradeItemStack)) {
            return super.getUpgradeWorkRange(upgradeItemStack);
        }
        return 0;
    }

    @Override
    public void upgradeAction(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, ItemStack coin) {
        List<BlockPos> allPositions;
        List<BlockPos> list = allPositions = this.hasRemoteStorage(coin) ? this.getValidWorkCardPositions(pedestal, coin, this.getWorkCardType(), "mowlib") : List.of(MowLibBlockPosUtils.getPosOfBlockBelow((Level)level, (BlockPos)pedestalPos, (int)1));
        if (allPositions.isEmpty() || allPositions.size() > 8) {
            return;
        }
        Direction pedestalFacing = this.getPedestalFacing(level, pedestalPos);
        for (BlockPos position : allPositions) {
            if (level.m_7702_(position) instanceof BasePedestalBlockEntity) {
                return;
            }
            List<Boolean> importResults = List.of(Boolean.valueOf(this.importItemAction(level, position, pedestal, pedestalFacing, coin)), Boolean.valueOf(this.importFluidAction(level, position, pedestal, pedestalFacing, coin)), Boolean.valueOf(this.importEnergyAction(level, position, pedestal, pedestalFacing, coin)), Boolean.valueOf(this.importXPAction(level, position, pedestal, pedestalFacing, coin)), Boolean.valueOf(this.importDustAction(level, position, pedestal, pedestalFacing, coin)));
            if (!importResults.contains(true)) continue;
            break;
        }
    }

    private boolean importItemAction(Level level, BlockPos position, BasePedestalBlockEntity pedestal, Direction pedestalFacing, ItemStack upgradeItemStack) {
        if (this.canTransferItems(upgradeItemStack)) {
            int supportedTransferRate = (Integer)PedestalConfig.COMMON.upgrade_import_baseItemTransferSpeed.get() + this.getItemCapacityIncrease(upgradeItemStack);
            LazyOptional cap = this.hasEntityContainer(upgradeItemStack) ? ItemUpgradeImport.findItemHandlerAtPosEntity(level, position, pedestalFacing, true) : MowLibItemUtils.findItemHandlerAtPos((Level)level, (BlockPos)position, (Direction)pedestalFacing, (boolean)true);
            return cap.map(handler -> ItemUpgradeImport.getFirstSlotWithNonFilteredItems(pedestal, handler).map(slot -> {
                ItemStack stackInHandler = handler.getStackInSlot(slot.intValue());
                if (!stackInHandler.m_41619_()) {
                    ItemStack actualTransferred;
                    ItemStack simulateRemainder;
                    ItemStack toTransfer = stackInHandler.m_41777_();
                    if (toTransfer.m_41613_() > supportedTransferRate) {
                        toTransfer.m_41764_(supportedTransferRate);
                    }
                    if ((simulateRemainder = pedestal.addItemStack(toTransfer.m_41777_(), true)).m_41613_() != toTransfer.m_41613_() && !(actualTransferred = handler.extractItem(slot.intValue(), toTransfer.m_41613_() - simulateRemainder.m_41613_(), false)).m_41619_()) {
                        pedestal.addItemStack(actualTransferred, false);
                        return true;
                    }
                }
                return false;
            }).orElse(false)).orElse(false);
        }
        return false;
    }

    private boolean importFluidAction(Level level, BlockPos position, BasePedestalBlockEntity pedestal, Direction pedestalFacing, ItemStack upgradeItemStack) {
        if (this.canTransferFluids(upgradeItemStack)) {
            int supportedTransferRate = (Integer)PedestalConfig.COMMON.upgrade_import_baseFluidTransferSpeed.get() + this.getFluidCapacityIncrease(upgradeItemStack);
            LazyOptional cap = this.hasEntityContainer(upgradeItemStack) ? ItemUpgradeImport.findFluidHandlerAtPosEntity(level, position, pedestalFacing, true) : MowLibFluidUtils.findFluidHandlerAtPos((Level)level, (BlockPos)position, (Direction)pedestalFacing, (boolean)true);
            return cap.map(handler -> {
                int actualTransferred;
                int maxToTransfer = Math.min(supportedTransferRate, pedestal.spaceForFluid());
                FluidStack actualToTransfer = handler.drain(maxToTransfer, IFluidHandler.FluidAction.SIMULATE);
                if (!actualToTransfer.isEmpty() && (actualTransferred = pedestal.addFluid(actualToTransfer.copy(), IFluidHandler.FluidAction.EXECUTE)) > 0) {
                    FluidStack toRemoveStack = actualToTransfer.copy();
                    toRemoveStack.setAmount(actualTransferred);
                    handler.drain(toRemoveStack, IFluidHandler.FluidAction.EXECUTE);
                    return true;
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    private boolean importEnergyAction(Level level, BlockPos position, BasePedestalBlockEntity pedestal, Direction pedestalFacing, ItemStack upgradeItemStack) {
        if (this.canTransferEnergy(upgradeItemStack)) {
            int supportedTransferRate = (Integer)PedestalConfig.COMMON.upgrade_import_baseEnergyTransferSpeed.get() + this.getEnergyCapacityIncrease(upgradeItemStack);
            LazyOptional cap = this.hasEntityContainer(upgradeItemStack) ? ItemUpgradeImport.findEnergyHandlerAtPosEntity(level, position, pedestalFacing, true) : MowLibEnergyUtils.findEnergyHandlerAtPos((Level)level, (BlockPos)position, (Direction)pedestalFacing, (boolean)true);
            return cap.map(handler -> {
                int actualTransferred;
                int maxToTransfer = Math.min(supportedTransferRate, pedestal.spaceForEnergy());
                int actualToTransfer = handler.extractEnergy(maxToTransfer, true);
                if (actualToTransfer > 0 && (actualTransferred = pedestal.addEnergy(actualToTransfer, false)) > 0) {
                    handler.extractEnergy(actualTransferred, false);
                    return true;
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    private boolean importXPAction(Level level, BlockPos position, BasePedestalBlockEntity pedestal, Direction pedestalFacing, ItemStack upgradeItemStack) {
        if (this.canTransferXP(upgradeItemStack)) {
            int supportedTransferRate = (Integer)PedestalConfig.COMMON.upgrade_import_baseExpTransferSpeed.get() + MowLibXpUtils.getExpCountByLevel((int)this.getXPCapacityIncrease(upgradeItemStack));
            LazyOptional cap = MowLibXpUtils.findExperienceHandlerAtPos((Level)level, (BlockPos)position, (Direction)pedestalFacing, (boolean)true);
            return cap.map(handler -> {
                int actualTransferred;
                int maxToTransfer = Math.min(supportedTransferRate, pedestal.spaceForExperience());
                int actualToTransfer = handler.extractExperience(maxToTransfer, true);
                if (actualToTransfer > 0 && (actualTransferred = pedestal.addExperience(actualToTransfer, false)) > 0) {
                    handler.extractExperience(actualTransferred, false);
                    return true;
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    private boolean importDustAction(Level level, BlockPos position, BasePedestalBlockEntity pedestal, Direction pedestalFacing, ItemStack upgradeItemStack) {
        if (this.canTransferDust(upgradeItemStack)) {
            int supportedTransferRate = (Integer)PedestalConfig.COMMON.upgrade_import_baseDustTransferSpeed.get() + this.getDustCapacityIncrease(upgradeItemStack);
            LazyOptional cap = MowLibDustUtils.findDustHandlerAtPos((Level)level, (BlockPos)position, (Direction)pedestalFacing);
            return cap.map(handler -> {
                int actualTransferred;
                int maxToTransfer = Math.min(supportedTransferRate, pedestal.spaceForDust());
                DustMagic actualToTransfer = handler.drain(maxToTransfer, IDustHandler.DustAction.SIMULATE);
                if (actualToTransfer.getDustAmount() > 0 && (actualTransferred = pedestal.addDust(actualToTransfer.copy(), IDustHandler.DustAction.EXECUTE)) > 0) {
                    DustMagic toRemove = actualToTransfer.copy();
                    toRemove.setDustAmount(actualTransferred);
                    handler.drain(toRemove, IDustHandler.DustAction.EXECUTE);
                    return true;
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    @Override
    public void onCollideAction(BasePedestalBlockEntity pedestal) {
        Level level = pedestal.m_58904_();
        if (level == null) {
            return;
        }
        BlockPos pedestalPos = pedestal.getPos();
        ItemStack upgradeItemStack = pedestal.getCoinOnPedestal();
        for (Entity entityIn : level.m_45976_(Entity.class, new AABB(pedestalPos))) {
            Player player;
            ItemEntity itemEntity;
            if (this.canTransferXP(upgradeItemStack) && pedestal.canAcceptExperience()) {
                if (entityIn instanceof Player) {
                    int actualTransferred;
                    int supportedTransferRate;
                    int maxToTransfer;
                    Player player2 = (Player)entityIn;
                    if (!player2.m_6144_() && (maxToTransfer = Math.min(supportedTransferRate = (Integer)PedestalConfig.COMMON.upgrade_import_baseExpTransferSpeed.get() + MowLibXpUtils.getExpCountByLevel((int)this.getXPCapacityIncrease(upgradeItemStack)), pedestal.spaceForExperience())) > 0 && (actualTransferred = MowLibXpUtils.removeXp((Player)player2, (int)maxToTransfer)) > 0) {
                        pedestal.addExperience(actualTransferred, false);
                        if (pedestal.canSpawnParticles()) {
                            MowLibPacketHandler.sendToNearby((Level)level, (BlockPos)pedestalPos, (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR, (double)pedestalPos.m_123341_(), (double)pedestalPos.m_123342_(), (double)pedestalPos.m_123343_(), new int[]{0, 255, 0}));
                        }
                    }
                } else if (entityIn instanceof ExperienceOrb) {
                    ExperienceOrb xpOrb = (ExperienceOrb)entityIn;
                    int value = xpOrb.m_20801_();
                    if (pedestal.spaceForExperience() > value) {
                        pedestal.addExperience(value, false);
                        xpOrb.m_142687_(Entity.RemovalReason.DISCARDED);
                        if (pedestal.canSpawnParticles()) {
                            MowLibPacketHandler.sendToNearby((Level)level, (BlockPos)pedestalPos, (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR, (double)pedestalPos.m_123341_(), (double)pedestalPos.m_123342_(), (double)pedestalPos.m_123343_(), new int[]{0, 255, 0}));
                        }
                    }
                }
            }
            if (this.canTransferFluids(upgradeItemStack) && pedestal.spaceForFluid() > 1000) {
                if (entityIn instanceof ItemEntity) {
                    FluidStack fluidStack;
                    int filled;
                    BucketItem bucket;
                    itemEntity = (ItemEntity)entityIn;
                    Item maxToTransfer = itemEntity.m_32055_().m_41720_();
                    if (maxToTransfer instanceof BucketItem && (bucket = (BucketItem)maxToTransfer).getFluid() != Fluids.f_76191_ && (filled = pedestal.addFluid(fluidStack = new FluidStack(bucket.getFluid(), 1000), IFluidHandler.FluidAction.EXECUTE)) > 0) {
                        itemEntity.m_32045_(new ItemStack((ItemLike)Items.f_42446_, 1));
                    }
                } else if (entityIn instanceof Player && !(player = (Player)entityIn).m_6144_()) {
                    player.m_150109_().f_35974_.stream().filter(itemStack -> {
                        BucketItem bucket;
                        Item patt15115$temp = itemStack.m_41720_();
                        return patt15115$temp instanceof BucketItem && (bucket = (BucketItem)patt15115$temp).getFluid() != Fluids.f_76191_ && this.passesFluidFilter(pedestal, new FluidStack(bucket.getFluid(), 1000));
                    }).findFirst().ifPresent(inventoryItemStack -> {
                        BucketItem bucket;
                        FluidStack fluidInTank;
                        Item patt15426$temp = inventoryItemStack.m_41720_();
                        if (patt15426$temp instanceof BucketItem && pedestal.addFluid(fluidInTank = new FluidStack((bucket = (BucketItem)patt15426$temp).getFluid(), 1000), IFluidHandler.FluidAction.EXECUTE) > 0) {
                            inventoryItemStack.m_41774_(1);
                            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42446_, 1));
                            String fluid = pedestal.getStoredFluid().getDisplayName().getString() + ": " + pedestal.getStoredFluid().getAmount() + "/" + pedestal.getFluidCapacity();
                            MowLibMessageUtils.messagePopupText((Player)player, (ChatFormatting)ChatFormatting.WHITE, (String)fluid);
                        }
                    });
                }
            }
            if (!this.canTransferItems(upgradeItemStack)) continue;
            if (entityIn instanceof ItemEntity) {
                itemEntity = (ItemEntity)entityIn;
                ItemStack stackToAdd = itemEntity.m_32055_();
                ItemStack remainder = pedestal.addItemStack(stackToAdd.m_41777_(), false);
                if (remainder.m_41613_() == stackToAdd.m_41613_()) continue;
                if (remainder.m_41619_()) {
                    itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
                } else {
                    itemEntity.m_32055_().m_41764_(remainder.m_41613_());
                }
                if (!pedestal.canSpawnParticles()) continue;
                MowLibPacketHandler.sendToNearby((Level)level, (BlockPos)pedestalPos, (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR, (double)pedestalPos.m_123341_(), (double)pedestalPos.m_123342_(), (double)pedestalPos.m_123343_(), new int[]{180, 180, 180}));
                continue;
            }
            if (!(entityIn instanceof Player) || (player = (Player)entityIn).m_6144_()) continue;
            player.m_150109_().f_35974_.stream().filter(itemStack -> !itemStack.m_41619_()).filter(itemStack -> ItemUpgradeImport.passesItemFilter(pedestal, itemStack)).findFirst().ifPresent(inventoryItemStack -> {
                ItemStack remainder = pedestal.addItemStack((ItemStack)inventoryItemStack, false);
                if (remainder.m_41613_() != inventoryItemStack.m_41613_()) {
                    inventoryItemStack.m_41774_(inventoryItemStack.m_41613_() - remainder.m_41613_());
                    if (pedestal.canSpawnParticles()) {
                        MowLibPacketHandler.sendToNearby((Level)level, (BlockPos)pedestalPos, (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR, (double)pedestalPos.m_123341_(), (double)pedestalPos.m_123342_(), (double)pedestalPos.m_123343_(), new int[]{180, 180, 0}));
                    }
                }
            });
        }
    }
}

