/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Upgrades.Pedestal;

import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.Items.Filters.BaseFilter;
import com.mowmaster.mowlib.MowLibUtils.MowLibBlockPosUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibCompoundTagUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibItemUtils;
import com.mowmaster.mowlib.Networking.MowLibPacketHandler;
import com.mowmaster.mowlib.Networking.MowLibPacketParticles;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Configs.PedestalConfig;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemUpgradeHiveHarvester
extends ItemUpgradeBase {
    public ItemUpgradeHiveHarvester(Item.Properties p_41383_) {
        super(new Item.Properties());
    }

    @Override
    public boolean canModifySpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyRange(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyArea(ItemStack upgradeItemStack) {
        return (Boolean)PedestalConfig.COMMON.upgrade_require_sized_selectable_area.get();
    }

    @Override
    public boolean needsWorkCard(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public int getWorkCardType() {
        return 0;
    }

    @Override
    public int baseEnergyCostPerDistance() {
        return (Integer)PedestalConfig.COMMON.upgrade_hiveharvester_baseEnergyCost.get();
    }

    @Override
    public boolean energyDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_hiveharvester_energy_distance_multiplier.get();
    }

    @Override
    public double energyCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_hiveharvester_energyMultiplier.get();
    }

    @Override
    public int baseXpCostPerDistance() {
        return (Integer)PedestalConfig.COMMON.upgrade_hiveharvester_baseXpCost.get();
    }

    @Override
    public boolean xpDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_hiveharvester_xp_distance_multiplier.get();
    }

    @Override
    public double xpCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_hiveharvester_xpMultiplier.get();
    }

    @Override
    public DustMagic baseDustCostPerDistance() {
        return new DustMagic(((Integer)PedestalConfig.COMMON.upgrade_hiveharvester_dustColor.get()).intValue(), ((Integer)PedestalConfig.COMMON.upgrade_hiveharvester_baseDustAmount.get()).intValue());
    }

    @Override
    public boolean dustDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_hiveharvester_dust_distance_multiplier.get();
    }

    @Override
    public double dustCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_hiveharvester_dustMultiplier.get();
    }

    @Override
    public boolean hasSelectedAreaModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_hiveharvester_selectedAllowed.get();
    }

    @Override
    public double selectedAreaCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_hiveharvester_selectedMultiplier.get();
    }

    @Override
    public List<String> getUpgradeHUD(BasePedestalBlockEntity pedestal) {
        List<String> messages = super.getUpgradeHUD(pedestal);
        if (messages.isEmpty()) {
            if (this.baseEnergyCostPerDistance() > 0 && pedestal.getStoredEnergy() < this.baseEnergyCostPerDistance()) {
                messages.add(ChatFormatting.RED + "Needs Energy");
                messages.add(ChatFormatting.RED + "To Operate");
            }
            if (this.baseXpCostPerDistance() > 0 && pedestal.getStoredExperience() < this.baseXpCostPerDistance()) {
                messages.add(ChatFormatting.GREEN + "Needs Experience");
                messages.add(ChatFormatting.GREEN + "To Operate");
            }
            if (this.baseDustCostPerDistance().getDustAmount() > 0 && pedestal.getStoredEnergy() < this.baseEnergyCostPerDistance()) {
                messages.add(ChatFormatting.LIGHT_PURPLE + "Needs Dust");
                messages.add(ChatFormatting.LIGHT_PURPLE + "To Operate");
            }
        }
        return messages;
    }

    @Override
    public ItemStack getUpgradeDefaultTool() {
        return new ItemStack((ItemLike)Items.f_42574_);
    }

    @Override
    public void actionOnRemovedFromPedestal(BasePedestalBlockEntity pedestal, ItemStack coinInPedestal) {
        super.actionOnRemovedFromPedestal(pedestal, coinInPedestal);
        this.resetCachedValidWorkCardPositions("pedestals", coinInPedestal);
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41784_(), (String)"_numposition");
    }

    @Override
    public void upgradeAction(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, ItemStack coin) {
        if (level.m_5776_()) {
            return;
        }
        List<BlockPos> allPositions = this.getValidWorkCardPositions(pedestal, coin, this.getWorkCardType(), "pedestals");
        if (allPositions.isEmpty()) {
            return;
        }
        int currentPosition = this.getCurrentPosition(coin);
        BlockPos targetPos = allPositions.get(currentPosition);
        if (this.harvesterAction(level, pedestal, targetPos)) {
            if (currentPosition + 1 == allPositions.size()) {
                this.setCurrentPosition(pedestal, 0);
            } else {
                this.setCurrentPosition(pedestal, currentPosition + 1);
            }
        }
    }

    private int getCurrentPosition(ItemStack upgrade) {
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)upgrade.m_41784_(), (String)"_numposition");
    }

    private void setCurrentPosition(BasePedestalBlockEntity pedestal, int num) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (int)num, (String)"_numposition");
    }

    private boolean passesFilter(BasePedestalBlockEntity pedestal, Block targetBlock) {
        BaseFilter filter;
        ItemStack filterInPedestal;
        Item item;
        if (pedestal.hasFilter() && (item = (filterInPedestal = pedestal.getFilterInBlockEntity()).m_41720_()) instanceof BaseFilter && (filter = (BaseFilter)item).getFilterDirection().neutral()) {
            ItemStack blockToCheck = new ItemStack((ItemLike)targetBlock);
            return filter.canAcceptItems(filterInPedestal, blockToCheck);
        }
        return true;
    }

    private boolean canHarvest(Level level, BlockPos targetPos, BlockState targetBlockState, Block targetBlock) {
        List cannotBreakBlocks = ForgeRegistries.BLOCKS.tags().getTag(BlockTags.create((ResourceLocation)new ResourceLocation("pedestals", "pedestals_cannot_break"))).stream().toList();
        return !cannotBreakBlocks.contains(targetBlock) && targetBlockState.m_60800_((BlockGetter)level, targetPos) >= 0.0f && targetBlockState.m_61138_((Property)BeehiveBlock.f_49564_) && (Integer)targetBlockState.m_61143_((Property)BeehiveBlock.f_49564_) >= 5;
    }

    public boolean harvesterAction(Level level, BasePedestalBlockEntity pedestal, BlockPos targetPos) {
        WeakReference<FakePlayer> fakePlayerReference = pedestal.getPedestalPlayer(pedestal);
        if (fakePlayerReference != null && fakePlayerReference.get() != null) {
            FakePlayer fakePlayer = (FakePlayer)fakePlayerReference.get();
            BlockPos pedestalPos = pedestal.getPos();
            BlockState targetBlockState = level.m_8055_(targetPos);
            Block targetBlock = targetBlockState.m_60734_();
            if (this.removeFuelForAction(pedestal, MowLibBlockPosUtils.getDistanceBetweenPoints((BlockPos)pedestalPos, (BlockPos)targetPos), true) && targetBlock instanceof BeehiveBlock) {
                BlockEvent.BreakEvent e;
                BeehiveBlock beehiveBlock = (BeehiveBlock)targetBlock;
                if (this.canHarvest(level, targetPos, targetBlockState, targetBlock) && this.passesFilter(pedestal, targetBlock) && !MinecraftForge.EVENT_BUS.post((Event)(e = new BlockEvent.BreakEvent(level, targetPos, targetBlockState, (Player)fakePlayer)))) {
                    boolean toolStackIsDamageable;
                    ItemStack toolStack = pedestal.hasItem() ? pedestal.getItemInPedestal() : pedestal.getToolStack();
                    boolean bl = toolStackIsDamageable = toolStack.m_41720_().isDamageable(toolStack) && toolStack.m_41741_() <= 1;
                    if (((Boolean)PedestalConfig.COMMON.hiveharvester_DamageTools.get()).booleanValue() && toolStackIsDamageable && !pedestal.damageTool(toolStack, 1, true)) {
                        if (pedestal.canSpawnParticles()) {
                            MowLibPacketHandler.sendToNearby((Level)level, (BlockPos)pedestalPos, (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)pedestalPos.m_123341_(), (double)((float)pedestalPos.m_123342_() + 1.0f), (double)pedestalPos.m_123343_(), new int[]{255, 255, 255}));
                        }
                        return false;
                    }
                    if (this.removeFuelForAction(pedestal, MowLibBlockPosUtils.getDistanceBetweenPoints((BlockPos)pedestalPos, (BlockPos)targetPos), false)) {
                        fakePlayer.m_21008_(InteractionHand.MAIN_HAND, toolStack.m_41777_());
                        UseOnContext blockContext = new UseOnContext(level, (Player)fakePlayer, InteractionHand.MAIN_HAND, toolStack.m_41777_(), new BlockHitResult(Vec3.f_82478_, this.getPedestalFacing(level, pedestalPos), targetPos, false));
                        BlockHitResult result = new BlockHitResult(blockContext.m_43720_(), blockContext.m_43719_(), blockContext.m_8083_(), blockContext.m_43721_());
                        if (result.m_6662_() == HitResult.Type.BLOCK) {
                            beehiveBlock.m_6227_(targetBlockState, level, targetPos, (Player)fakePlayer, InteractionHand.MAIN_HAND, result);
                            for (ItemStack stackInPlayer : fakePlayer.m_150109_().f_35974_) {
                                if (stackInPlayer.m_41619_() || stackInPlayer.m_150930_(toolStack.m_41720_())) continue;
                                MowLibItemUtils.spawnItemStack((Level)level, (double)targetPos.m_123341_(), (double)targetPos.m_123342_(), (double)targetPos.m_123343_(), (ItemStack)stackInPlayer);
                                if (toolStackIsDamageable) continue;
                                ItemStack toRemove = toolStack.m_41777_();
                                toRemove.m_41764_(1);
                                pedestal.removeItemStack(toRemove, false);
                            }
                            if (toolStackIsDamageable && ((Boolean)PedestalConfig.COMMON.hiveharvester_DamageTools.get()).booleanValue()) {
                                pedestal.damageTool(toolStack, 1, false);
                            }
                            if (pedestal.canSpawnParticles()) {
                                MowLibPacketHandler.sendToNearby((Level)level, (BlockPos)pedestalPos, (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)targetPos.m_123341_(), (double)((float)targetPos.m_123342_() + 1.0f), (double)targetPos.m_123343_(), new int[]{255, 246, 0}));
                            }
                        }
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

