/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Upgrades.Pedestal;

import com.mowmaster.mowlib.MowLibUtils.MowLibCompoundTagUtils;
import com.mowmaster.mowlib.Networking.MowLibPacketHandler;
import com.mowmaster.mowlib.Networking.MowLibPacketParticles;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Configs.PedestalConfig;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;

public class ItemUpgradeGenerator_FurnaceFuels
extends ItemUpgradeBase {
    public ItemUpgradeGenerator_FurnaceFuels(Item.Properties p_41383_) {
        super(new Item.Properties());
    }

    @Override
    public boolean canModifySpeed(ItemStack upgradeItemStack) {
        return true;
    }

    public int baseEnergyProduction() {
        return (Integer)PedestalConfig.COMMON.upgrade_generator_baseEnergyCost.get();
    }

    @Override
    public int getUpgradeWorkRange(ItemStack coinUpgrade) {
        return 0;
    }

    @Override
    public void actionOnRemovedFromPedestal(BasePedestalBlockEntity pedestal, ItemStack coinInPedestal) {
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41784_(), (String)"_numdelay");
    }

    private int getBurnTimeLeft(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (String)"_numdelay");
    }

    private void setBurnTime(BasePedestalBlockEntity pedestal, int burnTime) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (int)burnTime, (String)"_numdelay");
    }

    private int incrementBurnTime(BasePedestalBlockEntity pedestal, boolean simulate) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        int current = this.getBurnTimeLeft(pedestal);
        if (current > 0) {
            int ticks = 1 + this.getSpeedTicksReduced(pedestal.getCoinOnPedestal());
            int maxTicksReduced = Math.min(current, ticks);
            if (!simulate) {
                MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (int)(current - maxTicksReduced), (String)"_numdelay");
            }
            return maxTicksReduced;
        }
        return 0;
    }

    @Override
    public void updateAction(Level level, BasePedestalBlockEntity pedestal) {
        ItemStack stackInPedestal = pedestal.getItemInPedestal();
        BlockPos pedestalPos = pedestal.getPos();
        int simulatedBurnTime = this.incrementBurnTime(pedestal, true);
        if (simulatedBurnTime > 0) {
            int calcRF = simulatedBurnTime * this.baseEnergyProduction();
            if (pedestal.addEnergy(calcRF, true) >= calcRF) {
                this.incrementBurnTime(pedestal, false);
                pedestal.addEnergy(calcRF, false);
                if (pedestal.canSpawnParticles()) {
                    MowLibPacketHandler.sendToNearby((Level)pedestal.m_58904_(), (BlockPos)pedestalPos, (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)pedestalPos.m_123341_(), (double)pedestalPos.m_123342_() + 0.75, (double)pedestalPos.m_123343_(), new int[]{255, 0, 0}));
                }
            }
        } else if (!stackInPedestal.m_41619_()) {
            ItemStack toBurn = stackInPedestal.m_41777_();
            toBurn.m_41764_(1);
            int burnTime = ForgeHooks.getBurnTime((ItemStack)toBurn, (RecipeType)RecipeType.f_44108_);
            if (burnTime > 0 && !pedestal.removeItemStack(toBurn, true).m_41619_()) {
                if (toBurn.hasCraftingRemainingItem()) {
                    if (ItemUpgradeGenerator_FurnaceFuels.passesItemFilter(pedestal, toBurn.getCraftingRemainingItem())) {
                        this.setBurnTime(pedestal, burnTime);
                        pedestal.removeItemStack(toBurn, false);
                        pedestal.addItem(toBurn.getCraftingRemainingItem(), false);
                    } else if (pedestal.canSpawnParticles()) {
                        MowLibPacketHandler.sendToNearby((Level)pedestal.m_58904_(), (BlockPos)pedestalPos, (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)pedestalPos.m_123341_(), (double)pedestalPos.m_123342_() + 0.75, (double)pedestalPos.m_123343_(), new int[]{128, 128, 128}));
                    }
                } else {
                    this.setBurnTime(pedestal, burnTime);
                    pedestal.removeItemStack(toBurn, false);
                }
            }
        }
    }
}

