/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Upgrades.Pedestal;

import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.Items.Filters.BaseFilter;
import com.mowmaster.mowlib.Items.WorkCards.WorkCardBase;
import com.mowmaster.mowlib.MowLibUtils.MowLibBlockPosUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibCompoundTagUtils;
import com.mowmaster.mowlib.Networking.MowLibPacketHandler;
import com.mowmaster.mowlib.Networking.MowLibPacketParticles;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Configs.PedestalConfig;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChorusFlowerBlock;
import net.minecraft.world.level.block.GrowingPlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemUpgradeFiller
extends ItemUpgradeBase {
    public ItemUpgradeFiller(Item.Properties p_41383_) {
        super(new Item.Properties());
    }

    @Override
    public boolean canModifySpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyBlockCapacity(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyRange(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyArea(ItemStack upgradeItemStack) {
        return (Boolean)PedestalConfig.COMMON.upgrade_require_sized_selectable_area.get();
    }

    @Override
    public boolean needsWorkCard(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public int getWorkCardType() {
        return 1;
    }

    @Override
    public int baseEnergyCostPerDistance() {
        return (Integer)PedestalConfig.COMMON.upgrade_filler_baseEnergyCost.get();
    }

    @Override
    public boolean energyDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_filler_energy_distance_multiplier.get();
    }

    @Override
    public double energyCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_filler_energyMultiplier.get();
    }

    @Override
    public int baseXpCostPerDistance() {
        return (Integer)PedestalConfig.COMMON.upgrade_filler_baseXpCost.get();
    }

    @Override
    public boolean xpDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_filler_xp_distance_multiplier.get();
    }

    @Override
    public double xpCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_filler_xpMultiplier.get();
    }

    @Override
    public DustMagic baseDustCostPerDistance() {
        return new DustMagic(((Integer)PedestalConfig.COMMON.upgrade_filler_dustColor.get()).intValue(), ((Integer)PedestalConfig.COMMON.upgrade_filler_baseDustAmount.get()).intValue());
    }

    @Override
    public boolean dustDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_filler_dust_distance_multiplier.get();
    }

    @Override
    public double dustCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_filler_dustMultiplier.get();
    }

    @Override
    public boolean hasSelectedAreaModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_filler_selectedAllowed.get();
    }

    @Override
    public double selectedAreaCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_filler_selectedMultiplier.get();
    }

    @Override
    public List<String> getUpgradeHUD(BasePedestalBlockEntity pedestal) {
        List<String> messages = super.getUpgradeHUD(pedestal);
        if (messages.isEmpty()) {
            if (this.baseEnergyCostPerDistance() > 0 && pedestal.getStoredEnergy() < this.baseEnergyCostPerDistance()) {
                messages.add(ChatFormatting.RED + "Needs Energy");
                messages.add(ChatFormatting.RED + "To Operate");
            }
            if (this.baseXpCostPerDistance() > 0 && pedestal.getStoredExperience() < this.baseXpCostPerDistance()) {
                messages.add(ChatFormatting.GREEN + "Needs Experience");
                messages.add(ChatFormatting.GREEN + "To Operate");
            }
            if (this.baseDustCostPerDistance().getDustAmount() > 0 && pedestal.getStoredEnergy() < this.baseEnergyCostPerDistance()) {
                messages.add(ChatFormatting.LIGHT_PURPLE + "Needs Dust");
                messages.add(ChatFormatting.LIGHT_PURPLE + "To Operate");
            }
        }
        return messages;
    }

    @Override
    public void actionOnRemovedFromPedestal(BasePedestalBlockEntity pedestal, ItemStack coinInPedestal) {
        super.actionOnRemovedFromPedestal(pedestal, coinInPedestal);
        this.resetCachedValidWorkCardPositions("pedestals", coinInPedestal);
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_numposition");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_numdelay");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_numheight");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_boolstop");
    }

    @Override
    public void upgradeAction(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, ItemStack coin) {
        if (level.m_5776_()) {
            return;
        }
        if (!pedestal.hasItem()) {
            return;
        }
        List<BlockPos> allPositions = this.getValidWorkCardPositions(pedestal, coin, this.getWorkCardType(), "pedestals");
        if (allPositions.isEmpty()) {
            return;
        }
        this.fillerAction(level, pedestal, allPositions);
    }

    private boolean getStopped(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        return MowLibCompoundTagUtils.readBooleanFromNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (String)"_boolstop");
    }

    private void setStopped(BasePedestalBlockEntity pedestal, boolean value) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        MowLibCompoundTagUtils.writeBooleanToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (boolean)value, (String)"_boolstop");
    }

    private int getHeightIteratorValue(BasePedestalBlockEntity pedestal) {
        return (Integer)PedestalConfig.COMMON.upgrade_filler_baseBlocksPlaced.get() + this.getBlockCapacityIncrease(pedestal.getCoinOnPedestal());
    }

    private int getCurrentHeight(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        return coin.m_41784_().m_128441_("pedestals_numheight") ? MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (String)"_numheight") : pedestal.m_58904_().m_141937_();
    }

    private void setCurrentHeight(BasePedestalBlockEntity pedestal, int num) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (int)num, (String)"_numheight");
    }

    private void iterateCurrentHeight(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        int current = this.getCurrentHeight(pedestal);
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (int)(current + this.getHeightIteratorValue(pedestal)), (String)"_numheight");
    }

    private int getCurrentDelay(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (String)"_numdelay");
    }

    private void setCurrentDelay(BasePedestalBlockEntity pedestal, int num) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (int)num, (String)"_numdelay");
    }

    private void iterateCurrentDelay(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        int current = this.getCurrentDelay(pedestal);
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (int)(current + 1 + this.getSpeedTicksReduced(pedestal.getCoinOnPedestal())), (String)"_numdelay");
    }

    private int getCurrentPosition(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (String)"_numposition");
    }

    private void setCurrentPosition(BasePedestalBlockEntity pedestal, int num) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (int)num, (String)"_numposition");
    }

    private void iterateCurrentPosition(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        int current = this.getCurrentPosition(pedestal);
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (int)(current + 1), (String)"_numposition");
    }

    private boolean isToolHighEnoughLevelForBlock(ItemStack toolIn, BlockState getBlock) {
        Item item = toolIn.m_41720_();
        if (item instanceof TieredItem) {
            TieredItem tieredItem = (TieredItem)item;
            Tier toolTier = tieredItem.m_43314_();
            return TierSortingRegistry.isCorrectTierForDrops((Tier)toolTier, (BlockState)getBlock);
        }
        return false;
    }

    private boolean passesFilter(BasePedestalBlockEntity pedestal, ItemStack toPlace) {
        BaseFilter filter;
        ItemStack filterInPedestal;
        Item item;
        if (pedestal.hasFilter() && (item = (filterInPedestal = pedestal.getFilterInBlockEntity()).m_41720_()) instanceof BaseFilter && (filter = (BaseFilter)item).getFilterDirection().neutral() && Block.m_49814_((Item)toPlace.m_41720_()) != Blocks.f_50016_) {
            return filter.canAcceptItems(filterInPedestal, toPlace);
        }
        return true;
    }

    private boolean canPlace(ItemStack toPlace) {
        Block possibleBlock = Block.m_49814_((Item)toPlace.m_41720_());
        List cannotPlaceBlocks = ForgeRegistries.BLOCKS.tags().getTag(BlockTags.create((ResourceLocation)new ResourceLocation("pedestals", "pedestals_cannot_place"))).stream().toList();
        return possibleBlock != Blocks.f_50016_ && !cannotPlaceBlocks.contains(possibleBlock) && !(possibleBlock instanceof IPlantable) && !(possibleBlock instanceof ChorusFlowerBlock) && !(possibleBlock instanceof GrowingPlantBlock);
    }

    public void fillerAction(Level level, BasePedestalBlockEntity pedestal, List<BlockPos> listed) {
        WeakReference<FakePlayer> fakePlayerReference = pedestal.getPedestalPlayer(pedestal);
        if (fakePlayerReference != null && fakePlayerReference.get() != null) {
            ItemStack card;
            Item item;
            FakePlayer fakePlayer = (FakePlayer)fakePlayerReference.get();
            if (pedestal.hasWorkCard() && (item = (card = pedestal.getWorkCardInPedestal()).m_41720_()) instanceof WorkCardBase) {
                int min;
                boolean minMaxHeight;
                WorkCardBase workCardBase = (WorkCardBase)item;
                int currentPosition = this.getCurrentPosition(pedestal);
                BlockPos currentPoint = listed.get(currentPosition);
                AABB area = new AABB(MowLibBlockPosUtils.readBlockPosFromNBT((ItemStack)card, (int)1), MowLibBlockPosUtils.readBlockPosFromNBT((ItemStack)card, (int)2));
                int maxY = (int)area.f_82292_;
                int minY = (int)area.f_82289_;
                int ySpread = maxY - minY;
                boolean bl = minMaxHeight = ySpread > 0;
                if (ySpread > this.getHeightIteratorValue(pedestal)) {
                    this.setCurrentHeight(pedestal, minY);
                }
                int currentYMin = this.getCurrentHeight(pedestal);
                int currentYMax = minMaxHeight ? 0 : currentYMin + this.getHeightIteratorValue(pedestal);
                int n = min = minMaxHeight ? minY : currentYMin;
                int max = minMaxHeight ? (ySpread > this.getHeightIteratorValue(pedestal) ? minY + this.getHeightIteratorValue(pedestal) : maxY) : currentYMax;
                int absoluteMax = minMaxHeight ? maxY : level.m_151558_();
                boolean fuelRemoved = true;
                boolean runsOnce = true;
                boolean stop = this.getStopped(pedestal);
                List<BlockPos> adjustedPoints = IntStream.range(min, max).mapToObj(y -> new BlockPos(currentPoint.m_123341_(), y, currentPoint.m_123343_())).toList();
                List<Integer> distances = adjustedPoints.stream().map(point -> MowLibBlockPosUtils.getDistanceBetweenPoints((BlockPos)pedestal.getPos(), (BlockPos)point)).toList();
                if (this.removeFuelForActionMultiple(pedestal, distances, true)) {
                    if (!stop) {
                        for (BlockPos adjustedPoint : adjustedPoints) {
                            ItemStack toPlace = pedestal.getItemInPedestal().m_41777_();
                            toPlace.m_41764_(1);
                            BlockState blockAtPoint = level.m_8055_(adjustedPoint);
                            if (pedestal.removeItemStack(toPlace, true).m_41619_()) continue;
                            if (this.removeFuelForAction(pedestal, MowLibBlockPosUtils.getDistanceBetweenPoints((BlockPos)pedestal.getPos(), (BlockPos)adjustedPoint), false)) {
                                UseOnContext blockContext;
                                InteractionResult result;
                                if (!this.canPlace(toPlace) || !this.passesFilter(pedestal, toPlace) || adjustedPoint.equals((Object)pedestal.getPos()) || blockAtPoint.m_60734_() != Blocks.f_50016_ || (result = ForgeHooks.onPlaceItemIntoWorld((UseOnContext)(blockContext = new UseOnContext(level, (Player)fakePlayer, InteractionHand.MAIN_HAND, toPlace.m_41777_(), new BlockHitResult(Vec3.f_82478_, this.getPedestalFacing(level, pedestal.getPos()), adjustedPoint, false))))) != InteractionResult.CONSUME) continue;
                                pedestal.removeItemStack(toPlace, false);
                                continue;
                            }
                            fuelRemoved = false;
                        }
                    } else if (pedestal.canSpawnParticles()) {
                        MowLibPacketHandler.sendToNearby((Level)level, (BlockPos)pedestal.getPos(), (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)pedestal.getPos().m_123341_(), (double)((float)pedestal.getPos().m_123342_() + 1.0f), (double)pedestal.getPos().m_123343_(), new int[]{55, 55, 55}));
                    }
                    if (currentPosition + 1 >= listed.size() && currentYMax >= absoluteMax) {
                        if (runsOnce) {
                            int delay = listed.size() * Math.abs((minMaxHeight ? maxY : level.m_151558_()) - (minMaxHeight ? maxY : level.m_141937_()));
                            if (this.getCurrentDelay(pedestal) >= delay) {
                                this.setCurrentPosition(pedestal, 0);
                                this.setStopped(pedestal, false);
                                this.setCurrentDelay(pedestal, 0);
                            } else {
                                this.iterateCurrentDelay(pedestal);
                                this.setStopped(pedestal, true);
                            }
                        } else {
                            this.setCurrentPosition(pedestal, 0);
                        }
                    } else if (currentPosition + 1 >= listed.size()) {
                        this.setCurrentPosition(pedestal, 0);
                        this.iterateCurrentHeight(pedestal);
                    } else if (fuelRemoved) {
                        this.iterateCurrentPosition(pedestal);
                    }
                }
            }
        }
    }
}

