/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Upgrades.Pedestal;

import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.Items.Filters.BaseFilter;
import com.mowmaster.mowlib.MowLibUtils.MowLibBlockPosUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibCompoundTagUtils;
import com.mowmaster.mowlib.Networking.MowLibPacketHandler;
import com.mowmaster.mowlib.Networking.MowLibPacketParticles;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Configs.PedestalConfig;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;

public class ItemUpgradeFertilizer
extends ItemUpgradeBase {
    public ItemUpgradeFertilizer(Item.Properties p_41383_) {
        super(new Item.Properties());
    }

    @Override
    public boolean canModifySpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyRange(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyArea(ItemStack upgradeItemStack) {
        return (Boolean)PedestalConfig.COMMON.upgrade_require_sized_selectable_area.get();
    }

    @Override
    public boolean canModifySuperSpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean needsWorkCard(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public int getWorkCardType() {
        return 0;
    }

    @Override
    public int baseEnergyCostPerDistance() {
        return (Integer)PedestalConfig.COMMON.upgrade_fertilizer_baseEnergyCost.get();
    }

    @Override
    public boolean energyDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_fertilizer_energy_distance_multiplier.get();
    }

    @Override
    public double energyCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_fertilizer_energyMultiplier.get();
    }

    @Override
    public int baseXpCostPerDistance() {
        return (Integer)PedestalConfig.COMMON.upgrade_fertilizer_baseXpCost.get();
    }

    @Override
    public boolean xpDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_fertilizer_xp_distance_multiplier.get();
    }

    @Override
    public double xpCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_fertilizer_xpMultiplier.get();
    }

    @Override
    public DustMagic baseDustCostPerDistance() {
        return new DustMagic(((Integer)PedestalConfig.COMMON.upgrade_fertilizer_dustColor.get()).intValue(), ((Integer)PedestalConfig.COMMON.upgrade_fertilizer_baseDustAmount.get()).intValue());
    }

    @Override
    public boolean dustDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_fertilizer_dust_distance_multiplier.get();
    }

    @Override
    public double dustCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_fertilizer_dustMultiplier.get();
    }

    @Override
    public boolean hasSelectedAreaModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_fertilizer_selectedAllowed.get();
    }

    @Override
    public double selectedAreaCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_fertilizer_selectedMultiplier.get();
    }

    @Override
    public List<String> getUpgradeHUD(BasePedestalBlockEntity pedestal) {
        List<String> messages = super.getUpgradeHUD(pedestal);
        if (messages.size() <= 0) {
            if (this.baseEnergyCostPerDistance() > 0 && pedestal.getStoredEnergy() < this.baseEnergyCostPerDistance()) {
                messages.add(ChatFormatting.RED + "Needs Energy");
                messages.add(ChatFormatting.RED + "To Operate");
            }
            if (this.baseXpCostPerDistance() > 0 && pedestal.getStoredExperience() < this.baseXpCostPerDistance()) {
                messages.add(ChatFormatting.GREEN + "Needs Experience");
                messages.add(ChatFormatting.GREEN + "To Operate");
            }
            if (this.baseDustCostPerDistance().getDustAmount() > 0 && pedestal.getStoredEnergy() < this.baseEnergyCostPerDistance()) {
                messages.add(ChatFormatting.LIGHT_PURPLE + "Needs Dust");
                messages.add(ChatFormatting.LIGHT_PURPLE + "To Operate");
            }
        }
        return messages;
    }

    @Override
    public void actionOnRemovedFromPedestal(BasePedestalBlockEntity pedestal, ItemStack coinInPedestal) {
        super.actionOnRemovedFromPedestal(pedestal, coinInPedestal);
        this.resetCachedValidWorkCardPositions("pedestals", coinInPedestal);
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_numposition");
    }

    @Override
    public void upgradeAction(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, ItemStack coin) {
        List<BlockPos> allPositions = this.getValidWorkCardPositions(pedestal, coin, this.getWorkCardType(), "pedestals");
        if (allPositions.isEmpty()) {
            return;
        }
        this.fertilizerAction(level, pedestal, allPositions);
    }

    private int getCurrentPosition(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (String)"_numposition");
    }

    private void setCurrentPosition(BasePedestalBlockEntity pedestal, int num) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (int)num, (String)"_numposition");
    }

    private void iterateCurrentPosition(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        int current = this.getCurrentPosition(pedestal);
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (int)(current + 1), (String)"_numposition");
    }

    private boolean passesFilter(BasePedestalBlockEntity pedestal, BlockState canMineBlock, BlockPos canMinePos) {
        BaseFilter filter;
        ItemStack filterInPedestal;
        Item item;
        if (pedestal.hasFilter() && (item = (filterInPedestal = pedestal.getFilterInBlockEntity()).m_41720_()) instanceof BaseFilter && (filter = (BaseFilter)item).getFilterDirection().neutral()) {
            ItemStack itemToCheck = pedestal.getItemInPedestal();
            return filter.canAcceptItems(filterInPedestal, itemToCheck);
        }
        return true;
    }

    public static IntegerProperty getBlockPropertyAge(BlockState blockState) {
        for (Property prop : blockState.m_61147_()) {
            if (prop == null || prop.m_61708_() == null || !(prop instanceof IntegerProperty) || !prop.m_61708_().equalsIgnoreCase("age")) continue;
            return (IntegerProperty)prop;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean canUseOn(BasePedestalBlockEntity pedestal, BlockState useOnState, BlockPos useOnPosition, boolean bonemealUsed) {
        Block getBlockToUseOn = useOnState.m_60734_();
        if (bonemealUsed) {
            if (!(getBlockToUseOn instanceof IPlantable) && !(getBlockToUseOn instanceof BonemealableBlock)) return false;
            IntegerProperty propInt = ItemUpgradeFertilizer.getBlockPropertyAge(useOnState);
            if (!useOnState.m_61138_((Property)propInt)) return true;
            int current = (Integer)useOnState.m_61143_((Property)propInt);
            int max = (Integer)Collections.max(propInt.m_6908_());
            if (max <= 0) return false;
            return current != max;
        }
        if (!getBlockToUseOn.m_6724_(useOnState)) return false;
        return true;
    }

    public BlockState getState(Block getBlock, ItemStack itemForBlock) {
        BlockState stated = Blocks.f_50016_.m_49966_();
        stated = itemForBlock.m_41720_() == Items.f_42451_ ? Blocks.f_50088_.m_49966_() : getBlock.m_49966_();
        return stated;
    }

    private BlockPos getPosBasedOnPedestalDirection(BasePedestalBlockEntity pedestalBlockEntity, BlockPos pos) {
        Direction ofPedestal = this.getPedestalFacing(pedestalBlockEntity.m_58904_(), pedestalBlockEntity.getPos());
        switch (ofPedestal) {
            case UP: {
                return pos.m_7495_();
            }
            case DOWN: {
                return pos.m_7494_();
            }
            case NORTH: {
                return pos.m_122019_();
            }
            case EAST: {
                return pos.m_122024_();
            }
            case SOUTH: {
                return pos.m_122012_();
            }
            case WEST: {
                return pos.m_122029_();
            }
        }
        return pos.m_7495_();
    }

    public void fertilizerAction(Level level, BasePedestalBlockEntity pedestal, List<BlockPos> listed) {
        WeakReference<FakePlayer> getPlayer;
        if (!level.m_5776_() && (getPlayer = pedestal.getPedestalPlayer(pedestal)) != null && getPlayer.get() != null) {
            if (this.hasSuperSpeed(pedestal.getCoinOnPedestal())) {
                ItemStack stackInPed = pedestal.getItemInPedestal();
                for (BlockPos currentPoint : listed) {
                    BlockState blockAtPoint = level.m_8055_(currentPoint);
                    if (!this.removeFuelForAction(pedestal, MowLibBlockPosUtils.getDistanceBetweenPoints((BlockPos)pedestal.getPos(), (BlockPos)currentPoint), true) || !this.passesFilter(pedestal, blockAtPoint, currentPoint) || currentPoint.equals((Object)pedestal.getPos()) || level.m_8055_(currentPoint).m_60734_() == Blocks.f_50016_) continue;
                    if (!pedestal.removeItem(1, true).m_41619_() && blockAtPoint.m_60734_() instanceof BonemealableBlock) {
                        UseOnContext blockContext;
                        InteractionResult result;
                        Item item = stackInPed.m_41720_();
                        if (!(item instanceof BoneMealItem)) continue;
                        BoneMealItem bonerItem = (BoneMealItem)item;
                        if (!this.canUseOn(pedestal, blockAtPoint, currentPoint, true) || !this.removeFuelForAction(pedestal, MowLibBlockPosUtils.getDistanceBetweenPoints((BlockPos)pedestal.getPos(), (BlockPos)currentPoint), false) || (result = bonerItem.m_6225_(blockContext = new UseOnContext(level, getPlayer.get() == null ? (Player)pedestal.getPedestalPlayer(pedestal).get() : (Player)getPlayer.get(), InteractionHand.MAIN_HAND, pedestal.getItemInPedestal().m_41777_(), new BlockHitResult(Vec3.f_82478_, this.getPedestalFacing(level, pedestal.getPos()), currentPoint, false)))) != InteractionResult.CONSUME) continue;
                        if (pedestal.canSpawnParticles()) {
                            MowLibPacketHandler.sendToNearby((Level)level, (BlockPos)pedestal.getPos(), (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)currentPoint.m_123341_(), (double)((float)currentPoint.m_123342_() + 1.0f), (double)currentPoint.m_123343_(), new int[]{0, 255, 0}));
                        }
                        pedestal.removeItem(1, false);
                        continue;
                    }
                    if (!this.canUseOn(pedestal, blockAtPoint, currentPoint, false) || !this.removeFuelForAction(pedestal, MowLibBlockPosUtils.getDistanceBetweenPoints((BlockPos)pedestal.getPos(), (BlockPos)currentPoint), false)) continue;
                    blockAtPoint.m_222972_((ServerLevel)level, currentPoint, RandomSource.m_216327_());
                    if (!pedestal.canSpawnParticles()) continue;
                    MowLibPacketHandler.sendToNearby((Level)level, (BlockPos)pedestal.getPos(), (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)currentPoint.m_123341_(), (double)((float)currentPoint.m_123342_() + 1.0f), (double)currentPoint.m_123343_(), new int[]{240, 240, 240}));
                }
            } else {
                int currentPosition = this.getCurrentPosition(pedestal);
                BlockPos currentPoint = listed.get(currentPosition);
                BlockState blockAtPoint = level.m_8055_(currentPoint);
                ItemStack stackInPed = pedestal.getItemInPedestal();
                if (this.removeFuelForAction(pedestal, MowLibBlockPosUtils.getDistanceBetweenPoints((BlockPos)pedestal.getPos(), (BlockPos)currentPoint), true)) {
                    if (this.passesFilter(pedestal, blockAtPoint, currentPoint) && !currentPoint.equals((Object)pedestal.getPos()) && level.m_8055_(currentPoint).m_60734_() != Blocks.f_50016_) {
                        if (!pedestal.removeItem(1, true).m_41619_() && blockAtPoint.m_60734_() instanceof BonemealableBlock) {
                            Item blockContext = stackInPed.m_41720_();
                            if (blockContext instanceof BoneMealItem) {
                                InteractionResult result;
                                BoneMealItem bonerItem = (BoneMealItem)blockContext;
                                if (this.canUseOn(pedestal, blockAtPoint, currentPoint, true) && this.removeFuelForAction(pedestal, MowLibBlockPosUtils.getDistanceBetweenPoints((BlockPos)pedestal.getPos(), (BlockPos)currentPoint), false) && (result = bonerItem.m_6225_((UseOnContext)(blockContext = new UseOnContext(level, getPlayer.get() == null ? (Player)pedestal.getPedestalPlayer(pedestal).get() : (Player)getPlayer.get(), InteractionHand.MAIN_HAND, pedestal.getItemInPedestal().m_41777_(), new BlockHitResult(Vec3.f_82478_, this.getPedestalFacing(level, pedestal.getPos()), currentPoint, false))))) == InteractionResult.CONSUME) {
                                    if (pedestal.canSpawnParticles()) {
                                        MowLibPacketHandler.sendToNearby((Level)level, (BlockPos)pedestal.getPos(), (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)currentPoint.m_123341_(), (double)((float)currentPoint.m_123342_() + 1.0f), (double)currentPoint.m_123343_(), new int[]{0, 255, 0}));
                                    }
                                    pedestal.removeItem(1, false);
                                }
                            }
                        } else if (this.canUseOn(pedestal, blockAtPoint, currentPoint, false) && this.removeFuelForAction(pedestal, MowLibBlockPosUtils.getDistanceBetweenPoints((BlockPos)pedestal.getPos(), (BlockPos)currentPoint), false)) {
                            blockAtPoint.m_222972_((ServerLevel)level, currentPoint, RandomSource.m_216327_());
                            if (pedestal.canSpawnParticles()) {
                                MowLibPacketHandler.sendToNearby((Level)level, (BlockPos)pedestal.getPos(), (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)currentPoint.m_123341_(), (double)((float)currentPoint.m_123342_() + 1.0f), (double)currentPoint.m_123343_(), new int[]{240, 240, 240}));
                            }
                        }
                    }
                    if (currentPosition + 1 >= listed.size()) {
                        this.setCurrentPosition(pedestal, 0);
                    } else {
                        this.iterateCurrentPosition(pedestal);
                    }
                }
            }
        }
    }
}

