/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Upgrades.Pedestal;

import com.mowmaster.mowlib.BlockEntities.MowLibBaseBlockEntity;
import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.Items.WorkCards.WorkCardArea;
import com.mowmaster.mowlib.MowLibUtils.MowLibBlockPosUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibCompoundTagUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibContainerUtils;
import com.mowmaster.mowlib.Recipes.BaseBlockEntityFilter;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Configs.PedestalConfig;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ItemUpgradeFan
extends ItemUpgradeBase {
    public ItemUpgradeFan(Item.Properties p_41383_) {
        super(new Item.Properties());
    }

    @Override
    public boolean canModifySpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyRange(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyArea(ItemStack upgradeItemStack) {
        return (Boolean)PedestalConfig.COMMON.upgrade_require_sized_selectable_area.get();
    }

    @Override
    public boolean needsWorkCard(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public int getWorkCardType() {
        return 1;
    }

    @Override
    public int baseEnergyCostPerDistance() {
        return (Integer)PedestalConfig.COMMON.upgrade_fan_baseEnergyCost.get();
    }

    @Override
    public boolean energyDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_fan_energy_distance_multiplier.get();
    }

    @Override
    public double energyCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_fan_energyMultiplier.get();
    }

    @Override
    public int baseXpCostPerDistance() {
        return (Integer)PedestalConfig.COMMON.upgrade_fan_baseXpCost.get();
    }

    @Override
    public boolean xpDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_fan_xp_distance_multiplier.get();
    }

    @Override
    public double xpCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_fan_xpMultiplier.get();
    }

    @Override
    public DustMagic baseDustCostPerDistance() {
        return new DustMagic(((Integer)PedestalConfig.COMMON.upgrade_fan_dustColor.get()).intValue(), ((Integer)PedestalConfig.COMMON.upgrade_fan_baseDustAmount.get()).intValue());
    }

    @Override
    public boolean dustDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_fan_dust_distance_multiplier.get();
    }

    @Override
    public double dustCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_fan_dustMultiplier.get();
    }

    @Override
    public boolean hasSelectedAreaModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_fan_selectedAllowed.get();
    }

    @Override
    public double selectedAreaCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_fan_selectedMultiplier.get();
    }

    @Override
    public List<String> getUpgradeHUD(BasePedestalBlockEntity pedestal) {
        List<String> messages = super.getUpgradeHUD(pedestal);
        if (messages.size() <= 0) {
            if (this.baseEnergyCostPerDistance() > 0 && pedestal.getStoredEnergy() < this.baseEnergyCostPerDistance()) {
                messages.add(ChatFormatting.RED + "Needs Energy");
                messages.add(ChatFormatting.RED + "To Operate");
            }
            if (this.baseXpCostPerDistance() > 0 && pedestal.getStoredExperience() < this.baseXpCostPerDistance()) {
                messages.add(ChatFormatting.GREEN + "Needs Experience");
                messages.add(ChatFormatting.GREEN + "To Operate");
            }
            if (this.baseDustCostPerDistance().getDustAmount() > 0 && pedestal.getStoredEnergy() < this.baseEnergyCostPerDistance()) {
                messages.add(ChatFormatting.LIGHT_PURPLE + "Needs Dust");
                messages.add(ChatFormatting.LIGHT_PURPLE + "To Operate");
            }
        }
        return messages;
    }

    @Override
    public ItemStack getUpgradeDefaultTool() {
        return new ItemStack((ItemLike)Items.f_42398_);
    }

    @Nullable
    protected BaseBlockEntityFilter getRecipeFilterBlock(Level level, ItemStack stackIn) {
        Container container = MowLibContainerUtils.getContainer((int)1);
        container.m_6836_(-1, stackIn);
        List recipes = level.m_7465_().m_44056_((RecipeType)BaseBlockEntityFilter.Type.INSTANCE, container, level);
        return level != null ? (recipes.size() > 0 ? (BaseBlockEntityFilter)recipes.stream().findFirst().get() : null) : null;
    }

    protected String getProcessResultFilterBlock(BaseBlockEntityFilter recipe) {
        return recipe == null ? "" : recipe.getResultEntityString();
    }

    protected int getProcessResultFilterBlockMobType(BaseBlockEntityFilter recipe) {
        return recipe == null ? 1 : recipe.getResultMobType();
    }

    protected boolean getProcessResultFilterBlockIsBaby(BaseBlockEntityFilter recipe) {
        return recipe == null ? false : recipe.getResultBaby();
    }

    public boolean hasBaseBlock(ItemStack coinInPedestal) {
        String entityString;
        ItemStack getBaseBlockList;
        CompoundTag tag = new CompoundTag();
        if (coinInPedestal.m_41782_()) {
            tag = coinInPedestal.m_41783_();
        }
        return !(getBaseBlockList = MowLibCompoundTagUtils.readItemStackFromNBT((String)"pedestals", (CompoundTag)tag, (String)"_baseblockStack")).m_41619_() && (entityString = MowLibCompoundTagUtils.readStringFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_entityString")) != "";
    }

    public boolean allowEntity(ItemStack coinInPedestal, Entity entityIn) {
        String entityString;
        ItemStack baseBlock = MowLibCompoundTagUtils.readItemStackFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_baseBlockStack");
        if (!baseBlock.m_41619_() && (entityString = MowLibCompoundTagUtils.readStringFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_entityString")) != "") {
            int entityTypeNum = MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_entityType");
            boolean isBaby = MowLibCompoundTagUtils.readBooleanFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_entityIsBaby");
            if (entityTypeNum == 0) {
                if (entityIn.getClassification(false).equals((Object)MobCategory.byName((String)entityString))) {
                    if (isBaby && entityIn instanceof LivingEntity) {
                        LivingEntity entity = (LivingEntity)entityIn;
                        return entity.m_6162_();
                    }
                    return true;
                }
            } else if (entityTypeNum == 1) {
                if (!EntityType.m_20632_((String)entityString).isPresent()) {
                    return false;
                }
                if (entityIn.m_6095_().equals(EntityType.m_20632_((String)entityString).get())) {
                    if (isBaby && entityIn instanceof LivingEntity) {
                        LivingEntity entity = (LivingEntity)entityIn;
                        return entity.m_6162_();
                    }
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    protected void addMotion(double speed, Direction enumfacing, Entity entity) {
        switch (enumfacing) {
            case DOWN: {
                entity.m_20334_(entity.m_20184_().f_82479_, entity.m_20184_().f_82480_ - speed, entity.m_20184_().f_82481_);
                break;
            }
            case UP: {
                entity.m_20334_(entity.m_20184_().f_82479_, entity.m_20184_().f_82480_ + speed, entity.m_20184_().f_82481_);
                break;
            }
            case NORTH: {
                entity.m_20334_(entity.m_20184_().f_82479_, entity.m_20184_().f_82480_, entity.m_20184_().f_82481_ - speed);
                break;
            }
            case SOUTH: {
                entity.m_20334_(entity.m_20184_().f_82479_, entity.m_20184_().f_82480_, entity.m_20184_().f_82481_ + speed);
                break;
            }
            case WEST: {
                entity.m_20334_(entity.m_20184_().f_82479_ - speed, entity.m_20184_().f_82480_, entity.m_20184_().f_82481_);
                break;
            }
            case EAST: {
                entity.m_20334_(entity.m_20184_().f_82479_ + speed, entity.m_20184_().f_82480_, entity.m_20184_().f_82481_);
            }
        }
    }

    @Override
    public void updateAction(Level level, BasePedestalBlockEntity pedestal) {
        if (level.m_46467_() % 2L == 0L) {
            this.fanAction(pedestal, level, pedestal.getPos(), pedestal.getCoinOnPedestal());
        }
    }

    public void fanAction(BasePedestalBlockEntity pedestal, Level level, BlockPos posOfPedestal, ItemStack coinInPedestal) {
        ItemStack workCardItemStack = pedestal.getWorkCardInPedestal();
        if (workCardItemStack.m_41720_() instanceof WorkCardArea) {
            List entities = WorkCardArea.getEntitiesInRangeOfUpgrade((Level)level, LivingEntity.class, (ItemStack)workCardItemStack, (MowLibBaseBlockEntity)pedestal, (int)this.getUpgradeWorkRange(coinInPedestal));
            if (this.removeFuelForAction(pedestal, 0, false)) {
                Direction facing = this.getPedestalFacing(level, posOfPedestal);
                for (LivingEntity entity : entities) {
                    Player player;
                    if (entity == null || !this.allowEntity(coinInPedestal, (Entity)entity) || entity instanceof Player && (player = (Player)entity).m_6047_()) continue;
                    this.addMotion((facing == Direction.UP ? 0.2 : 0.1) + (double)((this.getSpeedTicksReduced(coinInPedestal) == 0 ? 1 : this.getSpeedTicksReduced(coinInPedestal)) / (Integer)PedestalConfig.COMMON.pedestal_maxTicksToTransfer.get()), facing, (Entity)entity);
                }
            }
        }
    }

    @Override
    public void actionOnAddedToPedestal(Player player, BasePedestalBlockEntity pedestal, ItemStack coinInPedestal) {
        super.actionOnAddedToPedestal(player, pedestal, coinInPedestal);
        Level level = pedestal.m_58904_();
        CompoundTag tagCoin = new CompoundTag();
        if (coinInPedestal.m_41782_()) {
            tagCoin = coinInPedestal.m_41783_();
        }
        ItemStack getBaseBlock = this.getBaseBlock(pedestal);
        BaseBlockEntityFilter filter = this.getRecipeFilterBlock(level, getBaseBlock);
        tagCoin = MowLibCompoundTagUtils.writeItemStackToNBT((String)"pedestals", (CompoundTag)tagCoin, (ItemStack)getBaseBlock, (String)"_baseBlockStack");
        tagCoin = MowLibCompoundTagUtils.writeStringToNBT((String)"pedestals", (CompoundTag)tagCoin, (String)this.getProcessResultFilterBlock(filter), (String)"_entityString");
        tagCoin = MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)tagCoin, (int)this.getProcessResultFilterBlockMobType(filter), (String)"_entityType");
        tagCoin = MowLibCompoundTagUtils.writeBooleanToNBT((String)"pedestals", (CompoundTag)tagCoin, (boolean)this.getProcessResultFilterBlockIsBaby(filter), (String)"_entityIsBaby");
        coinInPedestal.m_41751_(tagCoin);
    }

    @Override
    public void actionOnRemovedFromPedestal(BasePedestalBlockEntity pedestal, ItemStack coinInPedestal) {
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_baseBlockStack");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_entityString");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_entityType");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_entityIsBaby");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_fanEntityId");
    }

    public ItemStack getBaseBlock(BasePedestalBlockEntity pedestal) {
        return new ItemStack((ItemLike)pedestal.m_58904_().m_8055_(MowLibBlockPosUtils.getPosOfBlockBelow((Level)pedestal.m_58904_(), (BlockPos)pedestal.getPos(), (int)1)).m_60734_().m_5456_());
    }

    @Override
    public void actionOnNeighborBelowChange(BasePedestalBlockEntity pedestal, BlockPos belowBlock) {
        Level level = pedestal.m_58904_();
        CompoundTag tagCoin = new CompoundTag();
        ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
        if (coinInPedestal.m_41782_()) {
            tagCoin = coinInPedestal.m_41783_();
        }
        ItemStack getBaseBlock = this.getBaseBlock(pedestal);
        BaseBlockEntityFilter filter = this.getRecipeFilterBlock(level, getBaseBlock);
        tagCoin = MowLibCompoundTagUtils.writeItemStackToNBT((String)"pedestals", (CompoundTag)tagCoin, (ItemStack)getBaseBlock, (String)"_baseBlockStack");
        tagCoin = MowLibCompoundTagUtils.writeStringToNBT((String)"pedestals", (CompoundTag)tagCoin, (String)this.getProcessResultFilterBlock(filter), (String)"_entityString");
        tagCoin = MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)tagCoin, (int)this.getProcessResultFilterBlockMobType(filter), (String)"_entityType");
        tagCoin = MowLibCompoundTagUtils.writeBooleanToNBT((String)"pedestals", (CompoundTag)tagCoin, (boolean)this.getProcessResultFilterBlockIsBaby(filter), (String)"_entityIsBaby");
        coinInPedestal.m_41751_(tagCoin);
    }
}

