/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Upgrades.Pedestal;

import com.mowmaster.mowlib.MowLibUtils.MowLibBlockPosUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibCompoundTagUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibContainerUtils;
import com.mowmaster.mowlib.Networking.MowLibPacketHandler;
import com.mowmaster.mowlib.Networking.MowLibPacketParticles;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.RepairItemRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemUpgradeCrafter
extends ItemUpgradeBase {
    public ItemUpgradeCrafter(Item.Properties p_41383_) {
        super(new Item.Properties());
    }

    @Override
    public boolean canModifySpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyRange(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean needsWorkCard(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public int getWorkCardType() {
        return 3;
    }

    @Override
    public void actionOnRemovedFromPedestal(BasePedestalBlockEntity pedestal, ItemStack coinInPedestal) {
        super.actionOnRemovedFromPedestal(pedestal, coinInPedestal);
        this.resetCachedValidWorkCardPositions("pedestals", coinInPedestal);
        this.resetCachedRecipe("pedestals", coinInPedestal);
        CompoundTag tag = coinInPedestal.m_41784_();
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)tag, (String)"input");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)tag, (String)"output");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)tag, (String)"hasrecipe");
    }

    @Override
    public void upgradeAction(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, ItemStack coin) {
        List<BlockPos> allPositions = this.getValidWorkCardPositions(pedestal, coin, this.getWorkCardType(), "pedestals");
        if (allPositions.isEmpty()) {
            return;
        }
        this.crafterAction(level, pedestal, allPositions);
    }

    public void resetCachedRecipe(String modID, ItemStack stackToStoreNBT) {
        CompoundTag tag = stackToStoreNBT.m_41784_();
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)modID, (CompoundTag)tag, (String)"craft_ingredients");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)modID, (CompoundTag)tag, (String)"craft_result");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)modID, (CompoundTag)tag, (String)"craft_cached");
    }

    private ItemStack getAndCacheCraftingResult(String modID, Level level, ItemStack stackToStoreNBT, List<ItemStack> ingredients) {
        int numIngredients = ingredients.size();
        int dimension = (int)Math.ceil(Math.sqrt(numIngredients));
        TransientCraftingContainer craftingContainer = new TransientCraftingContainer(MowLibContainerUtils.getAbstractContainerMenu((int)40), dimension, dimension);
        for (int i = 0; i < numIngredients; ++i) {
            craftingContainer.m_6836_(i, ingredients.get(i));
        }
        RecipeManager recipeManager = level.m_7465_();
        Optional result = recipeManager.m_44015_(RecipeType.f_44107_, (Container)craftingContainer, level);
        if (result.isPresent()) {
            CraftingRecipe recipe = (CraftingRecipe)result.get();
            ItemStack resultItem = recipe instanceof RepairItemRecipe ? recipe.m_5874_((Container)craftingContainer, level.m_9598_()) : recipe.m_8043_(level.m_9598_());
            CompoundTag tag = stackToStoreNBT.m_41784_();
            MowLibCompoundTagUtils.writeItemStackListToNBT((String)modID, (CompoundTag)tag, ingredients, (String)"craft_ingredients");
            MowLibCompoundTagUtils.writeItemStackToNBT((String)modID, (CompoundTag)tag, (ItemStack)resultItem, (String)"craft_result");
            MowLibCompoundTagUtils.writeBooleanToNBT((String)modID, (CompoundTag)tag, (boolean)true, (String)"craft_cached");
            return resultItem;
        }
        MowLibCompoundTagUtils.writeBooleanToNBT((String)modID, (CompoundTag)stackToStoreNBT.m_41784_(), (boolean)false, (String)"craft_cached");
        return ItemStack.f_41583_;
    }

    private boolean hasCachedRecipe(String modID, ItemStack stackToStoreNBT) {
        return MowLibCompoundTagUtils.readBooleanFromNBT((String)modID, (CompoundTag)stackToStoreNBT.m_41784_(), (String)"craft_cached");
    }

    private boolean cachedRecipeHasSameInputs(String modID, ItemStack stackToStoreNBT, List<ItemStack> ingredients) {
        List cachedIngredients = MowLibCompoundTagUtils.readItemStackListFromNBT((String)modID, (CompoundTag)stackToStoreNBT.m_41784_(), (String)"craft_ingredients");
        if (ingredients.size() == cachedIngredients.size()) {
            for (int i = 0; i < ingredients.size(); ++i) {
                ItemStack cachedIngredient;
                ItemStack ingredient = ingredients.get(i);
                if (ItemHandlerHelper.canItemStacksStack((ItemStack)ingredient, (ItemStack)(cachedIngredient = (ItemStack)cachedIngredients.get(i))) || ingredient.m_41619_() && cachedIngredient.m_41619_()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public ItemStack getCraftingResult(String modID, Level level, ItemStack stackToStoreNBT, List<ItemStack> ingredients) {
        if (this.hasCachedRecipe(modID, stackToStoreNBT) && this.cachedRecipeHasSameInputs(modID, stackToStoreNBT, ingredients)) {
            return MowLibCompoundTagUtils.readItemStackFromNBT((String)modID, (CompoundTag)stackToStoreNBT.m_41784_(), (String)"craft_result");
        }
        return this.getAndCacheCraftingResult(modID, level, stackToStoreNBT, ingredients);
    }

    public void crafterAction(Level level, BasePedestalBlockEntity crafterPedestal, List<BlockPos> allPositions) {
        if (!level.m_5776_()) {
            BlockPos crafterBlockPos = crafterPedestal.getPos();
            BlockPos crafterParticleBlockPos = MowLibBlockPosUtils.getPosOfBlockBelow((Level)level, (BlockPos)crafterBlockPos, (int)-1);
            List ingredientPedestals = allPositions.stream().map(arg_0 -> ((Level)level).m_7702_(arg_0)).flatMap(entity -> {
                if (entity instanceof BasePedestalBlockEntity) {
                    BasePedestalBlockEntity pedestalEntity = (BasePedestalBlockEntity)((Object)entity);
                    return Stream.of(pedestalEntity);
                }
                return Stream.empty();
            }).toList();
            if (ingredientPedestals.size() != allPositions.size()) {
                if (crafterPedestal.canSpawnParticles()) {
                    MowLibPacketHandler.sendToNearby((Level)level, (BlockPos)crafterBlockPos, (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)crafterParticleBlockPos.m_123341_(), (double)crafterParticleBlockPos.m_123342_(), (double)crafterParticleBlockPos.m_123343_(), new int[]{255, 0, 0}));
                }
                return;
            }
            List<ItemStack> ingredientList = ingredientPedestals.stream().map(BasePedestalBlockEntity::getItemInPedestal).toList();
            ItemStack craftingResult = this.getCraftingResult("pedestals", level, crafterPedestal.getCoinOnPedestal(), ingredientList);
            if (!craftingResult.m_41619_()) {
                if (crafterPedestal.addItem(craftingResult, true)) {
                    for (BasePedestalBlockEntity ingredientPedestal : ingredientPedestals) {
                        ItemStack toRemove = ingredientPedestal.getItemInPedestal().m_41777_();
                        toRemove.m_41764_(1);
                        ingredientPedestal.removeItemStack(toRemove, false);
                        if (toRemove.hasCraftingRemainingItem()) {
                            ingredientPedestal.addItem(toRemove.getCraftingRemainingItem(), false);
                        }
                        if (!ingredientPedestal.canSpawnParticles()) continue;
                        BlockPos particleBlockPos = MowLibBlockPosUtils.getPosOfBlockBelow((Level)level, (BlockPos)ingredientPedestal.getPos(), (int)-1);
                        MowLibPacketHandler.sendToNearby((Level)level, (BlockPos)ingredientPedestal.getPos(), (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)particleBlockPos.m_123341_(), (double)particleBlockPos.m_123342_(), (double)particleBlockPos.m_123343_(), new int[]{50, 200, 0}));
                    }
                    if (crafterPedestal.addItem(craftingResult, true)) {
                        crafterPedestal.addItem(craftingResult, false);
                    } else {
                        BlockPos pedestalPos = MowLibBlockPosUtils.getPosOfBlockBelow((Level)level, (BlockPos)crafterBlockPos, (int)-1);
                        ItemEntity itemEntity = new ItemEntity(level, (double)pedestalPos.m_123341_(), (double)pedestalPos.m_123342_(), (double)pedestalPos.m_123343_(), craftingResult);
                        itemEntity.m_32060_();
                        itemEntity.m_20334_(0.0, 0.0, 0.0);
                        itemEntity.m_20219_(Vec3.m_82512_((Vec3i)pedestalPos));
                        level.m_7967_((Entity)itemEntity);
                    }
                    if (crafterPedestal.canSpawnParticles()) {
                        MowLibPacketHandler.sendToNearby((Level)level, (BlockPos)crafterBlockPos, (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)crafterParticleBlockPos.m_123341_(), (double)crafterParticleBlockPos.m_123342_(), (double)crafterParticleBlockPos.m_123343_(), new int[]{0, 255, 0}));
                    }
                } else if (crafterPedestal.canSpawnParticles()) {
                    MowLibPacketHandler.sendToNearby((Level)level, (BlockPos)crafterBlockPos, (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)crafterParticleBlockPos.m_123341_(), (double)crafterParticleBlockPos.m_123342_(), (double)crafterParticleBlockPos.m_123343_(), new int[]{50, 50, 50}));
                }
            }
        }
    }
}

