/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Upgrades.Pedestal;

import com.mowmaster.mowlib.BlockEntities.MowLibBaseBlockEntity;
import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.Items.Filters.BaseFilter;
import com.mowmaster.mowlib.Items.WorkCards.WorkCardBase;
import com.mowmaster.mowlib.MowLibUtils.MowLibBlockPosUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibCompoundTagUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibItemUtils;
import com.mowmaster.mowlib.Networking.MowLibPacketHandler;
import com.mowmaster.mowlib.Networking.MowLibPacketParticles;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Configs.PedestalConfig;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemUpgradeChopper
extends ItemUpgradeBase {
    public ItemUpgradeChopper(Item.Properties p_41383_) {
        super(new Item.Properties());
    }

    @Override
    public boolean canModifySpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyRange(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyArea(ItemStack upgradeItemStack) {
        return (Boolean)PedestalConfig.COMMON.upgrade_require_sized_selectable_area.get();
    }

    @Override
    public boolean canModifySuperSpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean needsWorkCard(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public int getWorkCardType() {
        return 1;
    }

    @Override
    public int baseEnergyCostPerDistance() {
        return (Integer)PedestalConfig.COMMON.upgrade_chopper_baseEnergyCost.get();
    }

    @Override
    public boolean energyDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_chopper_energy_distance_multiplier.get();
    }

    @Override
    public double energyCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_chopper_energyMultiplier.get();
    }

    @Override
    public int baseXpCostPerDistance() {
        return (Integer)PedestalConfig.COMMON.upgrade_chopper_baseXpCost.get();
    }

    @Override
    public boolean xpDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_chopper_xp_distance_multiplier.get();
    }

    @Override
    public double xpCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_chopper_xpMultiplier.get();
    }

    @Override
    public DustMagic baseDustCostPerDistance() {
        return new DustMagic(((Integer)PedestalConfig.COMMON.upgrade_chopper_dustColor.get()).intValue(), ((Integer)PedestalConfig.COMMON.upgrade_chopper_baseDustAmount.get()).intValue());
    }

    @Override
    public boolean dustDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_chopper_dust_distance_multiplier.get();
    }

    @Override
    public double dustCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_chopper_dustMultiplier.get();
    }

    @Override
    public boolean hasSelectedAreaModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_chopper_selectedAllowed.get();
    }

    @Override
    public double selectedAreaCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_chopper_selectedMultiplier.get();
    }

    @Override
    public List<String> getUpgradeHUD(BasePedestalBlockEntity pedestal) {
        List<String> messages = super.getUpgradeHUD(pedestal);
        if (messages.size() <= 0) {
            if (this.baseEnergyCostPerDistance() > 0 && pedestal.getStoredEnergy() < this.baseEnergyCostPerDistance()) {
                messages.add(ChatFormatting.RED + "Needs Energy");
                messages.add(ChatFormatting.RED + "To Operate");
            }
            if (this.baseXpCostPerDistance() > 0 && pedestal.getStoredExperience() < this.baseXpCostPerDistance()) {
                messages.add(ChatFormatting.GREEN + "Needs Experience");
                messages.add(ChatFormatting.GREEN + "To Operate");
            }
            if (this.baseDustCostPerDistance().getDustAmount() > 0 && pedestal.getStoredEnergy() < this.baseEnergyCostPerDistance()) {
                messages.add(ChatFormatting.LIGHT_PURPLE + "Needs Dust");
                messages.add(ChatFormatting.LIGHT_PURPLE + "To Operate");
            }
        }
        return messages;
    }

    @Override
    public ItemStack getUpgradeDefaultTool() {
        return new ItemStack((ItemLike)Items.f_42386_);
    }

    private boolean getStopped(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        return MowLibCompoundTagUtils.readBooleanFromNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (String)"_boolstop");
    }

    private void setStopped(BasePedestalBlockEntity pedestal, boolean value) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        MowLibCompoundTagUtils.writeBooleanToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (boolean)value, (String)"_boolstop");
    }

    private void buildValidBlockList(BasePedestalBlockEntity pedestal) {
        ItemStack card;
        Item item;
        ItemStack coin = pedestal.getCoinOnPedestal();
        if (pedestal.hasWorkCard() && (item = (card = pedestal.getWorkCardInPedestal()).m_41720_()) instanceof WorkCardBase) {
            WorkCardBase workCardBase = (WorkCardBase)item;
            List listed = MowLibBlockPosUtils.readBlockPosListFromNBT((ItemStack)card);
            ArrayList<BlockPos> valid = new ArrayList<BlockPos>();
            for (BlockPos pos : listed) {
                if (!MowLibBlockPosUtils.selectedPointWithinRange((MowLibBaseBlockEntity)pedestal, (BlockPos)pos, (int)this.getUpgradeWorkRange(coin))) continue;
                valid.add(pos);
            }
            MowLibBlockPosUtils.saveBlockPosListCustomToNBT((String)"pedestals", (String)"_validlist", (ItemStack)coin, valid);
        }
    }

    private void buildValidBlockListArea(BasePedestalBlockEntity pedestal) {
        ItemStack card;
        Item item;
        ItemStack coin = pedestal.getCoinOnPedestal();
        ArrayList<BlockPos> valid = new ArrayList<BlockPos>();
        if (pedestal.hasWorkCard() && (item = (card = pedestal.getWorkCardInPedestal()).m_41720_()) instanceof WorkCardBase) {
            WorkCardBase workCardBase = (WorkCardBase)item;
            AABB area = new AABB(MowLibBlockPosUtils.readBlockPosFromNBT((ItemStack)card, (int)1), MowLibBlockPosUtils.readBlockPosFromNBT((ItemStack)card, (int)2));
            int maxX = (int)area.f_82291_;
            int maxY = (int)area.f_82292_;
            int maxZ = (int)area.f_82293_;
            int minX = (int)area.f_82288_;
            int minY = (int)area.f_82289_;
            int minZ = (int)area.f_82290_;
            BlockPos pedestalPos = pedestal.getPos();
            for (int i = maxX; i >= minX; --i) {
                for (int j = maxZ; j >= minZ; --j) {
                    BlockPos newPoint = new BlockPos(i, pedestalPos.m_123342_(), j);
                    if (!MowLibBlockPosUtils.selectedPointWithinRange((MowLibBaseBlockEntity)pedestal, (BlockPos)newPoint, (int)this.getUpgradeWorkRange(coin))) continue;
                    valid.add(newPoint);
                }
            }
        }
        MowLibBlockPosUtils.saveBlockPosListCustomToNBT((String)"pedestals", (String)"_validlist", (ItemStack)coin, valid);
    }

    private List<BlockPos> getValidList(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        return MowLibBlockPosUtils.readBlockPosListCustomFromNBT((String)"pedestals", (String)"_validlist", (ItemStack)coin);
    }

    @Override
    public void actionOnRemovedFromPedestal(BasePedestalBlockEntity pedestal, ItemStack coinInPedestal) {
        super.actionOnRemovedFromPedestal(pedestal, coinInPedestal);
        MowLibBlockPosUtils.removeBlockListCustomNBTTags((String)"pedestals", (String)"_validlist", (ItemStack)coinInPedestal);
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_numposition");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_numdelay");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_boolstop");
    }

    @Override
    public void upgradeAction(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, ItemStack coin) {
        if (pedestal.hasWorkCard()) {
            ItemStack card = pedestal.getWorkCardInPedestal();
            boolean override = this.hasTwoPointsSelected(card);
            List<BlockPos> listed = this.getValidList(pedestal);
            if (override) {
                if (listed.size() > 0) {
                    this.chopperAction(level, pedestal);
                } else if (MowLibBlockPosUtils.selectedAreaWithinRange((MowLibBaseBlockEntity)pedestal, (int)this.getUpgradeWorkRange(coin)) && !MowLibBlockPosUtils.hasBlockListCustomNBTTags((String)"pedestals", (String)"_validlist", (ItemStack)coin)) {
                    this.buildValidBlockListArea(pedestal);
                }
            }
        }
    }

    private int getCurrentDelay(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (String)"_numdelay");
    }

    private void setCurrentDelay(BasePedestalBlockEntity pedestal, int num) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (int)num, (String)"_numdelay");
    }

    private void iterateCurrentDelay(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        int current = this.getCurrentPosition(pedestal);
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (int)(current + 1 + this.getSpeedTicksReduced(pedestal.getCoinOnPedestal())), (String)"_numdelay");
    }

    private int getCurrentPosition(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (String)"_numposition");
    }

    private void setCurrentPosition(BasePedestalBlockEntity pedestal, int num) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (int)num, (String)"_numposition");
    }

    private void iterateCurrentPosition(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        int current = this.getCurrentPosition(pedestal);
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (int)(current + 1), (String)"_numposition");
    }

    private boolean isToolHighEnoughLevelForBlock(ItemStack toolIn, BlockState getBlock) {
        Item item = toolIn.m_41720_();
        if (item instanceof TieredItem) {
            TieredItem tieredItem = (TieredItem)item;
            Tier toolTier = tieredItem.m_43314_();
            return TierSortingRegistry.isCorrectTierForDrops((Tier)toolTier, (BlockState)getBlock);
        }
        return false;
    }

    private boolean passesFilter(BasePedestalBlockEntity pedestal, BlockState canMineBlock, BlockPos canMinePos) {
        BaseFilter filter;
        ItemStack filterInPedestal;
        Item item;
        if (pedestal.hasFilter() && (item = (filterInPedestal = pedestal.getFilterInBlockEntity()).m_41720_()) instanceof BaseFilter && (filter = (BaseFilter)item).getFilterDirection().neutral()) {
            ItemStack blockToCheck = ItemStack.f_41583_;
            if (canMineBlock.m_60734_() instanceof Block) {
                blockToCheck = canMineBlock.m_60734_().m_7397_((BlockGetter)pedestal.m_58904_(), canMinePos, canMineBlock);
            }
            return filter.canAcceptItems(filterInPedestal, blockToCheck);
        }
        return true;
    }

    private boolean canMine(BasePedestalBlockEntity pedestal, BlockState canMineBlock, BlockPos canMinePos) {
        return ForgeRegistries.BLOCKS.tags().getTag(BlockTags.create((ResourceLocation)new ResourceLocation("pedestals:pedestals_can_chop_cant_quarry"))).stream().toList().contains(canMineBlock.m_60734_());
    }

    private void dropXP(Level level, BasePedestalBlockEntity pedestal, BlockState blockAtPoint, BlockPos currentPoint) {
        int fortune = EnchantmentHelper.m_44831_((ItemStack)pedestal.getToolStack()).containsKey(Enchantments.f_44987_) ? EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)pedestal.getToolStack()) : 0;
        int silky = EnchantmentHelper.m_44831_((ItemStack)pedestal.getToolStack()).containsKey(Enchantments.f_44985_) ? EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)pedestal.getToolStack()) : 0;
        int xpdrop = blockAtPoint.m_60734_().getExpDrop(blockAtPoint, (LevelReader)level, level.f_46441_, currentPoint, fortune, silky);
        if (xpdrop > 0) {
            blockAtPoint.m_60734_().m_49805_((ServerLevel)level, currentPoint, xpdrop);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void chopperAction(Level level, BasePedestalBlockEntity pedestal) {
        block30: {
            block35: {
                block33: {
                    block31: {
                        if (level.m_5776_() || !pedestal.hasWorkCard() || !((var5_4 = (card = pedestal.getWorkCardInPedestal()).m_41720_()) instanceof WorkCardBase)) break block30;
                        workCardBase = (WorkCardBase)var5_4;
                        getPlayer = pedestal.getPedestalPlayer(pedestal);
                        if (getPlayer == null || getPlayer.get() == null) break block30;
                        if (!this.hasSuperSpeed(pedestal.getCoinOnPedestal())) break block31;
                        listed = this.getValidList(pedestal);
                        area = new AABB(MowLibBlockPosUtils.readBlockPosFromNBT((ItemStack)card, (int)1), MowLibBlockPosUtils.readBlockPosFromNBT((ItemStack)card, (int)2));
                        maxY = (int)area.f_82292_;
                        minY = (int)area.f_82289_;
                        for (BlockPos currentPoint : listed) {
                            if (!this.removeFuelForAction(pedestal, MowLibBlockPosUtils.getDistanceBetweenPoints((BlockPos)pedestal.getPos(), (BlockPos)currentPoint), true)) continue;
                            for (y = minY; y <= maxY; ++y) {
                                block32: {
                                    adjustedPoint = new BlockPos(currentPoint.m_123341_(), y, currentPoint.m_123343_());
                                    blockAtPoint = level.m_8055_(adjustedPoint);
                                    if (blockAtPoint.m_60734_().equals(Blocks.f_50016_) || !(blockAtPoint.m_60800_((BlockGetter)level, currentPoint) >= 0.0f) || !ForgeEventFactory.doPlayerHarvestCheck((Player)(getPlayer.get() == null ? (Player)pedestal.getPedestalPlayer(pedestal).get() : (Player)getPlayer.get()), (BlockState)blockAtPoint, (boolean)true) || MinecraftForge.EVENT_BUS.post((Event)(e = new BlockEvent.BreakEvent(level, adjustedPoint, blockAtPoint, getPlayer.get() == null ? (Player)pedestal.getPedestalPlayer(pedestal).get() : (Player)getPlayer.get()))) || !this.canMine(pedestal, blockAtPoint, adjustedPoint) || !this.passesFilter(pedestal, blockAtPoint, adjustedPoint) || ForgeRegistries.BLOCKS.tags().getTag(BlockTags.create((ResourceLocation)new ResourceLocation("pedestals", "pedestals_cannot_break"))).stream().toList().contains(blockAtPoint.m_60734_())) continue;
                                    damage = false;
                                    if (adjustedPoint.equals((Object)pedestal.getPos()) || !this.removeFuelForAction(pedestal, MowLibBlockPosUtils.getDistanceBetweenPoints((BlockPos)pedestal.getPos(), (BlockPos)adjustedPoint), true)) continue;
                                    if (!((Boolean)PedestalConfig.COMMON.chopperDamageTools.get()).booleanValue() || !pedestal.hasTool()) break block32;
                                    pedestalPos = pedestal.getPos();
                                    if (pedestal.getDurabilityRemainingOnInsertedTool() <= 0) ** GOTO lbl27
                                    if (pedestal.damageInsertedTool(1, true)) {
                                        damage = true;
                                    } else {
                                        if (pedestal.canSpawnParticles()) {
                                            MowLibPacketHandler.sendToNearby((Level)level, (BlockPos)pedestalPos, (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)pedestalPos.m_123341_(), (double)((float)pedestalPos.m_123342_() + 1.0f), (double)pedestalPos.m_123343_(), new int[]{255, 255, 255}));
                                        }
                                        return;
lbl27:
                                        // 1 sources

                                        if (pedestal.canSpawnParticles()) {
                                            MowLibPacketHandler.sendToNearby((Level)level, (BlockPos)pedestalPos, (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)pedestalPos.m_123341_(), (double)((float)pedestalPos.m_123342_() + 1.0f), (double)pedestalPos.m_123343_(), new int[]{255, 255, 255}));
                                        }
                                        return;
                                    }
                                }
                                if (!this.removeFuelForAction(pedestal, MowLibBlockPosUtils.getDistanceBetweenPoints((BlockPos)pedestal.getPos(), (BlockPos)adjustedPoint), false)) continue;
                                canRemoveBlockEntities = (Boolean)PedestalConfig.COMMON.blockBreakerBreakEntities.get();
                                drops = this.getBlockDrops(level, pedestal, (FakePlayer)getPlayer.get(), blockAtPoint);
                                if (level.m_7702_(adjustedPoint) != null) {
                                    if (!canRemoveBlockEntities) continue;
                                    blockAtPoint.m_60753_(level, adjustedPoint, blockAtPoint, true);
                                    this.dropXP(level, pedestal, blockAtPoint, adjustedPoint);
                                    level.m_46747_(adjustedPoint);
                                    level.m_46597_(adjustedPoint, Blocks.f_50016_.m_49966_());
                                    if (damage) {
                                        pedestal.damageInsertedTool(1, false);
                                    }
                                    if (drops.size() <= 0) continue;
                                    for (ItemStack stack : drops) {
                                        MowLibItemUtils.spawnItemStack((Level)level, (double)adjustedPoint.m_123341_(), (double)adjustedPoint.m_123342_(), (double)adjustedPoint.m_123343_(), (ItemStack)stack);
                                    }
                                    continue;
                                }
                                this.dropXP(level, pedestal, blockAtPoint, adjustedPoint);
                                level.m_46597_(adjustedPoint, Blocks.f_50016_.m_49966_());
                                if (damage) {
                                    pedestal.damageInsertedTool(1, false);
                                }
                                if (drops.size() <= 0) continue;
                                for (ItemStack stack : drops) {
                                    MowLibItemUtils.spawnItemStack((Level)level, (double)adjustedPoint.m_123341_(), (double)adjustedPoint.m_123342_(), (double)adjustedPoint.m_123343_(), (ItemStack)stack);
                                }
                            }
                        }
                        break block30;
                    }
                    listed = this.getValidList(pedestal);
                    currentPosition = this.getCurrentPosition(pedestal);
                    currentPoint = listed.get(currentPosition);
                    area = new AABB(MowLibBlockPosUtils.readBlockPosFromNBT((ItemStack)card, (int)1), MowLibBlockPosUtils.readBlockPosFromNBT((ItemStack)card, (int)2));
                    maxY = (int)area.f_82292_;
                    minY = (int)area.f_82289_;
                    fuelRemoved = true;
                    runsOnce = true;
                    stop = this.getStopped(pedestal);
                    if (!this.removeFuelForAction(pedestal, MowLibBlockPosUtils.getDistanceBetweenPoints((BlockPos)pedestal.getPos(), (BlockPos)currentPoint), true)) break block30;
                    if (stop) break block33;
                    for (y = minY; y <= maxY; ++y) {
                        block34: {
                            adjustedPoint = new BlockPos(currentPoint.m_123341_(), y, currentPoint.m_123343_());
                            blockAtPoint = level.m_8055_(adjustedPoint);
                            if (blockAtPoint.m_60734_().equals(Blocks.f_50016_) || !(blockAtPoint.m_60800_((BlockGetter)level, currentPoint) >= 0.0f) || !ForgeEventFactory.doPlayerHarvestCheck((Player)(getPlayer.get() == null ? (Player)pedestal.getPedestalPlayer(pedestal).get() : (Player)getPlayer.get()), (BlockState)blockAtPoint, (boolean)true) || MinecraftForge.EVENT_BUS.post((Event)(e = new BlockEvent.BreakEvent(level, adjustedPoint, blockAtPoint, getPlayer.get() == null ? (Player)pedestal.getPedestalPlayer(pedestal).get() : (Player)getPlayer.get()))) || !this.canMine(pedestal, blockAtPoint, adjustedPoint) || !this.passesFilter(pedestal, blockAtPoint, adjustedPoint) || ForgeRegistries.BLOCKS.tags().getTag(BlockTags.create((ResourceLocation)new ResourceLocation("pedestals", "pedestals_cannot_break"))).stream().toList().contains(blockAtPoint.m_60734_())) continue;
                            damage = false;
                            if (adjustedPoint.equals((Object)pedestal.getPos()) || !this.removeFuelForAction(pedestal, MowLibBlockPosUtils.getDistanceBetweenPoints((BlockPos)pedestal.getPos(), (BlockPos)adjustedPoint), true)) continue;
                            if (!((Boolean)PedestalConfig.COMMON.chopperDamageTools.get()).booleanValue() || !pedestal.hasTool()) break block34;
                            pedestalPos = pedestal.getPos();
                            if (pedestal.getDurabilityRemainingOnInsertedTool() <= 0) ** GOTO lbl89
                            if (pedestal.damageInsertedTool(1, true)) {
                                damage = true;
                            } else {
                                if (pedestal.canSpawnParticles()) {
                                    MowLibPacketHandler.sendToNearby((Level)level, (BlockPos)pedestalPos, (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)pedestalPos.m_123341_(), (double)((float)pedestalPos.m_123342_() + 1.0f), (double)pedestalPos.m_123343_(), new int[]{255, 255, 255}));
                                }
                                return;
lbl89:
                                // 1 sources

                                if (pedestal.canSpawnParticles()) {
                                    MowLibPacketHandler.sendToNearby((Level)level, (BlockPos)pedestalPos, (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)pedestalPos.m_123341_(), (double)((float)pedestalPos.m_123342_() + 1.0f), (double)pedestalPos.m_123343_(), new int[]{255, 255, 255}));
                                }
                                return;
                            }
                        }
                        if (this.removeFuelForAction(pedestal, MowLibBlockPosUtils.getDistanceBetweenPoints((BlockPos)pedestal.getPos(), (BlockPos)adjustedPoint), false)) {
                            canRemoveBlockEntities = (Boolean)PedestalConfig.COMMON.blockBreakerBreakEntities.get();
                            drops = this.getBlockDrops(level, pedestal, (FakePlayer)getPlayer.get(), blockAtPoint);
                            if (level.m_7702_(adjustedPoint) != null) {
                                if (!canRemoveBlockEntities) continue;
                                blockAtPoint.m_60753_(level, adjustedPoint, blockAtPoint, true);
                                this.dropXP(level, pedestal, blockAtPoint, adjustedPoint);
                                level.m_46747_(adjustedPoint);
                                level.m_46597_(adjustedPoint, Blocks.f_50016_.m_49966_());
                                if (damage) {
                                    pedestal.damageInsertedTool(1, false);
                                }
                                if (drops.size() <= 0) continue;
                                for (ItemStack stack : drops) {
                                    MowLibItemUtils.spawnItemStack((Level)level, (double)adjustedPoint.m_123341_(), (double)adjustedPoint.m_123342_(), (double)adjustedPoint.m_123343_(), (ItemStack)stack);
                                }
                                continue;
                            }
                            this.dropXP(level, pedestal, blockAtPoint, adjustedPoint);
                            level.m_46597_(adjustedPoint, Blocks.f_50016_.m_49966_());
                            if (damage) {
                                pedestal.damageInsertedTool(1, false);
                            }
                            if (drops.size() <= 0) continue;
                            for (ItemStack stack : drops) {
                                MowLibItemUtils.spawnItemStack((Level)level, (double)adjustedPoint.m_123341_(), (double)adjustedPoint.m_123342_(), (double)adjustedPoint.m_123343_(), (ItemStack)stack);
                            }
                            continue;
                        }
                        fuelRemoved = false;
                    }
                    break block35;
                }
                if (pedestal.canSpawnParticles()) {
                    MowLibPacketHandler.sendToNearby((Level)level, (BlockPos)pedestal.getPos(), (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)pedestal.getPos().m_123341_(), (double)((float)pedestal.getPos().m_123342_() + 1.0f), (double)pedestal.getPos().m_123343_(), new int[]{55, 55, 55}));
                }
            }
            if (currentPosition + 1 >= listed.size()) {
                if (runsOnce) {
                    delay = Math.floorDiv(listed.size() * Math.abs(maxY - minY), 20);
                    if (this.getCurrentDelay(pedestal) >= delay) {
                        this.setCurrentPosition(pedestal, 0);
                        this.setStopped(pedestal, false);
                        this.setCurrentDelay(pedestal, 0);
                    } else {
                        this.iterateCurrentDelay(pedestal);
                        this.setStopped(pedestal, true);
                    }
                } else {
                    this.setCurrentPosition(pedestal, 0);
                }
            } else if (fuelRemoved) {
                this.iterateCurrentPosition(pedestal);
            }
        }
    }
}

