/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Upgrades.Pedestal;

import com.mowmaster.mowlib.BlockEntities.MowLibBaseBlockEntity;
import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.Items.WorkCards.WorkCardArea;
import com.mowmaster.mowlib.MowLibUtils.MowLibBlockPosUtils;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Configs.PedestalConfig;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.FakePlayer;

public class ItemUpgradeBreeder
extends ItemUpgradeBase {
    public ItemUpgradeBreeder(Item.Properties p_41383_) {
        super(new Item.Properties());
    }

    @Override
    public boolean canModifySpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyRange(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyArea(ItemStack upgradeItemStack) {
        return (Boolean)PedestalConfig.COMMON.upgrade_require_sized_selectable_area.get();
    }

    @Override
    public boolean needsWorkCard(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public int getWorkCardType() {
        return 1;
    }

    @Override
    public int baseEnergyCostPerDistance() {
        return (Integer)PedestalConfig.COMMON.upgrade_breeder_baseEnergyCost.get();
    }

    @Override
    public boolean energyDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_breeder_energy_distance_multiplier.get();
    }

    @Override
    public double energyCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_breeder_energyMultiplier.get();
    }

    @Override
    public int baseXpCostPerDistance() {
        return (Integer)PedestalConfig.COMMON.upgrade_breeder_baseXpCost.get();
    }

    @Override
    public boolean xpDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_breeder_xp_distance_multiplier.get();
    }

    @Override
    public double xpCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_breeder_xpMultiplier.get();
    }

    @Override
    public DustMagic baseDustCostPerDistance() {
        return new DustMagic(((Integer)PedestalConfig.COMMON.upgrade_breeder_dustColor.get()).intValue(), ((Integer)PedestalConfig.COMMON.upgrade_breeder_baseDustAmount.get()).intValue());
    }

    @Override
    public boolean dustDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_breeder_dust_distance_multiplier.get();
    }

    @Override
    public double dustCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_breeder_dustMultiplier.get();
    }

    @Override
    public boolean hasSelectedAreaModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_breeder_selectedAllowed.get();
    }

    @Override
    public double selectedAreaCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_breeder_selectedMultiplier.get();
    }

    public boolean hasBreederLimit() {
        return (Boolean)PedestalConfig.COMMON.upgrade_breeder_entityBreedingLimit.get();
    }

    public int getBreederLimitCount() {
        return (Integer)PedestalConfig.COMMON.upgrade_breeder_entityLimitBreedingCount.get();
    }

    @Override
    public List<String> getUpgradeHUD(BasePedestalBlockEntity pedestal) {
        List<String> messages = super.getUpgradeHUD(pedestal);
        if (messages.size() == 0) {
            if (this.baseEnergyCostPerDistance() > 0 && pedestal.getStoredEnergy() < this.baseEnergyCostPerDistance()) {
                messages.add(ChatFormatting.RED + "Needs Energy");
                messages.add(ChatFormatting.RED + "To Operate");
            }
            if (this.baseXpCostPerDistance() > 0 && pedestal.getStoredExperience() < this.baseXpCostPerDistance()) {
                messages.add(ChatFormatting.GREEN + "Needs Experience");
                messages.add(ChatFormatting.GREEN + "To Operate");
            }
            if (this.baseDustCostPerDistance().getDustAmount() > 0 && pedestal.getStoredEnergy() < this.baseEnergyCostPerDistance()) {
                messages.add(ChatFormatting.LIGHT_PURPLE + "Needs Dust");
                messages.add(ChatFormatting.LIGHT_PURPLE + "To Operate");
            }
        }
        return messages;
    }

    @Override
    public void upgradeAction(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, ItemStack coin) {
        WeakReference<FakePlayer> fakePlayerReference = pedestal.getPedestalPlayer(pedestal);
        if (fakePlayerReference != null && fakePlayerReference.get() != null) {
            FakePlayer fakePlayer = (FakePlayer)fakePlayerReference.get();
            ItemStack workCardItemStack = pedestal.getWorkCardInPedestal();
            if (workCardItemStack.m_41720_() instanceof WorkCardArea) {
                List animals = WorkCardArea.getEntitiesInRangeOfUpgrade((Level)level, Animal.class, (ItemStack)workCardItemStack, (MowLibBaseBlockEntity)pedestal, (int)this.getUpgradeWorkRange(coin));
                if (this.hasBreederLimit() && animals.size() >= this.getBreederLimitCount()) {
                    return;
                }
                for (Animal animal : animals) {
                    ItemStack stackInPedestal;
                    ItemStack itemStack = stackInPedestal = pedestal.hasItem() ? pedestal.getItemInPedestal() : pedestal.getToolStack();
                    if (stackInPedestal.m_41619_()) {
                        return;
                    }
                    if (!animal.m_6898_(stackInPedestal) || animal.m_146764_() != 0 || !animal.m_5957_() || !this.removeFuelForAction(pedestal, MowLibBlockPosUtils.getDistanceBetweenPoints((BlockPos)pedestal.getPos(), (BlockPos)animal.m_20097_()), true)) continue;
                    ItemStack toFeed = stackInPedestal.m_41777_();
                    toFeed.m_41764_(1);
                    fakePlayer.m_21008_(InteractionHand.MAIN_HAND, toFeed.m_41777_());
                    InteractionResult result = animal.m_6071_((Player)fakePlayer, InteractionHand.MAIN_HAND);
                    if (result != InteractionResult.SUCCESS) continue;
                    this.removeFuelForAction(pedestal, MowLibBlockPosUtils.getDistanceBetweenPoints((BlockPos)pedestal.getPos(), (BlockPos)animal.m_20097_()), false);
                    pedestal.removeItemStack(toFeed, false);
                }
            }
        }
    }
}

