/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Upgrades.Pedestal;

import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.Items.Filters.BaseFilter;
import com.mowmaster.mowlib.MowLibUtils.MowLibBlockPosUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibCompoundTagUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibItemUtils;
import com.mowmaster.mowlib.Networking.MowLibPacketHandler;
import com.mowmaster.mowlib.Networking.MowLibPacketParticles;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Configs.PedestalConfig;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemUpgradeBlockBreaker
extends ItemUpgradeBase {
    public ItemUpgradeBlockBreaker(Item.Properties p_41383_) {
        super(new Item.Properties());
    }

    @Override
    public boolean canModifySpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyRange(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyArea(ItemStack upgradeItemStack) {
        return (Boolean)PedestalConfig.COMMON.upgrade_require_sized_selectable_area.get();
    }

    @Override
    public boolean needsWorkCard(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public int getWorkCardType() {
        return 0;
    }

    @Override
    public int baseEnergyCostPerDistance() {
        return (Integer)PedestalConfig.COMMON.upgrade_blockbreaker_baseEnergyCost.get();
    }

    @Override
    public boolean energyDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_blockbreaker_energy_distance_multiplier.get();
    }

    @Override
    public double energyCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_blockbreaker_energyMultiplier.get();
    }

    @Override
    public int baseXpCostPerDistance() {
        return (Integer)PedestalConfig.COMMON.upgrade_blockbreaker_baseXpCost.get();
    }

    @Override
    public boolean xpDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_blockbreaker_xp_distance_multiplier.get();
    }

    @Override
    public double xpCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_blockbreaker_xpMultiplier.get();
    }

    @Override
    public DustMagic baseDustCostPerDistance() {
        return new DustMagic(((Integer)PedestalConfig.COMMON.upgrade_blockbreaker_dustColor.get()).intValue(), ((Integer)PedestalConfig.COMMON.upgrade_blockbreaker_baseDustAmount.get()).intValue());
    }

    @Override
    public boolean dustDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_blockbreaker_dust_distance_multiplier.get();
    }

    @Override
    public double dustCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_blockbreaker_dustMultiplier.get();
    }

    @Override
    public boolean hasSelectedAreaModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_blockbreaker_selectedAllowed.get();
    }

    @Override
    public double selectedAreaCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_blockbreaker_selectedMultiplier.get();
    }

    @Override
    public List<String> getUpgradeHUD(BasePedestalBlockEntity pedestal) {
        List<String> messages = super.getUpgradeHUD(pedestal);
        if (messages.size() <= 0) {
            if (this.baseEnergyCostPerDistance() > 0 && pedestal.getStoredEnergy() < this.baseEnergyCostPerDistance()) {
                messages.add(ChatFormatting.RED + "Needs Energy");
                messages.add(ChatFormatting.RED + "To Operate");
            }
            if (this.baseXpCostPerDistance() > 0 && pedestal.getStoredExperience() < this.baseXpCostPerDistance()) {
                messages.add(ChatFormatting.GREEN + "Needs Experience");
                messages.add(ChatFormatting.GREEN + "To Operate");
            }
            if (this.baseDustCostPerDistance().getDustAmount() > 0 && pedestal.getStoredEnergy() < this.baseEnergyCostPerDistance()) {
                messages.add(ChatFormatting.LIGHT_PURPLE + "Needs Dust");
                messages.add(ChatFormatting.LIGHT_PURPLE + "To Operate");
            }
        }
        return messages;
    }

    @Override
    public ItemStack getUpgradeDefaultTool() {
        return new ItemStack((ItemLike)Items.f_42427_);
    }

    @Override
    public void actionOnRemovedFromPedestal(BasePedestalBlockEntity pedestal, ItemStack coinInPedestal) {
        super.actionOnRemovedFromPedestal(pedestal, coinInPedestal);
        this.resetCachedValidWorkCardPositions("pedestals", coinInPedestal);
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_numposition");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_numdelay");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_numheight");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_boolstop");
    }

    @Override
    public void upgradeAction(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, ItemStack coin) {
        List<BlockPos> allPositions = this.getValidWorkCardPositions(pedestal, coin, this.getWorkCardType(), "pedestals");
        if (allPositions.isEmpty()) {
            return;
        }
        this.breakerAction(level, pedestal, allPositions);
    }

    private int getCurrentPosition(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (String)"_numposition");
    }

    private void setCurrentPosition(BasePedestalBlockEntity pedestal, int num) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (int)num, (String)"_numposition");
    }

    private void iterateCurrentPosition(BasePedestalBlockEntity pedestal) {
        ItemStack coin = pedestal.getCoinOnPedestal();
        int current = this.getCurrentPosition(pedestal);
        MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)coin.m_41784_(), (int)(current + 1), (String)"_numposition");
    }

    private boolean isToolHighEnoughLevelForBlock(ItemStack toolIn, BlockState getBlock) {
        Item item = toolIn.m_41720_();
        if (item instanceof TieredItem) {
            TieredItem tieredItem = (TieredItem)item;
            Tier toolTier = tieredItem.m_43314_();
            return TierSortingRegistry.isCorrectTierForDrops((Tier)toolTier, (BlockState)getBlock);
        }
        return false;
    }

    private boolean passesFilter(BasePedestalBlockEntity pedestal, BlockState canMineBlock, BlockPos canMinePos) {
        BaseFilter filter;
        ItemStack filterInPedestal;
        Item item;
        if (pedestal.hasFilter() && (item = (filterInPedestal = pedestal.getFilterInBlockEntity()).m_41720_()) instanceof BaseFilter && (filter = (BaseFilter)item).getFilterDirection().neutral()) {
            ItemStack blockToCheck = ItemStack.f_41583_;
            if (canMineBlock.m_60734_() instanceof Block) {
                blockToCheck = canMineBlock.m_60734_().m_7397_((BlockGetter)pedestal.m_58904_(), canMinePos, canMineBlock);
            }
            return filter.canAcceptItems(filterInPedestal, blockToCheck);
        }
        return true;
    }

    private void dropXP(Level level, BasePedestalBlockEntity pedestal, BlockState blockAtPoint, BlockPos currentPoint) {
        int fortune = EnchantmentHelper.m_44831_((ItemStack)pedestal.getToolStack()).containsKey(Enchantments.f_44987_) ? EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)pedestal.getToolStack()) : 0;
        int silky = EnchantmentHelper.m_44831_((ItemStack)pedestal.getToolStack()).containsKey(Enchantments.f_44985_) ? EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)pedestal.getToolStack()) : 0;
        int xpdrop = blockAtPoint.m_60734_().getExpDrop(blockAtPoint, (LevelReader)level, level.f_46441_, currentPoint, fortune, silky);
        if (xpdrop > 0) {
            blockAtPoint.m_60734_().m_49805_((ServerLevel)level, currentPoint, xpdrop);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void breakerAction(Level level, BasePedestalBlockEntity pedestal, List<BlockPos> listed) {
        boolean fuelRemoved;
        int currentPosition;
        block11: {
            block12: {
                List<ItemStack> drops;
                boolean damage;
                BlockState blockAtPoint;
                BlockPos currentPoint;
                block13: {
                    BlockEvent.BreakEvent e;
                    if (level.m_5776_()) return;
                    WeakReference<FakePlayer> getPlayer = pedestal.getPedestalPlayer(pedestal);
                    if (getPlayer == null) return;
                    if (getPlayer.get() == null) return;
                    currentPosition = this.getCurrentPosition(pedestal);
                    currentPoint = listed.get(currentPosition);
                    blockAtPoint = level.m_8055_(currentPoint);
                    fuelRemoved = true;
                    if (blockAtPoint.m_60734_().equals(Blocks.f_50016_) || !(blockAtPoint.m_60800_((BlockGetter)level, currentPoint) >= 0.0f) || !this.passesFilter(pedestal, blockAtPoint, currentPoint) || ForgeRegistries.BLOCKS.tags().getTag(BlockTags.create((ResourceLocation)new ResourceLocation("pedestals", "pedestals_cannot_break"))).stream().toList().contains(blockAtPoint.m_60734_()) || !ForgeEventFactory.doPlayerHarvestCheck((Player)(getPlayer.get() == null ? (Player)pedestal.getPedestalPlayer(pedestal).get() : (Player)getPlayer.get()), (BlockState)blockAtPoint, (boolean)true) || MinecraftForge.EVENT_BUS.post((Event)(e = new BlockEvent.BreakEvent(level, currentPoint, blockAtPoint, getPlayer.get() == null ? (Player)pedestal.getPedestalPlayer(pedestal).get() : (Player)getPlayer.get())))) break block11;
                    damage = false;
                    if (currentPoint.equals((Object)pedestal.getPos()) || !this.removeFuelForAction(pedestal, MowLibBlockPosUtils.getDistanceBetweenPoints((BlockPos)pedestal.getPos(), (BlockPos)currentPoint), true)) break block11;
                    if (((Boolean)PedestalConfig.COMMON.blockBreakerDamageTools.get()).booleanValue() && pedestal.hasTool()) {
                        BlockPos pedestalPos = pedestal.getPos();
                        if (pedestal.getDurabilityRemainingOnInsertedTool() <= 0) {
                            if (!pedestal.canSpawnParticles()) return;
                            MowLibPacketHandler.sendToNearby((Level)level, (BlockPos)pedestalPos, (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)pedestalPos.m_123341_(), (double)((float)pedestalPos.m_123342_() + 1.0f), (double)pedestalPos.m_123343_(), new int[]{255, 255, 255}));
                            return;
                        }
                        if (!pedestal.damageInsertedTool(1, true)) {
                            if (!pedestal.canSpawnParticles()) return;
                            MowLibPacketHandler.sendToNearby((Level)level, (BlockPos)pedestalPos, (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)pedestalPos.m_123341_(), (double)((float)pedestalPos.m_123342_() + 1.0f), (double)pedestalPos.m_123343_(), new int[]{255, 255, 255}));
                            return;
                        }
                        damage = true;
                    }
                    if (!this.removeFuelForAction(pedestal, MowLibBlockPosUtils.getDistanceBetweenPoints((BlockPos)pedestal.getPos(), (BlockPos)currentPoint), false)) break block12;
                    boolean canRemoveBlockEntities = (Boolean)PedestalConfig.COMMON.blockBreakerBreakEntities.get();
                    drops = this.getBlockDrops(level, pedestal, (FakePlayer)getPlayer.get(), blockAtPoint);
                    if (level.m_7702_(currentPoint) == null) break block13;
                    if (canRemoveBlockEntities) {
                        blockAtPoint.m_60753_(level, currentPoint, blockAtPoint, true);
                        this.dropXP(level, pedestal, blockAtPoint, currentPoint);
                        level.m_46747_(currentPoint);
                        level.m_46597_(currentPoint, Blocks.f_50016_.m_49966_());
                        if (damage) {
                            pedestal.damageInsertedTool(1, false);
                        }
                        if (drops.size() > 0) {
                            for (ItemStack stack : drops) {
                                MowLibItemUtils.spawnItemStack((Level)level, (double)currentPoint.m_123341_(), (double)currentPoint.m_123342_(), (double)currentPoint.m_123343_(), (ItemStack)stack);
                            }
                        }
                    }
                    break block11;
                }
                this.dropXP(level, pedestal, blockAtPoint, currentPoint);
                level.m_46597_(currentPoint, Blocks.f_50016_.m_49966_());
                if (damage) {
                    pedestal.damageInsertedTool(1, false);
                }
                if (drops.size() > 0) {
                    for (ItemStack stack : drops) {
                        MowLibItemUtils.spawnItemStack((Level)level, (double)currentPoint.m_123341_(), (double)currentPoint.m_123342_(), (double)currentPoint.m_123343_(), (ItemStack)stack);
                    }
                }
                break block11;
            }
            fuelRemoved = false;
        }
        if (currentPosition + 1 >= listed.size()) {
            this.setCurrentPosition(pedestal, 0);
            return;
        }
        if (!fuelRemoved) return;
        this.iterateCurrentPosition(pedestal);
    }
}

