/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Upgrades.Pedestal;

import com.mowmaster.mowlib.BlockEntities.MowLibBaseBlockEntity;
import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.Capabilities.Dust.IDustHandler;
import com.mowmaster.mowlib.Items.WorkCards.WorkCardArea;
import com.mowmaster.mowlib.Items.WorkCards.WorkCardBE;
import com.mowmaster.mowlib.Items.WorkCards.WorkCardBase;
import com.mowmaster.mowlib.Items.WorkCards.WorkCardLocations;
import com.mowmaster.mowlib.MowLibUtils.MowLibBlockPosUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibColorReference;
import com.mowmaster.mowlib.MowLibUtils.MowLibCompoundTagUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibFakePlayer;
import com.mowmaster.mowlib.MowLibUtils.MowLibMessageUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibOwnerUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibTooltipUtils;
import com.mowmaster.mowlib.Networking.MowLibPacketHandler;
import com.mowmaster.mowlib.Networking.MowLibPacketParticles;
import com.mowmaster.mowlib.api.DefineLocations.ISelectableArea;
import com.mowmaster.mowlib.api.DefineLocations.ISelectablePoints;
import com.mowmaster.mowlib.api.TransportAndStorage.IFilterItem;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlock;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Configs.PedestalConfig;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.IHasModeTypes;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.IPedestalUpgrade;
import com.mowmaster.pedestals.Registry.DeferredRegisterItems;
import java.lang.invoke.CallSite;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemUpgradeBase
extends Item
implements IPedestalUpgrade {
    public ItemUpgradeBase(Item.Properties p_41383_) {
        super(new Item.Properties());
    }

    @Override
    public int getComparatorRedstoneLevel(Level worldIn, BlockPos pos) {
        return -1;
    }

    @Override
    public void updateAction(Level level, BasePedestalBlockEntity pedestal) {
        if (!pedestal.isPedestalBlockPowered(pedestal)) {
            int speed = (Integer)PedestalConfig.COMMON.pedestal_maxTicksToTransfer.get() - this.getSpeedTicksReduced(pedestal.getCoinOnPedestal());
            if (speed <= 0) {
                speed = 1;
            }
            if (level.m_46467_() % (long)speed == 0L) {
                this.upgradeAction(level, pedestal, pedestal.getPos(), pedestal.getCoinOnPedestal());
            }
        }
    }

    public void upgradeAction(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, ItemStack coin) {
    }

    @Override
    public void actionOnCollideWithBlock(BasePedestalBlockEntity pedestal) {
        if (!pedestal.isPedestalBlockPowered(pedestal)) {
            int speed = (Integer)PedestalConfig.COMMON.pedestal_maxTicksToTransfer.get() - this.getSpeedTicksReduced(pedestal.getCoinOnPedestal());
            if (speed <= 0) {
                speed = 1;
            }
            if (pedestal.m_58904_().m_46467_() % (long)speed == 0L) {
                this.onCollideAction(pedestal);
            }
        }
    }

    public void onCollideAction(BasePedestalBlockEntity pedestal) {
    }

    @Override
    public void actionOnNeighborBelowChange(BasePedestalBlockEntity pedestal, BlockPos belowBlock) {
    }

    @Override
    public void actionOnAddedToPedestal(Player player, BasePedestalBlockEntity pedestal, ItemStack coinInPedestal) {
        MowLibOwnerUtils.writeNameToStackNBT((ItemStack)coinInPedestal, (String)player.m_7755_().getString());
        MowLibOwnerUtils.writeUUIDToNBT((ItemStack)coinInPedestal, (UUID)player.m_20148_());
    }

    @Override
    public void actionOnRemovedFromPedestal(BasePedestalBlockEntity pedestal, ItemStack coinInPedestal) {
        MowLibOwnerUtils.removePlayerFromStack((ItemStack)coinInPedestal);
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_string_last_clicked_direction");
    }

    public List<String> getUpgradeHUD(BasePedestalBlockEntity pedestal) {
        Item item;
        ItemStack upgradeItemStack = pedestal.getCoinOnPedestal();
        ArrayList<String> messages = new ArrayList<String>();
        int supportedWorkCardType = this.getWorkCardType();
        if (supportedWorkCardType < 0) {
            return messages;
        }
        if (this.needsWorkCard(upgradeItemStack) && !pedestal.hasWorkCard()) {
            messages.add(ChatFormatting.RED + "Missing WorkCard");
            messages.add(ChatFormatting.WHITE + "------------------");
            messages.add(ChatFormatting.WHITE + "Upgrade Supports:");
            switch (supportedWorkCardType) {
                case 0: {
                    messages.add(ChatFormatting.WHITE + "(Area), OR");
                    messages.add(ChatFormatting.WHITE + "(Location)");
                    break;
                }
                case 1: {
                    messages.add(ChatFormatting.WHITE + "(Area)");
                    break;
                }
                case 2: {
                    messages.add(ChatFormatting.WHITE + "(Location)");
                    break;
                }
                case 3: {
                    messages.add(ChatFormatting.WHITE + "(Machines)");
                }
            }
        } else if (pedestal.hasWorkCard() && (item = pedestal.getWorkCardInPedestal().m_41720_()) instanceof WorkCardBase) {
            WorkCardBase workCardBase = (WorkCardBase)item;
            int insertedWorkCardType = workCardBase.getWorkCardType();
            if (insertedWorkCardType != supportedWorkCardType && (supportedWorkCardType != 0 || insertedWorkCardType != 1 && insertedWorkCardType != 2)) {
                messages.add(ChatFormatting.RED + "Wrong WorkCard");
                messages.add(ChatFormatting.WHITE + "------------------");
                messages.add(ChatFormatting.WHITE + "Upgrade Supports:");
                switch (supportedWorkCardType) {
                    case 0: {
                        messages.add(ChatFormatting.WHITE + "(Area), OR");
                        messages.add(ChatFormatting.WHITE + "(Location)");
                        break;
                    }
                    case 1: {
                        messages.add(ChatFormatting.WHITE + "(Area)");
                        break;
                    }
                    case 2: {
                        messages.add(ChatFormatting.WHITE + "(Location)");
                        break;
                    }
                    case 3: {
                        messages.add(ChatFormatting.WHITE + "(Machines)");
                    }
                }
            } else {
                List<Object> errorReason = List.of();
                switch (insertedWorkCardType) {
                    case 1: {
                        if (!MowLibBlockPosUtils.selectedAreaWithinRange((MowLibBaseBlockEntity)pedestal, (int)this.getUpgradeWorkRange(pedestal.getCoinOnPedestal()))) {
                            errorReason = List.of(ChatFormatting.WHITE + "Area Not Within", ChatFormatting.WHITE + "Upgrade Range");
                            break;
                        }
                        if (!this.hasOperateToBedrock(upgradeItemStack) || MowLibBlockPosUtils.readBlockPosFromNBT((ItemStack)pedestal.getWorkCardInPedestal(), (int)1).m_123342_() == MowLibBlockPosUtils.readBlockPosFromNBT((ItemStack)pedestal.getWorkCardInPedestal(), (int)2).m_123342_()) break;
                        errorReason = List.of(ChatFormatting.WHITE + "Operate to Bedrock", ChatFormatting.WHITE + "Limits Height to 1");
                        break;
                    }
                    case 2: {
                        if (!this.hasRemoteStorage(upgradeItemStack) || MowLibBlockPosUtils.readBlockPosListFromNBT((ItemStack)pedestal.getWorkCardInPedestal()).size() <= 8) break;
                        errorReason = List.of(ChatFormatting.WHITE + "Remote Inventory", ChatFormatting.WHITE + "Targeting limited", ChatFormatting.WHITE + "to 8 locations");
                    }
                }
                if (!errorReason.isEmpty()) {
                    messages.add(ChatFormatting.RED + "Invalid Work Card");
                    messages.add(ChatFormatting.WHITE + "------------------");
                    messages.addAll(errorReason);
                }
            }
        }
        return messages;
    }

    public void sendUpgradeCustomChat(Player player, ItemStack upgrade) {
        if (this.canModifySpeed(upgrade) && this.getSpeedTicksReduced(upgrade) > 0) {
            MutableComponent speedLabel = Component.m_237115_((String)"pedestals.upgrade_tooltip_speed_label");
            speedLabel.m_130940_(ChatFormatting.AQUA);
            MutableComponent speedAmount = Component.m_237113_((String)("" + this.getSpeedTicksReduced(upgrade)));
            MutableComponent separator = Component.m_237115_((String)"pedestals.upgrade_tooltip_separator_slash");
            MutableComponent speedMax = Component.m_237113_((String)("" + this.getMaxSpeed(upgrade)));
            speedAmount.m_7220_((Component)separator);
            speedAmount.m_7220_((Component)speedMax);
            speedAmount.m_130940_(ChatFormatting.WHITE);
            speedLabel.m_7220_((Component)speedAmount);
            player.m_5661_((Component)speedLabel, false);
        }
        if (this.canModifyDamageCapacity(upgrade) || this.canModifyBlockCapacity(upgrade) || this.canModifyItemCapacity(upgrade) || this.canModifyFluidCapacity(upgrade) || this.canModifyEnergyCapacity(upgrade) || this.canModifyXPCapacity(upgrade) || this.canModifyDustCapacity(upgrade)) {
            MutableComponent capacityLabel = Component.m_237115_((String)"pedestals.upgrade_tooltip_capacity_label");
            capacityLabel.m_130940_(ChatFormatting.GREEN);
            MutableComponent separator_space = Component.m_237115_((String)"pedestals.upgrade_tooltip_separator_space");
            MutableComponent capacityDamageAmount = Component.m_237113_((String)"?");
            MutableComponent capacityBlockAmount = Component.m_237113_((String)"?");
            MutableComponent capacityItemAmount = Component.m_237113_((String)"?");
            MutableComponent capacityFluidAmount = Component.m_237113_((String)"?");
            MutableComponent capacityEnergyAmount = Component.m_237113_((String)"?");
            MutableComponent capacityXPAmount = Component.m_237113_((String)"?");
            MutableComponent capacityDustAmount = Component.m_237113_((String)"?");
            if (this.getDamageCapacityIncrease(upgrade) > 0) {
                capacityDamageAmount = Component.m_237113_((String)("" + this.getDamageCapacityIncrease(upgrade)));
            }
            if (this.getBlockCapacityIncrease(upgrade) > 0) {
                capacityBlockAmount = Component.m_237113_((String)("" + this.getBlockCapacityIncrease(upgrade)));
            }
            if (this.getItemCapacityIncrease(upgrade) > 0) {
                capacityItemAmount = Component.m_237113_((String)("" + this.getItemCapacityIncrease(upgrade)));
            }
            if (this.getFluidCapacityIncrease(upgrade) > 0) {
                capacityFluidAmount = Component.m_237113_((String)("" + this.getFluidCapacityIncrease(upgrade)));
            }
            if (this.getEnergyCapacityIncrease(upgrade) > 0) {
                capacityEnergyAmount = Component.m_237113_((String)("" + this.getEnergyCapacityIncrease(upgrade)));
            }
            if (this.getItemCapacityIncrease(upgrade) > 0) {
                capacityXPAmount = Component.m_237113_((String)("" + this.getXPCapacityIncrease(upgrade)));
            }
            if (this.getItemCapacityIncrease(upgrade) > 0) {
                capacityDustAmount = Component.m_237113_((String)("" + this.getDustCapacityIncrease(upgrade)));
            }
            capacityDamageAmount.m_130940_(ChatFormatting.DARK_RED);
            capacityBlockAmount.m_130940_(ChatFormatting.GRAY);
            capacityItemAmount.m_130940_(ChatFormatting.GOLD);
            capacityFluidAmount.m_130940_(ChatFormatting.BLUE);
            capacityEnergyAmount.m_130940_(ChatFormatting.RED);
            capacityXPAmount.m_130940_(ChatFormatting.GREEN);
            capacityDustAmount.m_130940_(ChatFormatting.LIGHT_PURPLE);
            if (this.canModifyDamageCapacity(upgrade)) {
                capacityLabel.m_7220_((Component)capacityDamageAmount);
            }
            if (this.canModifyBlockCapacity(upgrade)) {
                capacityLabel.m_7220_((Component)separator_space);
                capacityLabel.m_7220_((Component)capacityBlockAmount);
            }
            if (this.canModifyItemCapacity(upgrade)) {
                capacityLabel.m_7220_((Component)separator_space);
                capacityLabel.m_7220_((Component)capacityItemAmount);
            }
            if (this.canModifyFluidCapacity(upgrade)) {
                capacityLabel.m_7220_((Component)separator_space);
                capacityLabel.m_7220_((Component)capacityFluidAmount);
            }
            if (this.canModifyEnergyCapacity(upgrade)) {
                capacityLabel.m_7220_((Component)separator_space);
                capacityLabel.m_7220_((Component)capacityEnergyAmount);
            }
            if (this.canModifyXPCapacity(upgrade)) {
                capacityLabel.m_7220_((Component)separator_space);
                capacityLabel.m_7220_((Component)capacityXPAmount);
            }
            if (this.canModifyDustCapacity(upgrade)) {
                capacityLabel.m_7220_((Component)separator_space);
                capacityLabel.m_7220_((Component)capacityDustAmount);
            }
            player.m_5661_((Component)capacityLabel, false);
        }
        if (this.canModifyEntityContainers(upgrade) && this.getEntityContainer(upgrade)) {
            MutableComponent entityContainerLabel = Component.m_237115_((String)"pedestals.upgrade_tooltip_entitycontainer_label");
            entityContainerLabel.m_130940_(ChatFormatting.DARK_GREEN);
            player.m_5661_((Component)entityContainerLabel, false);
        }
        if (this.canModifyRemoteStorage(upgrade) && this.getRemoteStorage(upgrade)) {
            MutableComponent remoteStorageLabel = Component.m_237115_((String)"pedestals.upgrade_tooltip_remotestorage_label");
            remoteStorageLabel.m_130940_(ChatFormatting.DARK_PURPLE);
            player.m_5661_((Component)remoteStorageLabel, false);
        }
        if (this.canModifyArea(upgrade) && this.getAreaIncrease(upgrade) > 0) {
            MutableComponent areaLabel = Component.m_237115_((String)"pedestals.upgrade_tooltip_area_label");
            areaLabel.m_130940_(ChatFormatting.GRAY);
            MutableComponent areaAmount = Component.m_237113_((String)String.valueOf(this.getAreaIncrease(upgrade)));
            areaAmount.m_130940_(ChatFormatting.WHITE);
            areaLabel.m_7220_((Component)areaAmount);
            player.m_5661_((Component)areaLabel, false);
        }
        if (this.canModifyRange(upgrade) && this.getRangeIncrease(upgrade) > 0) {
            MutableComponent rangeLabel = Component.m_237115_((String)"pedestals.upgrade_tooltip_range_label");
            rangeLabel.m_130940_(ChatFormatting.GOLD);
            MutableComponent rangeAmount = Component.m_237113_((String)("" + this.getRangeIncrease(upgrade)));
            rangeAmount.m_130940_(ChatFormatting.WHITE);
            rangeLabel.m_7220_((Component)rangeAmount);
            player.m_5661_((Component)rangeLabel, false);
        }
        if (this.canModifyMagnet(upgrade) && this.getMagnet(upgrade)) {
            MutableComponent magnetLabel = Component.m_237115_((String)"pedestals.upgrade_tooltip_magnet_label");
            magnetLabel.m_130940_(ChatFormatting.DARK_RED);
            player.m_5661_((Component)magnetLabel, false);
        }
        if (this.canModifyGentleHarvest(upgrade) && this.getGentleHarvest(upgrade)) {
            MutableComponent gentleLabel = Component.m_237115_((String)"pedestals.upgrade_tooltip_gentle_label");
            gentleLabel.m_130940_(ChatFormatting.YELLOW);
            player.m_5661_((Component)gentleLabel, false);
        }
        if (this.canModifySuperSpeed(upgrade) && this.getSuperSpeed(upgrade)) {
            MutableComponent sspeedLabel = Component.m_237115_((String)"pedestals.upgrade_tooltip_superspeed_label");
            sspeedLabel.m_130940_(ChatFormatting.DARK_AQUA);
            player.m_5661_((Component)sspeedLabel, false);
        }
        if (this.canModifyOperateToBedrock(upgrade) && this.getOperateToBedrock(upgrade)) {
            MutableComponent operateToBedrockLabel = Component.m_237115_((String)"pedestals.upgrade_tooltip_operatetobedrock_label");
            operateToBedrockLabel.m_130940_(ChatFormatting.GRAY);
            player.m_5661_((Component)operateToBedrockLabel, false);
        }
    }

    public List<ItemStack> getBlockDrops(Level level, BasePedestalBlockEntity pedestal, FakePlayer fakePlayer, BlockState targetBlockState) {
        if (targetBlockState.m_60734_() != Blocks.f_50016_) {
            LootParams.Builder builder = new LootParams.Builder((ServerLevel)level).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pedestal.getPos())).m_287289_(LootContextParams.f_81455_, (Object)fakePlayer).m_287286_(LootContextParams.f_81463_, (Object)pedestal.getToolStack());
            return targetBlockState.m_287290_(builder);
        }
        return List.of();
    }

    public List<ItemStack> getBlockDrops(Level level, BasePedestalBlockEntity pedestal, Item targetItem) {
        Block targetBlock = Block.m_49814_((Item)targetItem);
        if (targetBlock != Blocks.f_50016_) {
            LootParams.Builder builder = new LootParams.Builder((ServerLevel)level).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pedestal.getPos())).m_287286_(LootContextParams.f_81463_, (Object)pedestal.getToolStack());
            WeakReference<FakePlayer> fakePlayerReference = pedestal.getPedestalPlayer(pedestal);
            if (fakePlayerReference != null && fakePlayerReference.get() != null) {
                builder.m_287289_(LootContextParams.f_81455_, (Object)((Entity)fakePlayerReference.get()));
            }
            return targetBlock.m_49966_().m_287290_(builder);
        }
        return List.of();
    }

    public boolean needsWorkCard(ItemStack upgradeItemStack) {
        return false;
    }

    public int getWorkCardType() {
        return -1;
    }

    public void resetCachedValidWorkCardPositions(String modid, ItemStack upgrade) {
        MowLibBlockPosUtils.removeBlockListCustomNBTTags((String)modid, (String)"_validlist", (ItemStack)upgrade);
    }

    public List<BlockPos> getValidWorkCardPositions(BasePedestalBlockEntity pedestal, ItemStack upgrade, int workCardType, String modid) {
        List cached = MowLibBlockPosUtils.readBlockPosListCustomFromNBT((String)modid, (String)"_validlist", (ItemStack)upgrade);
        if (cached.size() == 0 && !MowLibBlockPosUtils.hasBlockListCustomNBTTags((String)modid, (String)"_validlist", (ItemStack)upgrade) && pedestal.hasWorkCard()) {
            ItemStack workCardItemStack = pedestal.getWorkCardInPedestal();
            Item item = workCardItemStack.m_41720_();
            if (item instanceof WorkCardBase) {
                WorkCardBase baseCard = (WorkCardBase)item;
                int supportedWorkCardTypesForThisUpgrade = workCardType;
                int insertedWorkCardType = baseCard.getWorkCardType();
                if (insertedWorkCardType == supportedWorkCardTypesForThisUpgrade || supportedWorkCardTypesForThisUpgrade == 0 && (insertedWorkCardType == 1 || insertedWorkCardType == 2)) {
                    cached = switch (baseCard.getWorkCardType()) {
                        case 1 -> WorkCardArea.getPositionsInRangeOfUpgrade((ItemStack)workCardItemStack, (MowLibBaseBlockEntity)pedestal, (int)this.getUpgradeWorkRange(pedestal.getCoinOnPedestal()));
                        case 2 -> WorkCardLocations.getPositionsInRangeOfUpgrade((ItemStack)workCardItemStack, (MowLibBaseBlockEntity)pedestal, (int)this.getUpgradeWorkRange(pedestal.getCoinOnPedestal()));
                        case 3 -> WorkCardBE.getPositionsInRangeOfUpgrade((ItemStack)workCardItemStack, (MowLibBaseBlockEntity)pedestal, (int)this.getUpgradeWorkRange(pedestal.getCoinOnPedestal()));
                        default -> List.of();
                    };
                }
            }
            MowLibBlockPosUtils.saveBlockPosListCustomToNBT((String)modid, (String)"_validlist", (ItemStack)upgrade, (List)cached);
        }
        return cached;
    }

    public ItemStack getUpgradeDefaultTool() {
        return ItemStack.f_41583_;
    }

    public boolean hasSuperSpeed(ItemStack upgradeStack) {
        if (this.canModifySuperSpeed(upgradeStack)) {
            return this.getSuperSpeed(upgradeStack);
        }
        return false;
    }

    public boolean hasGentleHarvest(ItemStack upgradeStack) {
        if (this.canModifyGentleHarvest(upgradeStack)) {
            return this.getGentleHarvest(upgradeStack);
        }
        return false;
    }

    public boolean hasEntityContainer(ItemStack upgradeStack) {
        if (this.canModifyEntityContainers(upgradeStack)) {
            return this.getEntityContainer(upgradeStack);
        }
        return false;
    }

    public boolean hasRemoteStorage(ItemStack upgradeStack) {
        if (this.canModifyRemoteStorage(upgradeStack)) {
            return this.getRemoteStorage(upgradeStack);
        }
        return false;
    }

    public boolean hasOperateToBedrock(ItemStack upgradeStack) {
        if (this.canModifyOperateToBedrock(upgradeStack)) {
            return this.getOperateToBedrock(upgradeStack);
        }
        return false;
    }

    public void runClientStuff(BasePedestalBlockEntity pedestal) {
    }

    public int getUpgradeSelectableAreaSize(ItemStack upgradeStack) {
        return 2 + this.getAreaIncrease(upgradeStack);
    }

    public boolean requiresEnergy() {
        return this.baseEnergyCostPerDistance() > 0;
    }

    public boolean energyDistanceAsModifier() {
        return true;
    }

    public int baseEnergyCostPerDistance() {
        return 0;
    }

    public double energyCostMultiplier() {
        return 1.0;
    }

    public boolean requiresXp() {
        return this.baseXpCostPerDistance() > 0;
    }

    public boolean xpDistanceAsModifier() {
        return true;
    }

    public int baseXpCostPerDistance() {
        return 0;
    }

    public double xpCostMultiplier() {
        return 1.0;
    }

    public boolean requiresDust() {
        return !this.baseDustCostPerDistance().isEmpty();
    }

    public boolean dustDistanceAsModifier() {
        return true;
    }

    public DustMagic baseDustCostPerDistance() {
        return new DustMagic(-1, 0);
    }

    public double dustCostMultiplier() {
        return 1.0;
    }

    public boolean hasSelectedAreaModifier() {
        return false;
    }

    public double selectedAreaCostMultiplier() {
        return 1.0;
    }

    public boolean requiresFuelForUpgradeAction() {
        return this.requiresEnergy() || this.requiresXp() || this.requiresDust();
    }

    public boolean removeFuelForAction(BasePedestalBlockEntity pedestal, int distance, boolean simulate) {
        if (this.requiresFuelForUpgradeAction()) {
            double areaCostMultiplier;
            boolean enoughEnergy = true;
            boolean enoughXP = true;
            boolean enoughDust = true;
            double d = areaCostMultiplier = this.hasSelectedAreaModifier() ? this.selectedAreaCostMultiplier() : 0.0;
            if (this.requiresEnergy()) {
                int energyCost = (int)Math.round((double)this.baseEnergyCostPerDistance() + areaCostMultiplier * (double)(this.energyDistanceAsModifier() ? distance : 1) * this.energyCostMultiplier());
                boolean bl = enoughEnergy = pedestal.removeEnergy(energyCost, simulate) >= energyCost;
            }
            if (this.requiresXp()) {
                int xpCost = (int)Math.round((double)this.baseXpCostPerDistance() + areaCostMultiplier * (double)(this.xpDistanceAsModifier() ? distance : 1) * this.xpCostMultiplier());
                boolean bl = enoughXP = pedestal.removeExperience(xpCost, simulate) >= xpCost;
            }
            if (this.requiresDust()) {
                int dustCost = (int)Math.round((double)this.baseDustCostPerDistance().getDustAmount() + areaCostMultiplier * (double)(this.dustDistanceAsModifier() ? distance : 1) * this.dustCostMultiplier());
                enoughDust = pedestal.removeDust(dustCost, simulate ? IDustHandler.DustAction.SIMULATE : IDustHandler.DustAction.EXECUTE).getDustAmount() >= dustCost;
            }
            return enoughEnergy && enoughXP && enoughDust;
        }
        return true;
    }

    public boolean removeFuelForActionMultiple(BasePedestalBlockEntity pedestal, List<Integer> distances, boolean simulate) {
        if (this.requiresFuelForUpgradeAction()) {
            double areaCostMultiplier;
            boolean enoughEnergy = true;
            boolean enoughXP = true;
            boolean enoughDust = true;
            double d = areaCostMultiplier = this.hasSelectedAreaModifier() ? this.selectedAreaCostMultiplier() : 0.0;
            if (this.requiresEnergy()) {
                int energyCost = distances.stream().map(distance -> (int)Math.round((double)this.baseEnergyCostPerDistance() + areaCostMultiplier * (double)(this.energyDistanceAsModifier() ? distance : 1) * this.energyCostMultiplier())).reduce(0, Integer::sum);
                boolean bl = enoughEnergy = pedestal.removeEnergy(energyCost, simulate) >= energyCost;
            }
            if (this.requiresXp()) {
                int xpCost = distances.stream().map(distance -> (int)Math.round((double)this.baseXpCostPerDistance() + areaCostMultiplier * (double)(this.xpDistanceAsModifier() ? distance : 1) * this.xpCostMultiplier())).reduce(0, Integer::sum);
                boolean bl = enoughXP = pedestal.removeExperience(xpCost, simulate) >= xpCost;
            }
            if (this.requiresDust()) {
                int dustCost = distances.stream().map(distance -> (int)Math.round((double)this.baseDustCostPerDistance().getDustAmount() + areaCostMultiplier * (double)(this.dustDistanceAsModifier() ? distance : 1) * this.dustCostMultiplier())).reduce(0, Integer::sum);
                enoughDust = pedestal.removeDust(dustCost, simulate ? IDustHandler.DustAction.SIMULATE : IDustHandler.DustAction.EXECUTE).getDustAmount() >= dustCost;
            }
            return enoughEnergy && enoughXP && enoughDust;
        }
        return true;
    }

    public static ChatFormatting getModeColorFormat(int mode) {
        return switch (mode) {
            case 0 -> ChatFormatting.GOLD;
            case 1 -> ChatFormatting.BLUE;
            case 2 -> ChatFormatting.RED;
            case 3 -> ChatFormatting.GREEN;
            case 4 -> ChatFormatting.LIGHT_PURPLE;
            default -> ChatFormatting.WHITE;
        };
    }

    public static String getModeStringFromInt(int mode) {
        switch (mode) {
            case 0: {
                return "item";
            }
            case 1: {
                return "fluid";
            }
            case 2: {
                return "energy";
            }
            case 3: {
                return "xp";
            }
            case 4: {
                return "dust";
            }
        }
        return "item";
    }

    public static String getModeLocalizedString(int mode) {
        String typeString = "";
        switch (mode) {
            case 0: {
                typeString = ".mode_items";
                break;
            }
            case 1: {
                typeString = ".mode_fluids";
                break;
            }
            case 2: {
                typeString = ".mode_energy";
                break;
            }
            case 3: {
                typeString = ".mode_experience";
                break;
            }
            case 4: {
                typeString = ".mode_dust";
                break;
            }
            default: {
                typeString = ".error";
            }
        }
        return typeString;
    }

    public static void writeTransportModeToNBT(ItemStack filterStack, int mode, boolean allowed) {
        CompoundTag compound = new CompoundTag();
        if (filterStack.m_41782_()) {
            compound = filterStack.m_41783_();
        }
        compound.m_128379_("pedestals_" + ItemUpgradeBase.getModeStringFromInt(mode) + "_transport_mode", allowed);
        filterStack.m_41751_(compound);
    }

    public static boolean getTransportModeFromNBT(ItemStack filterStack, int mode) {
        boolean allowed = true;
        if (filterStack.m_41782_()) {
            CompoundTag getCompound = filterStack.m_41783_();
            String tag = "pedestals_" + ItemUpgradeBase.getModeStringFromInt(mode) + "_transport_mode";
            if (filterStack.m_41783_().m_128441_(tag)) {
                allowed = getCompound.m_128471_(tag);
            }
        }
        return allowed;
    }

    public void toggleTransportMode(Player player, ItemStack heldItem, InteractionHand hand) {
        Item item = heldItem.m_41720_();
        if (item instanceof ItemUpgradeBase) {
            int mode;
            ItemUpgradeBase baseUpgrade = (ItemUpgradeBase)item;
            boolean getTransportMode = ItemUpgradeBase.getTransportModeFromNBT(heldItem, mode = ItemUpgradeBase.getUpgradeMode(heldItem));
            ItemUpgradeBase.writeTransportModeToNBT(heldItem, mode, !getTransportMode);
            player.m_21008_(hand, heldItem);
            ChatFormatting colorChange = !getTransportMode ? ChatFormatting.WHITE : ChatFormatting.BLACK;
            MowLibMessageUtils.messagePopup((Player)player, (ChatFormatting)colorChange, (String)("pedestals" + (!getTransportMode ? ".transport_mode_changed_true" : ".transport_mode_changed_false")));
        }
    }

    public void incrementUpgradeMode(Player player, ItemStack heldItem, InteractionHand hand) {
        Item item = heldItem.m_41720_();
        if (item instanceof ItemUpgradeBase) {
            ItemUpgradeBase baseUpgrade = (ItemUpgradeBase)item;
            int mode = ItemUpgradeBase.getUpgradeMode(heldItem) + 1;
            int setNewMode = mode <= 4 ? mode : 0;
            ItemUpgradeBase.saveUpgradeModeToNBT(heldItem, setNewMode);
            player.m_21008_(hand, heldItem);
            ChatFormatting colorChange = ItemUpgradeBase.getModeColorFormat(setNewMode);
            String typeString = ItemUpgradeBase.getModeLocalizedString(setNewMode);
            ArrayList<CallSite> listed = new ArrayList<CallSite>();
            listed.add((CallSite)((Object)("pedestals" + typeString)));
            MowLibMessageUtils.messagePopupWithAppend((String)"pedestals", (Player)player, (ChatFormatting)colorChange, (String)"pedestals.mode_changed", listed);
        }
    }

    public static void saveUpgradeModeToNBT(ItemStack augment, int mode) {
        CompoundTag compound = new CompoundTag();
        if (augment.m_41782_()) {
            compound = augment.m_41783_();
        }
        compound.m_128405_("pedestals_upgrade_mode", mode);
        augment.m_41751_(compound);
    }

    public static int readUpgradeModeFromNBT(ItemStack augment) {
        if (augment.m_41782_()) {
            CompoundTag getCompound = augment.m_41783_();
            return getCompound.m_128451_("pedestals_upgrade_mode");
        }
        return 0;
    }

    public static int getUpgradeMode(ItemStack stack) {
        return ItemUpgradeBase.readUpgradeModeFromNBT(stack);
    }

    public static int getUpgradeModeForRender(ItemStack stack) {
        int mode = ItemUpgradeBase.readUpgradeModeFromNBT(stack);
        boolean type = ItemUpgradeBase.getTransportModeFromNBT(stack, mode);
        return type ? mode : mode + 5;
    }

    public static MutableComponent getUpgradeModeComponentFromInt(int mode) {
        switch (mode) {
            case 0: {
                return Component.m_237115_((String)"pedestals.item_mode_component");
            }
            case 1: {
                return Component.m_237115_((String)"pedestals.fluid_mode_component");
            }
            case 2: {
                return Component.m_237115_((String)"pedestals.energy_mode_component");
            }
            case 3: {
                return Component.m_237115_((String)"pedestals.xp_mode_component");
            }
            case 4: {
                return Component.m_237115_((String)"pedestals.dust_mode_component");
            }
        }
        return Component.m_237115_((String)"pedestals.item_mode_component");
    }

    public static BlockPos getExistingSingleBlockPos(ItemStack stack) {
        return !MowLibBlockPosUtils.readBlockPosFromNBT((ItemStack)stack, (int)1).equals((Object)BlockPos.f_121853_) ? MowLibBlockPosUtils.readBlockPosFromNBT((ItemStack)stack, (int)1) : MowLibBlockPosUtils.readBlockPosFromNBT((ItemStack)stack, (int)2);
    }

    public boolean isNewBlockPosSmallerThanExisting(ItemStack stack, BlockPos posTwo) {
        BlockPos posOne = ItemUpgradeBase.getExistingSingleBlockPos(stack);
        BlockPos toCompare = new BlockPos(Math.min(posOne.m_123341_(), posTwo.m_123341_()), Math.min(posOne.m_123342_(), posTwo.m_123342_()), Math.min(posOne.m_123343_(), posTwo.m_123343_()));
        return posTwo.equals((Object)toCompare);
    }

    public boolean hasTwoPointsSelected(ItemStack stack) {
        return !MowLibBlockPosUtils.readBlockPosFromNBT((ItemStack)stack, (int)1).equals((Object)BlockPos.f_121853_) && !MowLibBlockPosUtils.readBlockPosFromNBT((ItemStack)stack, (int)2).equals((Object)BlockPos.f_121853_);
    }

    public AABB getAABBonUpgrade(ItemStack stack) {
        if (stack.m_41720_() instanceof ISelectableArea && this.hasTwoPointsSelected(stack)) {
            BlockPos posOne = MowLibBlockPosUtils.readBlockPosFromNBT((ItemStack)stack, (int)1);
            BlockPos posTwo = MowLibBlockPosUtils.readBlockPosFromNBT((ItemStack)stack, (int)2);
            return new AABB((double)Math.min(posOne.m_123341_(), posTwo.m_123341_()), (double)Math.min(posOne.m_123342_(), posTwo.m_123342_()), (double)Math.min(posOne.m_123343_(), posTwo.m_123343_()), (double)Math.max(posOne.m_123341_(), posTwo.m_123341_()), (double)Math.max(posOne.m_123342_(), posTwo.m_123342_()), (double)Math.max(posOne.m_123343_(), posTwo.m_123343_())).m_82363_(1.0, 1.0, 1.0);
        }
        return new AABB(BlockPos.f_121853_);
    }

    public int getUpgradeWorkRange(ItemStack coinUpgrade) {
        return (Integer)PedestalConfig.COMMON.upgrades_baseSelectionRange.get() + this.getRangeIncrease(coinUpgrade);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        MowLibBlockPosUtils.saveBlockPosToNBT((ItemStack)stack, (int)10, (BlockPos)context.m_8083_());
        MowLibBlockPosUtils.saveStringToNBT((ItemStack)stack, (String)"_string_last_clicked_direction", (String)context.m_43719_().toString());
        return super.onItemUseFirst(stack, context);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level p_41432_, Player p_41433_, InteractionHand p_41434_) {
        Level level = p_41432_;
        Player player = p_41433_;
        InteractionHand hand = p_41434_;
        ItemStack itemInHand = player.m_21120_(hand);
        ItemStack itemInOffhand = player.m_21206_();
        HitResult result = player.m_19907_(5.0, player.m_20192_(), false);
        BlockPos atLocation = MowLibBlockPosUtils.readBlockPosFromNBT((ItemStack)itemInHand, (int)10);
        Direction facing = MowLibBlockPosUtils.getLastClickedDirectionFromUpgrade((ItemStack)itemInHand);
        if (itemInHand.m_41720_() instanceof ItemUpgradeBase) {
            if (hand.equals((Object)InteractionHand.MAIN_HAND) && !player.m_6144_() && itemInHand.m_41720_() instanceof ISelectablePoints) {
                if (result.m_6662_().equals((Object)HitResult.Type.BLOCK)) {
                    boolean added = MowLibBlockPosUtils.addBlockPosToList((ItemStack)itemInHand, (BlockPos)atLocation);
                    player.m_21008_(hand, itemInHand);
                    MowLibMessageUtils.messagePopup((Player)player, (ChatFormatting)(added ? ChatFormatting.WHITE : ChatFormatting.BLACK), (String)(added ? "pedestals.upgrade_blockpos_added" : "pedestals.upgrade_blockpos_removed"));
                    MowLibPacketHandler.sendToNearby((Level)p_41432_, (BlockPos)player.m_20097_(), (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)atLocation.m_123341_(), (double)atLocation.m_123342_() + 1.0, (double)atLocation.m_123343_(), new int[]{0, added ? 200 : 0, 0}));
                } else if (result.m_6662_().equals((Object)HitResult.Type.MISS) && MowLibBlockPosUtils.readBlockPosListFromNBT((ItemStack)itemInHand).size() > 0) {
                    MowLibBlockPosUtils.saveBlockPosListToNBT((ItemStack)itemInHand, new ArrayList());
                    MowLibMessageUtils.messagePopup((Player)player, (ChatFormatting)ChatFormatting.WHITE, (String)"pedestals.upgrade_blockpos_clear");
                }
            }
            if (hand.equals((Object)InteractionHand.MAIN_HAND) && player.m_6144_() && itemInHand.m_41720_() instanceof ISelectableArea) {
                if (result.m_6662_().equals((Object)HitResult.Type.BLOCK)) {
                    Boolean hasOnePointAlready = MowLibBlockPosUtils.hasOneBlockPos((ItemStack)itemInHand);
                    Boolean hasTwoPointsAlready = this.hasTwoPointsSelected(itemInHand);
                    if (hasOnePointAlready.booleanValue() && !hasTwoPointsAlready.booleanValue()) {
                        if (((Boolean)PedestalConfig.COMMON.upgrade_require_sized_selectable_area.get()).booleanValue()) {
                            if (MowLibBlockPosUtils.getDistanceBetweenPoints((BlockPos)MowLibBlockPosUtils.readBlockPosFromNBT((ItemStack)itemInHand, (int)1), (BlockPos)atLocation) <= this.getUpgradeSelectableAreaSize(itemInHand)) {
                                MowLibBlockPosUtils.saveBlockPosToNBT((ItemStack)itemInHand, (int)2, (BlockPos)atLocation);
                                player.m_21008_(hand, itemInHand);
                                MowLibMessageUtils.messagePopup((Player)player, (ChatFormatting)ChatFormatting.WHITE, (String)"pedestals.upgrade_blockpos_second");
                            } else {
                                MowLibMessageUtils.messagePopup((Player)player, (ChatFormatting)ChatFormatting.RED, (String)"pedestals.upgrade_blockpos_point_out_of_range");
                            }
                        } else {
                            MowLibBlockPosUtils.saveBlockPosToNBT((ItemStack)itemInHand, (int)2, (BlockPos)atLocation);
                            player.m_21008_(hand, itemInHand);
                            MowLibMessageUtils.messagePopup((Player)player, (ChatFormatting)ChatFormatting.WHITE, (String)"pedestals.upgrade_blockpos_second");
                        }
                    } else if (!hasTwoPointsAlready.booleanValue()) {
                        MowLibBlockPosUtils.saveBlockPosToNBT((ItemStack)itemInHand, (int)1, (BlockPos)atLocation);
                        player.m_21008_(hand, itemInHand);
                        MowLibMessageUtils.messagePopup((Player)player, (ChatFormatting)ChatFormatting.WHITE, (String)"pedestals.upgrade_blockpos_first");
                    }
                } else if (result.m_6662_().equals((Object)HitResult.Type.MISS) && MowLibBlockPosUtils.hasOneBlockPos((ItemStack)itemInHand)) {
                    MowLibBlockPosUtils.saveBlockPosToNBT((ItemStack)itemInHand, (int)1, (BlockPos)BlockPos.f_121853_);
                    MowLibBlockPosUtils.saveBlockPosToNBT((ItemStack)itemInHand, (int)2, (BlockPos)BlockPos.f_121853_);
                    MowLibMessageUtils.messagePopup((Player)player, (ChatFormatting)ChatFormatting.WHITE, (String)"pedestals.upgrade_blockpos_clear");
                }
            }
            if (hand.equals((Object)InteractionHand.OFF_HAND) && itemInHand.m_41720_() instanceof IHasModeTypes && result.m_6662_().equals((Object)HitResult.Type.MISS)) {
                if (player.m_6144_()) {
                    this.incrementUpgradeMode(player, itemInOffhand, hand);
                } else {
                    this.toggleTransportMode(player, itemInOffhand, hand);
                }
            }
        }
        return InteractionResultHolder.m_19100_((Object)p_41433_.m_21120_(p_41434_));
    }

    @Override
    public boolean canTransferItems(ItemStack upgrade) {
        return ItemUpgradeBase.getTransportModeFromNBT(upgrade, 0);
    }

    @Override
    public boolean canTransferFluids(ItemStack upgrade) {
        return ItemUpgradeBase.getTransportModeFromNBT(upgrade, 1);
    }

    @Override
    public boolean canTransferEnergy(ItemStack upgrade) {
        return ItemUpgradeBase.getTransportModeFromNBT(upgrade, 2);
    }

    @Override
    public boolean canTransferXP(ItemStack upgrade) {
        return ItemUpgradeBase.getTransportModeFromNBT(upgrade, 3);
    }

    @Override
    public boolean canTransferDust(ItemStack upgrade) {
        return ItemUpgradeBase.getTransportModeFromNBT(upgrade, 4);
    }

    public Direction getPedestalFacing(Level world, BlockPos posOfPedestal) {
        BlockState state = world.m_8055_(posOfPedestal);
        return (Direction)state.m_61143_((Property)BasePedestalBlock.FACING);
    }

    public boolean isInventoryEmpty(LazyOptional<IItemHandler> cap) {
        IItemHandler handler;
        if (cap.isPresent() && (handler = (IItemHandler)cap.orElse(null)) != null) {
            int range = handler.getSlots();
            ItemStack itemFromInv = ItemStack.f_41583_;
            itemFromInv = IntStream.range(0, range).mapToObj(arg_0 -> ((IItemHandler)handler).getStackInSlot(arg_0)).filter(itemStack -> !itemStack.m_41619_()).findFirst().orElse(ItemStack.f_41583_);
            if (!itemFromInv.m_41619_()) {
                return false;
            }
        }
        return true;
    }

    public boolean doItemsMatch(ItemStack stackPedestal, ItemStack itemStackIn) {
        return ItemHandlerHelper.canItemStacksStack((ItemStack)stackPedestal, (ItemStack)itemStackIn);
    }

    public boolean doItemsMatchWithEmpty(ItemStack stackPedestal, ItemStack itemStackIn) {
        if (stackPedestal.m_41619_() && itemStackIn.m_41619_()) {
            return true;
        }
        return ItemHandlerHelper.canItemStacksStack((ItemStack)stackPedestal, (ItemStack)itemStackIn);
    }

    public static Optional<Integer> getFirstSlotWithNonMachineFilteredItems(BasePedestalBlockEntity pedestal, IItemHandler itemHandler) {
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(i);
            if (stackInSlot.m_41619_() || itemHandler.extractItem(i, 1, true).equals(ItemStack.f_41583_) || !ItemUpgradeBase.passesMachineFilterItems(pedestal, stackInSlot)) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    public static Optional<Integer> getFirstSlotWithNonFilteredItems(BasePedestalBlockEntity pedestal, IItemHandler itemHandler) {
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(i);
            if (stackInSlot.m_41619_() || itemHandler.extractItem(i, 1, true).equals(ItemStack.f_41583_) || !ItemUpgradeBase.passesItemFilter(pedestal, stackInSlot)) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    public int getNextSlotWithItemsCapFiltered(BasePedestalBlockEntity pedestal, LazyOptional<IItemHandler> cap) {
        AtomicInteger slot = new AtomicInteger(-1);
        if (cap.isPresent()) {
            cap.ifPresent(itemHandler -> {
                int range = itemHandler.getSlots();
                for (int i = 0; i < range; ++i) {
                    ItemStack stackInSlot = itemHandler.getStackInSlot(i);
                    if (stackInSlot.m_41619_() || itemHandler.extractItem(i, 1, true).equals(ItemStack.f_41583_) || !ItemUpgradeBase.passesItemFilter(pedestal, stackInSlot)) continue;
                    ItemStack itemFromPedestal = pedestal.getMatchingItemInPedestalOrEmptySlot(stackInSlot);
                    if (itemFromPedestal.m_41619_()) {
                        slot.set(i);
                        break;
                    }
                    if (!this.doItemsMatch(itemFromPedestal, stackInSlot)) continue;
                    slot.set(i);
                    break;
                }
            });
        }
        return slot.get();
    }

    public static boolean passesMachineFilterItems(BasePedestalBlockEntity pedestal, ItemStack itemStack) {
        IFilterItem filter;
        ItemStack filterInPedestal;
        Item item;
        if (pedestal.hasFilter() && (item = (filterInPedestal = pedestal.getFilterInBlockEntity()).m_41720_()) instanceof IFilterItem && (filter = (IFilterItem)item).getFilterDirection().equals((Object)IFilterItem.FilterDirection.NEUTRAL)) {
            return filter.canAcceptItems(filterInPedestal, itemStack);
        }
        return true;
    }

    public static boolean passesMachineFilterFluids(BasePedestalBlockEntity pedestal, FluidStack fluidStack) {
        IFilterItem filter;
        ItemStack filterInPedestal;
        Item item;
        if (pedestal.hasFilter() && (item = (filterInPedestal = pedestal.getFilterInBlockEntity()).m_41720_()) instanceof IFilterItem && (filter = (IFilterItem)item).getFilterDirection().equals((Object)IFilterItem.FilterDirection.NEUTRAL)) {
            return filter.canAcceptFluids(filterInPedestal, fluidStack);
        }
        return true;
    }

    public static boolean passesItemFilter(BasePedestalBlockEntity pedestal, ItemStack stackIn) {
        ItemStack filterInPedestal;
        Item item;
        if (pedestal.hasFilter() && (item = (filterInPedestal = pedestal.getFilterInBlockEntity()).m_41720_()) instanceof IFilterItem) {
            IFilterItem filter = (IFilterItem)item;
            return filter.canAcceptItems(filterInPedestal, stackIn);
        }
        return true;
    }

    public FluidStack getFluidStackFromItemStack(ItemStack stackIn) {
        Item item = stackIn.m_41720_();
        if (item instanceof BucketItem) {
            BucketItem bucket = (BucketItem)item;
            Fluid bucketFluid = bucket.getFluid();
            return new FluidStack(bucketFluid, 1000);
        }
        return FluidStack.EMPTY;
    }

    public boolean passesFluidFilter(BasePedestalBlockEntity pedestal, FluidStack incomingFluidStack) {
        boolean returner = true;
        if (pedestal.hasFilter()) {
            ItemStack filterInPedestal = pedestal.getFilterInBlockEntity();
            Item item = filterInPedestal.m_41720_();
            if (item instanceof IFilterItem) {
                IFilterItem filter = (IFilterItem)item;
                returner = filter.canAcceptFluids(filterInPedestal, incomingFluidStack);
            }
        } else {
            return pedestal.canAcceptFluid(incomingFluidStack);
        }
        return returner;
    }

    public boolean passesDustFilter(BasePedestalBlockEntity pedestal, DustMagic incomingDust) {
        boolean returner = true;
        if (pedestal.hasFilter()) {
            ItemStack filterInPedestal = pedestal.getFilterInBlockEntity();
            Item item = filterInPedestal.m_41720_();
            if (item instanceof IFilterItem) {
                IFilterItem filter = (IFilterItem)item;
                returner = filter.canAcceptDust(filterInPedestal, incomingDust);
            }
        } else {
            return pedestal.canAcceptDust(incomingDust);
        }
        return returner;
    }

    public int getCountItemFilter(BasePedestalBlockEntity pedestal, ItemStack stackIn) {
        ItemStack filterStackInPedestal;
        Item item;
        if (pedestal.hasFilter() && (item = (filterStackInPedestal = pedestal.getFilterInBlockEntity()).m_41720_()) instanceof IFilterItem) {
            IFilterItem filter = (IFilterItem)item;
            return filter.canAcceptCountItems((MowLibBaseBlockEntity)pedestal, filterStackInPedestal, stackIn.m_41741_(), pedestal.getSlotSizeLimit(), stackIn);
        }
        return stackIn.m_41613_();
    }

    public void m_7373_(ItemStack p_41421_, @Nullable Level p_41422_, List<Component> p_41423_, TooltipFlag p_41424_) {
        List getList;
        MutableComponent areaAmount;
        MutableComponent areaLabel;
        MutableComponent separator;
        MutableComponent base;
        super.m_7373_(p_41421_, p_41422_, p_41423_, p_41424_);
        if (p_41421_.m_41720_().equals(DeferredRegisterItems.PEDESTAL_UPGRADE_BASE.get())) {
            base = Component.m_237115_((String)(this.m_5524_() + ".base_description"));
            base.m_130940_(ChatFormatting.DARK_RED);
            p_41423_.add((Component)base);
        }
        if (p_41421_.m_41720_() instanceof IHasModeTypes) {
            int mode = ItemUpgradeBase.getUpgradeMode(p_41421_);
            MutableComponent changed = Component.m_237115_((String)"pedestals.upgrade_tooltip_mode");
            ChatFormatting colorChange = ChatFormatting.GOLD;
            String typeString = "";
            switch (mode) {
                case 0: {
                    typeString = ".mode_tooltip_items";
                    break;
                }
                case 1: {
                    typeString = ".mode_tooltip_fluids";
                    break;
                }
                case 2: {
                    typeString = ".mode_tooltip_energy";
                    break;
                }
                case 3: {
                    typeString = ".mode_tooltip_experience";
                    break;
                }
                case 4: {
                    typeString = ".mode_tooltip_dust";
                    break;
                }
                default: {
                    typeString = ".tooltip_error";
                }
            }
            changed.m_130940_(colorChange);
            MutableComponent type = Component.m_237115_((String)("pedestals" + typeString));
            changed.m_7220_((Component)type);
            p_41423_.add((Component)changed);
            if (!Screen.m_96638_()) {
                MutableComponent base2 = Component.m_237115_((String)"pedestals.upgrade_description_shift");
                base2.m_130940_(ChatFormatting.WHITE);
                p_41423_.add((Component)base2);
            } else {
                MutableComponent separator2 = Component.m_237115_((String)"pedestals.tooltip_separator");
                p_41423_.add((Component)separator2);
                for (int i = 0; i < 5; ++i) {
                    MutableComponent modeIterator = ItemUpgradeBase.getUpgradeModeComponentFromInt(i);
                    MutableComponent typeIterator = ItemUpgradeBase.getTransportModeFromNBT(p_41421_, i) ? Component.m_237115_((String)"pedestals.upgrade_tooltip_type_enabled") : Component.m_237115_((String)"pedestals.upgrade_tooltip_type_disabled");
                    modeIterator.m_7220_((Component)Component.m_237115_((String)"pedestals.upgrade_tooltip_separator"));
                    modeIterator.m_7220_((Component)typeIterator);
                    p_41423_.add((Component)modeIterator);
                }
            }
        }
        if (this.canModifySpeed(p_41421_)) {
            if (this.getSpeedTicksReduced(p_41421_) > 0) {
                MutableComponent speedLabel = Component.m_237115_((String)"pedestals.upgrade_tooltip_speed_label");
                speedLabel.m_130940_(ChatFormatting.AQUA);
                MutableComponent speedAmount = Component.m_237113_((String)("" + this.getSpeedTicksReduced(p_41421_)));
                separator = Component.m_237115_((String)"pedestals.upgrade_tooltip_separator_slash");
                MutableComponent speedMax = Component.m_237113_((String)("" + this.getMaxSpeed(p_41421_)));
                speedAmount.m_7220_((Component)separator);
                speedAmount.m_7220_((Component)speedMax);
                speedAmount.m_130940_(ChatFormatting.WHITE);
                speedLabel.m_7220_((Component)speedAmount);
                p_41423_.add((Component)speedLabel);
            } else {
                MowLibTooltipUtils.addTooltipMessageWithStyle(p_41423_, (String)"pedestals.upgrade_tooltip_speed_allowed", (ChatFormatting)ChatFormatting.AQUA);
            }
        }
        if (this.canModifyDamageCapacity(p_41421_) || this.canModifyBlockCapacity(p_41421_) || this.canModifyItemCapacity(p_41421_) || this.canModifyFluidCapacity(p_41421_) || this.canModifyEnergyCapacity(p_41421_) || this.canModifyXPCapacity(p_41421_) || this.canModifyDustCapacity(p_41421_)) {
            if (Screen.m_96638_()) {
                MutableComponent capacityAmount;
                MutableComponent itemCapacityLabel;
                if (this.canModifyDamageCapacity(p_41421_)) {
                    if (this.getDamageCapacityIncrease(p_41421_) > 0) {
                        itemCapacityLabel = Component.m_237115_((String)"pedestals.upgrade_tooltip_damagecapacity_label");
                        itemCapacityLabel.m_130940_(ChatFormatting.DARK_RED);
                        capacityAmount = Component.m_237113_((String)("" + this.getDamageCapacityIncrease(p_41421_)));
                        capacityAmount.m_130940_(ChatFormatting.WHITE);
                        itemCapacityLabel.m_7220_((Component)capacityAmount);
                        p_41423_.add((Component)itemCapacityLabel);
                    } else {
                        MowLibTooltipUtils.addTooltipMessageWithStyle(p_41423_, (String)"pedestals.upgrade_tooltip_damagecapacity_allowed", (ChatFormatting)ChatFormatting.DARK_RED);
                    }
                }
                if (this.canModifyBlockCapacity(p_41421_)) {
                    if (this.getBlockCapacityIncrease(p_41421_) > 0) {
                        itemCapacityLabel = Component.m_237115_((String)"pedestals.upgrade_tooltip_blockcapacity_label");
                        itemCapacityLabel.m_130940_(ChatFormatting.GRAY);
                        capacityAmount = Component.m_237113_((String)("" + this.getBlockCapacityIncrease(p_41421_)));
                        capacityAmount.m_130940_(ChatFormatting.WHITE);
                        itemCapacityLabel.m_7220_((Component)capacityAmount);
                        p_41423_.add((Component)itemCapacityLabel);
                    } else {
                        MowLibTooltipUtils.addTooltipMessageWithStyle(p_41423_, (String)"pedestals.upgrade_tooltip_blockcapacity_allowed", (ChatFormatting)ChatFormatting.GRAY);
                    }
                }
                if (this.canModifyItemCapacity(p_41421_)) {
                    if (this.getItemCapacityIncrease(p_41421_) > 0) {
                        itemCapacityLabel = Component.m_237115_((String)"pedestals.upgrade_tooltip_itemcapacity_label");
                        itemCapacityLabel.m_130940_(ChatFormatting.GOLD);
                        capacityAmount = Component.m_237113_((String)("" + this.getItemCapacityIncrease(p_41421_)));
                        capacityAmount.m_130940_(ChatFormatting.WHITE);
                        itemCapacityLabel.m_7220_((Component)capacityAmount);
                        p_41423_.add((Component)itemCapacityLabel);
                    } else {
                        MowLibTooltipUtils.addTooltipMessageWithStyle(p_41423_, (String)"pedestals.upgrade_tooltip_itemcapacity_allowed", (ChatFormatting)ChatFormatting.GOLD);
                    }
                }
                if (this.canModifyFluidCapacity(p_41421_)) {
                    if (this.getFluidCapacityIncrease(p_41421_) > 0) {
                        MutableComponent fluidCapacityLabel = Component.m_237115_((String)"pedestals.upgrade_tooltip_fluidcapacity_label");
                        fluidCapacityLabel.m_130940_(ChatFormatting.BLUE);
                        capacityAmount = Component.m_237113_((String)("" + this.getFluidCapacityIncrease(p_41421_)));
                        capacityAmount.m_130940_(ChatFormatting.WHITE);
                        fluidCapacityLabel.m_7220_((Component)capacityAmount);
                        p_41423_.add((Component)fluidCapacityLabel);
                    } else {
                        MowLibTooltipUtils.addTooltipMessageWithStyle(p_41423_, (String)"pedestals.upgrade_tooltip_fluidcapacity_allowed", (ChatFormatting)ChatFormatting.BLUE);
                    }
                }
                if (this.canModifyEnergyCapacity(p_41421_)) {
                    if (this.getEnergyCapacityIncrease(p_41421_) > 0) {
                        MutableComponent energyCapacityLabel = Component.m_237115_((String)"pedestals.upgrade_tooltip_energycapacity_label");
                        energyCapacityLabel.m_130940_(ChatFormatting.RED);
                        capacityAmount = Component.m_237113_((String)("" + this.getEnergyCapacityIncrease(p_41421_)));
                        capacityAmount.m_130940_(ChatFormatting.WHITE);
                        energyCapacityLabel.m_7220_((Component)capacityAmount);
                        p_41423_.add((Component)energyCapacityLabel);
                    } else {
                        MowLibTooltipUtils.addTooltipMessageWithStyle(p_41423_, (String)"pedestals.upgrade_tooltip_energycapacity_allowed", (ChatFormatting)ChatFormatting.RED);
                    }
                }
                if (this.canModifyXPCapacity(p_41421_)) {
                    if (this.getItemCapacityIncrease(p_41421_) > 0) {
                        MutableComponent xpCapacityLabel = Component.m_237115_((String)"pedestals.upgrade_tooltip_xpcapacity_label");
                        xpCapacityLabel.m_130940_(ChatFormatting.GREEN);
                        capacityAmount = Component.m_237113_((String)("" + this.getXPCapacityIncrease(p_41421_)));
                        capacityAmount.m_130940_(ChatFormatting.WHITE);
                        xpCapacityLabel.m_7220_((Component)capacityAmount);
                        p_41423_.add((Component)xpCapacityLabel);
                    } else {
                        MowLibTooltipUtils.addTooltipMessageWithStyle(p_41423_, (String)"pedestals.upgrade_tooltip_xpcapacity_allowed", (ChatFormatting)ChatFormatting.GREEN);
                    }
                }
                if (this.canModifyDustCapacity(p_41421_)) {
                    if (this.getItemCapacityIncrease(p_41421_) > 0) {
                        MutableComponent dustCapacityLabel = Component.m_237115_((String)"pedestals.upgrade_tooltip_dustcapacity_label");
                        dustCapacityLabel.m_130940_(ChatFormatting.LIGHT_PURPLE);
                        capacityAmount = Component.m_237113_((String)("" + this.getDustCapacityIncrease(p_41421_)));
                        capacityAmount.m_130940_(ChatFormatting.WHITE);
                        dustCapacityLabel.m_7220_((Component)capacityAmount);
                        p_41423_.add((Component)dustCapacityLabel);
                    } else {
                        MowLibTooltipUtils.addTooltipMessageWithStyle(p_41423_, (String)"pedestals.upgrade_tooltip_dustcapacity_allowed", (ChatFormatting)ChatFormatting.LIGHT_PURPLE);
                    }
                }
            } else {
                MutableComponent capacityLabel = Component.m_237115_((String)"pedestals.upgrade_tooltip_capacity_label");
                capacityLabel.m_130940_(ChatFormatting.GREEN);
                MutableComponent separator_space = Component.m_237115_((String)"pedestals.upgrade_tooltip_separator_space");
                MutableComponent capacityDamageAmount = Component.m_237113_((String)"?");
                MutableComponent capacityBlockAmount = Component.m_237113_((String)"?");
                MutableComponent capacityItemAmount = Component.m_237113_((String)"?");
                MutableComponent capacityFluidAmount = Component.m_237113_((String)"?");
                MutableComponent capacityEnergyAmount = Component.m_237113_((String)"?");
                MutableComponent capacityXPAmount = Component.m_237113_((String)"?");
                MutableComponent capacityDustAmount = Component.m_237113_((String)"?");
                if (this.getDamageCapacityIncrease(p_41421_) > 0) {
                    capacityDamageAmount = Component.m_237113_((String)("" + this.getDamageCapacityIncrease(p_41421_)));
                }
                if (this.getBlockCapacityIncrease(p_41421_) > 0) {
                    capacityBlockAmount = Component.m_237113_((String)("" + this.getBlockCapacityIncrease(p_41421_)));
                }
                if (this.getItemCapacityIncrease(p_41421_) > 0) {
                    capacityItemAmount = Component.m_237113_((String)("" + this.getItemCapacityIncrease(p_41421_)));
                }
                if (this.getFluidCapacityIncrease(p_41421_) > 0) {
                    capacityFluidAmount = Component.m_237113_((String)("" + this.getFluidCapacityIncrease(p_41421_)));
                }
                if (this.getEnergyCapacityIncrease(p_41421_) > 0) {
                    capacityEnergyAmount = Component.m_237113_((String)("" + this.getEnergyCapacityIncrease(p_41421_)));
                }
                if (this.getItemCapacityIncrease(p_41421_) > 0) {
                    capacityXPAmount = Component.m_237113_((String)("" + this.getXPCapacityIncrease(p_41421_)));
                }
                if (this.getItemCapacityIncrease(p_41421_) > 0) {
                    capacityDustAmount = Component.m_237113_((String)("" + this.getDustCapacityIncrease(p_41421_)));
                }
                capacityDamageAmount.m_130940_(ChatFormatting.DARK_RED);
                capacityBlockAmount.m_130940_(ChatFormatting.GRAY);
                capacityItemAmount.m_130940_(ChatFormatting.GOLD);
                capacityFluidAmount.m_130940_(ChatFormatting.BLUE);
                capacityEnergyAmount.m_130940_(ChatFormatting.RED);
                capacityXPAmount.m_130940_(ChatFormatting.GREEN);
                capacityDustAmount.m_130940_(ChatFormatting.LIGHT_PURPLE);
                if (this.canModifyDamageCapacity(p_41421_)) {
                    capacityLabel.m_7220_((Component)capacityDamageAmount);
                }
                if (this.canModifyBlockCapacity(p_41421_)) {
                    capacityLabel.m_7220_((Component)separator_space);
                    capacityLabel.m_7220_((Component)capacityBlockAmount);
                }
                if (this.canModifyItemCapacity(p_41421_)) {
                    capacityLabel.m_7220_((Component)separator_space);
                    capacityLabel.m_7220_((Component)capacityItemAmount);
                }
                if (this.canModifyFluidCapacity(p_41421_)) {
                    capacityLabel.m_7220_((Component)separator_space);
                    capacityLabel.m_7220_((Component)capacityFluidAmount);
                }
                if (this.canModifyEnergyCapacity(p_41421_)) {
                    capacityLabel.m_7220_((Component)separator_space);
                    capacityLabel.m_7220_((Component)capacityEnergyAmount);
                }
                if (this.canModifyXPCapacity(p_41421_)) {
                    capacityLabel.m_7220_((Component)separator_space);
                    capacityLabel.m_7220_((Component)capacityXPAmount);
                }
                if (this.canModifyDustCapacity(p_41421_)) {
                    capacityLabel.m_7220_((Component)separator_space);
                    capacityLabel.m_7220_((Component)capacityDustAmount);
                }
                p_41423_.add((Component)capacityLabel);
            }
        }
        if (this.canModifyEntityContainers(p_41421_)) {
            if (this.getEntityContainer(p_41421_)) {
                areaLabel = Component.m_237115_((String)"pedestals.upgrade_tooltip_entitycontainer_label");
                areaLabel.m_130940_(ChatFormatting.DARK_GREEN);
                p_41423_.add((Component)areaLabel);
            } else {
                MowLibTooltipUtils.addTooltipMessageWithStyle(p_41423_, (String)"pedestals.upgrade_tooltip_entitycontainer_allowed", (ChatFormatting)ChatFormatting.DARK_GREEN);
            }
        }
        if (this.canModifyRemoteStorage(p_41421_)) {
            if (this.getRemoteStorage(p_41421_)) {
                areaLabel = Component.m_237115_((String)"pedestals.upgrade_tooltip_remotestorage_label");
                areaLabel.m_130940_(ChatFormatting.DARK_PURPLE);
                p_41423_.add((Component)areaLabel);
            } else {
                MowLibTooltipUtils.addTooltipMessageWithStyle(p_41423_, (String)"pedestals.upgrade_tooltip_remotestorage_allowed", (ChatFormatting)ChatFormatting.DARK_PURPLE);
            }
        }
        if (this.canModifyArea(p_41421_)) {
            if (this.getAreaIncrease(p_41421_) > 0) {
                areaLabel = Component.m_237115_((String)"pedestals.upgrade_tooltip_area_label");
                areaLabel.m_130940_(ChatFormatting.GRAY);
                areaAmount = Component.m_237113_((String)("" + this.getAreaIncrease(p_41421_)));
                areaAmount.m_130940_(ChatFormatting.WHITE);
                areaLabel.m_7220_((Component)areaAmount);
                p_41423_.add((Component)areaLabel);
            } else {
                MowLibTooltipUtils.addTooltipMessageWithStyle(p_41423_, (String)"pedestals.upgrade_tooltip_area_allowed", (ChatFormatting)ChatFormatting.GRAY);
            }
        }
        if (this.canModifyRange(p_41421_)) {
            if (this.getRangeIncrease(p_41421_) > 0) {
                areaLabel = Component.m_237115_((String)"pedestals.upgrade_tooltip_range_label");
                areaLabel.m_130940_(ChatFormatting.GOLD);
                areaAmount = Component.m_237113_((String)("" + this.getRangeIncrease(p_41421_)));
                areaAmount.m_130940_(ChatFormatting.WHITE);
                areaLabel.m_7220_((Component)areaAmount);
                p_41423_.add((Component)areaLabel);
            } else {
                MowLibTooltipUtils.addTooltipMessageWithStyle(p_41423_, (String)"pedestals.upgrade_tooltip_range_allowed", (ChatFormatting)ChatFormatting.GOLD);
            }
        }
        if (this.canModifyMagnet(p_41421_)) {
            if (this.getMagnet(p_41421_)) {
                areaLabel = Component.m_237115_((String)"pedestals.upgrade_tooltip_magnet_label");
                areaLabel.m_130940_(ChatFormatting.DARK_RED);
                p_41423_.add((Component)areaLabel);
            } else {
                MowLibTooltipUtils.addTooltipMessageWithStyle(p_41423_, (String)"pedestals.upgrade_tooltip_magnet_allowed", (ChatFormatting)ChatFormatting.DARK_RED);
            }
        }
        if (this.canModifyGentleHarvest(p_41421_)) {
            if (this.getGentleHarvest(p_41421_)) {
                areaLabel = Component.m_237115_((String)"pedestals.upgrade_tooltip_gentle_label");
                areaLabel.m_130940_(ChatFormatting.YELLOW);
                p_41423_.add((Component)areaLabel);
            } else {
                MowLibTooltipUtils.addTooltipMessageWithStyle(p_41423_, (String)"pedestals.upgrade_tooltip_gentle_allowed", (ChatFormatting)ChatFormatting.YELLOW);
            }
        }
        if (this.canModifySuperSpeed(p_41421_)) {
            if (this.getSuperSpeed(p_41421_)) {
                areaLabel = Component.m_237115_((String)"pedestals.upgrade_tooltip_superspeed_label");
                areaLabel.m_130940_(ChatFormatting.DARK_AQUA);
                p_41423_.add((Component)areaLabel);
            } else {
                MowLibTooltipUtils.addTooltipMessageWithStyle(p_41423_, (String)"pedestals.upgrade_tooltip_superspeed_allowed", (ChatFormatting)ChatFormatting.DARK_AQUA);
            }
        }
        if (this.canModifyOperateToBedrock(p_41421_)) {
            if (this.getOperateToBedrock(p_41421_)) {
                MutableComponent operateToBedrockLabel = Component.m_237115_((String)"pedestals.upgrade_tooltip_operatetobedrock_label");
                operateToBedrockLabel.m_130940_(ChatFormatting.GRAY);
                p_41423_.add((Component)operateToBedrockLabel);
            } else {
                MowLibTooltipUtils.addTooltipMessageWithStyle(p_41423_, (String)"pedestals.upgrade_tooltip_operatetobedrock_allowed", (ChatFormatting)ChatFormatting.DARK_AQUA);
            }
        }
        if (Screen.m_96638_() && Screen.m_96639_()) {
            p_41423_.add((Component)Component.m_237113_((String)""));
        }
        if (p_41421_.m_41720_() instanceof ISelectableArea && MowLibBlockPosUtils.hasOneBlockPos((ItemStack)p_41421_)) {
            if (!Screen.m_96639_()) {
                base = Component.m_237115_((String)"pedestals.upgrade_description_alt");
                base.m_130940_(ChatFormatting.WHITE);
                p_41423_.add((Component)base);
            } else {
                MutableComponent posTitle = Component.m_237115_((String)"pedestals.upgrade_tooltip_blockpos_title");
                posTitle.m_130940_(ChatFormatting.GOLD);
                p_41423_.add((Component)posTitle);
                MutableComponent separator3 = Component.m_237115_((String)"pedestals.tooltip_separator");
                p_41423_.add((Component)separator3);
                MutableComponent posOne = Component.m_237115_((String)"pedestals.upgrade_tooltip_blockpos_one");
                BlockPos blockPosOne = MowLibBlockPosUtils.readBlockPosFromNBT((ItemStack)p_41421_, (int)1);
                MutableComponent posOnePos = Component.m_237113_((String)(blockPosOne.m_123341_() + "x " + blockPosOne.m_123342_() + "y " + blockPosOne.m_123343_() + "z"));
                posOnePos.m_130940_(ChatFormatting.GRAY);
                posOne.m_7220_((Component)Component.m_237115_((String)"pedestals.upgrade_tooltip_separator"));
                posOne.m_7220_((Component)posOnePos);
                p_41423_.add((Component)posOne);
                MutableComponent posTwo = Component.m_237115_((String)"pedestals.upgrade_tooltip_blockpos_two");
                BlockPos blockPosTwo = MowLibBlockPosUtils.readBlockPosFromNBT((ItemStack)p_41421_, (int)2);
                MutableComponent posTwoPos = Component.m_237113_((String)(blockPosTwo.m_123341_() + "x " + blockPosTwo.m_123342_() + "y " + blockPosTwo.m_123343_() + "z"));
                posTwoPos.m_130940_(ChatFormatting.GRAY);
                posTwo.m_7220_((Component)Component.m_237115_((String)"pedestals.upgrade_tooltip_separator"));
                posTwo.m_7220_((Component)posTwoPos);
                p_41423_.add((Component)posTwo);
            }
        }
        if (p_41421_.m_41720_() instanceof ISelectablePoints && !this.hasTwoPointsSelected(p_41421_) && (getList = MowLibBlockPosUtils.readBlockPosListFromNBT((ItemStack)p_41421_)).size() > 0) {
            if (!Screen.m_96639_()) {
                MutableComponent base3 = Component.m_237115_((String)"pedestals.upgrade_description_alt");
                base3.m_130940_(ChatFormatting.WHITE);
                p_41423_.add((Component)base3);
            } else {
                MutableComponent posTitle = Component.m_237115_((String)"pedestals.upgrade_tooltip_blockpos_title");
                posTitle.m_130940_(ChatFormatting.GOLD);
                p_41423_.add((Component)posTitle);
                separator = Component.m_237115_((String)"pedestals.tooltip_separator");
                p_41423_.add((Component)separator);
                for (BlockPos pos : getList) {
                    MutableComponent posOnePos = Component.m_237113_((String)(pos.m_123341_() + "x " + pos.m_123342_() + "y " + pos.m_123343_() + "z"));
                    posOnePos.m_130940_(ChatFormatting.GRAY);
                    p_41423_.add((Component)posOnePos);
                }
            }
        }
        if (this.requiresFuelForUpgradeAction()) {
            if (this.requiresEnergy()) {
                base = Component.m_237115_((String)"pedestals.upgrade_fuel_energy");
                base.m_130940_(ChatFormatting.RED);
                p_41423_.add((Component)base);
            }
            if (this.requiresXp()) {
                base = Component.m_237115_((String)"pedestals.upgrade_fuel_xp");
                base.m_130940_(ChatFormatting.GREEN);
                p_41423_.add((Component)base);
            }
            if (this.requiresDust()) {
                base = Component.m_237115_((String)"pedestals.upgrade_fuel_dust");
                base.m_7220_((Component)Component.m_237115_((String)"pedestals.upgrade_tooltip_separator"));
                base.m_130940_(ChatFormatting.LIGHT_PURPLE);
                MutableComponent dust = Component.m_237115_((String)("mowlib." + MowLibColorReference.getColorName((int)this.baseDustCostPerDistance().getDustColor())));
                dust.m_130940_(ChatFormatting.WHITE);
                base.m_7220_((Component)dust);
                p_41423_.add((Component)base);
            }
        }
    }

    public WeakReference<FakePlayer> fakeUpgradePlayer(BasePedestalBlockEntity pedestal) {
        Level world = pedestal.m_58904_();
        ItemStack upgrade = pedestal.getCoinOnPedestal();
        if (world instanceof ServerLevel) {
            ServerLevel slevel = (ServerLevel)world;
            return new WeakReference<MowLibFakePlayer>(new MowLibFakePlayer(slevel, MowLibOwnerUtils.getPlayerFromStack((ItemStack)upgrade), MowLibOwnerUtils.getPlayerNameFromStack((ItemStack)upgrade), pedestal.getPos(), pedestal.getToolStack(), "[Pedestal_" + pedestal.getPos().m_123341_() + pedestal.getPos().m_123342_() + pedestal.getPos().m_123343_() + "]"));
        }
        return null;
    }

    public static LazyOptional<IItemHandler> findItemHandlerAtPosEntity(Level world, BlockPos pos, Direction side, boolean allowEntity) {
        LazyOptional cap;
        List list;
        LazyOptional cap2;
        BlockEntity neighbourTile = world.m_7702_(pos);
        if (neighbourTile != null && (cap2 = neighbourTile.getCapability(ForgeCapabilities.ITEM_HANDLER, side)).isPresent()) {
            return cap2;
        }
        if (allowEntity && !(list = world.m_6443_(Entity.class, new AABB(pos), entity -> entity instanceof Entity)).isEmpty() && (cap = ((Entity)list.get(world.f_46441_.m_188503_(list.size()))).getCapability(ForgeCapabilities.ITEM_HANDLER)).isPresent()) {
            return cap;
        }
        return LazyOptional.empty();
    }

    public static LazyOptional<IFluidHandler> findFluidHandlerAtPosEntity(Level world, BlockPos pos, Direction side, boolean allowEntity) {
        LazyOptional cap;
        List list;
        LazyOptional cap2;
        BlockEntity neighbourTile = world.m_7702_(pos);
        if (neighbourTile != null && (cap2 = neighbourTile.getCapability(ForgeCapabilities.FLUID_HANDLER, side)).isPresent()) {
            return cap2;
        }
        if (allowEntity && !(list = world.m_6443_(Entity.class, new AABB(pos), entity -> entity instanceof Entity)).isEmpty() && (cap = ((Entity)list.get(world.f_46441_.m_188503_(list.size()))).getCapability(ForgeCapabilities.FLUID_HANDLER)).isPresent()) {
            return cap;
        }
        return LazyOptional.empty();
    }

    public static LazyOptional<IEnergyStorage> findEnergyHandlerAtPosEntity(Level world, BlockPos pos, Direction side, boolean allowEntity) {
        LazyOptional cap;
        List list;
        LazyOptional cap2;
        BlockEntity neighbourTile = world.m_7702_(pos);
        if (neighbourTile != null && (cap2 = neighbourTile.getCapability(ForgeCapabilities.ENERGY, side)).isPresent()) {
            return cap2;
        }
        if (allowEntity && !(list = world.m_6443_(Entity.class, new AABB(pos), entity -> entity instanceof Entity)).isEmpty() && (cap = ((Entity)list.get(world.f_46441_.m_188503_(list.size()))).getCapability(ForgeCapabilities.ENERGY)).isPresent()) {
            return cap;
        }
        return LazyOptional.empty();
    }

    public boolean canModifySpeed(ItemStack upgradeItemStack) {
        return false;
    }

    public boolean canModifyDamageCapacity(ItemStack upgradeItemStack) {
        return false;
    }

    public boolean canModifyBlockCapacity(ItemStack upgradeItemStack) {
        return false;
    }

    public boolean canModifyItemCapacity(ItemStack upgradeItemStack) {
        return false;
    }

    public boolean canModifyFluidCapacity(ItemStack upgradeItemStack) {
        return false;
    }

    public boolean canModifyEnergyCapacity(ItemStack upgradeItemStack) {
        return false;
    }

    public boolean canModifyXPCapacity(ItemStack upgradeItemStack) {
        return false;
    }

    public boolean canModifyDustCapacity(ItemStack upgradeItemStack) {
        return false;
    }

    public boolean canModifyArea(ItemStack upgradeItemStack) {
        return false;
    }

    public boolean canModifyRange(ItemStack upgradeItemStack) {
        return false;
    }

    public boolean canModifyMagnet(ItemStack upgradeItemStack) {
        return false;
    }

    public boolean canModifyGentleHarvest(ItemStack upgradeItemStack) {
        return false;
    }

    public boolean canModifySuperSpeed(ItemStack upgradeItemStack) {
        return false;
    }

    public boolean canModifyEntityContainers(ItemStack upgradeItemStack) {
        return false;
    }

    public boolean canModifyRemoteStorage(ItemStack upgradeItemStack) {
        return false;
    }

    public boolean canModifyOperateToBedrock(ItemStack upgradeItemStack) {
        return false;
    }

    public boolean canAddModifierToUpgrade(ItemStack upgradeItemStack, String nbtTagString) {
        return switch (nbtTagString) {
            case "upgradespeed" -> this.canModifySpeed(upgradeItemStack);
            case "upgradedamagecapacity" -> this.canModifyDamageCapacity(upgradeItemStack);
            case "upgradeblockcapacity" -> this.canModifyBlockCapacity(upgradeItemStack);
            case "upgradeitemcapacity" -> this.canModifyItemCapacity(upgradeItemStack);
            case "upgradefluidcapacity" -> this.canModifyFluidCapacity(upgradeItemStack);
            case "upgradeenergycapacity" -> this.canModifyEnergyCapacity(upgradeItemStack);
            case "upgradexpcapacity" -> this.canModifyXPCapacity(upgradeItemStack);
            case "upgradedustcapacity" -> this.canModifyDustCapacity(upgradeItemStack);
            case "upgradearea" -> this.canModifyArea(upgradeItemStack);
            case "upgraderange" -> this.canModifyRange(upgradeItemStack);
            case "upgrademagnet" -> this.canModifyMagnet(upgradeItemStack);
            case "upgradegentle" -> this.canModifyGentleHarvest(upgradeItemStack);
            case "upgradesuperspeed" -> this.canModifySuperSpeed(upgradeItemStack);
            case "upgradeentitystorage" -> this.canModifyEntityContainers(upgradeItemStack);
            case "upgraderemotestorage" -> this.canModifyRemoteStorage(upgradeItemStack);
            case "upgradeoperatetobedrock" -> this.canModifyOperateToBedrock(upgradeItemStack);
            default -> false;
        };
    }

    public int getSpeedTicksReduced(ItemStack upgradeItemStack) {
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)upgradeItemStack.m_41784_(), (String)"upgradespeed");
    }

    public int getMaxSpeed(ItemStack upgradeItemStack) {
        return (Integer)PedestalConfig.COMMON.pedestal_maxTicksToTransfer.get();
    }

    public int getDamageCapacityIncrease(ItemStack upgradeItemStack) {
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)upgradeItemStack.m_41784_(), (String)"upgradedamagecapacity");
    }

    public int getBlockCapacityIncrease(ItemStack upgradeItemStack) {
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)upgradeItemStack.m_41784_(), (String)"upgradeblockcapacity");
    }

    public int getItemCapacityIncrease(ItemStack upgradeItemStack) {
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)upgradeItemStack.m_41784_(), (String)"upgradeitemcapacity");
    }

    public int getFluidCapacityIncrease(ItemStack upgradeItemStack) {
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)upgradeItemStack.m_41784_(), (String)"upgradefluidcapacity");
    }

    public int getEnergyCapacityIncrease(ItemStack upgradeItemStack) {
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)upgradeItemStack.m_41784_(), (String)"upgradeenergycapacity");
    }

    public int getXPCapacityIncrease(ItemStack upgradeItemStack) {
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)upgradeItemStack.m_41784_(), (String)"upgradexpcapacity");
    }

    public int getDustCapacityIncrease(ItemStack upgradeItemStack) {
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)upgradeItemStack.m_41784_(), (String)"upgradedustcapacity");
    }

    public int getAreaIncrease(ItemStack upgradeItemStack) {
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)upgradeItemStack.m_41784_(), (String)"upgradearea");
    }

    public int getRangeIncrease(ItemStack upgradeItemStack) {
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)upgradeItemStack.m_41784_(), (String)"upgraderange");
    }

    public boolean getMagnet(ItemStack upgradeItemStack) {
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)upgradeItemStack.m_41784_(), (String)"upgrademagnet") >= 1;
    }

    public boolean getGentleHarvest(ItemStack upgradeItemStack) {
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)upgradeItemStack.m_41784_(), (String)"upgradegentle") >= 1;
    }

    public boolean getSuperSpeed(ItemStack upgradeItemStack) {
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)upgradeItemStack.m_41784_(), (String)"upgradesuperspeed") >= 1;
    }

    public boolean getEntityContainer(ItemStack upgradeItemStack) {
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)upgradeItemStack.m_41784_(), (String)"upgradeentitystorage") >= 1;
    }

    public boolean getRemoteStorage(ItemStack upgradeItemStack) {
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)upgradeItemStack.m_41784_(), (String)"upgraderemotestorage") >= 1;
    }

    public boolean getOperateToBedrock(ItemStack upgradeItemStack) {
        return MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)upgradeItemStack.m_41784_(), (String)"upgradeoperatetobedrock") >= 1;
    }
}

