/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Items.Upgrades.Pedestal;

import com.mojang.datafixers.util.Either;
import com.mowmaster.mowlib.BlockEntities.MowLibBaseBlockEntity;
import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.Items.WorkCards.WorkCardArea;
import com.mowmaster.mowlib.MowLibUtils.MowLibBlockPosUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibCompoundTagUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibContainerUtils;
import com.mowmaster.mowlib.Networking.MowLibPacketHandler;
import com.mowmaster.mowlib.Networking.MowLibPacketParticles;
import com.mowmaster.mowlib.Recipes.BaseBlockEntityFilter;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Configs.PedestalConfig;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.CriticalHitEvent;

public class ItemUpgradeAttacker
extends ItemUpgradeBase {
    public ItemUpgradeAttacker(Item.Properties p_41383_) {
        super(new Item.Properties());
    }

    @Override
    public boolean canModifySpeed(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyDamageCapacity(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyRange(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public boolean canModifyArea(ItemStack upgradeItemStack) {
        return (Boolean)PedestalConfig.COMMON.upgrade_require_sized_selectable_area.get();
    }

    @Override
    public boolean needsWorkCard(ItemStack upgradeItemStack) {
        return true;
    }

    @Override
    public int getWorkCardType() {
        return 1;
    }

    @Override
    public int baseEnergyCostPerDistance() {
        return (Integer)PedestalConfig.COMMON.upgrade_attacker_baseEnergyCost.get();
    }

    @Override
    public boolean energyDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_attacker_energy_distance_multiplier.get();
    }

    @Override
    public double energyCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_attacker_energyMultiplier.get();
    }

    @Override
    public int baseXpCostPerDistance() {
        return (Integer)PedestalConfig.COMMON.upgrade_attacker_baseXpCost.get();
    }

    @Override
    public boolean xpDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_attacker_xp_distance_multiplier.get();
    }

    @Override
    public double xpCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_attacker_xpMultiplier.get();
    }

    @Override
    public DustMagic baseDustCostPerDistance() {
        return new DustMagic(((Integer)PedestalConfig.COMMON.upgrade_attacker_dustColor.get()).intValue(), ((Integer)PedestalConfig.COMMON.upgrade_attacker_baseDustAmount.get()).intValue());
    }

    @Override
    public boolean dustDistanceAsModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_attacker_dust_distance_multiplier.get();
    }

    @Override
    public double dustCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_attacker_dustMultiplier.get();
    }

    @Override
    public boolean hasSelectedAreaModifier() {
        return (Boolean)PedestalConfig.COMMON.upgrade_attacker_selectedAllowed.get();
    }

    @Override
    public double selectedAreaCostMultiplier() {
        return (Double)PedestalConfig.COMMON.upgrade_attacker_selectedMultiplier.get();
    }

    @Override
    public List<String> getUpgradeHUD(BasePedestalBlockEntity pedestal) {
        List<String> messages = super.getUpgradeHUD(pedestal);
        if (messages.size() <= 0) {
            if (this.baseEnergyCostPerDistance() > 0 && pedestal.getStoredEnergy() < this.baseEnergyCostPerDistance()) {
                messages.add(ChatFormatting.RED + "Needs Energy");
                messages.add(ChatFormatting.RED + "To Operate");
            }
            if (this.baseXpCostPerDistance() > 0 && pedestal.getStoredExperience() < this.baseXpCostPerDistance()) {
                messages.add(ChatFormatting.GREEN + "Needs Experience");
                messages.add(ChatFormatting.GREEN + "To Operate");
            }
            if (this.baseDustCostPerDistance().getDustAmount() > 0 && pedestal.getStoredEnergy() < this.baseEnergyCostPerDistance()) {
                messages.add(ChatFormatting.LIGHT_PURPLE + "Needs Dust");
                messages.add(ChatFormatting.LIGHT_PURPLE + "To Operate");
            }
        }
        return messages;
    }

    @Override
    public ItemStack getUpgradeDefaultTool() {
        return new ItemStack((ItemLike)Items.f_42398_);
    }

    @Nullable
    protected BaseBlockEntityFilter getRecipeFilterBlock(Level level, ItemStack stackIn) {
        Container container = MowLibContainerUtils.getContainer((int)1);
        container.m_6836_(-1, stackIn);
        List recipes = level.m_7465_().m_44056_((RecipeType)BaseBlockEntityFilter.Type.INSTANCE, container, level);
        return level != null ? (recipes.size() > 0 ? (BaseBlockEntityFilter)recipes.stream().findFirst().get() : null) : null;
    }

    protected String getProcessResultFilterBlock(BaseBlockEntityFilter recipe) {
        return recipe == null ? "" : recipe.getResultEntityString();
    }

    protected int getProcessResultFilterBlockMobType(BaseBlockEntityFilter recipe) {
        return recipe == null ? 1 : recipe.getResultMobType();
    }

    protected boolean getProcessResultFilterBlockIsBaby(BaseBlockEntityFilter recipe) {
        return recipe == null ? false : recipe.getResultBaby();
    }

    public boolean hasBaseBlock(ItemStack coinInPedestal) {
        String entityString;
        ItemStack getBaseBlockList;
        CompoundTag tag = new CompoundTag();
        if (coinInPedestal.m_41782_()) {
            tag = coinInPedestal.m_41783_();
        }
        return !(getBaseBlockList = MowLibCompoundTagUtils.readItemStackFromNBT((String)"pedestals", (CompoundTag)tag, (String)"_baseblockStack")).m_41619_() && (entityString = MowLibCompoundTagUtils.readStringFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_entityString")) != "";
    }

    public boolean allowEntity(ItemStack coinInPedestal, Entity entityIn) {
        String entityString;
        ItemStack baseBlock = MowLibCompoundTagUtils.readItemStackFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_baseBlockStack");
        if (!baseBlock.m_41619_() && (entityString = MowLibCompoundTagUtils.readStringFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_entityString")) != "") {
            int entityTypeNum = MowLibCompoundTagUtils.readIntegerFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_entityType");
            boolean isBaby = MowLibCompoundTagUtils.readBooleanFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_entityIsBaby");
            if (entityTypeNum == 0) {
                if (entityIn.getClassification(false).equals((Object)MobCategory.byName((String)entityString))) {
                    if (isBaby && entityIn instanceof LivingEntity) {
                        LivingEntity entity = (LivingEntity)entityIn;
                        return entity.m_6162_();
                    }
                    return true;
                }
            } else if (entityTypeNum == 1) {
                if (!EntityType.m_20632_((String)entityString).isPresent()) {
                    return false;
                }
                if (entityIn.m_6095_().equals(EntityType.m_20632_((String)entityString).get())) {
                    if (isBaby && entityIn instanceof LivingEntity) {
                        LivingEntity entity = (LivingEntity)entityIn;
                        return entity.m_6162_();
                    }
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public float getToolDamage(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof SwordItem) {
            SwordItem sward = (SwordItem)item;
            return sward.m_43299_();
        }
        item = stack.m_41720_();
        if (item instanceof DiggerItem) {
            DiggerItem digdug = (DiggerItem)item;
            return digdug.m_41008_();
        }
        item = stack.m_41720_();
        if (item instanceof Tier) {
            Tier tiered = (Tier)item;
            return tiered.m_6631_();
        }
        return 0.0f;
    }

    public void doAttack(BasePedestalBlockEntity pedestal, Player player, Entity toAttack) {
        if (!ForgeHooks.onPlayerAttackTarget((Player)player, (Entity)toAttack)) {
            return;
        }
        if (toAttack.m_6097_() && !toAttack.m_7313_((Entity)player)) {
            float damageFloat = 1.0f + this.getToolDamage(pedestal.getToolStack());
            float f1 = toAttack instanceof LivingEntity ? EnchantmentHelper.m_44833_((ItemStack)player.m_21205_(), (MobType)((LivingEntity)toAttack).m_6336_()) : EnchantmentHelper.m_44833_((ItemStack)player.m_21205_(), (MobType)MobType.f_21640_);
            if ((damageFloat += f1) > 0.0f || f1 > 0.0f) {
                Random rn;
                boolean flag = true;
                boolean flag1 = false;
                float i = (float)player.m_21133_(Attributes.f_22282_);
                i += (float)EnchantmentHelper.m_44894_((LivingEntity)player);
                if (player.m_20142_() && flag) {
                    player.m_9236_().m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12314_, player.m_5720_(), 1.0f, 1.0f);
                    i += 1.0f;
                    flag1 = true;
                }
                boolean flag2 = flag && player.f_19789_ > 0.0f && !player.m_20096_() && !player.m_6147_() && !player.m_20069_() && !player.m_21023_(MobEffects.f_19610_) && !player.m_20159_() && toAttack instanceof LivingEntity;
                flag2 = flag2 && !player.m_20142_();
                CriticalHitEvent hitResult = ForgeHooks.getCriticalHit((Player)player, (Entity)toAttack, (boolean)flag2, (float)(flag2 ? 1.5f : 1.0f));
                boolean bl = flag2 = hitResult != null;
                if (flag2) {
                    damageFloat *= hitResult.getDamageModifier();
                }
                damageFloat += f1;
                boolean flag3 = false;
                double d0 = player.f_19787_ - player.f_19867_;
                if (flag && !flag2 && !flag1 && player.m_20096_() && d0 < (double)player.m_6113_()) {
                    ItemStack itemstack = player.m_21120_(InteractionHand.MAIN_HAND);
                    flag3 = itemstack.canPerformAction(ToolActions.SWORD_SWEEP);
                }
                float f4 = 0.0f;
                boolean flag4 = false;
                int j = EnchantmentHelper.m_44914_((LivingEntity)player);
                if (toAttack instanceof LivingEntity) {
                    f4 = ((LivingEntity)toAttack).m_21223_();
                    if (j > 0 && !toAttack.m_6060_()) {
                        flag4 = true;
                        toAttack.m_20254_(1);
                    }
                }
                Vec3 vec3 = toAttack.m_20184_();
                final List<String> list = Arrays.asList("pedestal1", "pedestal2", "pedestal3", "pedestal4", "pedestal5", "pedestal6", "pedestal7", "pedestal8", "pedestal9", "pedestal10", "pedestal11", "pedestal12");
                Holder<DamageType> type = new Holder<DamageType>(){
                    final /* synthetic */ Random val$rn;
                    {
                        this.val$rn = random;
                    }

                    public DamageType value() {
                        return new DamageType((String)list.get(this.val$rn.nextInt(list.size())), 0.5f);
                    }

                    public boolean m_203633_() {
                        return false;
                    }

                    public boolean m_203373_(ResourceLocation p_205713_) {
                        return false;
                    }

                    public boolean m_203565_(ResourceKey<DamageType> p_205712_) {
                        return false;
                    }

                    public boolean m_203425_(Predicate<ResourceKey<DamageType>> p_205711_) {
                        return false;
                    }

                    public boolean m_203656_(TagKey<DamageType> p_205705_) {
                        return false;
                    }

                    public Stream<TagKey<DamageType>> m_203616_() {
                        return null;
                    }

                    public Either<ResourceKey<DamageType>, DamageType> m_203439_() {
                        return null;
                    }

                    public Optional<ResourceKey<DamageType>> m_203543_() {
                        return Optional.empty();
                    }

                    public Holder.Kind m_203376_() {
                        return null;
                    }

                    public boolean m_203401_(HolderOwner<DamageType> p_255833_) {
                        return false;
                    }
                };
                DamageSource source = new DamageSource((Holder)type, (Entity)player);
                boolean flag5 = toAttack.m_6469_(source, damageFloat + (float)this.getDamageCapacityIncrease(pedestal.getCoinOnPedestal()) * 1.0f);
                if (flag5) {
                    if (i > 0.0f) {
                        if (toAttack instanceof LivingEntity) {
                            ((LivingEntity)toAttack).m_147240_((double)(i * 0.5f), (double)Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180)))));
                        } else {
                            toAttack.m_5997_((double)(-Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180))) * i * 0.5f), 0.1, (double)(Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180))) * i * 0.5f));
                        }
                        player.m_20256_(player.m_20184_().m_82542_(0.6, 1.0, 0.6));
                        player.m_6858_(false);
                    }
                    if (flag3) {
                        float f3 = 1.0f + EnchantmentHelper.m_44821_((LivingEntity)player) * damageFloat;
                        for (LivingEntity livingentity : player.m_9236_().m_45976_(LivingEntity.class, player.m_21120_(InteractionHand.MAIN_HAND).getSweepHitBox(player, toAttack))) {
                            if (livingentity == player || livingentity == toAttack || player.m_7307_((Entity)livingentity) || livingentity instanceof ArmorStand && ((ArmorStand)livingentity).m_31677_() || !player.m_6779_(livingentity)) continue;
                            livingentity.m_147240_((double)0.4f, (double)Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180)))));
                            livingentity.m_6469_(source, f3 + (float)this.getDamageCapacityIncrease(pedestal.getCoinOnPedestal()) * 0.5f);
                        }
                        player.m_9236_().m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12317_, player.m_5720_(), 1.0f, 1.0f);
                        player.m_36346_();
                    }
                    if (toAttack instanceof ServerPlayer && toAttack.f_19864_) {
                        ((ServerPlayer)toAttack).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(toAttack));
                        toAttack.f_19864_ = false;
                        toAttack.m_20256_(vec3);
                    }
                    if (flag2) {
                        player.m_9236_().m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12313_, player.m_5720_(), 1.0f, 1.0f);
                        player.m_5704_(toAttack);
                    }
                    if (!flag2 && !flag3) {
                        if (flag) {
                            player.m_9236_().m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12316_, player.m_5720_(), 1.0f, 1.0f);
                        } else {
                            player.m_9236_().m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12318_, player.m_5720_(), 1.0f, 1.0f);
                        }
                    }
                    if (f1 > 0.0f) {
                        player.m_5700_(toAttack);
                    }
                    player.m_21335_(toAttack);
                    if (toAttack instanceof LivingEntity) {
                        EnchantmentHelper.m_44823_((LivingEntity)((LivingEntity)toAttack), (Entity)player);
                    }
                    EnchantmentHelper.m_44896_((LivingEntity)player, (Entity)toAttack);
                    ItemStack itemstack1 = player.m_21205_();
                    Entity entity = toAttack;
                    if (toAttack instanceof PartEntity) {
                        entity = ((PartEntity)toAttack).getParent();
                    }
                    if (!player.m_9236_().f_46443_ && !itemstack1.m_41619_() && entity instanceof LivingEntity) {
                        ItemStack copy = itemstack1.m_41777_();
                        itemstack1.m_41640_((LivingEntity)entity, player);
                        if (itemstack1.m_41619_()) {
                            ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)copy, (InteractionHand)InteractionHand.MAIN_HAND);
                            player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                        }
                    }
                    if (toAttack instanceof LivingEntity) {
                        float f5 = f4 - ((LivingEntity)toAttack).m_21223_();
                        player.m_36222_(Stats.f_12928_, Math.round(f5 * 10.0f));
                        if (j > 0) {
                            toAttack.m_20254_(j * 4);
                        }
                        if (player.m_9236_() instanceof ServerLevel && f5 > 2.0f) {
                            int k = (int)((double)f5 * 0.5);
                            ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123798_, toAttack.m_20185_(), toAttack.m_20227_(0.5), toAttack.m_20189_(), k, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                    player.m_36399_(0.1f);
                } else {
                    player.m_9236_().m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12315_, player.m_5720_(), 1.0f, 1.0f);
                    if (flag4) {
                        toAttack.m_20095_();
                    }
                }
            }
            player.m_36334_();
        }
    }

    @Override
    public void upgradeAction(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, ItemStack coin) {
        this.attackerAction(level, pedestal, pedestalPos, coin);
    }

    public void attackerAction(Level level, BasePedestalBlockEntity pedestal, BlockPos pedestalPos, ItemStack coin) {
        WeakReference<FakePlayer> fakePlayerReference = pedestal.getPedestalPlayer(pedestal);
        if (fakePlayerReference != null && fakePlayerReference.get() != null) {
            FakePlayer fakePlayer = (FakePlayer)fakePlayerReference.get();
            ItemStack workCardItemStack = pedestal.getWorkCardInPedestal();
            if (workCardItemStack.m_41720_() instanceof WorkCardArea) {
                List entities = WorkCardArea.getEntitiesInRangeOfUpgrade((Level)level, LivingEntity.class, (ItemStack)workCardItemStack, (MowLibBaseBlockEntity)pedestal, (int)this.getUpgradeWorkRange(coin));
                boolean canRun = true;
                boolean damage = false;
                if (this.removeFuelForAction(pedestal, 0, true)) {
                    ItemStack toolStack = pedestal.getToolStack().m_41777_();
                    fakePlayer.m_21008_(InteractionHand.MAIN_HAND, toolStack);
                    if (((Boolean)PedestalConfig.COMMON.attacker_DamageTools.get()).booleanValue() && pedestal.hasTool()) {
                        if (pedestal.getDurabilityRemainingOnInsertedTool() > 0) {
                            if (pedestal.damageInsertedTool(1, true)) {
                                damage = true;
                            } else {
                                if (pedestal.canSpawnParticles()) {
                                    MowLibPacketHandler.sendToNearby((Level)level, (BlockPos)pedestalPos, (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)pedestalPos.m_123341_(), (double)((float)pedestalPos.m_123342_() + 1.0f), (double)pedestalPos.m_123343_(), new int[]{255, 255, 255}));
                                }
                                canRun = false;
                            }
                        } else {
                            if (pedestal.canSpawnParticles()) {
                                MowLibPacketHandler.sendToNearby((Level)level, (BlockPos)pedestalPos, (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)pedestalPos.m_123341_(), (double)((float)pedestalPos.m_123342_() + 1.0f), (double)pedestalPos.m_123343_(), new int[]{255, 255, 255}));
                            }
                            canRun = false;
                        }
                    }
                    if (canRun) {
                        for (LivingEntity getEntity : entities) {
                            if (getEntity == null || !this.allowEntity(coin, (Entity)getEntity) || !this.removeFuelForAction(pedestal, MowLibBlockPosUtils.getDistanceBetweenPoints((BlockPos)pedestal.getPos(), (BlockPos)pedestalPos), false)) continue;
                            this.doAttack(pedestal, (Player)fakePlayer, (Entity)getEntity);
                            if (!damage) continue;
                            pedestal.damageInsertedTool(1, false);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void actionOnAddedToPedestal(Player player, BasePedestalBlockEntity pedestal, ItemStack coinInPedestal) {
        super.actionOnAddedToPedestal(player, pedestal, coinInPedestal);
        Level level = pedestal.m_58904_();
        CompoundTag tagCoin = new CompoundTag();
        if (coinInPedestal.m_41782_()) {
            tagCoin = coinInPedestal.m_41783_();
        }
        ItemStack getBaseBlock = this.getBaseBlock(pedestal);
        BaseBlockEntityFilter filter = this.getRecipeFilterBlock(level, getBaseBlock);
        tagCoin = MowLibCompoundTagUtils.writeItemStackToNBT((String)"pedestals", (CompoundTag)tagCoin, (ItemStack)getBaseBlock, (String)"_baseBlockStack");
        tagCoin = MowLibCompoundTagUtils.writeStringToNBT((String)"pedestals", (CompoundTag)tagCoin, (String)this.getProcessResultFilterBlock(filter), (String)"_entityString");
        tagCoin = MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)tagCoin, (int)this.getProcessResultFilterBlockMobType(filter), (String)"_entityType");
        tagCoin = MowLibCompoundTagUtils.writeBooleanToNBT((String)"pedestals", (CompoundTag)tagCoin, (boolean)this.getProcessResultFilterBlockIsBaby(filter), (String)"_entityIsBaby");
        coinInPedestal.m_41751_(tagCoin);
    }

    @Override
    public void actionOnRemovedFromPedestal(BasePedestalBlockEntity pedestal, ItemStack coinInPedestal) {
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_baseBlockStack");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_entityString");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_entityType");
        MowLibCompoundTagUtils.removeCustomTagFromNBT((String)"pedestals", (CompoundTag)coinInPedestal.m_41783_(), (String)"_entityIsBaby");
    }

    public ItemStack getBaseBlock(BasePedestalBlockEntity pedestal) {
        return new ItemStack((ItemLike)pedestal.m_58904_().m_8055_(MowLibBlockPosUtils.getPosOfBlockBelow((Level)pedestal.m_58904_(), (BlockPos)pedestal.getPos(), (int)1)).m_60734_().m_5456_());
    }

    @Override
    public void actionOnNeighborBelowChange(BasePedestalBlockEntity pedestal, BlockPos belowBlock) {
        Level level = pedestal.m_58904_();
        CompoundTag tagCoin = new CompoundTag();
        ItemStack coinInPedestal = pedestal.getCoinOnPedestal();
        if (coinInPedestal.m_41782_()) {
            tagCoin = coinInPedestal.m_41783_();
        }
        ItemStack getBaseBlock = this.getBaseBlock(pedestal);
        BaseBlockEntityFilter filter = this.getRecipeFilterBlock(level, getBaseBlock);
        tagCoin = MowLibCompoundTagUtils.writeItemStackToNBT((String)"pedestals", (CompoundTag)tagCoin, (ItemStack)getBaseBlock, (String)"_baseBlockStack");
        tagCoin = MowLibCompoundTagUtils.writeStringToNBT((String)"pedestals", (CompoundTag)tagCoin, (String)this.getProcessResultFilterBlock(filter), (String)"_entityString");
        tagCoin = MowLibCompoundTagUtils.writeIntegerToNBT((String)"pedestals", (CompoundTag)tagCoin, (int)this.getProcessResultFilterBlockMobType(filter), (String)"_entityType");
        tagCoin = MowLibCompoundTagUtils.writeBooleanToNBT((String)"pedestals", (CompoundTag)tagCoin, (boolean)this.getProcessResultFilterBlockIsBaby(filter), (String)"_entityIsBaby");
        coinInPedestal.m_41751_(tagCoin);
    }
}

