/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Configs;

import com.mowmaster.pedestals.pedestals;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

public class PedestalConfig {
    public static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;
    public static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        pedestals.PLOGGER.debug("Loaded Pedestals config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        pedestals.PLOGGER.debug("Pedestals config just got changed on the file system!");
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT = (Client)clientSpecPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.IntValue augment_t1CapacityItem;
        public final ForgeConfigSpec.IntValue augment_t1CapacityFluid;
        public final ForgeConfigSpec.IntValue augment_t1CapacityEnergy;
        public final ForgeConfigSpec.IntValue augment_t1CapacityXp;
        public final ForgeConfigSpec.IntValue augment_t1CapacityDust;
        public final ForgeConfigSpec.IntValue augment_t1CapacityInsertSize;
        public final ForgeConfigSpec.IntValue augment_t2CapacityItem;
        public final ForgeConfigSpec.IntValue augment_t2CapacityFluid;
        public final ForgeConfigSpec.IntValue augment_t2CapacityEnergy;
        public final ForgeConfigSpec.IntValue augment_t2CapacityXp;
        public final ForgeConfigSpec.IntValue augment_t2CapacityDust;
        public final ForgeConfigSpec.IntValue augment_t2CapacityInsertSize;
        public final ForgeConfigSpec.IntValue augment_t3CapacityItem;
        public final ForgeConfigSpec.IntValue augment_t3CapacityFluid;
        public final ForgeConfigSpec.IntValue augment_t3CapacityEnergy;
        public final ForgeConfigSpec.IntValue augment_t3CapacityXp;
        public final ForgeConfigSpec.IntValue augment_t3CapacityDust;
        public final ForgeConfigSpec.IntValue augment_t3CapacityInsertSize;
        public final ForgeConfigSpec.IntValue augment_t4CapacityItem;
        public final ForgeConfigSpec.IntValue augment_t4CapacityFluid;
        public final ForgeConfigSpec.IntValue augment_t4CapacityEnergy;
        public final ForgeConfigSpec.IntValue augment_t4CapacityXp;
        public final ForgeConfigSpec.IntValue augment_t4CapacityDust;
        public final ForgeConfigSpec.IntValue augment_t4CapacityInsertSize;
        public final ForgeConfigSpec.IntValue augment_t1StorageItem;
        public final ForgeConfigSpec.IntValue augment_t1StorageFluid;
        public final ForgeConfigSpec.IntValue augment_t1StorageEnergy;
        public final ForgeConfigSpec.IntValue augment_t1StorageXp;
        public final ForgeConfigSpec.IntValue augment_t1StorageDust;
        public final ForgeConfigSpec.IntValue augment_t1StorageInsertSize;
        public final ForgeConfigSpec.IntValue augment_t2StorageItem;
        public final ForgeConfigSpec.IntValue augment_t2StorageFluid;
        public final ForgeConfigSpec.IntValue augment_t2StorageEnergy;
        public final ForgeConfigSpec.IntValue augment_t2StorageXp;
        public final ForgeConfigSpec.IntValue augment_t2StorageDust;
        public final ForgeConfigSpec.IntValue augment_t2StorageInsertSize;
        public final ForgeConfigSpec.IntValue augment_t3StorageItem;
        public final ForgeConfigSpec.IntValue augment_t3StorageFluid;
        public final ForgeConfigSpec.IntValue augment_t3StorageEnergy;
        public final ForgeConfigSpec.IntValue augment_t3StorageXp;
        public final ForgeConfigSpec.IntValue augment_t3StorageDust;
        public final ForgeConfigSpec.IntValue augment_t3StorageInsertSize;
        public final ForgeConfigSpec.IntValue augment_t4StorageItem;
        public final ForgeConfigSpec.IntValue augment_t4StorageFluid;
        public final ForgeConfigSpec.IntValue augment_t4StorageEnergy;
        public final ForgeConfigSpec.IntValue augment_t4StorageXp;
        public final ForgeConfigSpec.IntValue augment_t4StorageDust;
        public final ForgeConfigSpec.IntValue augment_t4StorageInsertSize;
        public final ForgeConfigSpec.IntValue pedestal_maxTicksToTransfer;
        public final ForgeConfigSpec.IntValue pedestal_baseItemStacks;
        public final ForgeConfigSpec.IntValue pedestal_baseFluidStorage;
        public final ForgeConfigSpec.IntValue pedestal_baseEnergyStorage;
        public final ForgeConfigSpec.IntValue pedestal_baseXpStorage;
        public final ForgeConfigSpec.IntValue pedestal_baseDustStorage;
        public final ForgeConfigSpec.IntValue pedestal_baseItemTransferRate;
        public final ForgeConfigSpec.IntValue pedestal_baseFluidTransferRate;
        public final ForgeConfigSpec.IntValue pedestal_baseEnergyTransferRate;
        public final ForgeConfigSpec.IntValue pedestal_baseXpTransferRate;
        public final ForgeConfigSpec.IntValue pedestal_baseDustTransferRate;
        public final ForgeConfigSpec.IntValue pedestal_baseLinkingRange;
        public final ForgeConfigSpec.IntValue upgrades_baseSelectionRange;
        public final ForgeConfigSpec.IntValue augment_t1SpeedReduction;
        public final ForgeConfigSpec.IntValue augment_t1SpeedInsertable;
        public final ForgeConfigSpec.IntValue augment_t2SpeedReduction;
        public final ForgeConfigSpec.IntValue augment_t2SpeedInsertable;
        public final ForgeConfigSpec.IntValue augment_t3SpeedReduction;
        public final ForgeConfigSpec.IntValue augment_t3SpeedInsertable;
        public final ForgeConfigSpec.IntValue augment_t4SpeedReduction;
        public final ForgeConfigSpec.IntValue augment_t4SpeedInsertable;
        public final ForgeConfigSpec.IntValue augment_t1RangeIncrease;
        public final ForgeConfigSpec.IntValue augment_t1RangeInsertable;
        public final ForgeConfigSpec.IntValue augment_t2RangeIncrease;
        public final ForgeConfigSpec.IntValue augment_t2RangeInsertable;
        public final ForgeConfigSpec.IntValue augment_t3RangeIncrease;
        public final ForgeConfigSpec.IntValue augment_t3RangeInsertable;
        public final ForgeConfigSpec.IntValue augment_t4RangeIncrease;
        public final ForgeConfigSpec.IntValue augment_t4RangeInsertable;
        public final ForgeConfigSpec.BooleanValue cobbleGeneratorDamageTools;
        public final ForgeConfigSpec.BooleanValue blockBreakerBreakEntities;
        public final ForgeConfigSpec.BooleanValue blockBreakerDamageTools;
        public final ForgeConfigSpec.IntValue upgrade_blockbreaker_baseEnergyCost;
        public final ForgeConfigSpec.BooleanValue upgrade_blockbreaker_energy_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_blockbreaker_energyMultiplier;
        public final ForgeConfigSpec.IntValue upgrade_blockbreaker_baseXpCost;
        public final ForgeConfigSpec.BooleanValue upgrade_blockbreaker_xp_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_blockbreaker_xpMultiplier;
        public final ForgeConfigSpec.IntValue upgrade_blockbreaker_dustColor;
        public final ForgeConfigSpec.IntValue upgrade_blockbreaker_baseDustAmount;
        public final ForgeConfigSpec.BooleanValue upgrade_blockbreaker_dust_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_blockbreaker_dustMultiplier;
        public final ForgeConfigSpec.BooleanValue upgrade_blockbreaker_selectedAllowed;
        public final ForgeConfigSpec.DoubleValue upgrade_blockbreaker_selectedMultiplier;
        public final ForgeConfigSpec.IntValue upgrade_blockplacer_baseEnergyCost;
        public final ForgeConfigSpec.BooleanValue upgrade_blockplacer_energy_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_blockplacer_energyMultiplier;
        public final ForgeConfigSpec.IntValue upgrade_blockplacer_baseXpCost;
        public final ForgeConfigSpec.BooleanValue upgrade_blockplacer_xp_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_blockplacer_xpMultiplier;
        public final ForgeConfigSpec.IntValue upgrade_blockplacer_dustColor;
        public final ForgeConfigSpec.IntValue upgrade_blockplacer_baseDustAmount;
        public final ForgeConfigSpec.BooleanValue upgrade_blockplacer_dust_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_blockplacer_dustMultiplier;
        public final ForgeConfigSpec.BooleanValue upgrade_blockplacer_selectedAllowed;
        public final ForgeConfigSpec.DoubleValue upgrade_blockplacer_selectedMultiplier;
        public final ForgeConfigSpec.IntValue upgrade_filler_baseEnergyCost;
        public final ForgeConfigSpec.DoubleValue upgrade_filler_energyMultiplier;
        public final ForgeConfigSpec.BooleanValue upgrade_filler_energy_distance_multiplier;
        public final ForgeConfigSpec.IntValue upgrade_filler_baseXpCost;
        public final ForgeConfigSpec.BooleanValue upgrade_filler_xp_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_filler_xpMultiplier;
        public final ForgeConfigSpec.IntValue upgrade_filler_dustColor;
        public final ForgeConfigSpec.IntValue upgrade_filler_baseDustAmount;
        public final ForgeConfigSpec.BooleanValue upgrade_filler_dust_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_filler_dustMultiplier;
        public final ForgeConfigSpec.BooleanValue upgrade_filler_selectedAllowed;
        public final ForgeConfigSpec.DoubleValue upgrade_filler_selectedMultiplier;
        public final ForgeConfigSpec.IntValue upgrade_filler_baseBlocksPlaced;
        public final ForgeConfigSpec.BooleanValue quarryDamageTools;
        public final ForgeConfigSpec.IntValue upgrade_quarry_baseEnergyCost;
        public final ForgeConfigSpec.DoubleValue upgrade_quarry_energyMultiplier;
        public final ForgeConfigSpec.BooleanValue upgrade_quarry_energy_distance_multiplier;
        public final ForgeConfigSpec.IntValue upgrade_quarry_baseXpCost;
        public final ForgeConfigSpec.BooleanValue upgrade_quarry_xp_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_quarry_xpMultiplier;
        public final ForgeConfigSpec.IntValue upgrade_quarry_dustColor;
        public final ForgeConfigSpec.IntValue upgrade_quarry_baseDustAmount;
        public final ForgeConfigSpec.BooleanValue upgrade_quarry_dust_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_quarry_dustMultiplier;
        public final ForgeConfigSpec.BooleanValue upgrade_quarry_selectedAllowed;
        public final ForgeConfigSpec.DoubleValue upgrade_quarry_selectedMultiplier;
        public final ForgeConfigSpec.IntValue upgrade_quarry_baseBlocksMined;
        public final ForgeConfigSpec.BooleanValue chopperDamageTools;
        public final ForgeConfigSpec.IntValue upgrade_chopper_baseEnergyCost;
        public final ForgeConfigSpec.BooleanValue upgrade_chopper_energy_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_chopper_energyMultiplier;
        public final ForgeConfigSpec.IntValue upgrade_chopper_baseXpCost;
        public final ForgeConfigSpec.BooleanValue upgrade_chopper_xp_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_chopper_xpMultiplier;
        public final ForgeConfigSpec.IntValue upgrade_chopper_dustColor;
        public final ForgeConfigSpec.IntValue upgrade_chopper_baseDustAmount;
        public final ForgeConfigSpec.BooleanValue upgrade_chopper_dust_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_chopper_dustMultiplier;
        public final ForgeConfigSpec.BooleanValue upgrade_chopper_selectedAllowed;
        public final ForgeConfigSpec.DoubleValue upgrade_chopper_selectedMultiplier;
        public final ForgeConfigSpec.IntValue upgrade_magnet_baseEnergyCost;
        public final ForgeConfigSpec.DoubleValue upgrade_magnet_energyMultiplier;
        public final ForgeConfigSpec.IntValue upgrade_magnet_baseXpCost;
        public final ForgeConfigSpec.DoubleValue upgrade_magnet_xpMultiplier;
        public final ForgeConfigSpec.IntValue upgrade_magnet_dustColor;
        public final ForgeConfigSpec.IntValue upgrade_magnet_baseDustAmount;
        public final ForgeConfigSpec.DoubleValue upgrade_magnet_dustMultiplier;
        public final ForgeConfigSpec.BooleanValue upgrade_magnet_selectedAllowed;
        public final ForgeConfigSpec.DoubleValue upgrade_magnet_selectedMultiplier;
        public final ForgeConfigSpec.BooleanValue harvester_DamageTools;
        public final ForgeConfigSpec.IntValue upgrade_harvester_baseEnergyCost;
        public final ForgeConfigSpec.BooleanValue upgrade_harvester_energy_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_harvester_energyMultiplier;
        public final ForgeConfigSpec.IntValue upgrade_harvester_baseXpCost;
        public final ForgeConfigSpec.BooleanValue upgrade_harvester_xp_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_harvester_xpMultiplier;
        public final ForgeConfigSpec.IntValue upgrade_harvester_dustColor;
        public final ForgeConfigSpec.IntValue upgrade_harvester_baseDustAmount;
        public final ForgeConfigSpec.BooleanValue upgrade_harvester_dust_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_harvester_dustMultiplier;
        public final ForgeConfigSpec.BooleanValue upgrade_harvester_selectedAllowed;
        public final ForgeConfigSpec.DoubleValue upgrade_harvester_selectedMultiplier;
        public final ForgeConfigSpec.IntValue upgrade_planter_baseEnergyCost;
        public final ForgeConfigSpec.BooleanValue upgrade_planter_energy_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_planter_energyMultiplier;
        public final ForgeConfigSpec.IntValue upgrade_planter_baseXpCost;
        public final ForgeConfigSpec.BooleanValue upgrade_planter_xp_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_planter_xpMultiplier;
        public final ForgeConfigSpec.IntValue upgrade_planter_dustColor;
        public final ForgeConfigSpec.IntValue upgrade_planter_baseDustAmount;
        public final ForgeConfigSpec.BooleanValue upgrade_planter_dust_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_planter_dustMultiplier;
        public final ForgeConfigSpec.BooleanValue upgrade_planter_selectedAllowed;
        public final ForgeConfigSpec.DoubleValue upgrade_planter_selectedMultiplier;
        public final ForgeConfigSpec.IntValue upgrade_fertilizer_baseEnergyCost;
        public final ForgeConfigSpec.BooleanValue upgrade_fertilizer_energy_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_fertilizer_energyMultiplier;
        public final ForgeConfigSpec.IntValue upgrade_fertilizer_baseXpCost;
        public final ForgeConfigSpec.BooleanValue upgrade_fertilizer_xp_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_fertilizer_xpMultiplier;
        public final ForgeConfigSpec.IntValue upgrade_fertilizer_dustColor;
        public final ForgeConfigSpec.IntValue upgrade_fertilizer_baseDustAmount;
        public final ForgeConfigSpec.BooleanValue upgrade_fertilizer_dust_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_fertilizer_dustMultiplier;
        public final ForgeConfigSpec.BooleanValue upgrade_fertilizer_selectedAllowed;
        public final ForgeConfigSpec.DoubleValue upgrade_fertilizer_selectedMultiplier;
        public final ForgeConfigSpec.BooleanValue hiveharvester_DamageTools;
        public final ForgeConfigSpec.IntValue upgrade_hiveharvester_baseEnergyCost;
        public final ForgeConfigSpec.BooleanValue upgrade_hiveharvester_energy_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_hiveharvester_energyMultiplier;
        public final ForgeConfigSpec.IntValue upgrade_hiveharvester_baseXpCost;
        public final ForgeConfigSpec.BooleanValue upgrade_hiveharvester_xp_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_hiveharvester_xpMultiplier;
        public final ForgeConfigSpec.IntValue upgrade_hiveharvester_dustColor;
        public final ForgeConfigSpec.IntValue upgrade_hiveharvester_baseDustAmount;
        public final ForgeConfigSpec.BooleanValue upgrade_hiveharvester_dust_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_hiveharvester_dustMultiplier;
        public final ForgeConfigSpec.BooleanValue upgrade_hiveharvester_selectedAllowed;
        public final ForgeConfigSpec.DoubleValue upgrade_hiveharvester_selectedMultiplier;
        public final ForgeConfigSpec.BooleanValue upgrade_dropper_canDropBolt;
        public final ForgeConfigSpec.IntValue upgrade_dropper_baseItemDropAmount;
        public final ForgeConfigSpec.IntValue upgrade_dropper_baseFluidDropAmount;
        public final ForgeConfigSpec.IntValue upgrade_dropper_baseEnergyDropAmount;
        public final ForgeConfigSpec.IntValue upgrade_dropper_baseExpDropAmount;
        public final ForgeConfigSpec.IntValue upgrade_dropper_baseDustDropAmount;
        public final ForgeConfigSpec.IntValue upgrade_pump_baseEnergyCost;
        public final ForgeConfigSpec.DoubleValue upgrade_pump_energyMultiplier;
        public final ForgeConfigSpec.BooleanValue upgrade_pump_energy_distance_multiplier;
        public final ForgeConfigSpec.IntValue upgrade_pump_baseXpCost;
        public final ForgeConfigSpec.BooleanValue upgrade_pump_xp_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_pump_xpMultiplier;
        public final ForgeConfigSpec.IntValue upgrade_pump_dustColor;
        public final ForgeConfigSpec.IntValue upgrade_pump_baseDustAmount;
        public final ForgeConfigSpec.BooleanValue upgrade_pump_dust_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_pump_dustMultiplier;
        public final ForgeConfigSpec.BooleanValue upgrade_pump_selectedAllowed;
        public final ForgeConfigSpec.DoubleValue upgrade_pump_selectedMultiplier;
        public final ForgeConfigSpec.IntValue upgrade_pump_baseBlocksPumped;
        public final ForgeConfigSpec.BooleanValue upgrade_pump_waterlogged;
        public final ForgeConfigSpec.IntValue upgrade_drain_baseEnergyCost;
        public final ForgeConfigSpec.DoubleValue upgrade_drain_energyMultiplier;
        public final ForgeConfigSpec.BooleanValue upgrade_drain_energy_distance_multiplier;
        public final ForgeConfigSpec.IntValue upgrade_drain_baseXpCost;
        public final ForgeConfigSpec.BooleanValue upgrade_drain_xp_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_drain_xpMultiplier;
        public final ForgeConfigSpec.IntValue upgrade_drain_dustColor;
        public final ForgeConfigSpec.IntValue upgrade_drain_baseDustAmount;
        public final ForgeConfigSpec.BooleanValue upgrade_drain_dust_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_drain_dustMultiplier;
        public final ForgeConfigSpec.BooleanValue upgrade_drain_selectedAllowed;
        public final ForgeConfigSpec.DoubleValue upgrade_drain_selectedMultiplier;
        public final ForgeConfigSpec.IntValue upgrade_drain_baseBlocksPlaced;
        public final ForgeConfigSpec.BooleanValue sheerer_DamageTools;
        public final ForgeConfigSpec.IntValue upgrade_sheerer_baseEnergyCost;
        public final ForgeConfigSpec.BooleanValue upgrade_sheerer_energy_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_sheerer_energyMultiplier;
        public final ForgeConfigSpec.IntValue upgrade_sheerer_baseXpCost;
        public final ForgeConfigSpec.BooleanValue upgrade_sheerer_xp_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_sheerer_xpMultiplier;
        public final ForgeConfigSpec.IntValue upgrade_sheerer_dustColor;
        public final ForgeConfigSpec.IntValue upgrade_sheerer_baseDustAmount;
        public final ForgeConfigSpec.BooleanValue upgrade_sheerer_dust_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_sheerer_dustMultiplier;
        public final ForgeConfigSpec.BooleanValue upgrade_sheerer_selectedAllowed;
        public final ForgeConfigSpec.DoubleValue upgrade_sheerer_selectedMultiplier;
        public final ForgeConfigSpec.BooleanValue milker_DamageTools;
        public final ForgeConfigSpec.IntValue upgrade_milker_baseEnergyCost;
        public final ForgeConfigSpec.BooleanValue upgrade_milker_energy_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_milker_energyMultiplier;
        public final ForgeConfigSpec.IntValue upgrade_milker_baseXpCost;
        public final ForgeConfigSpec.BooleanValue upgrade_milker_xp_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_milker_xpMultiplier;
        public final ForgeConfigSpec.IntValue upgrade_milker_dustColor;
        public final ForgeConfigSpec.IntValue upgrade_milker_baseDustAmount;
        public final ForgeConfigSpec.BooleanValue upgrade_milker_dust_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_milker_dustMultiplier;
        public final ForgeConfigSpec.BooleanValue upgrade_milker_selectedAllowed;
        public final ForgeConfigSpec.DoubleValue upgrade_milker_selectedMultiplier;
        public final ForgeConfigSpec.BooleanValue breeder_DamageTools;
        public final ForgeConfigSpec.IntValue upgrade_breeder_baseEnergyCost;
        public final ForgeConfigSpec.BooleanValue upgrade_breeder_energy_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_breeder_energyMultiplier;
        public final ForgeConfigSpec.IntValue upgrade_breeder_baseXpCost;
        public final ForgeConfigSpec.BooleanValue upgrade_breeder_xp_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_breeder_xpMultiplier;
        public final ForgeConfigSpec.IntValue upgrade_breeder_dustColor;
        public final ForgeConfigSpec.IntValue upgrade_breeder_baseDustAmount;
        public final ForgeConfigSpec.BooleanValue upgrade_breeder_dust_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_breeder_dustMultiplier;
        public final ForgeConfigSpec.BooleanValue upgrade_breeder_selectedAllowed;
        public final ForgeConfigSpec.DoubleValue upgrade_breeder_selectedMultiplier;
        public final ForgeConfigSpec.BooleanValue upgrade_breeder_entityBreedingLimit;
        public final ForgeConfigSpec.IntValue upgrade_breeder_entityLimitBreedingCount;
        public final ForgeConfigSpec.BooleanValue attacker_DamageTools;
        public final ForgeConfigSpec.IntValue upgrade_attacker_baseEnergyCost;
        public final ForgeConfigSpec.BooleanValue upgrade_attacker_energy_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_attacker_energyMultiplier;
        public final ForgeConfigSpec.IntValue upgrade_attacker_baseXpCost;
        public final ForgeConfigSpec.BooleanValue upgrade_attacker_xp_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_attacker_xpMultiplier;
        public final ForgeConfigSpec.IntValue upgrade_attacker_dustColor;
        public final ForgeConfigSpec.IntValue upgrade_attacker_baseDustAmount;
        public final ForgeConfigSpec.BooleanValue upgrade_attacker_dust_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_attacker_dustMultiplier;
        public final ForgeConfigSpec.BooleanValue upgrade_attacker_selectedAllowed;
        public final ForgeConfigSpec.DoubleValue upgrade_attacker_selectedMultiplier;
        public final ForgeConfigSpec.IntValue upgrade_fan_baseEnergyCost;
        public final ForgeConfigSpec.BooleanValue upgrade_fan_energy_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_fan_energyMultiplier;
        public final ForgeConfigSpec.IntValue upgrade_fan_baseXpCost;
        public final ForgeConfigSpec.BooleanValue upgrade_fan_xp_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_fan_xpMultiplier;
        public final ForgeConfigSpec.IntValue upgrade_fan_dustColor;
        public final ForgeConfigSpec.IntValue upgrade_fan_baseDustAmount;
        public final ForgeConfigSpec.BooleanValue upgrade_fan_dust_distance_multiplier;
        public final ForgeConfigSpec.DoubleValue upgrade_fan_dustMultiplier;
        public final ForgeConfigSpec.BooleanValue upgrade_fan_selectedAllowed;
        public final ForgeConfigSpec.DoubleValue upgrade_fan_selectedMultiplier;
        public final ForgeConfigSpec.IntValue upgrade_smelter_baseEnergyCost;
        public final ForgeConfigSpec.IntValue upgrade_blast_baseEnergyCost;
        public final ForgeConfigSpec.IntValue upgrade_smoker_baseEnergyCost;
        public final ForgeConfigSpec.IntValue upgrade_generator_baseEnergyCost;
        public final ForgeConfigSpec.IntValue upgrade_import_baseItemTransferSpeed;
        public final ForgeConfigSpec.IntValue upgrade_import_baseFluidTransferSpeed;
        public final ForgeConfigSpec.IntValue upgrade_import_baseEnergyTransferSpeed;
        public final ForgeConfigSpec.IntValue upgrade_import_baseExpTransferSpeed;
        public final ForgeConfigSpec.IntValue upgrade_import_baseDustTransferSpeed;
        public final ForgeConfigSpec.IntValue upgrade_export_baseItemTransferSpeed;
        public final ForgeConfigSpec.IntValue upgrade_export_baseFluidTransferSpeed;
        public final ForgeConfigSpec.IntValue upgrade_export_baseEnergyTransferSpeed;
        public final ForgeConfigSpec.IntValue upgrade_export_baseExpTransferSpeed;
        public final ForgeConfigSpec.IntValue upgrade_export_baseDustTransferSpeed;
        public final ForgeConfigSpec.BooleanValue upgrade_require_sized_selectable_area;
        public final ForgeConfigSpec.IntValue bulkstorage_itemDischarge;
        public final ForgeConfigSpec.BooleanValue bulkstorage_itemDischarge_toggle;
        public final ForgeConfigSpec.IntValue bulkstorage_maxItemStorage;
        public final ForgeConfigSpec.IntValue bulkstorage_fluidDischarge;
        public final ForgeConfigSpec.BooleanValue bulkstorage_fluidDischarge_toggle;
        public final ForgeConfigSpec.IntValue bulkstorage_energyDischarge;
        public final ForgeConfigSpec.BooleanValue bulkstorage_energyDischarge_toggle;
        public final ForgeConfigSpec.IntValue bulkstorage_xpDischarge;
        public final ForgeConfigSpec.BooleanValue bulkstorage_xpDischarge_toggle;
        public final ForgeConfigSpec.IntValue bulkstorage_dustDischarge;
        public final ForgeConfigSpec.BooleanValue bulkstorage_dustDischarge_toggle;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Pedestal Defaults").push("Global Pedestal Defaults");
            this.pedestal_baseItemTransferRate = builder.comment("Base Item Transfer Rate").defineInRange("pedestal_baseItemTransferRate", 4, 1, Integer.MAX_VALUE);
            this.pedestal_baseFluidTransferRate = builder.comment("Base Fluid Transfer Rate").defineInRange("pedestal_baseFluidTransferRate", 1000, 1, Integer.MAX_VALUE);
            this.pedestal_baseEnergyTransferRate = builder.comment("Base Energy Transfer Rate").defineInRange("pedestal_baseEnergyTransferRate", 5000, 1, Integer.MAX_VALUE);
            this.pedestal_baseXpTransferRate = builder.comment("Base Xp Transfer Rate [In Levels]").defineInRange("pedestal_baseXpTransferRate", 1, 1, Integer.MAX_VALUE);
            this.pedestal_baseDustTransferRate = builder.comment("Base Dust Transfer Rate").defineInRange("pedestal_baseDustTransferRate", 10, 1, Integer.MAX_VALUE);
            this.pedestal_baseLinkingRange = builder.comment("The Base Distance between Pedestals for Linking").defineInRange("pedestal_baseLinkingRange", 8, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Tiered Augments").push("Augment_Tiers");
            this.augment_t1CapacityItem = builder.comment("Tier 1, Capacity Item Transfer Increase").defineInRange("t1_increaseItemTransfer", 2, 0, Integer.MAX_VALUE);
            this.augment_t1CapacityFluid = builder.comment("Tier 1, Capacity Fluid Transfer Increase").defineInRange("t1_increaseFluidTransfer", 2000, 0, Integer.MAX_VALUE);
            this.augment_t1CapacityEnergy = builder.comment("Tier 1, Capacity Energy Transfer Increase").defineInRange("t1_increaseEnergyTransfer", 5000, 0, Integer.MAX_VALUE);
            this.augment_t1CapacityXp = builder.comment("Tier 1, Capacity Xp Transfer Increase (Levels)").defineInRange("t1_increaseXpTransfer", 1, 0, Integer.MAX_VALUE);
            this.augment_t1CapacityDust = builder.comment("Tier 1, Capacity Dust Transfer Increase").defineInRange("t1_increaseDustTransfer", 10, 0, Integer.MAX_VALUE);
            this.augment_t1CapacityInsertSize = builder.comment("Tier 1, Max Allowed To Insert of this Tier").defineInRange("t1_increaseInsertableAmount", 4, 1, 64);
            this.augment_t2CapacityItem = builder.comment("Tier 2, Capacity Item Transfer Increase").defineInRange("t2_increaseItemTransfer", 4, 0, Integer.MAX_VALUE);
            this.augment_t2CapacityFluid = builder.comment("Tier 2, Capacity Fluid Transfer Increase").defineInRange("t2_increaseFluidTransfer", 4000, 0, Integer.MAX_VALUE);
            this.augment_t2CapacityEnergy = builder.comment("Tier 2, Capacity Energy Transfer Increase").defineInRange("t2_increaseEnergyTransfer", 10000, 0, Integer.MAX_VALUE);
            this.augment_t2CapacityXp = builder.comment("Tier 2, Capacity Xp Transfer Increase (Levels)").defineInRange("t2_increaseXpTransfer", 5, 0, Integer.MAX_VALUE);
            this.augment_t2CapacityDust = builder.comment("Tier 2, Capacity Dust Transfer Increase (Levels)").defineInRange("t2_increaseDustTransfer", 10, 0, Integer.MAX_VALUE);
            this.augment_t2CapacityInsertSize = builder.comment("Tier 2, Max Allowed To Insert of this Tier").defineInRange("t2_increaseInsertableAmount", 8, 1, 64);
            this.augment_t3CapacityItem = builder.comment("Tier 3, Capacity Item Transfer Increase").defineInRange("t3_increaseItemTransfer", 8, 0, Integer.MAX_VALUE);
            this.augment_t3CapacityFluid = builder.comment("Tier 3, Capacity Fluid Transfer Increase").defineInRange("t3_increaseFluidTransfer", 8000, 0, Integer.MAX_VALUE);
            this.augment_t3CapacityEnergy = builder.comment("Tier 3, Capacity Energy Transfer Increase").defineInRange("t3_increaseEnergyTransfer", 100000, 0, Integer.MAX_VALUE);
            this.augment_t3CapacityXp = builder.comment("Tier 3, Capacity Xp Transfer Increase (Levels)").defineInRange("t3_increaseXpTransfer", 10, 0, Integer.MAX_VALUE);
            this.augment_t3CapacityDust = builder.comment("Tier 3, Capacity Dust Transfer Increase").defineInRange("t3_increaseDustTransfer", 10, 0, Integer.MAX_VALUE);
            this.augment_t3CapacityInsertSize = builder.comment("Tier 3, Max Allowed To Insert of this Tier").defineInRange("t3_increaseInsertableAmount", 12, 1, 64);
            this.augment_t4CapacityItem = builder.comment("Tier 4, Capacity Item Transfer Increase").defineInRange("t4_increaseItemTransfer", 16, 0, Integer.MAX_VALUE);
            this.augment_t4CapacityFluid = builder.comment("Tier 4, Capacity Fluid Transfer Increase").defineInRange("t4_increaseFluidTransfer", 16000, 0, Integer.MAX_VALUE);
            this.augment_t4CapacityEnergy = builder.comment("Tier 4, Capacity Energy Transfer Increase").defineInRange("t4_increaseEnergyTransfer", 1000000, 0, Integer.MAX_VALUE);
            this.augment_t4CapacityXp = builder.comment("Tier 4, Capacity Xp Transfer Increase (Levels)").defineInRange("t4_increaseXpTransfer", 15, 0, Integer.MAX_VALUE);
            this.augment_t4CapacityDust = builder.comment("Tier 4, Capacity Dust Transfer Increase").defineInRange("t4_increaseDustTransfer", 10, 0, Integer.MAX_VALUE);
            this.augment_t4CapacityInsertSize = builder.comment("Tier 4, Max Allowed To Insert of this Tier").defineInRange("t4_increaseInsertableAmount", 16, 1, 64);
            this.augment_t1StorageItem = builder.comment("Tier 1, Storage Item Increase").defineInRange("t1_increaseItemStorage", 1, 0, Integer.MAX_VALUE);
            this.augment_t1StorageFluid = builder.comment("Tier 1, Storage Fluid Increase").defineInRange("t1_increaseFluidStorage", 4000, 0, Integer.MAX_VALUE);
            this.augment_t1StorageEnergy = builder.comment("Tier 1, Storage Energy Increase").defineInRange("t1_increaseEnergyStorage", 20000, 0, Integer.MAX_VALUE);
            this.augment_t1StorageXp = builder.comment("Tier 1, Storage Xp Increase (Levels)").defineInRange("t1_increaseXpStorage", 10, 0, Integer.MAX_VALUE);
            this.augment_t1StorageDust = builder.comment("Tier 1, Storage Dust Increase").defineInRange("t1_increaseDustStorage", 50, 0, Integer.MAX_VALUE);
            this.augment_t1StorageInsertSize = builder.comment("Tier 1, Max Allowed To Insert of this Tier").defineInRange("t1_increaseInsertableStorageAmount", 3, 1, 64);
            this.augment_t2StorageItem = builder.comment("Tier 2, Storage Item Increase").defineInRange("t2_increaseItemStorage", 1, 0, Integer.MAX_VALUE);
            this.augment_t2StorageFluid = builder.comment("Tier 2, Storage Fluid Increase").defineInRange("t2_increaseFluidStorage", 16000, 0, Integer.MAX_VALUE);
            this.augment_t2StorageEnergy = builder.comment("Tier 2, Storage Energy Increase").defineInRange("t2_increaseEnergyStorage", 100000, 0, Integer.MAX_VALUE);
            this.augment_t2StorageXp = builder.comment("Tier 2, Storage Xp Increase (Levels)").defineInRange("t2_increaseXpStorage", 15, 0, Integer.MAX_VALUE);
            this.augment_t2StorageDust = builder.comment("Tier 2, Storage Dust Increase").defineInRange("t2_increaseDustStorage", 100, 0, Integer.MAX_VALUE);
            this.augment_t2StorageInsertSize = builder.comment("Tier 2, Max Allowed To Insert of this Tier").defineInRange("t2_increaseInsertableStorageAmount", 7, 1, 64);
            this.augment_t3StorageItem = builder.comment("Tier 3, Storage Item Increase").defineInRange("t3_increaseItemStorage", 1, 0, Integer.MAX_VALUE);
            this.augment_t3StorageFluid = builder.comment("Tier 3, Storage Fluid Increase").defineInRange("t3_increaseFluidStorage", 64000, 0, Integer.MAX_VALUE);
            this.augment_t3StorageEnergy = builder.comment("Tier 3, Storage Energy Increase").defineInRange("t3_increaseEnergyStorage", 1000000, 0, Integer.MAX_VALUE);
            this.augment_t3StorageXp = builder.comment("Tier 3, Storage Xp Increase (Levels)").defineInRange("t3_increaseXpStorage", 20, 0, Integer.MAX_VALUE);
            this.augment_t3StorageDust = builder.comment("Tier 3, Storage Dust Increase").defineInRange("t3_increaseDustStorage", 200, 0, Integer.MAX_VALUE);
            this.augment_t3StorageInsertSize = builder.comment("Tier 3, Max Allowed To Insert of this Tier").defineInRange("t3_increaseInsertableStorageAmount", 11, 1, 64);
            this.augment_t4StorageItem = builder.comment("Tier 4, Storage Item Increase").defineInRange("t4_increaseItemStorage", 1, 0, Integer.MAX_VALUE);
            this.augment_t4StorageFluid = builder.comment("Tier 4, Storage Fluid Increase").defineInRange("t4_increaseFluidStorage", 265000, 0, Integer.MAX_VALUE);
            this.augment_t4StorageEnergy = builder.comment("Tier 4, Storage Energy Increase").defineInRange("t4_increaseEnergyStorage", 10000000, 0, Integer.MAX_VALUE);
            this.augment_t4StorageXp = builder.comment("Tier 4, Storage Xp Increase (Levels)").defineInRange("t4_increaseXpStorage", 25, 0, Integer.MAX_VALUE);
            this.augment_t4StorageDust = builder.comment("Tier 4, Storage Dust Increase").defineInRange("t4_increaseDustStorage", 500, 0, Integer.MAX_VALUE);
            this.augment_t4StorageInsertSize = builder.comment("Tier 4, Max Allowed To Insert of this Tier").defineInRange("t4_increaseInsertableStorageAmount", 15, 1, 64);
            this.pedestal_maxTicksToTransfer = builder.comment("The max number of ticks needed to send items (before augments)").defineInRange("pedestal_ticksToTransfer", 40, 1, Integer.MAX_VALUE);
            this.pedestal_baseItemStacks = builder.comment("The initial number of stacks a pedestal holds (max values are definitive max values including with upgrades)").defineInRange("pedestal_baseItemStacks", 1, 1, 27);
            this.pedestal_baseFluidStorage = builder.comment("The initial fluid storage for pedestals (max values are definitive max values including with upgrades)").defineInRange("pedestal_baseFluidStorage", 16000, 1, Integer.MAX_VALUE);
            this.pedestal_baseEnergyStorage = builder.comment("The initial energy storage for pedestals (max values are definitive max values including with upgrades)").defineInRange("pedestal_baseEnergyStorage", 20000, 1, Integer.MAX_VALUE);
            this.pedestal_baseXpStorage = builder.comment("The initial xp storage for pedestals [In levels] (max values are definitive max values including with upgrades)").defineInRange("pedestal_baseXpStorage", 30, 1, 21000);
            this.pedestal_baseDustStorage = builder.comment("The initial dust storage for pedestals (max values are definitive max values including with upgrades)").defineInRange("pedestal_baseDustStorage", 200, 1, Integer.MAX_VALUE);
            this.augment_t1SpeedReduction = builder.comment("Tier 1, Number of Ticks Reduced").defineInRange("t1_ticksReduced", 2, 0, Integer.MAX_VALUE);
            this.augment_t1SpeedInsertable = builder.comment("Tier 1, Max Allowed To Insert of this Tier").defineInRange("t1_speedInsertable", 5, 1, 64);
            this.augment_t2SpeedReduction = builder.comment("Tier 2, Number of Ticks Reduced").defineInRange("t2_ticksReduced", 4, 0, Integer.MAX_VALUE);
            this.augment_t2SpeedInsertable = builder.comment("Tier 2, Max Allowed To Insert of this Tier").defineInRange("t2_speedInsertable", 5, 1, 64);
            this.augment_t3SpeedReduction = builder.comment("Tier 3, Number of Ticks Reduced").defineInRange("t3_ticksReduced", 6, 0, Integer.MAX_VALUE);
            this.augment_t3SpeedInsertable = builder.comment("Tier 3, Max Allowed To Insert of this Tier").defineInRange("t3_speedInsertable", 5, 1, 64);
            this.augment_t4SpeedReduction = builder.comment("Tier 4, Number of Ticks Reduced").defineInRange("t4_ticksReduced", 8, 0, Integer.MAX_VALUE);
            this.augment_t4SpeedInsertable = builder.comment("Tier 4, Max Allowed To Insert of this Tier").defineInRange("t4_speedInsertable", 5, 1, 64);
            this.augment_t1RangeIncrease = builder.comment("Tier 1, Block Range Increase").defineInRange("t1_rangeIncrease", 2, 0, Integer.MAX_VALUE);
            this.augment_t1RangeInsertable = builder.comment("Tier 1, Max Allowed To Insert of this Tier").defineInRange("t1_rangeInsertable", 4, 1, 64);
            this.augment_t2RangeIncrease = builder.comment("Tier 2, Block Range Increase").defineInRange("t2_rangeIncrease", 6, 0, Integer.MAX_VALUE);
            this.augment_t2RangeInsertable = builder.comment("Tier 2, Max Allowed To Insert of this Tier").defineInRange("t2_rangeInsertable", 4, 1, 64);
            this.augment_t3RangeIncrease = builder.comment("Tier 3, Block Range Increase").defineInRange("t3_rangeIncrease", 8, 0, Integer.MAX_VALUE);
            this.augment_t3RangeInsertable = builder.comment("Tier 3, Max Allowed To Insert of this Tier").defineInRange("t3_rangeInsertable", 5, 1, 64);
            this.augment_t4RangeIncrease = builder.comment("Tier 4, Block Range Increase").defineInRange("t4_rangeIncrease", 8, 0, Integer.MAX_VALUE);
            this.augment_t4RangeInsertable = builder.comment("Tier 4, Max Allowed To Insert of this Tier").defineInRange("t4_rangeInsertable", 7, 1, 64);
            builder.pop();
            builder.comment("Global Upgrade Configs").push("Global_Upgrade_Configs");
            this.blockBreakerBreakEntities = builder.comment("Allows the breaking of Block Entities").define("allowBreakEntities", false);
            this.upgrade_require_sized_selectable_area = builder.comment("Restrict the Selectable Area Size based on the Upgrades AOE modifier").define("upgrade_toggleable_require_selectable_size", false);
            this.upgrades_baseSelectionRange = builder.comment("The Base Distance from the Pedestal for Upgrade Block Selections to be 'In Range' ").defineInRange("upgrades_baseSelectionRange", 8, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Material Generator Configs").push("Material_Generator_Configs");
            this.cobbleGeneratorDamageTools = builder.comment("Material Generator Damages Inserted Tools").define("materialGenToolDamage", false);
            builder.pop();
            builder.comment("Import Upgrade Configs").push("Import_Upgrade_Configs");
            this.upgrade_import_baseItemTransferSpeed = builder.comment("Base Import Speed (Item)").defineInRange("upgrade_import_base_item_rate", 4, 0, Integer.MAX_VALUE);
            this.upgrade_import_baseFluidTransferSpeed = builder.comment("Base Import Speed (Fluid)").defineInRange("upgrade_import_base_fluid_rate", 1000, 0, Integer.MAX_VALUE);
            this.upgrade_import_baseEnergyTransferSpeed = builder.comment("Base Import Speed (Energy)").defineInRange("upgrade_import_base_energy_rate", 5000, 0, Integer.MAX_VALUE);
            this.upgrade_import_baseExpTransferSpeed = builder.comment("Base Import Speed (Exp)").defineInRange("upgrade_import_base_exp_rate", 7, 0, Integer.MAX_VALUE);
            this.upgrade_import_baseDustTransferSpeed = builder.comment("Base Import Speed (Dust)").defineInRange("upgrade_import_base_dust_rate", 200, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Export Upgrade Configs").push("Export_Upgrade_Configs");
            this.upgrade_export_baseItemTransferSpeed = builder.comment("Base Export Speed (Item)").defineInRange("upgrade_export_base_item_rate", 4, 0, Integer.MAX_VALUE);
            this.upgrade_export_baseFluidTransferSpeed = builder.comment("Base Export Speed (Fluid)").defineInRange("upgrade_export_base_fluid_rate", 1000, 0, Integer.MAX_VALUE);
            this.upgrade_export_baseEnergyTransferSpeed = builder.comment("Base Export Speed (Energy)").defineInRange("upgrade_export_base_energy_rate", 5000, 0, Integer.MAX_VALUE);
            this.upgrade_export_baseExpTransferSpeed = builder.comment("Base Export Speed (Exp)").defineInRange("upgrade_export_base_exp_rate", 7, 0, Integer.MAX_VALUE);
            this.upgrade_export_baseDustTransferSpeed = builder.comment("Base Export Speed (Dust)").defineInRange("upgrade_export_base_dust_rate", 200, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Magnet Configs").push("Magnet_Configs");
            this.upgrade_magnet_baseEnergyCost = builder.comment("Base RF cost per upgrade operation [Magnet]").defineInRange("upgrade_magnet_base_energy_cost", 0, 0, Integer.MAX_VALUE);
            this.upgrade_magnet_energyMultiplier = builder.comment("Energy Multiplier, total cost x multiplier [Magnet]").defineInRange("upgrade_magnet_base_energy_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_magnet_baseXpCost = builder.comment("Base XP cost per upgrade operation [Magnet]").defineInRange("upgrade_magnet_base_xp_cost", 0, 0, Integer.MAX_VALUE);
            this.upgrade_magnet_xpMultiplier = builder.comment("XP Multiplier, total cost x multiplier [Magnet]").defineInRange("upgrade_magnet_base_xp_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_magnet_dustColor = builder.comment("Dust Color Required to do action [Magnet]").defineInRange("upgrade_magnet_base_dust_color", -1, -1, Integer.MAX_VALUE);
            this.upgrade_magnet_baseDustAmount = builder.comment("Base Dust amount needed per upgrade operation [Magnet]").defineInRange("upgrade_magnet_base_dust_amount", 0, 0, Integer.MAX_VALUE);
            this.upgrade_magnet_dustMultiplier = builder.comment("Dust Amount Multiplier, total cost x multiplier [Magnet]").defineInRange("upgrade_magnet_base_dust_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_magnet_selectedAllowed = builder.comment("Additional Modifier based on distance of work(breaking a block or picking up items as an example) from pedestal [Magnet]").define("upgrade_magnet_selected_allowed", false);
            this.upgrade_magnet_selectedMultiplier = builder.comment("Modifier Amount, Distance x Modifier + Other 'Energy' BaseCost (this is the 'total cost' formula) [Magnet]").defineInRange("upgrade_magnet_selected_modifier", 1.0, 0.0, 2.147483647E9);
            builder.pop();
            builder.comment("Breaker Configs").push("Breaker_Configs");
            this.blockBreakerDamageTools = builder.comment("Block Breaker Damages Inserted Tools").define("blockBreakerDamageTools", false);
            this.upgrade_blockbreaker_baseEnergyCost = builder.comment("Base RF cost per upgrade operation [Block Breaker]").defineInRange("upgrade_blockbreaker_base_energy_cost", 0, 0, Integer.MAX_VALUE);
            this.upgrade_blockbreaker_energy_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Block Breaker]").define("upgrade_blockbreaker_energy_distance_multiplier", true);
            this.upgrade_blockbreaker_energyMultiplier = builder.comment("Energy Multiplier, total cost x multiplier [Block Breaker]").defineInRange("upgrade_blockbreaker_energy_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_blockbreaker_baseXpCost = builder.comment("Base XP cost per upgrade operation [Block Breaker]").defineInRange("upgrade_blockbreaker_base_xp_cost", 0, 0, Integer.MAX_VALUE);
            this.upgrade_blockbreaker_xp_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Block Breaker]").define("upgrade_blockbreaker_xp_distance_multiplier", true);
            this.upgrade_blockbreaker_xpMultiplier = builder.comment("XP Multiplier, total cost x multiplier [Block Breaker]").defineInRange("upgrade_blockbreaker_xp_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_blockbreaker_dustColor = builder.comment("Dust Color Required to do action [Block Breaker]").defineInRange("upgrade_blockbreaker_dust_color", -1, -1, Integer.MAX_VALUE);
            this.upgrade_blockbreaker_baseDustAmount = builder.comment("Base Dust amount needed per upgrade operation [Block Breaker]").defineInRange("upgrade_blockbreaker_base_dust_amount", 0, 0, Integer.MAX_VALUE);
            this.upgrade_blockbreaker_dust_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Block Breaker]").define("upgrade_blockbreaker_dust_distance_multiplier", true);
            this.upgrade_blockbreaker_dustMultiplier = builder.comment("Dust Amount Multiplier, total cost x multiplier [Block Breaker]").defineInRange("upgrade_blockbreaker_dust_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_blockbreaker_selectedAllowed = builder.comment("Additional Modifier based on distance of work(breaking a block or picking up items as an example) from pedestal [Block Breaker]").define("upgrade_blockbreaker_selected_allowed", false);
            this.upgrade_blockbreaker_selectedMultiplier = builder.comment("Modifier Amount, Distance x Modifier + Other 'Energy' BaseCost (this is the 'total cost' formula) [Block Breaker]").defineInRange("upgrade_blockbreaker_selected_multiplier", 1.0, 0.0, 2.147483647E9);
            builder.pop();
            builder.comment("Placer Configs").push("Placer_Configs");
            this.upgrade_blockplacer_baseEnergyCost = builder.comment("Base RF cost per upgrade operation [Block Placer]").defineInRange("upgrade_blockplacer_base_energy_cost", 0, 0, Integer.MAX_VALUE);
            this.upgrade_blockplacer_energy_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Block Placer]").define("upgrade_blockplacer_energy_distance_multiplier", true);
            this.upgrade_blockplacer_energyMultiplier = builder.comment("Energy Multiplier, total cost x multiplier [Block Placer]").defineInRange("upgrade_blockplacer_energy_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_blockplacer_baseXpCost = builder.comment("Base XP cost per upgrade operation [Block Placer]").defineInRange("upgrade_blockplacer_base_xp_cost", 0, 0, Integer.MAX_VALUE);
            this.upgrade_blockplacer_xp_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Block Placer]").define("upgrade_blockplacer_xp_distance_multiplier", true);
            this.upgrade_blockplacer_xpMultiplier = builder.comment("XP Multiplier, total cost x multiplier [Block Placer]").defineInRange("upgrade_blockplacer_xp_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_blockplacer_dustColor = builder.comment("Dust Color Required to do action [Block Placer]").defineInRange("upgrade_blockplacer_dust_color", -1, -1, Integer.MAX_VALUE);
            this.upgrade_blockplacer_baseDustAmount = builder.comment("Base Dust amount needed per upgrade operation [Block Placer]").defineInRange("upgrade_blockplacer_base_dust_amount", 0, 0, Integer.MAX_VALUE);
            this.upgrade_blockplacer_dust_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Block Placer]").define("upgrade_blockplacer_dust_distance_multiplier", true);
            this.upgrade_blockplacer_dustMultiplier = builder.comment("Dust Amount Multiplier, total cost x multiplier [Block Placer]").defineInRange("upgrade_blockplacer_dust_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_blockplacer_selectedAllowed = builder.comment("Additional Modifier based on distance of work(breaking a block or picking up items as an example) from pedestal [Block Placer]").define("upgrade_blockplacer_selected_allowed", false);
            this.upgrade_blockplacer_selectedMultiplier = builder.comment("Modifier Amount, Distance x Modifier + Other 'Energy' BaseCost (this is the 'total cost' formula) [Block Placer]").defineInRange("upgrade_blockplacer_selected_multiplier", 1.0, 0.0, 2.147483647E9);
            builder.pop();
            builder.comment("Filler Configs").push("Filler_Configs");
            this.upgrade_filler_baseEnergyCost = builder.comment("Base RF cost per upgrade operation [Filler]").defineInRange("upgrade_filler_base_energy_cost", 0, 0, Integer.MAX_VALUE);
            this.upgrade_filler_energy_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Filler]").define("upgrade_filler_energy_distance_multiplier", true);
            this.upgrade_filler_energyMultiplier = builder.comment("Energy Multiplier, total cost x multiplier [Filler]").defineInRange("upgrade_filler_energy_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_filler_baseXpCost = builder.comment("Base XP cost per upgrade operation [Filler]").defineInRange("upgrade_filler_base_xp_cost", 0, 0, Integer.MAX_VALUE);
            this.upgrade_filler_xp_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Filler]").define("upgrade_filler_xp_distance_multiplier", true);
            this.upgrade_filler_xpMultiplier = builder.comment("XP Multiplier, total cost x multiplier [Filler]").defineInRange("upgrade_filler_xp_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_filler_dustColor = builder.comment("Dust Color Required to do action [Filler]").defineInRange("upgrade_filler_dust_color", -1, -1, Integer.MAX_VALUE);
            this.upgrade_filler_baseDustAmount = builder.comment("Base Dust amount needed per upgrade operation [Filler]").defineInRange("upgrade_filler_based_dust_amount", 0, 0, Integer.MAX_VALUE);
            this.upgrade_filler_dust_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Filler]").define("upgrade_filler_dust_distance_multiplier", true);
            this.upgrade_filler_dustMultiplier = builder.comment("Dust Amount Multiplier, total cost x multiplier [Filler]").defineInRange("upgrade_filler_dust_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_filler_selectedAllowed = builder.comment("Additional Modifier based on distance of work(placing a block or picking up items as an example) from pedestal [Filler]").define("upgrade_filler_selected_allowed", false);
            this.upgrade_filler_selectedMultiplier = builder.comment("Modifier Amount, Distance x Modifier + Other 'Energy' BaseCost (this is the 'total cost' formula) [Filler]").defineInRange("upgrade_filler_selected_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_filler_baseBlocksPlaced = builder.comment("Base Amount of Blocks the Filler will Place at a Time. [Filler]").defineInRange("upgrade_filler_base_blocks_placed", 4, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Quarry Configs").push("Quarry_Configs");
            this.quarryDamageTools = builder.comment("Quarry Damages Inserted Tools").define("quarryDamageTools", false);
            this.upgrade_quarry_baseEnergyCost = builder.comment("Base RF cost per upgrade operation [Quarry]").defineInRange("upgrade_quarry_base_energy_cost", 500, 0, Integer.MAX_VALUE);
            this.upgrade_quarry_energy_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Quarry]").define("upgrade_quarry_energy_distance_multiplier", false);
            this.upgrade_quarry_energyMultiplier = builder.comment("Energy Multiplier, total cost x multiplier [Quarry]").defineInRange("upgrade_quarry_energy_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_quarry_baseXpCost = builder.comment("Base XP cost per upgrade operation [Quarry]").defineInRange("upgrade_quarry_base_xp_cost", 0, 0, Integer.MAX_VALUE);
            this.upgrade_quarry_xp_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Quarry]").define("upgrade_quarry_xp_distance_multiplier", true);
            this.upgrade_quarry_xpMultiplier = builder.comment("XP Multiplier, total cost x multiplier [Quarry]").defineInRange("upgrade_quarry_xp_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_quarry_dustColor = builder.comment("Dust Color Required to do action [Quarry]").defineInRange("upgrade_quarry_dust_color", -1, -1, Integer.MAX_VALUE);
            this.upgrade_quarry_baseDustAmount = builder.comment("Base Dust amount needed per upgrade operation [Quarry]").defineInRange("upgrade_quarry_based_dust_amount", 0, 0, Integer.MAX_VALUE);
            this.upgrade_quarry_dust_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Quarry]").define("upgrade_quarry_dust_distance_multiplier", true);
            this.upgrade_quarry_dustMultiplier = builder.comment("Dust Amount Multiplier, total cost x multiplier [Quarry]").defineInRange("upgrade_quarry_dust_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_quarry_selectedAllowed = builder.comment("Additional Modifier based on distance of work(breaking a block or picking up items as an example) from pedestal [Quarry]").define("upgrade_quarry_selected_allowed", false);
            this.upgrade_quarry_selectedMultiplier = builder.comment("Modifier Amount, Distance x Modifier + Other 'Energy' BaseCost (this is the 'total cost' formula) [Quarry]").defineInRange("upgrade_quarry_selected_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_quarry_baseBlocksMined = builder.comment("Base Amount of Blocks the Quarry will Mine at a Time. [Quarry]").defineInRange("upgrade_quarry_base_blocks_mined", 4, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Chopper Configs").push("Chopper_Configs");
            this.chopperDamageTools = builder.comment("Chopper Damages Inserted Tools").define("chopper_damages_tools", false);
            this.upgrade_chopper_baseEnergyCost = builder.comment("Base RF cost per upgrade operation [Chopper]").defineInRange("upgrade_chopper_base_energy_cost", 0, 0, Integer.MAX_VALUE);
            this.upgrade_chopper_energy_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Chopper]").define("upgrade_chopper_energy_distance_multiplier", true);
            this.upgrade_chopper_energyMultiplier = builder.comment("Energy Multiplier, total cost x multiplier [Chopper]").defineInRange("upgrade_chopper_energy_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_chopper_baseXpCost = builder.comment("Base XP cost per upgrade operation [Chopper]").defineInRange("upgrade_chopper_base_xp_cost", 0, 0, Integer.MAX_VALUE);
            this.upgrade_chopper_xp_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Chopper]").define("upgrade_chopper_xp_distance_multiplier", true);
            this.upgrade_chopper_xpMultiplier = builder.comment("XP Multiplier, total cost x multiplier [Chopper]").defineInRange("upgrade_chopper_xp_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_chopper_dustColor = builder.comment("Dust Color Required to do action [Chopper]").defineInRange("upgrade_chopper_dust_color", -1, -1, Integer.MAX_VALUE);
            this.upgrade_chopper_baseDustAmount = builder.comment("Base Dust amount needed per upgrade operation [Chopper]").defineInRange("upgrade_chopper_base_dust_amount", 0, 0, Integer.MAX_VALUE);
            this.upgrade_chopper_dust_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Chopper]").define("upgrade_chopper_dust_distance_multiplier", true);
            this.upgrade_chopper_dustMultiplier = builder.comment("Dust Amount Multiplier, total cost x multiplier [Chopper]").defineInRange("upgrade_chopper_dust_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_chopper_selectedAllowed = builder.comment("Additional Modifier based on distance of work(breaking a block or picking up items as an example) from pedestal [Chopper]").define("upgrade_chopper_selected_allowed", false);
            this.upgrade_chopper_selectedMultiplier = builder.comment("Modifier Amount, Distance x Modifier + Other 'Energy' BaseCost (this is the 'total cost' formula) [Chopper]").defineInRange("upgrade_chopper_selected_multiplier", 1.0, 0.0, 2.147483647E9);
            builder.pop();
            builder.comment("Harvester Configs").push("Harvester_Configs");
            this.harvester_DamageTools = builder.comment("Harvester Damages Inserted Tools").define("harvester_damage_tools", false);
            this.upgrade_harvester_baseEnergyCost = builder.comment("Base RF cost per upgrade operation [Harvester]").defineInRange("upgrade_harvester_base_energy_cost", 0, 0, Integer.MAX_VALUE);
            this.upgrade_harvester_energy_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Harvester]").define("upgrade_harvester_energy_distance_multiplier", true);
            this.upgrade_harvester_energyMultiplier = builder.comment("Energy Multiplier, total cost x multiplier [Harvester]").defineInRange("upgrade_harvester_energy_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_harvester_baseXpCost = builder.comment("Base XP cost per upgrade operation [Harvester]").defineInRange("upgrade_harvester_base_xp_cost", 0, 0, Integer.MAX_VALUE);
            this.upgrade_harvester_xp_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Harvester]").define("upgrade_harvester_xp_distance_multiplier", true);
            this.upgrade_harvester_xpMultiplier = builder.comment("XP Multiplier, total cost x multiplier [Harvester]").defineInRange("upgrade_harvester_xp_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_harvester_dustColor = builder.comment("Dust Color Required to do action [Harvester]").defineInRange("upgrade_harvester_dust_color", -1, -1, Integer.MAX_VALUE);
            this.upgrade_harvester_baseDustAmount = builder.comment("Base Dust amount needed per upgrade operation [Harvester]").defineInRange("upgrade_harvester_base_dust_amount", 0, 0, Integer.MAX_VALUE);
            this.upgrade_harvester_dust_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Harvester]").define("upgrade_harvester_dust_distance_multiplier", true);
            this.upgrade_harvester_dustMultiplier = builder.comment("Dust Amount Multiplier, total cost x multiplier [Harvester]").defineInRange("upgrade_harvester_dust_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_harvester_selectedAllowed = builder.comment("Additional Modifier based on distance of work(breaking a block or picking up items as an example) from pedestal [Harvester]").define("upgrade_harvester_selected_allowed", false);
            this.upgrade_harvester_selectedMultiplier = builder.comment("Modifier Amount, Distance x Modifier + Other 'Energy' BaseCost (this is the 'total cost' formula) [Harvester]").defineInRange("upgrade_harvester_selected_multiplier", 1.0, 0.0, 2.147483647E9);
            builder.pop();
            builder.comment("Planter Configs").push("Planter_Configs");
            this.upgrade_planter_baseEnergyCost = builder.comment("Base RF cost per upgrade operation [Planter]").defineInRange("upgrade_planter_base_energy_cost", 0, 0, Integer.MAX_VALUE);
            this.upgrade_planter_energy_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Planter]").define("upgrade_planter_energy_distance_multiplier", true);
            this.upgrade_planter_energyMultiplier = builder.comment("Energy Multiplier, total cost x multiplier [Planter]").defineInRange("upgrade_planter_energy_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_planter_baseXpCost = builder.comment("Base XP cost per upgrade operation [Planter]").defineInRange("upgrade_planter_base_xp_cost", 0, 0, Integer.MAX_VALUE);
            this.upgrade_planter_xp_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Chopper]").define("upgrade_planter_xp_distance_multiplier", true);
            this.upgrade_planter_xpMultiplier = builder.comment("XP Multiplier, total cost x multiplier [Planter]").defineInRange("upgrade_planter_xp_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_planter_dustColor = builder.comment("Dust Color Required to do action [Planter]").defineInRange("upgrade_planter_dust_color", -1, -1, Integer.MAX_VALUE);
            this.upgrade_planter_baseDustAmount = builder.comment("Base Dust amount needed per upgrade operation [Planter]").defineInRange("upgrade_planter_base_dust_amount", 0, 0, Integer.MAX_VALUE);
            this.upgrade_planter_dust_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Planter]").define("upgrade_planter_dust_distance_multiplier", true);
            this.upgrade_planter_dustMultiplier = builder.comment("Dust Amount Multiplier, total cost x multiplier [Planter]").defineInRange("upgrade_planter_dust_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_planter_selectedAllowed = builder.comment("Additional Modifier based on distance of work(breaking a block or picking up items as an example) from pedestal [Planter]").define("upgrade_planter_selected_allowed", false);
            this.upgrade_planter_selectedMultiplier = builder.comment("Modifier Amount, Distance x Modifier + Other 'Energy' BaseCost (this is the 'total cost' formula) [Planter]").defineInRange("upgrade_planter_selected_multiplier", 1.0, 0.0, 2.147483647E9);
            builder.pop();
            builder.comment("Fertilizer Configs").push("Fertilizer_Configs");
            this.upgrade_fertilizer_baseEnergyCost = builder.comment("Base RF cost per upgrade operation [Fertilizer]").defineInRange("upgrade_fertilizer_base_energy_cost", 0, 0, Integer.MAX_VALUE);
            this.upgrade_fertilizer_energy_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Fertilizer]").define("upgrade_fertilizer_energy_distance_multiplier", true);
            this.upgrade_fertilizer_energyMultiplier = builder.comment("Energy Multiplier, total cost x multiplier [Fertilizer]").defineInRange("upgrade_fertilizer_energy_multiplier", 1.0, 0.0, Double.MAX_VALUE);
            this.upgrade_fertilizer_baseXpCost = builder.comment("Base XP cost per upgrade operation [Fertilizer]").defineInRange("upgrade_fertilizer_base_xp_cost", 0, 0, Integer.MAX_VALUE);
            this.upgrade_fertilizer_xp_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Fertilizer]").define("upgrade_fertilizer_xp_distance_multiplier", true);
            this.upgrade_fertilizer_xpMultiplier = builder.comment("XP Multiplier, total cost x multiplier [Fertilizer]").defineInRange("upgrade_fertilizer_xp_multiplier", 1.0, 0.0, Double.MAX_VALUE);
            this.upgrade_fertilizer_dustColor = builder.comment("Dust Color Required to do action [Fertilizer]").defineInRange("upgrade_fertilizer_dust_color", -1, -1, Integer.MAX_VALUE);
            this.upgrade_fertilizer_baseDustAmount = builder.comment("Base Dust amount needed per upgrade operation [Fertilizer]").defineInRange("upgrade_fertilizer_base_dust_amount", 0, 0, Integer.MAX_VALUE);
            this.upgrade_fertilizer_dust_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Fertilizer]").define("upgrade_fertilizer_dust_distance_multiplier", true);
            this.upgrade_fertilizer_dustMultiplier = builder.comment("Dust Amount Multiplier, total cost x multiplier [Fertilizer]").defineInRange("upgrade_fertilizer_dust_multiplier", 1.0, 0.0, Double.MAX_VALUE);
            this.upgrade_fertilizer_selectedAllowed = builder.comment("Additional Modifier based on distance of work(breaking a block or picking up items as an example) from pedestal [Fertilizer]").define("upgrade_fertilizer_selected_allowed", false);
            this.upgrade_fertilizer_selectedMultiplier = builder.comment("Modifier Amount, Distance x Modifier + Other 'Energy' BaseCost (this is the 'total cost' formula) [Fertilizer]").defineInRange("upgrade_fertilizer_selected_multiplier", 1.0, 0.0, Double.MAX_VALUE);
            builder.pop();
            builder.comment("Hive Harvester Configs").push("Hive_Harvester_Configs");
            this.hiveharvester_DamageTools = builder.comment("Hive Harvester Damages Inserted Tools").define("hiveharvester_damage_tools", false);
            this.upgrade_hiveharvester_baseEnergyCost = builder.comment("Base RF cost per upgrade operation [Hive Harvester]").defineInRange("upgrade_hiveharvester_base_energy_cost", 0, 0, Integer.MAX_VALUE);
            this.upgrade_hiveharvester_energy_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Hive Harvester]").define("upgrade_hiveharvester_energy_distance_multiplier", true);
            this.upgrade_hiveharvester_energyMultiplier = builder.comment("Energy Multiplier, total cost x multiplier [Hive Harvester]").defineInRange("upgrade_hiveharvester_energy_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_hiveharvester_baseXpCost = builder.comment("Base XP cost per upgrade operation [Hive Harvester]").defineInRange("upgrade_hiveharvester_base_xp_cost", 0, 0, Integer.MAX_VALUE);
            this.upgrade_hiveharvester_xp_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Hive Harvester]").define("upgrade_hiveharvester_xp_distance_multiplier", true);
            this.upgrade_hiveharvester_xpMultiplier = builder.comment("XP Multiplier, total cost x multiplier [Hive Harvester]").defineInRange("upgrade_hiveharvester_xp_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_hiveharvester_dustColor = builder.comment("Dust Color Required to do action [Hive Harvester]").defineInRange("upgrade_hiveharvester_dust_color", -1, -1, Integer.MAX_VALUE);
            this.upgrade_hiveharvester_baseDustAmount = builder.comment("Base Dust amount needed per upgrade operation [Hive Harvester]").defineInRange("upgrade_hiveharvester_base_dust_amount", 0, 0, Integer.MAX_VALUE);
            this.upgrade_hiveharvester_dust_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Hive Harvester]").define("upgrade_hiveharvester_dust_distance_multiplier", true);
            this.upgrade_hiveharvester_dustMultiplier = builder.comment("Dust Amount Multiplier, total cost x multiplier [Hive Harvester]").defineInRange("upgrade_hiveharvester_dust_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_hiveharvester_selectedAllowed = builder.comment("Additional Modifier based on distance of work(breaking a block or picking up items as an example) from pedestal [Hive Harvester]").define("upgrade_hiveharvester_selected_allowed", false);
            this.upgrade_hiveharvester_selectedMultiplier = builder.comment("Modifier Amount, Distance x Modifier + Other 'Energy' BaseCost (this is the 'total cost' formula) [Hive Harvester]").defineInRange("upgrade_hiveharvester_selected_multiplier", 1.0, 0.0, 2.147483647E9);
            builder.pop();
            builder.comment("Dropper Configs").push("Dropper_Configs");
            this.upgrade_dropper_canDropBolt = builder.comment("Is Dropper Allowed to Drop Lightning").define("upgrade_dropper_can_drop_bolt", true);
            this.upgrade_dropper_baseItemDropAmount = builder.comment("Base Item Drop Amount ").defineInRange("upgrade_dropper_base_drop_item_amount", 1, 0, Integer.MAX_VALUE);
            this.upgrade_dropper_baseFluidDropAmount = builder.comment("Base Fluid Drop Amount ").defineInRange("upgrade_dropper_base_drop_fluid_amount", 1000, 0, Integer.MAX_VALUE);
            this.upgrade_dropper_baseEnergyDropAmount = builder.comment("Base Energy Drop Amount ").defineInRange("upgrade_dropper_base_drop_energy_amount", 5000, 0, Integer.MAX_VALUE);
            this.upgrade_dropper_baseExpDropAmount = builder.comment("Base Exp Drop Amount ").defineInRange("upgrade_dropper_base_drop_exp_amount", 7, 0, Integer.MAX_VALUE);
            this.upgrade_dropper_baseDustDropAmount = builder.comment("Base Dust Drop Amount ").defineInRange("upgrade_dropper_base_drop_dust_amount", 200, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Pump Configs").push("Pump_Configs");
            this.upgrade_pump_baseEnergyCost = builder.comment("Base RF cost per upgrade operation [Pump]").defineInRange("upgrade_pump_base_energy_cost", 0, 0, Integer.MAX_VALUE);
            this.upgrade_pump_energy_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Pump]").define("upgrade_pump_energy_distance_multiplier", true);
            this.upgrade_pump_energyMultiplier = builder.comment("Energy Multiplier, total cost x multiplier [Pump]").defineInRange("upgrade_pump_energy_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_pump_baseXpCost = builder.comment("Base XP cost per upgrade operation [Pump]").defineInRange("upgrade_pump_base_xp_cost", 0, 0, Integer.MAX_VALUE);
            this.upgrade_pump_xp_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Pump]").define("upgrade_pump_xp_distance_multiplier", true);
            this.upgrade_pump_xpMultiplier = builder.comment("XP Multiplier, total cost x multiplier [Pump]").defineInRange("upgrade_pump_xp_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_pump_dustColor = builder.comment("Dust Color Required to do action [Pump]").defineInRange("upgrade_pump_dust_color", -1, -1, Integer.MAX_VALUE);
            this.upgrade_pump_baseDustAmount = builder.comment("Base Dust amount needed per upgrade operation [Pump]").defineInRange("upgrade_pump_based_dust_amount", 0, 0, Integer.MAX_VALUE);
            this.upgrade_pump_dust_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Pump]").define("upgrade_pump_dust_distance_multiplier", true);
            this.upgrade_pump_dustMultiplier = builder.comment("Dust Amount Multiplier, total cost x multiplier [Pump]").defineInRange("upgrade_pump_dust_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_pump_selectedAllowed = builder.comment("Additional Modifier based on distance of work(breaking a block or picking up items as an example) from pedestal [Pump]").define("upgrade_pump_selected_allowed", false);
            this.upgrade_pump_selectedMultiplier = builder.comment("Modifier Amount, Distance x Modifier + Other 'Energy' BaseCost (this is the 'total cost' formula) [Pump]").defineInRange("upgrade_pump_selected_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_pump_baseBlocksPumped = builder.comment("Base Amount of Blocks the Quarry will Mine at a Time. [Pump]").defineInRange("upgrade_pump_base_blocks_mined", 4, 0, Integer.MAX_VALUE);
            this.upgrade_pump_waterlogged = builder.comment("Remove water from Waterlogged Blocks [Pump]").define("upgrade_pump_waterlogged", false);
            builder.pop();
            builder.comment("Drain Configs").push("Drain_Configs");
            this.upgrade_drain_baseEnergyCost = builder.comment("Base RF cost per upgrade operation [Drain]").defineInRange("upgrade_drain_base_energy_cost", 0, 0, Integer.MAX_VALUE);
            this.upgrade_drain_energy_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Drain]").define("upgrade_drain_energy_distance_multiplier", true);
            this.upgrade_drain_energyMultiplier = builder.comment("Energy Multiplier, total cost x multiplier [Drain]").defineInRange("upgrade_drain_energy_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_drain_baseXpCost = builder.comment("Base XP cost per upgrade operation [Drain]").defineInRange("upgrade_drain_base_xp_cost", 0, 0, Integer.MAX_VALUE);
            this.upgrade_drain_xp_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Drain]").define("upgrade_drain_xp_distance_multiplier", true);
            this.upgrade_drain_xpMultiplier = builder.comment("XP Multiplier, total cost x multiplier [Drain]").defineInRange("upgrade_drain_xp_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_drain_dustColor = builder.comment("Dust Color Required to do action [Drain]").defineInRange("upgrade_drain_dust_color", -1, -1, Integer.MAX_VALUE);
            this.upgrade_drain_baseDustAmount = builder.comment("Base Dust amount needed per upgrade operation [Drain]").defineInRange("upgrade_drain_based_dust_amount", 0, 0, Integer.MAX_VALUE);
            this.upgrade_drain_dust_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Drain]").define("upgrade_drain_dust_distance_multiplier", true);
            this.upgrade_drain_dustMultiplier = builder.comment("Dust Amount Multiplier, total cost x multiplier [Drain]").defineInRange("upgrade_drain_dust_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_drain_selectedAllowed = builder.comment("Additional Modifier based on distance of work(placing a block or picking up items as an example) from pedestal [Drain]").define("upgrade_drain_selected_allowed", false);
            this.upgrade_drain_selectedMultiplier = builder.comment("Modifier Amount, Distance x Modifier + Other 'Energy' BaseCost (this is the 'total cost' formula) [Drain]").defineInRange("upgrade_drain_selected_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_drain_baseBlocksPlaced = builder.comment("Base Amount of Blocks the Drain will Place at a Time. [Drain]").defineInRange("upgrade_drain_base_blocks_placed", 4, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Sheerer Configs").push("Sheerer_Configs");
            this.sheerer_DamageTools = builder.comment("Sheerer Damages Inserted Tools").define("shearer_damages_tools", false);
            this.upgrade_sheerer_baseEnergyCost = builder.comment("Base RF cost per upgrade operation [Sheerer]").defineInRange("upgrade_sheerer_base_energy_cost", 0, 0, Integer.MAX_VALUE);
            this.upgrade_sheerer_energy_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Sheerer]").define("upgrade_sheerer_energy_distance_multiplier", true);
            this.upgrade_sheerer_energyMultiplier = builder.comment("Energy Multiplier, total cost x multiplier [Sheerer]").defineInRange("upgrade_sheerer_energy_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_sheerer_baseXpCost = builder.comment("Base XP cost per upgrade operation [Sheerer]").defineInRange("upgrade_sheerer_base_xp_cost", 0, 0, Integer.MAX_VALUE);
            this.upgrade_sheerer_xp_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Sheerer]").define("upgrade_sheerer_xp_distance_multiplier", true);
            this.upgrade_sheerer_xpMultiplier = builder.comment("XP Multiplier, total cost x multiplier [Sheerer]").defineInRange("upgrade_sheerer_xp_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_sheerer_dustColor = builder.comment("Dust Color Required to do action [Sheerer]").defineInRange("upgrade_sheerer_dust_color", -1, -1, Integer.MAX_VALUE);
            this.upgrade_sheerer_baseDustAmount = builder.comment("Base Dust amount needed per upgrade operation [Sheerer]").defineInRange("upgrade_sheerer_base_dust_amount", 0, 0, Integer.MAX_VALUE);
            this.upgrade_sheerer_dust_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Sheerer]").define("upgrade_sheerer_dust_distance_multiplier", true);
            this.upgrade_sheerer_dustMultiplier = builder.comment("Dust Amount Multiplier, total cost x multiplier [Sheerer]").defineInRange("upgrade_sheerer_dust_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_sheerer_selectedAllowed = builder.comment("Additional Modifier based on distance of work(breaking a block or picking up items as an example) from pedestal [Sheerer]").define("upgrade_sheerer_selected_allowed", false);
            this.upgrade_sheerer_selectedMultiplier = builder.comment("Modifier Amount, Distance x Modifier + Other 'Energy' BaseCost (this is the 'total cost' formula) [Sheerer]").defineInRange("upgrade_sheerer_selected_multiplier", 1.0, 0.0, 2.147483647E9);
            builder.pop();
            builder.comment("Milker Configs").push("Milker_Configs");
            this.milker_DamageTools = builder.comment("Milker Damages Inserted Tools").define("milker_damages_tools", false);
            this.upgrade_milker_baseEnergyCost = builder.comment("Base RF cost per upgrade operation [Milker]").defineInRange("upgrade_milker_base_energy_cost", 0, 0, Integer.MAX_VALUE);
            this.upgrade_milker_energy_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Milker]").define("upgrade_milker_energy_distance_multiplier", true);
            this.upgrade_milker_energyMultiplier = builder.comment("Energy Multiplier, total cost x multiplier [Milker]").defineInRange("upgrade_milker_energy_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_milker_baseXpCost = builder.comment("Base XP cost per upgrade operation [Milker]").defineInRange("upgrade_milker_base_xp_cost", 0, 0, Integer.MAX_VALUE);
            this.upgrade_milker_xp_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Milker]").define("upgrade_milker_xp_distance_multiplier", true);
            this.upgrade_milker_xpMultiplier = builder.comment("XP Multiplier, total cost x multiplier [Milker]").defineInRange("upgrade_milker_xp_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_milker_dustColor = builder.comment("Dust Color Required to do action [Milker]").defineInRange("upgrade_milker_dust_color", -1, -1, Integer.MAX_VALUE);
            this.upgrade_milker_baseDustAmount = builder.comment("Base Dust amount needed per upgrade operation [Milker]").defineInRange("upgrade_milker_base_dust_amount", 0, 0, Integer.MAX_VALUE);
            this.upgrade_milker_dust_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Milker]").define("upgrade_milker_dust_distance_multiplier", true);
            this.upgrade_milker_dustMultiplier = builder.comment("Dust Amount Multiplier, total cost x multiplier [Milker]").defineInRange("upgrade_milker_dust_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_milker_selectedAllowed = builder.comment("Additional Modifier based on distance of work(breaking a block or picking up items as an example) from pedestal [Milker]").define("upgrade_milker_selected_allowed", false);
            this.upgrade_milker_selectedMultiplier = builder.comment("Modifier Amount, Distance x Modifier + Other 'Energy' BaseCost (this is the 'total cost' formula) [Milker]").defineInRange("upgrade_milker_selected_multiplier", 1.0, 0.0, 2.147483647E9);
            builder.pop();
            builder.comment("Mob Breeder Configs").push("Mob_Breeder_Configs");
            this.breeder_DamageTools = builder.comment("Mob Breeder Damages Inserted Tools").define("breeder_damages_tools", false);
            this.upgrade_breeder_baseEnergyCost = builder.comment("Base RF cost per upgrade operation [Mob Breeder]").defineInRange("upgrade_breeder_base_energy_cost", 0, 0, Integer.MAX_VALUE);
            this.upgrade_breeder_energy_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Mob Breeder]").define("upgrade_breeder_energy_distance_multiplier", true);
            this.upgrade_breeder_energyMultiplier = builder.comment("Energy Multiplier, total cost x multiplier [Mob Breeder]").defineInRange("upgrade_breeder_energy_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_breeder_baseXpCost = builder.comment("Base XP cost per upgrade operation [Mob Breeder]").defineInRange("upgrade_breeder_base_xp_cost", 0, 0, Integer.MAX_VALUE);
            this.upgrade_breeder_xp_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Mob Breeder]").define("upgrade_breeder_xp_distance_multiplier", true);
            this.upgrade_breeder_xpMultiplier = builder.comment("XP Multiplier, total cost x multiplier [Mob Breeder]").defineInRange("upgrade_breeder_xp_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_breeder_dustColor = builder.comment("Dust Color Required to do action [Mob Breeder]").defineInRange("upgrade_breeder_dust_color", -1, -1, Integer.MAX_VALUE);
            this.upgrade_breeder_baseDustAmount = builder.comment("Base Dust amount needed per upgrade operation [Mob Breeder]").defineInRange("upgrade_breeder_base_dust_amount", 0, 0, Integer.MAX_VALUE);
            this.upgrade_breeder_dust_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Mob Breeder]").define("upgrade_breeder_dust_distance_multiplier", true);
            this.upgrade_breeder_dustMultiplier = builder.comment("Dust Amount Multiplier, total cost x multiplier [Mob Breeder]").defineInRange("upgrade_breeder_dust_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_breeder_selectedAllowed = builder.comment("Additional Modifier based on distance of work(breaking a block or picking up items as an example) from pedestal [Mob Breeder]").define("upgrade_breeder_selected_allowed", false);
            this.upgrade_breeder_selectedMultiplier = builder.comment("Modifier Amount, Distance x Modifier + Other 'Energy' BaseCost (this is the 'total cost' formula) [Mob Breeder]").defineInRange("upgrade_breeder_selected_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_breeder_entityBreedingLimit = builder.comment("Checks for Entities in the Selected Area, if they exceed an amount, itll halt all breeding operations.").define("upgrade_breeder_has_limit", false);
            this.upgrade_breeder_entityLimitBreedingCount = builder.comment("If the limiter is true, this is the entity count limit before it stop breeding").defineInRange("upgrade_breeder_limit_count", 20, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Attacker Configs").push("Attacker_Configs");
            this.attacker_DamageTools = builder.comment("Attacker Damages Inserted Tools").define("attacker_damages_tools", false);
            this.upgrade_attacker_baseEnergyCost = builder.comment("Base RF cost per upgrade operation [Attacker]").defineInRange("upgrade_attacker_base_energy_cost", 0, 0, Integer.MAX_VALUE);
            this.upgrade_attacker_energy_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Attacker]").define("upgrade_attacker_energy_distance_multiplier", true);
            this.upgrade_attacker_energyMultiplier = builder.comment("Energy Multiplier, total cost x multiplier [Attacker]").defineInRange("upgrade_attacker_energy_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_attacker_baseXpCost = builder.comment("Base XP cost per upgrade operation [Attacker]").defineInRange("upgrade_attacker_base_xp_cost", 0, 0, Integer.MAX_VALUE);
            this.upgrade_attacker_xp_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Attacker]").define("upgrade_attacker_xp_distance_multiplier", true);
            this.upgrade_attacker_xpMultiplier = builder.comment("XP Multiplier, total cost x multiplier [Attacker]").defineInRange("upgrade_attacker_xp_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_attacker_dustColor = builder.comment("Dust Color Required to do action [Attacker]").defineInRange("upgrade_attacker_dust_color", -1, -1, Integer.MAX_VALUE);
            this.upgrade_attacker_baseDustAmount = builder.comment("Base Dust amount needed per upgrade operation [Attacker]").defineInRange("upgrade_attacker_base_dust_amount", 0, 0, Integer.MAX_VALUE);
            this.upgrade_attacker_dust_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Attacker]").define("upgrade_attacker_dust_distance_multiplier", true);
            this.upgrade_attacker_dustMultiplier = builder.comment("Dust Amount Multiplier, total cost x multiplier [Attacker]").defineInRange("upgrade_attacker_dust_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_attacker_selectedAllowed = builder.comment("Additional Modifier based on distance of work(breaking a block or picking up items as an example) from pedestal [Attacker]").define("upgrade_attacker_selected_allowed", false);
            this.upgrade_attacker_selectedMultiplier = builder.comment("Modifier Amount, Distance x Modifier + Other 'Energy' BaseCost (this is the 'total cost' formula) [Attacker]").defineInRange("upgrade_attacker_selected_multiplier", 1.0, 0.0, 2.147483647E9);
            builder.pop();
            builder.comment("Fan Configs").push("Fan_Configs");
            this.upgrade_fan_baseEnergyCost = builder.comment("Base RF cost per upgrade operation [Fan]").defineInRange("upgrade_fan_base_energy_cost", 0, 0, Integer.MAX_VALUE);
            this.upgrade_fan_energy_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Fan]").define("upgrade_fan_energy_distance_multiplier", true);
            this.upgrade_fan_energyMultiplier = builder.comment("Energy Multiplier, total cost x multiplier [Fan]").defineInRange("upgrade_fan_energy_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_fan_baseXpCost = builder.comment("Base XP cost per upgrade operation [Fan]").defineInRange("upgrade_fan_base_xp_cost", 0, 0, Integer.MAX_VALUE);
            this.upgrade_fan_xp_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Fan]").define("upgrade_fan_xp_distance_multiplier", true);
            this.upgrade_fan_xpMultiplier = builder.comment("XP Multiplier, total cost x multiplier [Fan]").defineInRange("upgrade_fan_xp_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_fan_dustColor = builder.comment("Dust Color Required to do action [Fan]").defineInRange("upgrade_fan_dust_color", -1, -1, Integer.MAX_VALUE);
            this.upgrade_fan_baseDustAmount = builder.comment("Base Dust amount needed per upgrade operation [Fan]").defineInRange("upgrade_fan_base_dust_amount", 0, 0, Integer.MAX_VALUE);
            this.upgrade_fan_dust_distance_multiplier = builder.comment("Distance of Block Broken Used as a modifier (Requires selected_allowed = True) [Fan]").define("upgrade_fan_dust_distance_multiplier", true);
            this.upgrade_fan_dustMultiplier = builder.comment("Dust Amount Multiplier, total cost x multiplier [Fan]").defineInRange("upgrade_fan_dust_multiplier", 1.0, 0.0, 2.147483647E9);
            this.upgrade_fan_selectedAllowed = builder.comment("Additional Modifier based on distance of work(breaking a block or picking up items as an example) from pedestal [Fan]").define("upgrade_fan_selected_allowed", false);
            this.upgrade_fan_selectedMultiplier = builder.comment("Modifier Amount, Distance x Modifier + Other 'Energy' BaseCost (this is the 'total cost' formula) [Fan]").defineInRange("upgrade_fan_selected_multiplier", 1.0, 0.0, 2.147483647E9);
            builder.pop();
            builder.comment("Smelter Configs").push("Smelter_Configs");
            this.upgrade_smelter_baseEnergyCost = builder.comment("Base RF cost per tick").defineInRange("upgrade_smelter_base_energy_cost", 20, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("BlastFurnace Configs").push("BlastFurnace_Configs");
            this.upgrade_blast_baseEnergyCost = builder.comment("Base RF cost per tick").defineInRange("upgrade_blast_base_energy_cost", 20, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Smoking Configs").push("Smoking_Configs");
            this.upgrade_smoker_baseEnergyCost = builder.comment("Base RF cost per tick").defineInRange("upgrade_smoker_base_energy_cost", 20, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("RF Generator Configs").push("RFGenerator_Configs");
            this.upgrade_generator_baseEnergyCost = builder.comment("Base RF generation per tick").defineInRange("upgrade_generator_base_energy_production", 20, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Bulk Storage Options").push("Bulk_Storage");
            this.bulkstorage_itemDischarge = builder.comment("Time (In Seconds) for items to Discharge from Bulk Storage (Item)").defineInRange("bulkstorage_item_discharge_time", 5, 1, Integer.MAX_VALUE);
            this.bulkstorage_itemDischarge_toggle = builder.comment("Weather bulk storage discharge is allowed to trigger or not (Item)").define("bulkstorage_item_discharge_toggle", true);
            this.bulkstorage_maxItemStorage = builder.comment("Set Max Item Stacks Allowed in a Package").defineInRange("bulkstorage_item_max_stacks", 54, 1, Integer.MAX_VALUE);
            this.bulkstorage_fluidDischarge = builder.comment("Time (In Seconds) for energy to Discharge from Bulk Storage (Fluid)").defineInRange("bulkstorage_fluid_discharge_time", 5, 1, Integer.MAX_VALUE);
            this.bulkstorage_fluidDischarge_toggle = builder.comment("Weather bulk storage discharge is allowed to trigger or not (Fluid)").define("bulkstorage_fluid_discharge_toggle", true);
            this.bulkstorage_energyDischarge = builder.comment("Time (In Seconds) for energy to Discharge from Bulk Storage (Energy)").defineInRange("bulkstorage_energy_discharge_time", 5, 1, Integer.MAX_VALUE);
            this.bulkstorage_energyDischarge_toggle = builder.comment("Weather bulk storage discharge is allowed to trigger or not (Energy)").define("bulkstorage_energy_discharge_toggle", true);
            this.bulkstorage_xpDischarge = builder.comment("Time (In Seconds) for energy to Discharge from Bulk Storage (XP)").defineInRange("bulkstorage_xp_discharge_time", 5, 1, Integer.MAX_VALUE);
            this.bulkstorage_xpDischarge_toggle = builder.comment("Weather bulk storage discharge is allowed to trigger or not (XP)").define("bulkstorage_xp_discharge_toggle", true);
            this.bulkstorage_dustDischarge = builder.comment("Time (In Seconds) for energy to Discharge from Bulk Storage (Dust)").defineInRange("bulkstorage_dust_discharge_time", 5, 1, Integer.MAX_VALUE);
            this.bulkstorage_dustDischarge_toggle = builder.comment("Weather bulk storage discharge is allowed to trigger or not (Dust)").define("bulkstorage_dust_discharge_toggle", true);
            builder.pop();
        }
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue pedestalRotateItems;
        public final ForgeConfigSpec.BooleanValue pedestalRenderItems;
        public final ForgeConfigSpec.BooleanValue pedestalRenderParticles;
        public final ForgeConfigSpec.BooleanValue pedestalRenderHUD;
        public final ForgeConfigSpec.BooleanValue pedestalRenderUpgrades;
        public final ForgeConfigSpec.BooleanValue pedestalRenderToolSlot;
        public final ForgeConfigSpec.BooleanValue pedestalRenderUpgradeInToolSlot;
        public final ForgeConfigSpec.IntValue pedestalRenderDistance;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Pedestal rendering options").push("Pedestal");
            this.pedestalRotateItems = builder.comment("Should items on pedestal rotate").comment("\u00a7a\u00a7lLOW\u00a7f impact when \u00a7a\u00a7lTRUE").comment("\u00a72\u00a7lLOWEST\u00a7f impact when \u00a7c\u00a7lFALSE").define("Rotate Items", true);
            this.pedestalRenderItems = builder.comment("Should items be rendered on pedestal").comment("\u00a76\u00a7lMEDIUM\u00a7f impact when \u00a7a\u00a7lTRUE").comment("\u00a72\u00a7lLOWEST\u00a7f impact when \u00a7c\u00a7lFALSE").define("Render Items", true);
            this.pedestalRenderParticles = builder.comment("Should pedestals render particles").comment("\u00a7a\u00a7lLOW\u00a7f impact when \u00a7a\u00a7lTRUE").comment("\u00a72\u00a7lLOWEST\u00a7f impact when \u00a7c\u00a7lFALSE").define("Render Particles", true);
            this.pedestalRenderHUD = builder.comment("Should pedestals render HUD elements?").comment("\u00a7a\u00a7lLOW\u00a7f impact when \u00a7a\u00a7lTRUE").comment("\u00a72\u00a7lLOWEST\u00a7f impact when \u00a7c\u00a7lFALSE").define("Render HUD", true);
            this.pedestalRenderUpgrades = builder.comment("Should pedestals render upgrades?").comment("This will prevent upgrades from being rendered").comment("Set to false if you're experiencing client-side lag from Pedestals").comment("\u00a74\u00a7lHIGHEST\u00a7f impact when \u00a7a\u00a7lTRUE").comment("\u00a72\u00a7lLOWEST\u00a7f impact when \u00a7c\u00a7lFALSE").define("Render Upgrades", true);
            this.pedestalRenderToolSlot = builder.comment("Should pedestals render their Tool Slot which is located at the TOP?").comment("\u00a7a\u00a7lLOW\u00a7f impact when \u00a7a\u00a7lTRUE").comment("\u00a72\u00a7lLOWEST\u00a7f impact when \u00a7c\u00a7lFALSE").define("Render Tool Slot", true);
            this.pedestalRenderUpgradeInToolSlot = builder.comment("Should the pedestal upgrades be rendered on TOP instead?").comment("This will prevent the 'Tool Slot' from being rendered").comment("\u00a7a\u00a7lLOW\u00a7f impact when \u00a7c\u00a7lFALSE").comment("\u00a72\u00a7lLOWEST\u00a7f impact when \u00a7a\u00a7lTRUE").define("Render Upgrades in Tool Slot", false);
            this.pedestalRenderDistance = builder.comment("Distance (blocks) away before Pedestal renders").comment("\u00a76\u00a7lMEDIUM\u00a7f impact when on \u00a7c\u00a7l64").comment("\u00a72\u00a7lLOWEST\u00a7f impact when on \u00a7a\u00a7l1").defineInRange("Render Distance", 32, 1, 64);
            builder.pop();
        }
    }
}

