/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Compat.JEI.recipes;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.MowLibUtils.MowLibColorReference;
import com.mowmaster.pedestals.Compat.JEI.JEIPedestalsRecipeTypes;
import com.mowmaster.pedestals.PedestalUtils.References;
import com.mowmaster.pedestals.Recipes.FluidConverterRecipe;
import com.mowmaster.pedestals.Registry.DeferredRegisterItems;
import com.mowmaster.pedestals.Registry.DeferredRegisterTileBlocks;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class FluidConverterRecipeCategory
implements IRecipeCategory<FluidConverterRecipe> {
    private final IDrawable background;
    private final Component localizedName;
    private final IDrawable icon;
    private final ItemStack renderStack = new ItemStack((ItemLike)DeferredRegisterItems.PEDESTAL_UPGRADE_FLUIDCONVERTER.get());

    public FluidConverterRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(new ResourceLocation("pedestals", References.isDustLoaded() ? "textures/gui/jei/fluidconverter.png" : "textures/gui/jei/fluidconverter_nodust.png"), 0, 0, 128, 96);
        this.localizedName = Component.m_237115_((String)"pedestals.jei.fluidconverter");
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)this.renderStack);
    }

    public RecipeType<FluidConverterRecipe> getRecipeType() {
        return JEIPedestalsRecipeTypes.FLUIDCONVERTER_RECIPE;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FluidConverterRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 7, 19).setFluidRenderer(10L, false, 16, 16).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)recipe.getFluidRequired());
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 53, 19).addItemStack(new ItemStack((ItemLike)DeferredRegisterTileBlocks.BLOCK_PEDESTAL.get()).m_41714_((Component)Component.m_237115_((String)"pedestals.fluidconverter.returnedstack")));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 99, 19).addItemStack(recipe.getResultItem());
    }

    public void draw(FluidConverterRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        RenderSystem.enableBlend();
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        MutableComponent energy = Component.m_237115_((String)"pedestals.fluidconverter.energy");
        energy.m_7220_((Component)Component.m_237113_((String)("" + recipe.getEnergyReturned())));
        energy.m_130940_(ChatFormatting.WHITE);
        guiGraphics.m_280430_(fontRenderer, (Component)energy, 10, 44, -1);
        MutableComponent exp = Component.m_237115_((String)"pedestals.fluidconverter.xp");
        exp.m_7220_((Component)Component.m_237113_((String)("" + recipe.getExperienceReturned())));
        exp.m_130940_(ChatFormatting.WHITE);
        guiGraphics.m_280430_(fontRenderer, (Component)exp, 10, 62, -1);
        if (References.isDustLoaded()) {
            DustMagic dustNeeded = recipe.getDustReturned();
            MutableComponent dust = Component.m_237115_((String)"pedestals.fluidconverter.dust");
            if (dustNeeded.getDustColor() > 0) {
                dust = Component.m_237115_((String)("mowlib." + MowLibColorReference.getColorName((int)dustNeeded.getDustColor())));
                dust.m_7220_((Component)Component.m_237113_((String)(": " + dustNeeded.getDustAmount())));
            } else {
                dust.m_7220_((Component)Component.m_237113_((String)("" + dustNeeded.getDustAmount())));
            }
            dust.m_130940_(ChatFormatting.WHITE);
            guiGraphics.m_280430_(fontRenderer, (Component)dust, 10, 80, -1);
        }
    }
}

