/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Blocks.Pedestal;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.mowmaster.mowlib.BlockEntities.MowLibBaseBlockEntity;
import com.mowmaster.mowlib.Items.WorkCards.WorkCardArea;
import com.mowmaster.mowlib.MowLibUtils.MowLibBlockPosUtils;
import com.mowmaster.mowlib.api.DefineLocations.ISelectablePoints;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlock;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlockEntity;
import com.mowmaster.pedestals.Configs.PedestalConfig;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class BasePedestalBlockEntityRenderer
implements BlockEntityRenderer<BasePedestalBlockEntity> {
    private static final ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
    private static BakedModel cachedModel = null;

    public BasePedestalBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(BasePedestalBlockEntity p_112307_, float p_112308_, PoseStack p_112309_, MultiBufferSource p_112310_, int p_112311_, int p_112312_) {
        if (!p_112307_.m_58901_()) {
            AABB aabbCoin;
            Item aabb;
            TextureAtlasSprite whiteTextureSprite;
            int range;
            Direction facing = (Direction)p_112307_.m_58900_().m_61143_((Property)BasePedestalBlock.FACING);
            List<ItemStack> listed = p_112307_.getItemStacks();
            ItemStack stack = p_112307_.getItemInPedestalFirst();
            ItemStack toolStack = p_112307_.getToolStack();
            ItemStack coin = p_112307_.getCoinOnPedestal();
            ItemStack workCard = p_112307_.getWorkCardInPedestal();
            List<BlockPos> linkedLocations = p_112307_.getLinkedLocations();
            BlockPos pos = p_112307_.getPos();
            Level world = p_112307_.m_58904_();
            List<String> hudMessages = p_112307_.getHudLog();
            int renderAugmentType = p_112307_.getRendererType();
            if (p_112307_.getRenderRange()) {
                range = p_112307_.getLinkingRange();
                whiteTextureSprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(new ResourceLocation("pedestals", "util/pedestal_render"));
                aabb = new AABB((double)(pos.m_123341_() - range), (double)(pos.m_123342_() - range), (double)(pos.m_123343_() - range), (double)(pos.m_123341_() + range + 1), (double)(pos.m_123342_() + range + 1), (double)(pos.m_123343_() + range + 1));
                p_112309_.m_85836_();
                this.renderBoundingBox(pos, (AABB)aabb, p_112309_, p_112310_.m_6299_(RenderType.m_110504_()), p_112307_, 1.0f, 0.2f, 0.2f, 1.0f);
                this.renderFaces(whiteTextureSprite, pos, (AABB)aabb, p_112309_, p_112310_.m_6299_(Sheets.m_110792_()), p_112307_, 1.0f, 0.2f, 0.2f, 0.5f);
                p_112309_.m_85849_();
                if (linkedLocations.size() > 0) {
                    ArrayList<BlockPos> resetList = new ArrayList<BlockPos>();
                    p_112309_.m_85836_();
                    for (BlockPos posPoints : linkedLocations) {
                        if (resetList.contains(posPoints) || (aabbCoin = new AABB(posPoints)) == new AABB(BlockPos.f_121853_)) continue;
                        TextureAtlasSprite upgradeTextureSprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(new ResourceLocation("pedestals", "util/pedestal_render_" + (linkedLocations.indexOf(posPoints) + 1)));
                        this.renderBoundingBox(pos, aabbCoin, p_112309_, p_112310_.m_6299_(RenderType.m_110504_()), p_112307_, 0.0f, 0.0f, 1.0f, 1.0f);
                        this.renderFaces(upgradeTextureSprite, pos, aabbCoin, p_112309_, p_112310_.m_6299_(Sheets.m_110792_()), p_112307_, 0.0f, 0.0f, 1.0f, 0.5f);
                        resetList.add(posPoints);
                    }
                    p_112309_.m_85849_();
                }
            } else {
                linkedLocations.clear();
            }
            if (p_112307_.getRenderRangeUpgrade() && !coin.m_41619_()) {
                range = 0;
                aabb = coin.m_41720_();
                if (aabb instanceof ItemUpgradeBase) {
                    ItemUpgradeBase upgrade = (ItemUpgradeBase)aabb;
                    range = upgrade.getUpgradeWorkRange(coin);
                }
                if (range > 0) {
                    whiteTextureSprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(new ResourceLocation("pedestals", "util/pedestal_render"));
                    aabb = new AABB((double)(pos.m_123341_() - range), (double)(pos.m_123342_() - range), (double)(pos.m_123343_() - range), (double)(pos.m_123341_() + range + 1), (double)(pos.m_123342_() + range + 1), (double)(pos.m_123343_() + range + 1));
                    p_112309_.m_85836_();
                    this.renderBoundingBox(pos, (AABB)aabb, p_112309_, p_112310_.m_6299_(RenderType.m_110504_()), p_112307_, 0.2f, 0.2f, 1.0f, 1.0f);
                    this.renderFaces(whiteTextureSprite, pos, (AABB)aabb, p_112309_, p_112310_.m_6299_(Sheets.m_110792_()), p_112307_, 0.2f, 0.2f, 1.0f, 0.5f);
                    p_112309_.m_85849_();
                    Item item = workCard.m_41720_();
                    if (item instanceof WorkCardArea) {
                        WorkCardArea workCardArea = (WorkCardArea)item;
                        p_112309_.m_85836_();
                        WorkCardArea.getAABBIfDefined((ItemStack)workCard).ifPresent(workCardAABB -> {
                            AABB expandedWorkCardAABB = workCardAABB.m_82363_(1.0, 1.0, 1.0);
                            boolean inSelectedInRange = MowLibBlockPosUtils.selectedAreaWithinRange((MowLibBaseBlockEntity)p_112307_, (int)((ItemUpgradeBase)coin.m_41720_()).getUpgradeWorkRange(coin));
                            TextureAtlasSprite upgradeTextureSprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(new ResourceLocation("pedestals", "util/upgrade_render"));
                            this.renderBoundingBox(pos, expandedWorkCardAABB, p_112309_, p_112310_.m_6299_(RenderType.m_110504_()), p_112307_, inSelectedInRange ? 0.0f : 1.0f, inSelectedInRange ? 1.0f : 0.0f, 0.0f, 1.0f);
                            this.renderFaces(upgradeTextureSprite, pos, expandedWorkCardAABB, p_112309_, p_112310_.m_6299_(Sheets.m_110792_()), p_112307_, inSelectedInRange ? 0.0f : 1.0f, inSelectedInRange ? 1.0f : 0.0f, 0.0f, 0.5f);
                        });
                        p_112309_.m_85849_();
                    }
                    if (workCard.m_41720_() instanceof ISelectablePoints && !MowLibBlockPosUtils.hasTwoPointsSelected((ItemStack)workCard)) {
                        p_112309_.m_85836_();
                        List locations = MowLibBlockPosUtils.readBlockPosListFromNBT((ItemStack)workCard);
                        if (locations.size() > 0) {
                            for (BlockPos posPoints : locations) {
                                aabbCoin = new AABB(posPoints);
                                if (aabbCoin == new AABB(BlockPos.f_121853_)) continue;
                                Boolean inSelectedInRange = MowLibBlockPosUtils.selectedPointWithinRange((MowLibBaseBlockEntity)p_112307_, (BlockPos)posPoints, (int)((ItemUpgradeBase)coin.m_41720_()).getUpgradeWorkRange(coin));
                                TextureAtlasSprite upgradeTextureSprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(new ResourceLocation("pedestals", "util/upgrade_render"));
                                this.renderBoundingBox(pos, aabbCoin, p_112309_, p_112310_.m_6299_(RenderType.m_110504_()), p_112307_, inSelectedInRange != false ? 0.0f : 1.0f, inSelectedInRange != false ? 1.0f : 0.0f, 0.0f, 1.0f);
                                this.renderFaces(upgradeTextureSprite, pos, aabbCoin, p_112309_, p_112310_.m_6299_(Sheets.m_110792_()), p_112307_, inSelectedInRange != false ? 0.0f : 1.0f, inSelectedInRange != false ? 1.0f : 0.0f, 0.0f, 0.5f);
                            }
                        }
                        p_112309_.m_85849_();
                    }
                }
            }
            if (renderAugmentType != 6) {
                if (facing == Direction.UP) {
                    BasePedestalBlockEntityRenderer.renderTileItems(world, p_112309_, p_112310_, listed, coin, toolStack, p_112311_, p_112312_, renderAugmentType, hudMessages);
                }
                if (facing == Direction.DOWN) {
                    p_112309_.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                    p_112309_.m_252880_(0.0f, -1.0f, 0.0f);
                    p_112309_.m_252880_(-1.0f, 0.0f, 0.0f);
                    BasePedestalBlockEntityRenderer.renderTileItems(world, p_112309_, p_112310_, listed, coin, toolStack, p_112311_, p_112312_, renderAugmentType, hudMessages);
                }
                if (facing == Direction.NORTH) {
                    p_112309_.m_252781_(Axis.f_252529_.m_252977_(270.0f));
                    p_112309_.m_252880_(0.0f, -1.0f, 0.0f);
                    BasePedestalBlockEntityRenderer.renderTileItems(world, p_112309_, p_112310_, listed, coin, toolStack, p_112311_, p_112312_, renderAugmentType, hudMessages);
                }
                if (facing == Direction.EAST) {
                    p_112309_.m_252781_(Axis.f_252403_.m_252977_(270.0f));
                    p_112309_.m_252880_(-1.0f, 0.0f, 0.0f);
                    BasePedestalBlockEntityRenderer.renderTileItems(world, p_112309_, p_112310_, listed, coin, toolStack, p_112311_, p_112312_, renderAugmentType, hudMessages);
                }
                if (facing == Direction.SOUTH) {
                    p_112309_.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                    p_112309_.m_252880_(0.0f, 0.0f, -1.0f);
                    BasePedestalBlockEntityRenderer.renderTileItems(world, p_112309_, p_112310_, listed, coin, toolStack, p_112311_, p_112312_, renderAugmentType, hudMessages);
                }
                if (facing == Direction.WEST) {
                    p_112309_.m_252781_(Axis.f_252403_.m_252977_(90.0f));
                    p_112309_.m_252880_(0.0f, -1.0f, 0.0f);
                    BasePedestalBlockEntityRenderer.renderTileItems(world, p_112309_, p_112310_, listed, coin, toolStack, p_112311_, p_112312_, renderAugmentType, hudMessages);
                }
            }
        }
    }

    private static void renderCoinAndTool(Level worldIn, PoseStack poseStack, MultiBufferSource multiBufferSource, ItemStack coin, ItemStack toolStack, int p_112311_, int p_112312_) {
        boolean renderUpgrades = (Boolean)PedestalConfig.CLIENT.pedestalRenderUpgrades.get();
        boolean renderUpgradesInToolSlot = (Boolean)PedestalConfig.CLIENT.pedestalRenderUpgradeInToolSlot.get();
        if (renderUpgradesInToolSlot) {
            if (renderUpgrades) {
                BasePedestalBlockEntityRenderer.renderTool(worldIn, coin, poseStack, multiBufferSource, p_112311_, p_112312_);
            }
        } else {
            boolean renderToolSlot;
            if (renderUpgrades) {
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, poseStack, multiBufferSource, 0.5f, 0.475f, 0.3125f, 0.0f, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, poseStack, multiBufferSource, 0.3125f, 0.475f, 0.5f, 90.0f, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, poseStack, multiBufferSource, 0.5f, 0.475f, 0.6875f, 180.0f, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderCoin(worldIn, coin, poseStack, multiBufferSource, 0.6875f, 0.475f, 0.5f, 270.0f, p_112311_, p_112312_);
            }
            if (renderToolSlot = ((Boolean)PedestalConfig.CLIENT.pedestalRenderToolSlot.get()).booleanValue()) {
                BasePedestalBlockEntityRenderer.renderTool(worldIn, toolStack, poseStack, multiBufferSource, p_112311_, p_112312_);
            }
        }
    }

    private static void renderHUD(PoseStack poseStack, MultiBufferSource multiBufferSource, List<String> messages) {
        boolean renderHUD = (Boolean)PedestalConfig.CLIENT.pedestalRenderHUD.get();
        if (renderHUD && messages.size() > 0) {
            BasePedestalBlockEntityRenderer.renderPedestalsHUD(poseStack, multiBufferSource, messages, -0.75f, 2.25f, 0.5f, 180, 0);
            BasePedestalBlockEntityRenderer.renderPedestalsHUD(poseStack, multiBufferSource, messages, 1.5f, 2.25f, 0.5f, 180, 180);
        }
    }

    public static void renderTileItems(Level worldIn, PoseStack poseStack, MultiBufferSource multiBufferSource, List<ItemStack> item, ItemStack coin, ItemStack toolStack, int p_112311_, int p_112312_, int renderAugmentType, List<String> messages) {
        switch (renderAugmentType) {
            case 1: 
            case 3: {
                BasePedestalBlockEntityRenderer.renderCoinAndTool(worldIn, poseStack, multiBufferSource, coin, toolStack, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderHUD(poseStack, multiBufferSource, messages);
                break;
            }
            case 2: 
            case 4: {
                BasePedestalBlockEntityRenderer.renderItemsRotating(worldIn, poseStack, multiBufferSource, item, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderHUD(poseStack, multiBufferSource, messages);
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            default: {
                BasePedestalBlockEntityRenderer.renderItemsRotating(worldIn, poseStack, multiBufferSource, item, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderCoinAndTool(worldIn, poseStack, multiBufferSource, coin, toolStack, p_112311_, p_112312_);
                BasePedestalBlockEntityRenderer.renderHUD(poseStack, multiBufferSource, messages);
            }
        }
    }

    private static void renderItemsRotating(Level worldIn, PoseStack posStack, MultiBufferSource buffers, List<ItemStack> listed, int light, int overlay) {
        boolean renderItems = (Boolean)PedestalConfig.CLIENT.pedestalRenderItems.get();
        if (renderItems) {
            int stacks = listed.size();
            boolean rotateEnabled = (Boolean)PedestalConfig.CLIENT.pedestalRotateItems.get();
            if (stacks > 1) {
                posStack.m_85836_();
                double time = worldIn.m_46467_();
                float[] angles = new float[stacks];
                float anglePer = 360.0f / (float)stacks;
                for (int i = 0; i < angles.length; ++i) {
                    angles[i] = anglePer * (float)i + (rotateEnabled ? (float)time : 0.0f);
                }
                float sized = 1.25f;
                float sizedd = 0.25f;
                if (stacks <= 4) {
                    sized = 0.25f;
                    sizedd = 0.05f;
                }
                if (stacks <= 8 && stacks > 4) {
                    sized = 0.5f;
                    sizedd = 0.1f;
                }
                if (stacks <= 12 && stacks > 8) {
                    sized = 0.75f;
                    sizedd = 0.15f;
                }
                if (stacks <= 16 && stacks > 12) {
                    sized = 1.0f;
                    sizedd = 0.2f;
                }
                for (int i = 0; i < stacks; ++i) {
                    posStack.m_85836_();
                    posStack.m_252880_(0.5f, 0.75f, 0.5f);
                    posStack.m_252781_(Axis.f_252436_.m_252977_(angles[i]));
                    posStack.m_252880_(sized, 0.0f, sizedd);
                    posStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                    if (rotateEnabled) {
                        posStack.m_85837_(0.0, 0.075 * Math.sin((time + (double)(i * 10)) / 5.0), 0.0);
                    }
                    ItemStack stack = listed.get(i);
                    Minecraft mc = Minecraft.m_91087_();
                    if (!stack.m_41619_()) {
                        mc.m_91291_().m_269128_(stack, ItemDisplayContext.GROUND, light, overlay, posStack, buffers, worldIn, 0);
                    }
                    posStack.m_85849_();
                }
                posStack.m_85849_();
            } else if (stacks == 1) {
                posStack.m_85836_();
                posStack.m_85837_(0.5, 1.0, 0.5);
                posStack.m_85841_(0.75f, 0.75f, 0.75f);
                long time = System.currentTimeMillis();
                float angle = time / 25L % 360L;
                if (rotateEnabled) {
                    posStack.m_252781_(Axis.f_252436_.m_252977_(angle));
                }
                ItemRenderer renderer = Minecraft.m_91087_().m_91291_();
                BakedModel baked = renderer.m_174264_(listed.get(0), worldIn, null, 0);
                renderer.m_115143_(listed.get(0), ItemDisplayContext.GROUND, true, posStack, buffers, light, overlay, baked);
                posStack.m_85849_();
            }
        }
    }

    public static void renderCoin(Level worldIn, ItemStack itemCoin, PoseStack poseStack, MultiBufferSource bufferSource, float x, float y, float z, float angle, int overlay, int light) {
        if (!itemCoin.m_41619_()) {
            poseStack.m_85836_();
            poseStack.m_252880_(x, y, z);
            poseStack.m_85841_(0.1875f, 0.1875f, 0.1875f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(angle));
            if (cachedModel == null || cachedModel != itemRenderer.m_174264_(itemCoin, worldIn, null, 0)) {
                cachedModel = itemRenderer.m_174264_(itemCoin, worldIn, null, 0);
            }
            itemRenderer.m_115143_(itemCoin, ItemDisplayContext.FIXED, true, poseStack, bufferSource, overlay, light, cachedModel);
            poseStack.m_85849_();
        }
    }

    public static void renderTool(Level worldIn, ItemStack itemTool, PoseStack p_112309_, MultiBufferSource p_112310_, int p_112311_, int p_112312_) {
        if (!itemTool.m_41619_()) {
            p_112309_.m_85836_();
            p_112309_.m_85837_(0.5, 0.75, 0.5);
            p_112309_.m_85841_(0.5f, 0.5f, 0.5f);
            p_112309_.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            p_112309_.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            ItemRenderer renderer = Minecraft.m_91087_().m_91291_();
            BakedModel baked = renderer.m_174264_(itemTool, worldIn, null, 0);
            renderer.m_115143_(itemTool, ItemDisplayContext.FIXED, true, p_112309_, p_112310_, p_112311_, p_112312_, baked);
            p_112309_.m_85849_();
        }
    }

    public void renderBoundingBox(BlockPos pos, AABB aabb, PoseStack matrixStack, VertexConsumer buffer, BasePedestalBlockEntity blockEntity, float red, float green, float blue, float alpha) {
        Matrix4f matrix4f = matrixStack.m_85850_().m_252922_();
        Matrix3f matrix3f = matrixStack.m_85850_().m_252943_();
        float minX = (float)(aabb.f_82288_ - (double)pos.m_123341_());
        float minY = (float)(aabb.f_82289_ - (double)pos.m_123342_());
        float minZ = (float)(aabb.f_82290_ - (double)pos.m_123343_());
        float maxX = (float)(aabb.f_82291_ - (double)pos.m_123341_());
        float maxY = (float)(aabb.f_82292_ - (double)pos.m_123342_());
        float maxZ = (float)(aabb.f_82293_ - (double)pos.m_123343_());
        buffer.m_252986_(matrix4f, minX, minY, maxZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, minY, maxZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, minY, minZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, minY, minZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, minY, minZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, minY, maxZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, minY, minZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, minY, maxZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, maxY, maxZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, maxY, maxZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, maxY, minZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, maxY, minZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, maxY, minZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, maxY, maxZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, maxY, minZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, maxY, maxZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, minY, minZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, maxY, minZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, minY, maxZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, maxY, maxZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, minY, maxZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, maxY, maxZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, minY, minZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, maxY, minZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
    }

    public void renderFaces(TextureAtlasSprite sprite, BlockPos pos, AABB aabb, PoseStack matrixStack, VertexConsumer buffer, BasePedestalBlockEntity blockEntity, float red, float green, float blue, float alpha) {
        Matrix4f matrix4f = matrixStack.m_85850_().m_252922_();
        float minX = (float)(aabb.f_82288_ - (double)pos.m_123341_());
        float minY = (float)(aabb.f_82289_ - (double)pos.m_123342_());
        float minZ = (float)(aabb.f_82290_ - (double)pos.m_123343_());
        float maxX = (float)(aabb.f_82291_ - (double)pos.m_123341_());
        float maxY = (float)(aabb.f_82292_ - (double)pos.m_123342_());
        float maxZ = (float)(aabb.f_82293_ - (double)pos.m_123343_());
        float minU = sprite.m_118409_();
        float maxU = sprite.m_118410_();
        float minV = sprite.m_118411_();
        float maxV = sprite.m_118412_();
        int uvBrightness = 240;
        buffer.m_252986_(matrix4f, minX - 0.01f, minY, maxZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX - 0.01f, maxY, maxZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX - 0.01f, maxY, minZ).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX - 0.01f, minY, minZ).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX + 0.01f, minY, minZ).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX + 0.01f, maxY, minZ).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX + 0.01f, maxY, maxZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX + 0.01f, minY, maxZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX + 0.01f, minY, minZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX + 0.01f, maxY, minZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX + 0.01f, maxY, maxZ).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX + 0.01f, minY, maxZ).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX - 0.01f, minY, maxZ).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX - 0.01f, maxY, maxZ).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX - 0.01f, maxY, minZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX - 0.01f, minY, minZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, maxY, minZ - 0.01f).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, maxY, minZ - 0.01f).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, minY, minZ - 0.01f).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, minY, minZ - 0.01f).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, minY, minZ + 0.01f).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, minY, minZ + 0.01f).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, maxY, minZ + 0.01f).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, maxY, minZ + 0.01f).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, minY, maxZ + 0.01f).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, minY, maxZ + 0.01f).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, maxY, maxZ + 0.01f).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, maxY, maxZ + 0.01f).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, maxY, maxZ - 0.01f).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, maxY, maxZ - 0.01f).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, minY, maxZ - 0.01f).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, minY, maxZ - 0.01f).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, minY - 0.01f, minZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, minY - 0.01f, maxZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, minY - 0.01f, maxZ).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, minY - 0.01f, minZ).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, minY + 0.01f, minZ).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, minY + 0.01f, maxZ).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, minY + 0.01f, maxZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, minY + 0.01f, minZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, maxY + 0.01f, minZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, maxY + 0.01f, maxZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, maxY + 0.01f, maxZ).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, maxY + 0.01f, minZ).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, maxY - 0.01f, minZ).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, maxY - 0.01f, maxZ).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, maxY - 0.01f, maxZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, maxY - 0.01f, minZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
    }

    private static void renderPedestalsHUD(PoseStack matrixStack, MultiBufferSource buffer, List<String> messages, float x, float y, float z, int angleX, int angleY) {
        matrixStack.m_85836_();
        matrixStack.m_252880_(x, y, z);
        float f3 = 0.025f;
        matrixStack.m_85841_(f3, f3, f3);
        matrixStack.m_252781_(new Quaternionf((Quaternionfc)Axis.f_252529_.m_252977_((float)angleX)));
        matrixStack.m_252781_(new Quaternionf((Quaternionfc)Axis.f_252436_.m_252977_((float)angleY)));
        Font fontrenderer = Minecraft.m_91087_().f_91062_;
        int lines = 11;
        int currenty = 7;
        int height = 10;
        int logsize = messages.size();
        int i = 0;
        float xF = 0.0f;
        float yF = 0.0f;
        for (String s : messages) {
            if (i >= logsize - lines && currenty + height <= 124) {
                String prefix = "";
                fontrenderer.m_271703_(fontrenderer.m_92834_(prefix + s, 115), xF, yF, 7, false, matrixStack.m_85850_().m_252922_(), buffer, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
                currenty += height;
                yF += 10.0f;
            }
            ++i;
        }
        matrixStack.m_85849_();
    }

    public boolean shouldRenderOffScreen(BasePedestalBlockEntity p_112306_) {
        return p_112306_.getRenderRange() || p_112306_.getRenderRangeUpgrade();
    }

    public boolean shouldRender(BasePedestalBlockEntity blockEntity, @NotNull Vec3 playerPos) {
        Vec3 blockPos = Vec3.m_82512_((Vec3i)blockEntity.m_58899_());
        int renderDistance = (Integer)PedestalConfig.CLIENT.pedestalRenderDistance.get();
        return blockPos.m_82509_((Position)playerPos, (double)renderDistance);
    }
}

