/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.pedestals.Blocks.Pedestal;

import com.mowmaster.mowlib.BlockEntities.MowLibBaseBlockEntity;
import com.mowmaster.mowlib.BlockEntities.MowLibBaseFilterableBlockEntity;
import com.mowmaster.mowlib.Capabilities.Dust.CapabilityDust;
import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.Capabilities.Dust.IDustHandler;
import com.mowmaster.mowlib.Capabilities.Experience.CapabilityExperience;
import com.mowmaster.mowlib.Capabilities.Experience.IExperienceStorage;
import com.mowmaster.mowlib.MowLibUtils.MowLibBlockPosUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibColorReference;
import com.mowmaster.mowlib.MowLibUtils.MowLibFakePlayer;
import com.mowmaster.mowlib.MowLibUtils.MowLibItemUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibMessageUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibOwnerUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibXpUtils;
import com.mowmaster.mowlib.Networking.MowLibPacketHandler;
import com.mowmaster.mowlib.Networking.MowLibPacketParticles;
import com.mowmaster.mowlib.api.TransportAndStorage.IFilterItem;
import com.mowmaster.pedestals.Blocks.Pedestal.BasePedestalBlock;
import com.mowmaster.pedestals.Configs.PedestalConfig;
import com.mowmaster.pedestals.Items.Augments.AugmentRenderDiffuser;
import com.mowmaster.pedestals.Items.Augments.AugmentTieredCapacity;
import com.mowmaster.pedestals.Items.Augments.AugmentTieredRange;
import com.mowmaster.pedestals.Items.Augments.AugmentTieredSpeed;
import com.mowmaster.pedestals.Items.Augments.AugmentTieredStorage;
import com.mowmaster.pedestals.Items.MechanicalOnlyStorage.BaseEnergyBulkStorageItem;
import com.mowmaster.pedestals.Items.MechanicalOnlyStorage.BaseFluidBulkStorageItem;
import com.mowmaster.pedestals.Items.MechanicalOnlyStorage.BaseXpBulkStorageItem;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.IPedestalUpgrade;
import com.mowmaster.pedestals.Items.Upgrades.Pedestal.ItemUpgradeBase;
import com.mowmaster.pedestals.PedestalUtils.References;
import com.mowmaster.pedestals.Registry.DeferredBlockEntityTypes;
import com.mowmaster.pedestals.Registry.DeferredRegisterItems;
import com.mowmaster.pedestals.Registry.DeferredRegisterTileBlocks;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class BasePedestalBlockEntity
extends MowLibBaseFilterableBlockEntity {
    private final ItemStackHandler itemHandler = this.createItemHandlerPedestal();
    private final LazyOptional<IItemHandler> itemCapability = LazyOptional.of(() -> this.itemHandler);
    private final IEnergyStorage energyHandler = this.createEnergyHandler();
    private final LazyOptional<IEnergyStorage> energyCapability = LazyOptional.of(() -> this.energyHandler);
    private final IFluidHandler fluidHandler = this.createFluidHandler();
    private final LazyOptional<IFluidHandler> fluidCapability = LazyOptional.of(() -> this.fluidHandler);
    private final IExperienceStorage experienceHandler = this.createExperienceHandler();
    private final LazyOptional<IExperienceStorage> experienceCapability = LazyOptional.of(() -> this.experienceHandler);
    private final IDustHandler dustHandler = this.createDustHandler();
    private final LazyOptional<IDustHandler> dustCapability = LazyOptional.of(() -> this.dustHandler);
    private final List<ItemStack> stacksList = new ArrayList<ItemStack>();
    private MobEffectInstance storedPotionEffect = null;
    private int storedPotionEffectDuration = 0;
    private int storedEnergy = 0;
    private FluidStack storedFluid = FluidStack.EMPTY;
    private int storedExperience = 0;
    private DustMagic storedDust = DustMagic.EMPTY;
    private final ItemStackHandler privateItems = this.createPrivateItemHandler();
    private WeakReference<FakePlayer> pedestalPlayer;
    private final List<BlockPos> linkedPedestals = new ArrayList<BlockPos>();
    private int storedValueForUpgrades = 0;
    private boolean showRenderRange = false;
    private boolean showRenderRangeUpgrade = false;
    int pedTicker = 0;

    private BasePedestalBlockEntity getPedestal() {
        return this;
    }

    public boolean getRenderRange() {
        return this.showRenderRange;
    }

    public void setRenderRange(boolean setRender) {
        this.showRenderRange = setRender;
        this.update();
    }

    public boolean getRenderRangeUpgrade() {
        return this.showRenderRangeUpgrade;
    }

    public void setRenderRangeUpgrade(boolean setRenderUpgrade) {
        this.showRenderRangeUpgrade = setRenderUpgrade;
        this.update();
    }

    public BasePedestalBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)DeferredBlockEntityTypes.PEDESTAL.get(), p_155229_, p_155230_);
    }

    public void update() {
        BlockState state = this.f_58857_.m_8055_(this.getPos());
        this.f_58857_.m_7260_(this.getPos(), state, state, 3);
        this.m_6596_();
    }

    public void actionOnWorkCardRemovedFromBlockEntity(int type) {
        ItemStack coin;
        Item item;
        super.actionOnWorkCardRemovedFromBlockEntity(type);
        if (this.hasCoin() && (item = (coin = this.getCoinOnPedestal()).m_41720_()) instanceof ItemUpgradeBase) {
            ItemUpgradeBase base = (ItemUpgradeBase)item;
            base.actionOnRemovedFromPedestal(this.getPedestal(), coin);
        }
    }

    public ItemStackHandler createItemHandlerPedestal() {
        return new ItemStackHandler(64){

            public void onLoad() {
                super.onLoad();
            }

            public void onContentsChanged(int slot) {
                BasePedestalBlockEntity.this.update();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                IFilterItem filter = BasePedestalBlockEntity.this.getIFilterItem();
                if (filter == null || !filter.getFilterDirection().insert()) {
                    return true;
                }
                return filter.canAcceptItems(BasePedestalBlockEntity.this.getFilterInBlockEntity(), stack);
            }

            public int getSlots() {
                int baseSlots = (Integer)PedestalConfig.COMMON.pedestal_baseItemStacks.get();
                int additionalSlots = BasePedestalBlockEntity.this.getItemSlotIncreaseFromStorage();
                return baseSlots + additionalSlots;
            }

            public int getStackLimit(int slot, @Nonnull ItemStack stack) {
                IFilterItem filter = BasePedestalBlockEntity.this.getIFilterItem();
                if (filter == null || !filter.getFilterDirection().insert()) {
                    return super.getStackLimit(slot, stack);
                }
                return filter.canAcceptCountItems((MowLibBaseBlockEntity)BasePedestalBlockEntity.this.getPedestal(), BasePedestalBlockEntity.this.getFilterInBlockEntity(), stack.m_41741_(), BasePedestalBlockEntity.this.getSlotSizeLimit(), stack);
            }

            public int getSlotLimit(int slot) {
                return super.getSlotLimit(slot);
            }

            @Nonnull
            public ItemStack getStackInSlot(int slot) {
                return super.getStackInSlot(slot > this.getSlots() ? 0 : slot);
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return super.insertItem(slot > this.getSlots() ? 0 : slot, stack, simulate);
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                int actualSlot;
                IFilterItem filter = BasePedestalBlockEntity.this.getIFilterItem();
                int n = actualSlot = slot > this.getSlots() ? 0 : slot;
                if (filter == null || !filter.getFilterDirection().extract()) {
                    return super.extractItem(actualSlot, amount, simulate);
                }
                ItemStack stackInSlot = this.getStackInSlot(actualSlot);
                return super.extractItem(actualSlot, Math.min(amount, filter.canAcceptCountItems((MowLibBaseBlockEntity)BasePedestalBlockEntity.this.getPedestal(), BasePedestalBlockEntity.this.getFilterInBlockEntity(), stackInSlot.m_41741_(), BasePedestalBlockEntity.this.getSlotSizeLimit(), stackInSlot)), simulate);
            }
        };
    }

    private ItemStackHandler createPrivateItemHandler() {
        return new ItemStackHandler(20){

            protected void onLoad() {
                if (this.getSlots() < 20) {
                    for (int i = 0; i < this.getSlots(); ++i) {
                        BasePedestalBlockEntity.this.stacksList.add(i, this.getStackInSlot(i));
                    }
                    this.setSize(20);
                    for (int j = 0; j < BasePedestalBlockEntity.this.stacksList.size(); ++j) {
                        this.setStackInSlot(j, BasePedestalBlockEntity.this.stacksList.get(j));
                    }
                }
                super.onLoad();
            }

            protected void onContentsChanged(int slot) {
                if (BasePedestalBlockEntity.this.stacksList.size() <= 0) {
                    BasePedestalBlockEntity.this.update();
                }
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return switch (slot) {
                    case 0 -> {
                        if (stack.m_41720_() instanceof IPedestalUpgrade && !BasePedestalBlockEntity.this.hasCoin()) {
                            yield true;
                        }
                        yield false;
                    }
                    case 1 -> {
                        if (stack.m_150930_((Item)DeferredRegisterItems.AUGMENT_PEDESTAL_ROUNDROBIN.get()) && !BasePedestalBlockEntity.this.hasRRobin()) {
                            yield true;
                        }
                        yield false;
                    }
                    case 2 -> {
                        if (stack.m_150930_((Item)DeferredRegisterItems.AUGMENT_PEDESTAL_RENDERDIFFUSER.get()) && !BasePedestalBlockEntity.this.hasRenderAugment()) {
                            yield true;
                        }
                        yield false;
                    }
                    case 3 -> {
                        if (stack.m_150930_((Item)DeferredRegisterItems.AUGMENT_PEDESTAL_NOCOLLIDE.get()) && !BasePedestalBlockEntity.this.hasNoCollide()) {
                            yield true;
                        }
                        yield false;
                    }
                    case 4 -> BasePedestalBlockEntity.this.canInsertSpeedAugment(stack);
                    case 5 -> BasePedestalBlockEntity.this.canInsertAugmentCapacity(stack);
                    case 6 -> BasePedestalBlockEntity.this.canInsertAugmentStorage(stack);
                    case 7 -> BasePedestalBlockEntity.this.canInsertAugmentRange(stack);
                    case 8 -> BasePedestalBlockEntity.this.canInsertTool(stack);
                    default -> false;
                };
            }
        };
    }

    public IFluidHandler createFluidHandler() {
        return new IFluidHandler(){

            @Nonnull
            public FluidStack getFluidInTank(int i) {
                return BasePedestalBlockEntity.this.storedFluid;
            }

            public int getTanks() {
                return 1;
            }

            @Nonnull
            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                if (resource.isEmpty() || !resource.isFluidEqual(BasePedestalBlockEntity.this.storedFluid)) {
                    return FluidStack.EMPTY;
                }
                return this.drain(resource.getAmount(), action);
            }

            @Nonnull
            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction fluidAction) {
                IFilterItem filter = BasePedestalBlockEntity.this.getIFilterItem();
                int maxDrainPostFilter = filter != null && filter.getFilterDirection().extract() ? Math.min(filter.canAcceptCountFluids((MowLibBaseBlockEntity)BasePedestalBlockEntity.this.getPedestal(), BasePedestalBlockEntity.this.getFilterInBlockEntity(), BasePedestalBlockEntity.this.getFluidCapacity(), BasePedestalBlockEntity.this.spaceForFluid(), BasePedestalBlockEntity.this.storedFluid), maxDrain) : maxDrain;
                int fluidDrained = Math.min(maxDrainPostFilter, BasePedestalBlockEntity.this.storedFluid.getAmount());
                FluidStack returnFluidStack = new FluidStack(BasePedestalBlockEntity.this.storedFluid, fluidDrained);
                if (fluidAction.execute() && fluidDrained > 0) {
                    BasePedestalBlockEntity.this.storedFluid.shrink(fluidDrained);
                    BasePedestalBlockEntity.this.update();
                }
                return returnFluidStack;
            }

            public int getTankCapacity(int i) {
                int baseFluidStorage = (Integer)PedestalConfig.COMMON.pedestal_baseFluidStorage.get();
                int additionalFluidStorage = BasePedestalBlockEntity.this.getFluidAmountIncreaseFromStorage();
                return baseFluidStorage + additionalFluidStorage;
            }

            public boolean isFluidValid(int i, @Nonnull FluidStack fluidStack) {
                IFilterItem filter = BasePedestalBlockEntity.this.getIFilterItem();
                if (filter == null || !filter.getFilterDirection().insert()) {
                    return BasePedestalBlockEntity.this.storedFluid.isEmpty() || BasePedestalBlockEntity.this.storedFluid.isFluidEqual(fluidStack);
                }
                return filter.canAcceptFluids(BasePedestalBlockEntity.this.getFilterInBlockEntity(), fluidStack);
            }

            public int fill(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
                if (fluidStack.isEmpty() || !this.isFluidValid(0, fluidStack) || !BasePedestalBlockEntity.this.storedFluid.isEmpty() && !BasePedestalBlockEntity.this.storedFluid.isFluidEqual(fluidStack)) {
                    return 0;
                }
                IFilterItem filter = BasePedestalBlockEntity.this.getIFilterItem();
                int fluidAmountPostFilter = filter != null && filter.getFilterDirection().insert() ? Math.min(filter.canAcceptCountFluids((MowLibBaseBlockEntity)BasePedestalBlockEntity.this.getPedestal(), BasePedestalBlockEntity.this.getFilterInBlockEntity(), BasePedestalBlockEntity.this.getFluidCapacity(), BasePedestalBlockEntity.this.spaceForFluid(), fluidStack), fluidStack.getAmount()) : fluidStack.getAmount();
                int amountFilled = Math.min(this.getTankCapacity(0) - BasePedestalBlockEntity.this.storedFluid.getAmount(), fluidAmountPostFilter);
                if (fluidAction.execute()) {
                    if (BasePedestalBlockEntity.this.storedFluid.isEmpty()) {
                        BasePedestalBlockEntity.this.storedFluid = new FluidStack(fluidStack, amountFilled);
                    } else {
                        BasePedestalBlockEntity.this.storedFluid.grow(amountFilled);
                    }
                    BasePedestalBlockEntity.this.update();
                }
                return amountFilled;
            }
        };
    }

    public IEnergyStorage createEnergyHandler() {
        return new IEnergyStorage(){

            public int receiveEnergy(int maxReceive, boolean simulate) {
                if (!this.canReceive()) {
                    return 0;
                }
                IFilterItem filter = BasePedestalBlockEntity.this.getIFilterItem();
                int maxReceivePostFilter = filter != null && filter.getFilterDirection().insert() ? filter.canAcceptCountEnergy((MowLibBaseBlockEntity)BasePedestalBlockEntity.this.getPedestal(), BasePedestalBlockEntity.this.getFilterInBlockEntity(), BasePedestalBlockEntity.this.getEnergyCapacity(), BasePedestalBlockEntity.this.spaceForEnergy(), maxReceive) : maxReceive;
                int energyReceived = Math.min(this.getMaxEnergyStored() - this.getEnergyStored(), maxReceivePostFilter);
                if (!simulate) {
                    BasePedestalBlockEntity.this.storedEnergy += energyReceived;
                }
                BasePedestalBlockEntity.this.update();
                return energyReceived;
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                if (!this.canExtract()) {
                    return 0;
                }
                IFilterItem filter = BasePedestalBlockEntity.this.getIFilterItem();
                int maxExtractPostFilter = filter != null && filter.getFilterDirection().extract() ? filter.canAcceptCountEnergy((MowLibBaseBlockEntity)BasePedestalBlockEntity.this.getPedestal(), BasePedestalBlockEntity.this.getFilterInBlockEntity(), BasePedestalBlockEntity.this.getEnergyCapacity(), BasePedestalBlockEntity.this.spaceForEnergy(), maxExtract) : maxExtract;
                int energyExtracted = Math.min(BasePedestalBlockEntity.this.storedEnergy, maxExtractPostFilter);
                if (!simulate) {
                    BasePedestalBlockEntity.this.storedEnergy -= energyExtracted;
                }
                return energyExtracted;
            }

            public int getEnergyStored() {
                return BasePedestalBlockEntity.this.storedEnergy;
            }

            public int getMaxEnergyStored() {
                int baseStorage = (Integer)PedestalConfig.COMMON.pedestal_baseEnergyStorage.get();
                int additionalStorage = BasePedestalBlockEntity.this.getEnergyAmountIncreaseFromStorage();
                return baseStorage + additionalStorage;
            }

            public boolean canExtract() {
                if (BasePedestalBlockEntity.this.hasEnergy()) {
                    IFilterItem filter = BasePedestalBlockEntity.this.getIFilterItem();
                    if (filter == null || !filter.getFilterDirection().extract()) {
                        return true;
                    }
                    return filter.canAcceptEnergy(BasePedestalBlockEntity.this.getFilterInBlockEntity(), 1);
                }
                return false;
            }

            public boolean canReceive() {
                if (BasePedestalBlockEntity.this.hasSpaceForEnergy()) {
                    IFilterItem filter = BasePedestalBlockEntity.this.getIFilterItem();
                    if (filter == null || !filter.getFilterDirection().insert()) {
                        return true;
                    }
                    return filter.canAcceptEnergy(BasePedestalBlockEntity.this.getFilterInBlockEntity(), 1);
                }
                return false;
            }
        };
    }

    public IExperienceStorage createExperienceHandler() {
        return new IExperienceStorage(){

            public int receiveExperience(int maxReceive, boolean simulate) {
                if (!this.canReceive()) {
                    return 0;
                }
                int spaceAvailable = this.getMaxExperienceStored() - this.getExperienceStored();
                IFilterItem filter = BasePedestalBlockEntity.this.getIFilterItem();
                int maxReceivePostFilter = filter != null && filter.getFilterDirection().insert() ? filter.canAcceptCountExperience((MowLibBaseBlockEntity)BasePedestalBlockEntity.this.getPedestal(), BasePedestalBlockEntity.this.getFilterInBlockEntity(), BasePedestalBlockEntity.this.getExperienceCapacity(), BasePedestalBlockEntity.this.spaceForExperience(), maxReceive) : maxReceive;
                int experienceReceived = Math.min(spaceAvailable, maxReceivePostFilter);
                if (!simulate) {
                    BasePedestalBlockEntity.this.storedExperience += experienceReceived;
                }
                BasePedestalBlockEntity.this.update();
                return experienceReceived;
            }

            public int extractExperience(int maxExtract, boolean simulate) {
                if (!this.canExtract()) {
                    return 0;
                }
                IFilterItem filter = BasePedestalBlockEntity.this.getIFilterItem();
                int maxExtractPostFilter = filter != null && filter.getFilterDirection().extract() ? filter.canAcceptCountExperience((MowLibBaseBlockEntity)BasePedestalBlockEntity.this.getPedestal(), BasePedestalBlockEntity.this.getFilterInBlockEntity(), BasePedestalBlockEntity.this.getExperienceCapacity(), BasePedestalBlockEntity.this.spaceForExperience(), maxExtract) : maxExtract;
                int experienceExtracted = Math.min(BasePedestalBlockEntity.this.storedExperience, maxExtractPostFilter);
                if (!simulate) {
                    BasePedestalBlockEntity.this.storedExperience -= experienceExtracted;
                }
                return experienceExtracted;
            }

            public int getExperienceStored() {
                return BasePedestalBlockEntity.this.storedExperience;
            }

            public int getMaxExperienceStored() {
                int convertLevelsToXp = MowLibXpUtils.getExpCountByLevel((int)((Integer)PedestalConfig.COMMON.pedestal_baseXpStorage.get()));
                int convertLevelsToXpAdditional = BasePedestalBlockEntity.this.getXpLevelAmountIncreaseFromStorage() > 0 ? MowLibXpUtils.getExpCountByLevel((int)BasePedestalBlockEntity.this.getXpLevelAmountIncreaseFromStorage()) : 0;
                return convertLevelsToXp + convertLevelsToXpAdditional;
            }

            public boolean canExtract() {
                if (BasePedestalBlockEntity.this.hasExperience()) {
                    IFilterItem filter = BasePedestalBlockEntity.this.getIFilterItem();
                    if (filter == null || !filter.getFilterDirection().extract()) {
                        return true;
                    }
                    return filter.canAcceptExperience(BasePedestalBlockEntity.this.getFilterInBlockEntity(), 1);
                }
                return false;
            }

            public boolean canReceive() {
                if (BasePedestalBlockEntity.this.hasSpaceForExperience()) {
                    IFilterItem filter = BasePedestalBlockEntity.this.getIFilterItem();
                    if (filter == null || !filter.getFilterDirection().insert()) {
                        return true;
                    }
                    return filter.canAcceptExperience(BasePedestalBlockEntity.this.getFilterInBlockEntity(), 1);
                }
                return false;
            }
        };
    }

    public IDustHandler createDustHandler() {
        return new IDustHandler(){

            private void onContentsChanged() {
                BasePedestalBlockEntity.this.update();
            }

            public int getTanks() {
                return 1;
            }

            @NotNull
            public DustMagic getDustMagicInTank(int tank) {
                return BasePedestalBlockEntity.this.storedDust;
            }

            public int getTankCapacity(int tank) {
                int baseStorage = (Integer)PedestalConfig.COMMON.pedestal_baseDustStorage.get();
                int additionalStorage = BasePedestalBlockEntity.this.getDustAmountIncreaseFromStorage();
                return baseStorage + additionalStorage;
            }

            public boolean isDustValid(int tank, @NotNull DustMagic dustIn) {
                IFilterItem filter = BasePedestalBlockEntity.this.getIFilterItem();
                if (filter == null || !filter.getFilterDirection().insert()) {
                    return BasePedestalBlockEntity.this.storedDust.isDustEqualOrEmpty(dustIn);
                }
                return filter.canAcceptDust(BasePedestalBlockEntity.this.getFilterInBlockEntity(), dustIn);
            }

            public int fill(DustMagic dust, IDustHandler.DustAction action) {
                int dustAmountPostFilter;
                if (dust.isEmpty() || !this.isDustValid(0, dust) || !BasePedestalBlockEntity.this.storedDust.isDustEqual(dust)) {
                    return 0;
                }
                IFilterItem filter = BasePedestalBlockEntity.this.getIFilterItem();
                int n = dustAmountPostFilter = filter != null && filter.getFilterDirection().insert() ? Math.min(filter.canAcceptCountDust((MowLibBaseBlockEntity)BasePedestalBlockEntity.this.getPedestal(), BasePedestalBlockEntity.this.getFilterInBlockEntity(), BasePedestalBlockEntity.this.getDustCapacity(), BasePedestalBlockEntity.this.spaceForDust(), dust), dust.getDustAmount()) : dust.getDustAmount();
                if (BasePedestalBlockEntity.this.storedDust.isEmpty()) {
                    int amountFilled = Math.min(this.getTankCapacity(0), dustAmountPostFilter);
                    if (!action.simulate()) {
                        BasePedestalBlockEntity.this.storedDust = new DustMagic(dust.getDustColor(), amountFilled);
                        this.onContentsChanged();
                    }
                    return amountFilled;
                }
                int amountFilled = Math.min(Math.min(this.getTankCapacity(0) - BasePedestalBlockEntity.this.storedDust.getDustAmount(), dustAmountPostFilter), dust.getDustAmount());
                if (!action.simulate() && amountFilled > 0) {
                    BasePedestalBlockEntity.this.storedDust.grow(amountFilled);
                    this.onContentsChanged();
                }
                return amountFilled;
            }

            @NotNull
            public DustMagic drain(DustMagic dust, IDustHandler.DustAction action) {
                if (dust.isEmpty() || !dust.isDustEqual(BasePedestalBlockEntity.this.storedDust)) {
                    return new DustMagic(-1, 0);
                }
                return this.drain(dust.getDustAmount(), action);
            }

            @NotNull
            public DustMagic drain(int maxDrain, IDustHandler.DustAction action) {
                IFilterItem filter = BasePedestalBlockEntity.this.getIFilterItem();
                int maxDrainPostFilter = filter != null && filter.getFilterDirection().extract() ? Math.min(filter.canAcceptCountDust((MowLibBaseBlockEntity)BasePedestalBlockEntity.this.getPedestal(), BasePedestalBlockEntity.this.getFilterInBlockEntity(), BasePedestalBlockEntity.this.getDustCapacity(), BasePedestalBlockEntity.this.spaceForDust(), BasePedestalBlockEntity.this.storedDust), maxDrain) : maxDrain;
                int amountDrained = Math.min(BasePedestalBlockEntity.this.storedDust.getDustAmount(), maxDrainPostFilter);
                DustMagic magic = new DustMagic(BasePedestalBlockEntity.this.storedDust.getDustColor(), amountDrained);
                if (action.execute() && amountDrained > 0) {
                    if (amountDrained >= BasePedestalBlockEntity.this.storedDust.getDustAmount()) {
                        BasePedestalBlockEntity.this.storedDust.setDustAmount(0);
                        BasePedestalBlockEntity.this.storedDust.setDustColor(-1);
                    } else {
                        BasePedestalBlockEntity.this.storedDust.shrink(amountDrained);
                    }
                    this.onContentsChanged();
                }
                return magic;
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemCapability.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyCapability.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCapability.cast();
        }
        if (cap == CapabilityExperience.EXPERIENCE) {
            return this.experienceCapability.cast();
        }
        if (cap == CapabilityDust.DUST_HANDLER) {
            return this.dustCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public WeakReference<FakePlayer> getFakePlayer() {
        return this.pedestalPlayer;
    }

    public void setFakePlayer() {
        this.pedestalPlayer = this.fakePedestalPlayer(this.getPedestal());
        if (this.pedestalPlayer.get() != null) {
            ((FakePlayer)this.pedestalPlayer.get()).m_6034_((double)this.getPos().m_123341_(), (double)this.getPos().m_123342_(), (double)this.getPos().m_123343_());
            ((FakePlayer)this.pedestalPlayer.get()).m_9158_(((FakePlayer)this.pedestalPlayer.get()).m_8963_(), this.getPos(), 0.0f, false, false);
        }
    }

    public WeakReference<FakePlayer> getPedestalPlayer(BasePedestalBlockEntity pedestal) {
        if (pedestal.getFakePlayer() == null || pedestal.getFakePlayer().get() == null) {
            pedestal.setFakePlayer();
        }
        return pedestal.getFakePlayer();
    }

    public void updatePedestalPlayer(BasePedestalBlockEntity pedestal) {
        if (pedestal.getFakePlayer() != null) {
            pedestal.setFakePlayer();
        }
    }

    public WeakReference<FakePlayer> fakePedestalPlayer(BasePedestalBlockEntity pedestal) {
        Level world = pedestal.m_58904_();
        ItemStack upgrade = pedestal.getCoinOnPedestal();
        ItemStack tool = pedestal.getToolStack();
        if (world instanceof ServerLevel) {
            ServerLevel slevel = (ServerLevel)world;
            return new WeakReference<MowLibFakePlayer>(new MowLibFakePlayer(slevel, MowLibOwnerUtils.getPlayerFromStack((ItemStack)upgrade), MowLibOwnerUtils.getPlayerNameFromStack((ItemStack)upgrade), pedestal.getPos(), tool, "[Pedestal_" + pedestal.getPos().m_123341_() + pedestal.getPos().m_123342_() + pedestal.getPos().m_123343_() + "]"));
        }
        return null;
    }

    public void dropInventoryItemsPrivate(Level worldIn, BlockPos pos) {
        super.dropInventoryItemsPrivate(worldIn, pos);
        MowLibItemUtils.dropInventoryItems((Level)worldIn, (BlockPos)pos, (IItemHandler)this.privateItems);
    }

    public void dropInventoryItems(Level worldIn, BlockPos pos) {
        MowLibItemUtils.dropInventoryItems((Level)worldIn, (BlockPos)pos, (IItemHandler)this.itemHandler);
    }

    public void dropLiquidsInWorld(Level worldIn, BlockPos pos) {
        FluidStack inTank = this.fluidHandler.getFluidInTank(0);
        if (inTank.getAmount() > 0) {
            ItemStack toDrop = new ItemStack((ItemLike)DeferredRegisterItems.MECHANICAL_STORAGE_FLUID.get());
            Item item = toDrop.m_41720_();
            if (item instanceof BaseFluidBulkStorageItem) {
                BaseFluidBulkStorageItem droppedItemFluid = (BaseFluidBulkStorageItem)item;
                droppedItemFluid.setFluidStack(toDrop, inTank);
            }
            MowLibItemUtils.spawnItemStack((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)toDrop);
        }
    }

    public void removeEnergyFromBrokenPedestal(Level worldIn, BlockPos pos) {
        if (this.energyHandler.getEnergyStored() > 0) {
            ItemStack toDrop = new ItemStack((ItemLike)DeferredRegisterItems.MECHANICAL_STORAGE_ENERGY.get());
            Item item = toDrop.m_41720_();
            if (item instanceof BaseEnergyBulkStorageItem) {
                BaseEnergyBulkStorageItem droppedItemEnergy = (BaseEnergyBulkStorageItem)item;
                droppedItemEnergy.setEnergy(toDrop, this.energyHandler.getEnergyStored());
            }
            MowLibItemUtils.spawnItemStack((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)toDrop);
        }
    }

    public void dropXPInWorld(Level worldIn, BlockPos pos) {
        if (this.experienceHandler.getExperienceStored() > 0) {
            ItemStack toDrop = new ItemStack((ItemLike)DeferredRegisterItems.MECHANICAL_STORAGE_XP.get());
            Item item = toDrop.m_41720_();
            if (item instanceof BaseXpBulkStorageItem) {
                BaseXpBulkStorageItem droppedItemEnergy = (BaseXpBulkStorageItem)item;
                droppedItemEnergy.setXp(toDrop, this.experienceHandler.getExperienceStored());
            }
            MowLibItemUtils.spawnItemStack((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)toDrop);
        }
    }

    public void dropDustInWorld(Level worldIn, BlockPos pos) {
        if (!this.dustHandler.getDustMagicInTank(0).isEmpty()) {
            ItemStack toDrop = new ItemStack((ItemLike)DeferredRegisterItems.MECHANICAL_STORAGE_DUST.get());
            DustMagic.setDustMagicInStack((ItemStack)toDrop, (DustMagic)this.storedDust);
            MowLibItemUtils.spawnItemStack((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)toDrop);
        }
    }

    public int getStoredValueForUpgrades() {
        return this.storedValueForUpgrades;
    }

    public void setStoredValueForUpgrades(int value) {
        this.storedValueForUpgrades = value;
        this.update();
    }

    public int getNumLinkedPedestals() {
        return this.linkedPedestals.size();
    }

    private void addPedestalLink(BlockPos pos) {
        this.linkedPedestals.add(pos);
        this.update();
    }

    private void removePedestalLink(BlockPos pos) {
        this.linkedPedestals.remove(pos);
        this.update();
    }

    public List<BlockPos> getLinkedLocations() {
        return this.linkedPedestals;
    }

    public int getLinkingRange() {
        int range = (Integer)PedestalConfig.COMMON.pedestal_baseLinkingRange.get();
        return range + this.getRangeIncrease();
    }

    public boolean isPedestalInRange(BlockPos targetPos) {
        return MowLibBlockPosUtils.arePositionsInRange((BlockPos)this.getPos(), (BlockPos)targetPos, (int)this.getLinkingRange());
    }

    public boolean isSamePedestal(BlockPos targetPos) {
        return !this.getPos().equals((Object)targetPos);
    }

    public boolean isAlreadyLinked(BlockPos pos) {
        return this.linkedPedestals.contains(pos);
    }

    public boolean hasSpaceForPedestalLink() {
        return this.linkedPedestals.size() < 8;
    }

    public boolean attemptUpdateLink(BlockPos targetPos, Player player, String successLocalizedMessage) {
        boolean attemptSuccessful = false;
        if (!this.isPedestalInRange(targetPos)) {
            MowLibMessageUtils.messagePopup((Player)player, (ChatFormatting)ChatFormatting.WHITE, (String)"pedestals.tool_link_distance");
        } else if (!this.isSamePedestal(targetPos)) {
            MowLibMessageUtils.messagePopup((Player)player, (ChatFormatting)ChatFormatting.WHITE, (String)"pedestals.tool_link_itsself");
        } else if (this.isAlreadyLinked(targetPos)) {
            attemptSuccessful = true;
            this.removePedestalLink(targetPos);
            MowLibMessageUtils.messagePopup((Player)player, (ChatFormatting)ChatFormatting.WHITE, (String)"pedestals.tool_link_removed");
        } else if (!this.hasSpaceForPedestalLink()) {
            MowLibMessageUtils.messagePopup((Player)player, (ChatFormatting)ChatFormatting.WHITE, (String)"pedestals.tool_link_unsucess");
        } else {
            attemptSuccessful = true;
            this.addPedestalLink(targetPos);
            MowLibMessageUtils.messagePopup((Player)player, (ChatFormatting)ChatFormatting.WHITE, (String)successLocalizedMessage);
        }
        return attemptSuccessful;
    }

    public boolean hasItem() {
        int firstPartialOrNonEmptySlot = 0;
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stackInSlot = this.itemHandler.getStackInSlot(i);
            if (stackInSlot.m_41613_() >= stackInSlot.m_41741_() && !stackInSlot.m_41619_()) continue;
            firstPartialOrNonEmptySlot = i;
            break;
        }
        return !this.itemHandler.getStackInSlot(firstPartialOrNonEmptySlot).m_41619_();
    }

    public Optional<Integer> maybeFirstNonEmptySlot() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i).m_41619_()) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    public boolean hasItemFirst() {
        return this.maybeFirstNonEmptySlot().isPresent();
    }

    public Optional<Integer> maybeLastNonEmptySlot() {
        for (int i = this.itemHandler.getSlots() - 1; i >= 0; --i) {
            if (this.itemHandler.getStackInSlot(i).m_41619_()) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    public Optional<Integer> maybeFirstSlotWithSpaceForMatchingItem(ItemStack stackToMatch) {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stackInSlot = this.itemHandler.getStackInSlot(i);
            if (!stackInSlot.m_41619_() && (stackInSlot.m_41613_() >= stackInSlot.m_41741_() || !ItemHandlerHelper.canItemStacksStack((ItemStack)stackInSlot, (ItemStack)stackToMatch))) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    public boolean hasSpaceForItem(ItemStack stackToMatch) {
        return this.maybeFirstSlotWithSpaceForMatchingItem(stackToMatch).isPresent();
    }

    public ItemStack getItemInPedestal() {
        return this.maybeFirstNonEmptySlot().map(arg_0 -> ((ItemStackHandler)this.itemHandler).getStackInSlot(arg_0)).orElse(ItemStack.f_41583_);
    }

    public ItemStack getMatchingItemInPedestalOrEmptySlot(ItemStack stackToMatch) {
        return this.maybeFirstSlotWithSpaceForMatchingItem(stackToMatch).map(arg_0 -> ((ItemStackHandler)this.itemHandler).getStackInSlot(arg_0)).orElse(ItemStack.f_41583_);
    }

    public ItemStack getItemInPedestalFirst() {
        return this.maybeFirstNonEmptySlot().map(arg_0 -> ((ItemStackHandler)this.itemHandler).getStackInSlot(arg_0)).orElse(ItemStack.f_41583_);
    }

    public int getPedestalSlots() {
        return this.itemHandler.getSlots();
    }

    public List<ItemStack> getItemStacks() {
        ArrayList<ItemStack> listed = new ArrayList<ItemStack>();
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i).m_41619_()) continue;
            listed.add(this.itemHandler.getStackInSlot(i));
        }
        return listed;
    }

    public ItemStack getItemInPedestal(int slot) {
        if (this.itemHandler.getSlots() > slot) {
            return this.itemHandler.getStackInSlot(slot);
        }
        return ItemStack.f_41583_;
    }

    public ItemStack removeItem(int numToRemove, boolean simulate) {
        return this.maybeLastNonEmptySlot().map(slot -> this.itemHandler.extractItem(slot.intValue(), numToRemove, simulate)).orElse(ItemStack.f_41583_);
    }

    public ItemStack removeItemStack(ItemStack stackToRemove, boolean simulate) {
        int matchingSlotNumber = 0;
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)this.itemHandler.getStackInSlot(i), (ItemStack)stackToRemove)) continue;
            matchingSlotNumber = i;
            break;
        }
        return this.itemHandler.extractItem(matchingSlotNumber, stackToRemove.m_41613_(), simulate);
    }

    public ItemStack removeItem(boolean simulate) {
        return this.maybeLastNonEmptySlot().map(slot -> this.itemHandler.extractItem(slot.intValue(), this.itemHandler.getStackInSlot(slot.intValue()).m_41613_(), simulate)).orElse(ItemStack.f_41583_);
    }

    public boolean addItem(ItemStack itemFromBlock, boolean simulate) {
        return this.addItemStack(itemFromBlock, simulate).m_41619_();
    }

    public ItemStack addItemStack(ItemStack itemFromBlock, boolean simulate) {
        return this.maybeFirstSlotWithSpaceForMatchingItem(itemFromBlock).map(slot -> {
            if (this.itemHandler.isItemValid(slot.intValue(), itemFromBlock)) {
                ItemStack returner = this.itemHandler.insertItem(slot.intValue(), itemFromBlock.m_41777_(), simulate);
                if (!simulate) {
                    this.update();
                }
                return returner;
            }
            return itemFromBlock;
        }).orElse(itemFromBlock);
    }

    public int getSlotSizeLimit() {
        return this.maybeFirstNonEmptySlot().map(arg_0 -> ((ItemStackHandler)this.itemHandler).getSlotLimit(arg_0)).orElse(this.itemHandler.getSlotLimit(0));
    }

    public int getItemTransferRate() {
        return (Integer)PedestalConfig.COMMON.pedestal_baseItemTransferRate.get() + this.getItemTransferRateIncreaseFromCapacity();
    }

    public boolean hasFluid() {
        return !this.fluidHandler.getFluidInTank(0).isEmpty();
    }

    public FluidStack getStoredFluid() {
        return this.fluidHandler.getFluidInTank(0);
    }

    public int getFluidCapacity() {
        return this.fluidHandler.getTankCapacity(0);
    }

    public int spaceForFluid() {
        return this.getFluidCapacity() - this.getStoredFluid().getAmount();
    }

    public boolean canAcceptFluid(FluidStack fluidStackIn) {
        return this.fluidHandler.isFluidValid(0, fluidStackIn);
    }

    public FluidStack removeFluid(FluidStack fluidToRemove, IFluidHandler.FluidAction action) {
        return this.fluidHandler.drain(fluidToRemove, action);
    }

    public FluidStack removeFluid(int fluidAmountToRemove, IFluidHandler.FluidAction action) {
        return this.fluidHandler.drain(new FluidStack(this.getStoredFluid().getFluid(), fluidAmountToRemove, this.getStoredFluid().getTag()), action);
    }

    public int addFluid(FluidStack fluidStackIn, IFluidHandler.FluidAction fluidAction) {
        return this.fluidHandler.fill(fluidStackIn, fluidAction);
    }

    public int getFluidTransferRate() {
        int fluidTransferRate = (Integer)PedestalConfig.COMMON.pedestal_baseFluidTransferRate.get();
        int getFluidRateIncrease = this.getFluidTransferRateIncreaseFromCapacity();
        return fluidTransferRate + getFluidRateIncrease;
    }

    public boolean hasEnergy() {
        return this.energyHandler.getEnergyStored() > 0;
    }

    public boolean hasSpaceForEnergy() {
        return this.spaceForEnergy() > 0;
    }

    public int spaceForEnergy() {
        return this.getEnergyCapacity() - this.getStoredEnergy();
    }

    public int getEnergyCapacity() {
        return this.energyHandler.getMaxEnergyStored();
    }

    public int getStoredEnergy() {
        return this.energyHandler.getEnergyStored();
    }

    public int addEnergy(int amountIn, boolean simulate) {
        return this.energyHandler.receiveEnergy(amountIn, simulate);
    }

    public int removeEnergy(int amountOut, boolean simulate) {
        return this.energyHandler.extractEnergy(amountOut, simulate);
    }

    public boolean canAcceptEnergy() {
        return this.energyHandler.canReceive();
    }

    public boolean canSendEnergy() {
        return this.energyHandler.canExtract();
    }

    public int getEnergyTransferRate() {
        int energyTransferRate = (Integer)PedestalConfig.COMMON.pedestal_baseEnergyTransferRate.get();
        int energyTransferRateIncrease = this.getEnergyTransferRateIncreaseFromCapacity();
        return energyTransferRate + energyTransferRateIncrease;
    }

    public boolean hasExperience() {
        return this.experienceHandler.getExperienceStored() > 0;
    }

    public boolean hasSpaceForExperience() {
        return this.spaceForExperience() > 0;
    }

    public int spaceForExperience() {
        return this.getExperienceCapacity() - this.getStoredExperience();
    }

    public int getExperienceCapacity() {
        return this.experienceHandler.getMaxExperienceStored();
    }

    public int getStoredExperience() {
        return this.experienceHandler.getExperienceStored();
    }

    public int addExperience(int amountIn, boolean simulate) {
        return this.experienceHandler.receiveExperience(amountIn, simulate);
    }

    public int removeExperience(int amountOut, boolean simulate) {
        return this.experienceHandler.extractExperience(amountOut, simulate);
    }

    public boolean canAcceptExperience() {
        return this.experienceHandler.canReceive();
    }

    public boolean canSendExperience() {
        return this.experienceHandler.canExtract();
    }

    public int getExperienceTransferRate() {
        int baseValue = (Integer)PedestalConfig.COMMON.pedestal_baseXpTransferRate.get();
        int experienceTransferRateConverted = MowLibXpUtils.getExpCountByLevel((int)baseValue);
        return this.getXpTransferRateIncreaseFromCapacity() > 0 ? MowLibXpUtils.getExpCountByLevel((int)(this.getXpTransferRateIncreaseFromCapacity() + baseValue)) : experienceTransferRateConverted;
    }

    public boolean hasDust() {
        return !this.dustHandler.getDustMagicInTank(0).isEmpty();
    }

    public DustMagic getStoredDust() {
        if (this.hasDust()) {
            return this.dustHandler.getDustMagicInTank(0);
        }
        return DustMagic.EMPTY;
    }

    public int getDustCapacity() {
        return this.dustHandler.getTankCapacity(0);
    }

    public int spaceForDust() {
        return this.getDustCapacity() - this.getStoredDust().getDustAmount();
    }

    public boolean canAcceptDust(DustMagic dustMagicIn) {
        return this.dustHandler.isDustValid(0, dustMagicIn);
    }

    public DustMagic removeDust(DustMagic dustMagicToRemove, IDustHandler.DustAction action) {
        this.update();
        return this.dustHandler.drain(dustMagicToRemove, action);
    }

    public DustMagic removeDust(int dustAmountToRemove, IDustHandler.DustAction action) {
        this.update();
        return this.dustHandler.drain(new DustMagic(this.getStoredDust().getDustColor(), dustAmountToRemove), action);
    }

    public int addDust(DustMagic dustMagicIn, IDustHandler.DustAction action) {
        this.update();
        return this.dustHandler.fill(dustMagicIn, action);
    }

    public int getDustTransferRate() {
        int baseValue = (Integer)PedestalConfig.COMMON.pedestal_baseDustTransferRate.get();
        return this.getDustTransferRateIncreaseFromCapacity() > 0 ? MowLibXpUtils.getExpCountByLevel((int)(this.getDustTransferRateIncreaseFromCapacity() + baseValue)) : baseValue;
    }

    public boolean hasCoin() {
        return !this.privateItems.getStackInSlot(0).m_41619_();
    }

    public ItemStack getCoinOnPedestal() {
        return this.privateItems.getStackInSlot(0);
    }

    public ItemStack removeCoin() {
        return this.privateItems.extractItem(0, 1, false);
    }

    public boolean attemptAddCoin(ItemStack stack, Player player) {
        if (this.privateItems.isItemValid(0, stack)) {
            ItemStack toInsert = stack.m_41620_(1);
            this.privateItems.insertItem(0, toInsert, false);
            IPedestalUpgrade upgrade = (IPedestalUpgrade)toInsert.m_41720_();
            upgrade.actionOnAddedToPedestal(player, this.getPedestal(), toInsert);
            return true;
        }
        return false;
    }

    public void actionOnNeighborBelowChange(BlockPos belowBlock) {
        Item item = this.getCoinOnPedestal().m_41720_();
        if (item instanceof IPedestalUpgrade) {
            IPedestalUpgrade upgrade = (IPedestalUpgrade)item;
            upgrade.actionOnNeighborBelowChange(this.getPedestal(), belowBlock);
        }
    }

    public void actionOnRemovedFromPedestal(int type) {
        Item item;
        if (this.hasCoin() && (item = this.getCoinOnPedestal().m_41720_()) instanceof IPedestalUpgrade) {
            IPedestalUpgrade upgrade = (IPedestalUpgrade)item;
            upgrade.actionOnRemovedFromPedestal(this.getPedestal(), this.getCoinOnPedestal());
        }
    }

    public ItemStack getWorkCard() {
        return this.getWorkCardInPedestal();
    }

    public boolean attemptAddSpeed(ItemStack stack) {
        if (this.privateItems.isItemValid(4, stack)) {
            this.privateItems.insertItem(4, stack.m_41620_(1), false);
            return true;
        }
        return false;
    }

    public ItemStack removeSpeed(int count) {
        return this.privateItems.extractItem(4, count, false);
    }

    public ItemStack removeAllSpeed() {
        return this.removeSpeed(this.numAugmentsSpeed());
    }

    public boolean hasSpeed() {
        return this.numAugmentsSpeed() > 0;
    }

    public int numAugmentsSpeed() {
        return this.privateItems.getStackInSlot(4).m_41613_();
    }

    public ItemStack currentSpeedAugments() {
        return this.privateItems.getStackInSlot(4);
    }

    public boolean sameItem(ItemStack stackCompareTo, ItemStack stackIn) {
        return !stackIn.m_41619_() && stackCompareTo.m_150930_(stackIn.m_41720_());
    }

    public boolean canInsertSpeedAugment(ItemStack itemStack) {
        int allowedInsertAmount = AugmentTieredSpeed.getAllowedInsertAmount(itemStack);
        return allowedInsertAmount > 0 && (!this.hasSpeed() || this.sameItem(itemStack, this.currentSpeedAugments()) && this.numAugmentsSpeed() < allowedInsertAmount);
    }

    public int getTicksReduced() {
        return AugmentTieredSpeed.getTicksReduced(this.currentSpeedAugments()) * this.numAugmentsSpeed();
    }

    public int getCurrentSpeed() {
        return (Integer)PedestalConfig.COMMON.pedestal_maxTicksToTransfer.get() - this.getTicksReduced();
    }

    public boolean attemptAddCapacity(ItemStack stack) {
        if (this.privateItems.isItemValid(5, stack)) {
            this.privateItems.insertItem(5, stack.m_41620_(1), false);
            return true;
        }
        return false;
    }

    public ItemStack removeCapacity(int count) {
        return this.privateItems.extractItem(5, count, false);
    }

    public ItemStack removeAllCapacity() {
        return this.removeCapacity(this.numAugmentsCapacity());
    }

    public boolean hasCapacity() {
        return this.numAugmentsCapacity() > 0;
    }

    public int numAugmentsCapacity() {
        return this.privateItems.getStackInSlot(5).m_41613_();
    }

    public ItemStack currentCapacityAugments() {
        return this.privateItems.getStackInSlot(5);
    }

    public boolean canInsertAugmentCapacity(ItemStack itemStack) {
        int allowedInsertAmount = AugmentTieredCapacity.getAllowedInsertAmount(itemStack);
        return allowedInsertAmount > 0 && (!this.hasCapacity() || this.sameItem(itemStack, this.currentCapacityAugments()) && this.numAugmentsCapacity() < allowedInsertAmount);
    }

    public int getItemTransferRateIncreaseFromCapacity() {
        return AugmentTieredCapacity.getAdditionalItemTransferRatePerItem(this.currentCapacityAugments()) * this.numAugmentsCapacity();
    }

    public int getFluidTransferRateIncreaseFromCapacity() {
        return AugmentTieredCapacity.getAdditionalFluidTransferRatePerItem(this.currentCapacityAugments()) * this.numAugmentsCapacity();
    }

    public int getEnergyTransferRateIncreaseFromCapacity() {
        return AugmentTieredCapacity.getAdditionalEnergyTransferRatePerItem(this.currentCapacityAugments()) * this.numAugmentsCapacity();
    }

    public int getXpTransferRateIncreaseFromCapacity() {
        return AugmentTieredCapacity.getAdditionalXpTransferRatePerItem(this.currentCapacityAugments()) * this.numAugmentsCapacity();
    }

    public int getDustTransferRateIncreaseFromCapacity() {
        return AugmentTieredCapacity.getAdditionalDustTransferRatePerItem(this.currentCapacityAugments()) * this.numAugmentsCapacity();
    }

    public boolean attemptAddStorage(ItemStack stack) {
        if (this.privateItems.isItemValid(6, stack)) {
            this.privateItems.insertItem(6, stack.m_41620_(1), false);
            return true;
        }
        return false;
    }

    public ItemStack removeStorage(int count) {
        return this.privateItems.extractItem(6, count, false);
    }

    public ItemStack removeAllStorage() {
        return this.removeStorage(this.numAugmentsStorage());
    }

    public boolean hasStorage() {
        return this.numAugmentsStorage() > 0;
    }

    public int numAugmentsStorage() {
        return this.privateItems.getStackInSlot(6).m_41613_();
    }

    public ItemStack currentStorageAugments() {
        return this.privateItems.getStackInSlot(6);
    }

    public boolean canInsertAugmentStorage(ItemStack itemStack) {
        int allowedInsertAmount = AugmentTieredStorage.getAllowedInsertAmount(itemStack);
        return allowedInsertAmount > 0 && (!this.hasStorage() || this.sameItem(itemStack, this.currentStorageAugments()) && this.numAugmentsStorage() < allowedInsertAmount);
    }

    public int getItemSlotIncreaseFromStorage() {
        return AugmentTieredStorage.getAdditionalItemStoragePerItem(this.currentStorageAugments()) * this.numAugmentsStorage();
    }

    public int getFluidAmountIncreaseFromStorage() {
        return AugmentTieredStorage.getAdditionalFluidStoragePerItem(this.currentStorageAugments()) * this.numAugmentsStorage();
    }

    public int getEnergyAmountIncreaseFromStorage() {
        return AugmentTieredStorage.getAdditionalEnergyStoragePerItem(this.currentStorageAugments()) * this.numAugmentsStorage();
    }

    public int getXpLevelAmountIncreaseFromStorage() {
        return AugmentTieredStorage.getAdditionalXpStoragePerItem(this.currentStorageAugments()) * this.numAugmentsStorage();
    }

    public int getDustAmountIncreaseFromStorage() {
        return AugmentTieredStorage.getAdditionalDustStoragePerItem(this.currentStorageAugments()) * this.numAugmentsStorage();
    }

    public boolean attemptAddRange(ItemStack stack) {
        if (this.privateItems.isItemValid(7, stack)) {
            this.privateItems.insertItem(7, stack.m_41620_(1), false);
            return true;
        }
        return false;
    }

    public ItemStack removeRange(int count) {
        return this.privateItems.extractItem(7, count, false);
    }

    public ItemStack removeAllRange() {
        return this.removeRange(this.numAugmentsRange());
    }

    public boolean hasRange() {
        return this.numAugmentsRange() > 0;
    }

    public int numAugmentsRange() {
        return this.privateItems.getStackInSlot(7).m_41613_();
    }

    public ItemStack currentRangeAugments() {
        return this.privateItems.getStackInSlot(7);
    }

    public boolean canInsertAugmentRange(ItemStack itemStack) {
        int allowedInsertAmount = AugmentTieredRange.getAllowedInsertAmount(itemStack);
        return allowedInsertAmount > 0 && (!this.hasRange() || this.sameItem(itemStack, this.currentRangeAugments()) && this.numAugmentsRange() < allowedInsertAmount);
    }

    public int getRangeIncrease() {
        return AugmentTieredRange.getRangeIncreasePerItem(this.currentRangeAugments()) * this.numAugmentsRange();
    }

    public boolean isAllowedTool(ItemStack toolIn) {
        if (toolIn.m_41720_() instanceof DiggerItem) {
            return true;
        }
        if (toolIn.m_41720_() instanceof SwordItem) {
            return true;
        }
        if (toolIn.m_41720_() instanceof ProjectileWeaponItem) {
            return true;
        }
        if (toolIn.m_41720_() instanceof TridentItem) {
            return true;
        }
        if (toolIn.canPerformAction(ToolActions.PICKAXE_DIG)) {
            return true;
        }
        if (toolIn.canPerformAction(ToolActions.AXE_DIG)) {
            return true;
        }
        if (toolIn.canPerformAction(ToolActions.SHOVEL_DIG)) {
            return true;
        }
        if (toolIn.canPerformAction(ToolActions.HOE_DIG)) {
            return true;
        }
        if (toolIn.canPerformAction(ToolActions.SWORD_SWEEP)) {
            return true;
        }
        if (toolIn.canPerformAction(ToolActions.SWORD_DIG)) {
            return true;
        }
        if (toolIn.canPerformAction(ToolActions.SHEARS_HARVEST)) {
            return true;
        }
        return toolIn.canPerformAction(ToolActions.SHEARS_DIG);
    }

    public boolean attemptAddTool(ItemStack stack) {
        if (this.privateItems.isItemValid(8, stack)) {
            this.privateItems.insertItem(8, stack.m_41620_(1), false);
            return true;
        }
        return false;
    }

    public ItemStack removeTool(int count) {
        return this.privateItems.extractItem(8, count, false);
    }

    public ItemStack removeAllTool() {
        return this.removeTool(this.privateItems.getStackInSlot(8).m_41613_());
    }

    public boolean hasTool() {
        return !this.privateItems.getStackInSlot(8).m_41619_();
    }

    public int getToolDamageValue() {
        if (this.hasTool()) {
            ItemStack toolInPed = this.getToolStack();
            if (toolInPed.m_41763_()) {
                return toolInPed.m_41773_();
            }
            return -1;
        }
        return 0;
    }

    public int getToolMaxDurability() {
        if (this.hasTool()) {
            ItemStack toolInPed = this.getToolStack();
            if (toolInPed.m_41763_()) {
                return toolInPed.m_41776_();
            }
            return -1;
        }
        return 0;
    }

    public int getDurabilityRemainingOnInsertedTool() {
        return this.getToolMaxDurability() - this.getToolDamageValue();
    }

    public boolean repairInsertedTool(int repairAmount, boolean simulate) {
        if (this.getDurabilityRemainingOnInsertedTool() < this.getToolMaxDurability()) {
            if (!simulate) {
                this.getToolStack().m_41721_(this.getToolDamageValue() - repairAmount);
            }
            return true;
        }
        return false;
    }

    public boolean damageInsertedTool(int damageAmount, boolean simulate) {
        if (this.getDurabilityRemainingOnInsertedTool() > damageAmount) {
            if (!simulate) {
                this.getToolStack().m_41721_(this.getToolDamageValue() + damageAmount);
            }
            return true;
        }
        return false;
    }

    public boolean damageTool(ItemStack stackTool, int damageAmount, boolean simulate) {
        if (stackTool.m_41763_() && stackTool.m_41776_() - stackTool.m_41773_() > damageAmount) {
            if (!simulate && stackTool.m_41763_()) {
                int newDamageAmount = stackTool.m_41773_() + damageAmount;
                stackTool.m_41721_(newDamageAmount);
                return true;
            }
            return true;
        }
        return false;
    }

    public ItemStack getActualToolStack() {
        return this.privateItems.getStackInSlot(8);
    }

    public ItemStack getToolStack() {
        Item item;
        ItemStack toolInPed = this.privateItems.getStackInSlot(8);
        if (!toolInPed.m_41619_()) {
            return toolInPed;
        }
        if (this.hasCoin() && (item = this.getCoinOnPedestal().m_41720_()) instanceof ItemUpgradeBase) {
            ItemUpgradeBase upgrade = (ItemUpgradeBase)item;
            return upgrade.getUpgradeDefaultTool();
        }
        return ItemStack.f_41583_;
    }

    public boolean canInsertTool(ItemStack tool) {
        return this.isAllowedTool(tool) && !this.hasTool();
    }

    public boolean attemptAddRRobin(ItemStack stack) {
        if (this.privateItems.isItemValid(1, stack)) {
            this.privateItems.insertItem(1, stack.m_41620_(1), false);
            return true;
        }
        return false;
    }

    public ItemStack removeRRobin() {
        return this.privateItems.extractItem(1, 1, false);
    }

    public boolean hasRRobin() {
        return !this.privateItems.getStackInSlot(1).m_41619_();
    }

    public boolean attemptAddRenderAugment(ItemStack stack) {
        if (this.privateItems.isItemValid(2, stack)) {
            this.privateItems.insertItem(2, stack.m_41620_(1), false);
            return true;
        }
        return false;
    }

    public ItemStack removeRenderAugment() {
        return this.privateItems.extractItem(2, 1, false);
    }

    public boolean hasRenderAugment() {
        return !this.privateItems.getStackInSlot(2).m_41619_();
    }

    public boolean canSpawnParticles() {
        boolean particlesEnabled = (Boolean)PedestalConfig.CLIENT.pedestalRenderParticles.get();
        if (particlesEnabled) {
            switch (this.getRendererType()) {
                case 0: {
                    return false;
                }
                case 1: {
                    return true;
                }
                case 2: {
                    return true;
                }
                case 3: {
                    return false;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    return true;
                }
                case 6: {
                    return false;
                }
                case 7: {
                    return true;
                }
            }
            return true;
        }
        return false;
    }

    public int getRendererType() {
        if (this.hasRenderAugment()) {
            return AugmentRenderDiffuser.getAugmentMode(this.privateItems.getStackInSlot(2));
        }
        return 7;
    }

    public boolean attemptAddNoCollide(ItemStack stack) {
        if (this.privateItems.isItemValid(3, stack)) {
            this.privateItems.insertItem(3, stack.m_41620_(1), false);
            return true;
        }
        return false;
    }

    public ItemStack removeNoCollide() {
        return this.privateItems.extractItem(3, 1, false);
    }

    public boolean hasNoCollide() {
        return !this.privateItems.getStackInSlot(3).m_41619_();
    }

    public List<String> getHudLog() {
        Item item;
        ArrayList<String> messages = new ArrayList<String>();
        if (this.hasCoin() && (item = this.getCoinOnPedestal().m_41720_()) instanceof ItemUpgradeBase) {
            ItemUpgradeBase upgrade = (ItemUpgradeBase)item;
            return upgrade.getUpgradeHUD(this);
        }
        return messages;
    }

    public boolean attemptAddLight(ItemStack stack, @Nullable BlockState newState) {
        BlockState state = this.f_58857_.m_8055_(this.getPos());
        BlockState newishstate = (BlockState)((BlockState)((BlockState)((BlockState)MowLibColorReference.addColorToBlockState((BlockState)((Block)DeferredRegisterTileBlocks.BLOCK_PEDESTAL.get()).m_49966_(), (int)MowLibColorReference.getColorFromStateInt((BlockState)state)).m_61124_((Property)BasePedestalBlock.WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)BasePedestalBlock.WATERLOGGED)))).m_61124_((Property)BasePedestalBlock.FACING, (Comparable)((Direction)state.m_61143_((Property)BasePedestalBlock.FACING)))).m_61124_((Property)BasePedestalBlock.LIT, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BasePedestalBlock.FILTER_STATUS, (Comparable)((Integer)state.m_61143_((Property)BasePedestalBlock.FILTER_STATUS)));
        return super.attemptAddLight(stack, newishstate);
    }

    public ItemStack removeLight(@Nullable BlockState newState) {
        BlockState state = this.f_58857_.m_8055_(this.getPos());
        BlockState newishstate = (BlockState)((BlockState)((BlockState)((BlockState)MowLibColorReference.addColorToBlockState((BlockState)((Block)DeferredRegisterTileBlocks.BLOCK_PEDESTAL.get()).m_49966_(), (int)MowLibColorReference.getColorFromStateInt((BlockState)state)).m_61124_((Property)BasePedestalBlock.WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)BasePedestalBlock.WATERLOGGED)))).m_61124_((Property)BasePedestalBlock.FACING, (Comparable)((Direction)state.m_61143_((Property)BasePedestalBlock.FACING)))).m_61124_((Property)BasePedestalBlock.LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BasePedestalBlock.FILTER_STATUS, (Comparable)((Integer)state.m_61143_((Property)BasePedestalBlock.FILTER_STATUS)));
        return super.removeLight(newishstate);
    }

    public boolean attemptAddFilter(ItemStack stack, @Nullable BlockState newState) {
        BlockState state = this.f_58857_.m_8055_(this.getPos());
        BlockState newishstate = (BlockState)((BlockState)((BlockState)((BlockState)MowLibColorReference.addColorToBlockState((BlockState)((Block)DeferredRegisterTileBlocks.BLOCK_PEDESTAL.get()).m_49966_(), (int)MowLibColorReference.getColorFromStateInt((BlockState)state)).m_61124_((Property)BasePedestalBlock.WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)BasePedestalBlock.WATERLOGGED)))).m_61124_((Property)BasePedestalBlock.FACING, (Comparable)((Direction)state.m_61143_((Property)BasePedestalBlock.FACING)))).m_61124_((Property)BasePedestalBlock.LIT, (Comparable)((Boolean)state.m_61143_((Property)BasePedestalBlock.LIT)))).m_61124_((Property)BasePedestalBlock.FILTER_STATUS, (Comparable)Integer.valueOf(((IFilterItem)stack.m_41720_()).getFilterType(stack) ? 2 : 1));
        return super.attemptAddFilter(stack, newishstate);
    }

    public ItemStack removeFilter(@Nullable BlockState newState) {
        BlockState state = this.f_58857_.m_8055_(this.getPos());
        BlockState newishstate = (BlockState)((BlockState)((BlockState)((BlockState)MowLibColorReference.addColorToBlockState((BlockState)((Block)DeferredRegisterTileBlocks.BLOCK_PEDESTAL.get()).m_49966_(), (int)MowLibColorReference.getColorFromStateInt((BlockState)state)).m_61124_((Property)BasePedestalBlock.WATERLOGGED, (Comparable)((Boolean)state.m_61143_((Property)BasePedestalBlock.WATERLOGGED)))).m_61124_((Property)BasePedestalBlock.FACING, (Comparable)((Direction)state.m_61143_((Property)BasePedestalBlock.FACING)))).m_61124_((Property)BasePedestalBlock.LIT, (Comparable)((Boolean)state.m_61143_((Property)BasePedestalBlock.LIT)))).m_61124_((Property)BasePedestalBlock.FILTER_STATUS, (Comparable)Integer.valueOf(0));
        return super.removeFilter(newishstate);
    }

    public boolean canSendToPedestal(BasePedestalBlockEntity pedestal) {
        return this.f_58857_ != null && this.f_58857_.m_46749_(pedestal.getPos()) && !this.isPedestalBlockPowered(pedestal);
    }

    public boolean sendItemsToPedestal(BlockPos posReceiver, List<ItemStack> itemStacksIncoming) {
        BlockEntity blockEntity;
        if (itemStacksIncoming.size() > 0 && this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(posReceiver)) instanceof BasePedestalBlockEntity) {
            BasePedestalBlockEntity receiverPedestal = (BasePedestalBlockEntity)blockEntity;
            return receiverPedestal.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.UP).map(receiverHandler -> {
                for (ItemStack stack : itemStacksIncoming) {
                    ItemStack insertedStackSimulation = receiverPedestal.addItemStack(stack, true);
                    int countToSend = Math.min(this.getItemTransferRate(), stack.m_41613_() - insertedStackSimulation.m_41613_());
                    if (countToSend <= 0 || !receiverHandler.isItemValid(0, stack)) continue;
                    ItemStack stackToRemove = stack.m_41777_();
                    stackToRemove.m_41764_(countToSend);
                    receiverPedestal.addItemStack(stackToRemove, false);
                    this.removeItemStack(stackToRemove, false);
                    return true;
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    public boolean sendFluidsToPedestal(BlockPos posReceiver, FluidStack fluidStackIncoming) {
        BlockEntity blockEntity;
        if (!fluidStackIncoming.isEmpty() && this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(posReceiver)) instanceof BasePedestalBlockEntity) {
            BasePedestalBlockEntity receiverPedestal = (BasePedestalBlockEntity)blockEntity;
            return receiverPedestal.getCapability(ForgeCapabilities.FLUID_HANDLER, Direction.UP).map(receiverHandler -> {
                if (receiverHandler.isFluidValid(0, fluidStackIncoming)) {
                    int insertedStackSimulation = receiverHandler.fill(fluidStackIncoming, IFluidHandler.FluidAction.SIMULATE);
                    int countToSend = Math.min(this.getFluidTransferRate(), insertedStackSimulation);
                    if (countToSend > 0) {
                        FluidStack a = new FluidStack(fluidStackIncoming, countToSend);
                        receiverHandler.fill(a, IFluidHandler.FluidAction.EXECUTE);
                        this.removeFluid(countToSend, IFluidHandler.FluidAction.EXECUTE);
                        return true;
                    }
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    public boolean sendEnergyToPedestal(BlockPos posReceiver, int energyIncoming) {
        BlockEntity blockEntity;
        if (energyIncoming > 0 && this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(posReceiver)) instanceof BasePedestalBlockEntity) {
            BasePedestalBlockEntity receiverPedestal = (BasePedestalBlockEntity)blockEntity;
            return receiverPedestal.getCapability(ForgeCapabilities.ENERGY, Direction.UP).map(receiverHandler -> {
                int countToSend;
                int insertedStackSimulation;
                if (receiverHandler.canReceive() && (insertedStackSimulation = receiverHandler.receiveEnergy(energyIncoming, true)) > 0 && (countToSend = Math.min(this.getEnergyTransferRate(), insertedStackSimulation)) > 0) {
                    this.removeEnergy(countToSend, false);
                    receiverHandler.receiveEnergy(countToSend, false);
                    return true;
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    public boolean sendExperienceToPedestal(BlockPos posReceiver, int experienceIncoming) {
        BlockEntity blockEntity;
        if (experienceIncoming > 0 && this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(posReceiver)) instanceof BasePedestalBlockEntity) {
            BasePedestalBlockEntity receiverPedestal = (BasePedestalBlockEntity)blockEntity;
            return receiverPedestal.getCapability(CapabilityExperience.EXPERIENCE, Direction.UP).map(receiverHandler -> {
                int countToSend;
                int insertedStackSimulation;
                if (receiverHandler.canReceive() && (insertedStackSimulation = receiverHandler.receiveExperience(experienceIncoming, true)) > 0 && (countToSend = Math.min(this.getExperienceTransferRate(), insertedStackSimulation)) > 0) {
                    this.removeExperience(countToSend, false);
                    receiverHandler.receiveExperience(countToSend, false);
                    return true;
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    public boolean sendDustToPedestal(BlockPos posReceiver, DustMagic dustIncoming) {
        BlockEntity blockEntity;
        if (!dustIncoming.isEmpty() && this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(posReceiver)) instanceof BasePedestalBlockEntity) {
            BasePedestalBlockEntity receiverPedestal = (BasePedestalBlockEntity)blockEntity;
            return receiverPedestal.getCapability(CapabilityDust.DUST_HANDLER, Direction.UP).map(receiverHandler -> {
                int countToSend;
                int insertedStackSimulation;
                if (receiverHandler.isDustValid(0, dustIncoming) && (insertedStackSimulation = receiverHandler.fill(dustIncoming, IDustHandler.DustAction.SIMULATE)) > 0 && (countToSend = Math.min(this.getFluidTransferRate(), insertedStackSimulation)) > 0) {
                    this.removeDust(countToSend, IDustHandler.DustAction.EXECUTE);
                    receiverHandler.fill(new DustMagic(dustIncoming.getDustColor(), countToSend), IDustHandler.DustAction.EXECUTE);
                    this.update();
                    return true;
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    private boolean transferActionImpl(List<BlockPos> view, int startIndex) {
        boolean hasSent = false;
        int numScanned = 0;
        Iterator<BlockPos> it = view.iterator();
        while (it.hasNext()) {
            BlockPos posReceiver = it.next();
            BlockEntity blockEntity = this.f_58857_.m_7702_(posReceiver);
            if (blockEntity instanceof BasePedestalBlockEntity) {
                BasePedestalBlockEntity pedestal = (BasePedestalBlockEntity)blockEntity;
                if (this.isPedestalInRange(posReceiver) && this.canSendToPedestal(pedestal)) {
                    if (this.sendItemsToPedestal(posReceiver, this.getItemStacks())) {
                        hasSent = true;
                    }
                    if (this.sendFluidsToPedestal(posReceiver, this.getStoredFluid())) {
                        hasSent = true;
                    }
                    if (this.sendEnergyToPedestal(posReceiver, this.getStoredEnergy())) {
                        hasSent = true;
                    }
                    if (this.sendExperienceToPedestal(posReceiver, this.getStoredExperience())) {
                        hasSent = true;
                    }
                    if (this.sendDustToPedestal(posReceiver, this.getStoredDust())) {
                        hasSent = true;
                    }
                    if (hasSent) {
                        if (this.canSpawnParticles()) {
                            MowLibPacketHandler.sendToNearby((Level)this.f_58857_, (BlockPos)this.getPos(), (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_BEAM, (double)posReceiver.m_123341_(), (double)posReceiver.m_123342_(), (double)posReceiver.m_123343_(), new int[]{this.getPos().m_123341_(), this.getPos().m_123342_(), this.getPos().m_123343_()}));
                        }
                        if (this.hasRRobin()) {
                            this.setStoredValueForUpgrades(startIndex + numScanned + 1);
                        }
                        return true;
                    }
                }
            } else {
                it.remove();
                this.update();
            }
            ++numScanned;
        }
        return false;
    }

    public void transferAction() {
        if (!this.linkedPedestals.isEmpty()) {
            int scanStart;
            int n = scanStart = this.hasRRobin() ? this.getStoredValueForUpgrades() : 0;
            if (scanStart >= this.linkedPedestals.size()) {
                scanStart = 0;
            }
            if (!this.transferActionImpl(this.linkedPedestals.subList(scanStart, this.linkedPedestals.size()), scanStart) && scanStart > 0) {
                this.transferActionImpl(this.linkedPedestals.subList(0, scanStart), 0);
            }
        }
    }

    public void tick() {
        super.tick();
        if (!this.f_58857_.m_5776_() && this.f_58857_.isAreaLoaded(this.getPos(), 1)) {
            Item coinInPed;
            ++this.pedTicker;
            int maxTicksToTransfer = (Integer)PedestalConfig.COMMON.pedestal_maxTicksToTransfer.get();
            int speed = Math.max(maxTicksToTransfer - this.getTicksReduced(), 1);
            if (this.pedTicker % speed == 0) {
                if (!this.isPedestalBlockPowered(this.getPedestal()) && this.getNumLinkedPedestals() > 0) {
                    this.transferAction();
                }
                if (this.pedTicker >= 0x7FFFFFFE) {
                    this.pedTicker = 0;
                }
            }
            if (this.hasCoin() && (coinInPed = this.getCoinOnPedestal().m_41720_()) instanceof IPedestalUpgrade) {
                IPedestalUpgrade upgrade = (IPedestalUpgrade)coinInPed;
                upgrade.updateAction(this.f_58857_, this);
                if (this.hasNoCollide()) {
                    upgrade.actionOnCollideWithBlock(this);
                }
            }
            if (this.canSpawnParticles()) {
                BlockPos posOrientated = MowLibBlockPosUtils.getPosBelowBlockEntity((Level)this.f_58857_, (BlockPos)this.getPos(), (int)0);
                if (this.getRenderRange() && this.pedTicker % 10 == 0) {
                    MowLibPacketHandler.sendToNearby((Level)this.f_58857_, (BlockPos)this.getPos(), (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)this.getPos().m_123341_(), (double)this.getPos().m_123342_() + 1.0, (double)this.getPos().m_123343_(), new int[]{0, 0, 0}));
                }
                if (this.getRenderRangeUpgrade() && this.pedTicker % 10 == 0) {
                    MowLibPacketHandler.sendToNearby((Level)this.f_58857_, (BlockPos)this.getPos(), (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, (double)this.getPos().m_123341_(), (double)this.getPos().m_123342_() + 1.0, (double)this.getPos().m_123343_(), new int[]{50, 50, 50}));
                }
                if (this.pedTicker % 40 == 0) {
                    if (this.hasEnergy()) {
                        MowLibPacketHandler.sendToNearby((Level)this.f_58857_, (BlockPos)posOrientated, (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR, (double)posOrientated.m_123341_() + 0.25, (double)posOrientated.m_123342_(), (double)posOrientated.m_123343_() + 0.25, new int[]{255, 0, 0}));
                    }
                    if (this.hasExperience()) {
                        MowLibPacketHandler.sendToNearby((Level)this.f_58857_, (BlockPos)posOrientated, (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR, (double)posOrientated.m_123341_() + 0.75, (double)posOrientated.m_123342_(), (double)posOrientated.m_123343_() + 0.75, new int[]{0, 255, 0}));
                    }
                    if (this.hasFluid()) {
                        MowLibPacketHandler.sendToNearby((Level)this.f_58857_, (BlockPos)posOrientated, (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR, (double)posOrientated.m_123341_() + 0.75, (double)posOrientated.m_123342_(), (double)posOrientated.m_123343_() + 0.25, new int[]{0, 0, 255}));
                    }
                    if (References.isDustLoaded() && !this.isPedestalBlockPowered(this.getPedestal()) && this.hasDust()) {
                        MowLibPacketHandler.sendToNearby((Level)this.f_58857_, (BlockPos)posOrientated, (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR, (double)posOrientated.m_123341_() + 0.25, (double)posOrientated.m_123342_(), (double)posOrientated.m_123343_() + 0.75, new int[]{178, 0, 255}));
                    }
                }
            }
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        CompoundTag invTag = tag.m_128469_("inv");
        this.itemHandler.deserializeNBT(invTag);
        this.storedEnergy = tag.m_128451_("storedEnergy");
        this.storedFluid = FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("storedFluid"));
        this.storedExperience = tag.m_128451_("storedExperience");
        this.storedDust = DustMagic.getDustMagicInTag((CompoundTag)tag);
        this.storedPotionEffect = MobEffectInstance.m_19560_((CompoundTag)tag) != null ? MobEffectInstance.m_19560_((CompoundTag)tag) : null;
        this.storedPotionEffectDuration = tag.m_128451_("storedEffectDuration");
        CompoundTag invPrivateTag = tag.m_128469_("inv_private");
        this.privateItems.deserializeNBT(invPrivateTag);
        this.storedValueForUpgrades = tag.m_128451_("storedUpgradeValue");
        this.showRenderRange = tag.m_128471_("showRenderRange");
        this.showRenderRangeUpgrade = tag.m_128441_("showRenderRangeUpgrade") ? tag.m_128471_("showRenderRangeUpgrade") : false;
        int[] storedX = tag.m_128465_("intArrayXPos");
        int[] storedY = tag.m_128465_("intArrayYPos");
        int[] storedZ = tag.m_128465_("intArrayZPos");
        for (int i = 0; i < storedX.length; ++i) {
            BlockPos gotPos = new BlockPos(storedX[i], storedY[i], storedZ[i]);
            this.linkedPedestals.add(gotPos);
        }
    }

    public CompoundTag save(CompoundTag tag) {
        super.save(tag);
        tag.m_128365_("inv", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("storedEnergy", this.storedEnergy);
        tag.m_128365_("storedFluid", (Tag)this.storedFluid.writeToNBT(new CompoundTag()));
        tag.m_128405_("storedExperience", this.storedExperience);
        if (this.storedPotionEffect != null) {
            this.storedPotionEffect.m_19555_(tag);
        }
        tag.m_128405_("storedEffectDuration", this.storedPotionEffectDuration);
        tag.m_128365_("inv_private", (Tag)this.privateItems.serializeNBT());
        tag.m_128405_("storedUpgradeValue", this.storedValueForUpgrades);
        tag.m_128379_("showRenderRange", this.showRenderRange);
        tag.m_128379_("showRenderRangeUpgrade", this.showRenderRangeUpgrade);
        ArrayList<Integer> storedX = new ArrayList<Integer>();
        ArrayList<Integer> storedY = new ArrayList<Integer>();
        ArrayList<Integer> storedZ = new ArrayList<Integer>();
        for (int i = 0; i < this.getNumLinkedPedestals(); ++i) {
            storedX.add(this.linkedPedestals.get(i).m_123341_());
            storedY.add(this.linkedPedestals.get(i).m_123342_());
            storedZ.add(this.linkedPedestals.get(i).m_123343_());
        }
        tag.m_128408_("intArrayXPos", storedX);
        tag.m_128408_("intArrayYPos", storedY);
        tag.m_128408_("intArrayZPos", storedZ);
        return DustMagic.setDustMagicInTag((CompoundTag)tag, (DustMagic)this.storedDust);
    }

    public void m_7651_() {
        super.m_7651_();
        this.itemCapability.invalidate();
        this.energyCapability.invalidate();
        this.fluidCapability.invalidate();
        this.experienceCapability.invalidate();
        this.dustCapability.invalidate();
    }

    public AABB getRenderBoundingBox() {
        ItemUpgradeBase upgrade;
        int upgradeRange;
        Item item;
        int range = this.getLinkingRange();
        if (this.hasCoin() && (item = this.getCoinOnPedestal().m_41720_()) instanceof ItemUpgradeBase && (upgradeRange = (upgrade = (ItemUpgradeBase)item).getUpgradeWorkRange(this.getCoinOnPedestal())) > range) {
            range = upgradeRange;
        }
        AABB aabb = new AABB((double)(this.getPos().m_123341_() - range), (double)(this.getPos().m_123342_() - range), (double)(this.getPos().m_123343_() - range), (double)(this.getPos().m_123341_() + range), (double)(this.getPos().m_123342_() + range), (double)(this.getPos().m_123343_() + range));
        return aabb;
    }

    private static class PrivateInventorySlot {
        static final int COIN = 0;
        static final int AUGMENT_ROUNDROBIN = 1;
        static final int AUGMENT_RENDERDIFFUSER = 2;
        static final int AUGMENT_NOCOLLIDE = 3;
        static final int AUGMENT_TIERED_SPEED = 4;
        static final int AUGMENT_TIERED_CAPACITY = 5;
        static final int AUGMENT_TIERED_STORAGE = 6;
        static final int AUGMENT_TIERED_RANGE = 7;
        static final int TOOL = 8;

        private PrivateInventorySlot() {
        }
    }
}

