/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.partyparrots.common.core;

import java.util.Map;
import java.util.WeakHashMap;
import me.ichun.mods.partyparrots.common.PartyParrots;
import me.ichun.mods.partyparrots.mixin.ParrotAccessorMixin;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.player.Player;

public abstract class TwerkHandler {
    public static WeakHashMap<Player, TwerkInfo> playerTwerks = new WeakHashMap();

    public void onRenderLivingPre(LivingEntity living) {
        if (living instanceof Parrot) {
            Parrot parrot = (Parrot)living;
            if (PartyParrots.config.partyTwerk.get().booleanValue() && this.withinTwerkRange(parrot)) {
                ((ParrotAccessorMixin)parrot).setPartyParrot(true);
            }
        }
    }

    public void onPlayerTickEnd(Player player) {
        if (player.m_9236_().f_46443_ && player.m_6144_() && !playerTwerks.containsKey(player)) {
            playerTwerks.put(player, new TwerkInfo());
        }
    }

    public void onClientTickEnd(Minecraft client) {
        if (!client.m_91104_()) {
            playerTwerks.entrySet().removeIf(e -> !((TwerkInfo)e.getValue()).tick((Player)e.getKey()));
        }
    }

    public void onLevelLoad() {
        Minecraft.m_91087_().execute(this::clean);
    }

    public void onClientDisconnected() {
        Minecraft.m_91087_().execute(this::clean);
    }

    public void clean() {
        playerTwerks.clear();
    }

    public boolean withinTwerkRange(Parrot parrot) {
        for (Map.Entry<Player, TwerkInfo> e : playerTwerks.entrySet()) {
            if (!e.getValue().isTwerking() || !((double)parrot.m_20270_((Entity)e.getKey()) < PartyParrots.config.partyTwerkRange.get())) continue;
            return true;
        }
        return false;
    }

    public static class TwerkInfo {
        public int twerks = 1;
        public boolean playerSneak = true;
        public int twerkTimeout;

        public boolean tick(Player player) {
            if (player.m_213877_()) {
                return false;
            }
            if (player.m_6144_() && !this.playerSneak) {
                ++this.twerks;
                this.twerkTimeout = 0;
            }
            ++this.twerkTimeout;
            if (this.twerkTimeout > 60) {
                return false;
            }
            this.playerSneak = player.m_6144_();
            return true;
        }

        public boolean isTwerking() {
            return this.twerks >= 5;
        }
    }
}

