/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.oreberriesreplanted.compat.jei.vat;

import com.mrbysco.oreberriesreplanted.compat.jei.JeiCompat;
import com.mrbysco.oreberriesreplanted.recipes.VatRecipe;
import com.mrbysco.oreberriesreplanted.registry.OreBerryRegistry;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;

public class VatCategory
implements IRecipeCategory<VatRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final Component title;

    public VatCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(JeiCompat.RECIPE_VAT_JEI, 0, 0, 140, 37);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)OreBerryRegistry.OAK_VAT.get()));
        this.title = Component.m_237115_((String)"oreberriesreplanted.gui.jei.category.vat");
    }

    public RecipeType<VatRecipe> getRecipeType() {
        return JeiCompat.VAT_TYPE;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, VatRecipe recipe, IFocusGroup focuses) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        if (level == null) {
            throw new NullPointerException("level must not be null.");
        }
        RegistryAccess registryAccess = level.m_9598_();
        builder.addSlot(RecipeIngredientRole.INPUT, 10, 10).addIngredients((Ingredient)recipe.m_7527_().get(0));
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 113, 10).addItemStack(recipe.m_8043_(registryAccess))).addTooltipCallback((IRecipeSlotTooltipCallback)new OutputTooltip(recipe));
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 62, 10).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)new FluidStack(recipe.getFluid(), 1000))).addTooltipCallback((IRecipeSlotTooltipCallback)new FluidTooltip(recipe));
    }

    public static class OutputTooltip
    implements IRecipeSlotTooltipCallback {
        private final VatRecipe recipe;

        public OutputTooltip(VatRecipe recipe) {
            this.recipe = recipe;
        }

        public void onTooltip(IRecipeSlotView recipeSlotView, List<Component> tooltip) {
            tooltip.add((Component)Component.m_237110_((String)"oreberriesreplanted.gui.jei.category.vat_output.tooltip", (Object[])new Object[]{this.recipe.getEvaporationAmount()}).m_130940_(ChatFormatting.GOLD));
        }
    }

    public static class FluidTooltip
    implements IRecipeSlotTooltipCallback {
        private final VatRecipe recipe;

        public FluidTooltip(VatRecipe recipe) {
            this.recipe = recipe;
        }

        public void onTooltip(IRecipeSlotView recipeSlotView, List<Component> tooltip) {
            recipeSlotView.getDisplayedIngredient().flatMap(fluidStack -> fluidStack.getIngredient((IIngredientType)ForgeTypes.FLUID_STACK)).ifPresent(fluid -> tooltip.add((Component)Component.m_237110_((String)"oreberriesreplanted.gui.jei.category.vat.tooltip", (Object[])new Object[]{(int)(this.recipe.getMin() * 100.0f), (int)(this.recipe.getMax() * 100.0f), fluid.getDisplayName().getString()}).m_130940_(ChatFormatting.GOLD)));
        }
    }
}

