/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.oreberriesreplanted.compat.jei;

import com.mrbysco.oreberriesreplanted.compat.jei.VatRecipeValidator;
import com.mrbysco.oreberriesreplanted.compat.jei.vat.VatCategory;
import com.mrbysco.oreberriesreplanted.recipes.VatRecipe;
import com.mrbysco.oreberriesreplanted.registry.OreBerryRecipes;
import com.mrbysco.oreberriesreplanted.registry.OreBerryRegistry;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class JeiCompat
implements IModPlugin {
    public static final ResourceLocation RECIPE_VAT_JEI = new ResourceLocation("oreberriesreplanted", "textures/gui/jei/vat.png");
    public static final ResourceLocation PLUGIN_UID = new ResourceLocation("oreberriesreplanted", "main");
    public static final RecipeType<VatRecipe> VAT_TYPE = RecipeType.create((String)"oreberriesreplanted", (String)"vat_recipe", VatRecipe.class);
    @Nullable
    private IRecipeCategory<VatRecipe> vatCategory;

    public ResourceLocation getPluginUid() {
        return PLUGIN_UID;
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)OreBerryRegistry.OAK_VAT.get()), new RecipeType[]{VAT_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)OreBerryRegistry.SPRUCE_VAT.get()), new RecipeType[]{VAT_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)OreBerryRegistry.BIRCH_VAT.get()), new RecipeType[]{VAT_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)OreBerryRegistry.JUNGLE_VAT.get()), new RecipeType[]{VAT_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)OreBerryRegistry.ACACIA_VAT.get()), new RecipeType[]{VAT_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)OreBerryRegistry.DARK_OAK_VAT.get()), new RecipeType[]{VAT_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)OreBerryRegistry.CRIMSON_VAT.get()), new RecipeType[]{VAT_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)OreBerryRegistry.WARPED_VAT.get()), new RecipeType[]{VAT_TYPE});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        IRecipeCategory[] iRecipeCategoryArray = new IRecipeCategory[1];
        this.vatCategory = new VatCategory(guiHelper);
        iRecipeCategoryArray[0] = this.vatCategory;
        registration.addRecipeCategories(iRecipeCategoryArray);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        assert (this.vatCategory != null);
        registration.addRecipes(VAT_TYPE, this.getVatRecipes(this.vatCategory));
    }

    public List<VatRecipe> getVatRecipes(IRecipeCategory<VatRecipe> vatCategory) {
        return JeiCompat.getValidHandledRecipes(Minecraft.m_91087_().f_91073_.m_7465_(), new VatRecipeValidator(vatCategory));
    }

    private static <C extends Container> List<VatRecipe> getValidHandledRecipes(RecipeManager recipeManager, VatRecipeValidator validator) {
        return recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)OreBerryRecipes.VAT_RECIPE_TYPE.get()).stream().filter(r -> validator.isRecipeValid((VatRecipe)r) && validator.isRecipeHandled((VatRecipe)r)).toList();
    }
}

