/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.util;

import com.klikli_dev.occultism.Occultism;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.text.WordUtils;

public class TextUtil {
    private static final Map<String, String> MOD_NAME_TO_ID = new HashMap<String, String>();
    private static final String[] EASTER_EGGS = new String[]{"KliKli", "Xalmas", "Toastbroat", "Najlitarvan", "TheBoo", "Ridanisaurus", "Legiaseth", "Vallen", "Vemerion", "EqisEdu", "Feellian"};
    private static final String[] SYLLABLE1 = new String[]{"Kr", "Ca", "Ra", "Mrok", "Cru", "Ray", "Bre", "Zed", "Drak", "Mor", "Jag", "Mer", "Jar", "Mjol", "Zork", "Mad", "Cry", "Zur", "Creo", "Azak", "Azur", "Rei", "Cro", "Mar", "Luk", "Bar", "Gor", "Rak", "Thr", "Nar", "Vor", "Fir", "Trin", "Drog", "Karn", "Gar", "Ulf", "Hroth", "Ald", "Yng", "Styr", "Eir", "Ein", "Sig", "Ket", "Erl", "Haf", "Bryn", "Nid", "Grim", "Hol", "Fen", "Sigr", "Geir", "Hyr", "Val", "Har", "Kol", "Eyr"};
    private static final String[] SYLLABLE2 = new String[]{"air", "ir", "mi", "sor", "mee", "clo", "red", "cra", "ark", "arc", "miri", "lori", "cres", "mur", "zer", "marac", "zoir", "slamar", "salmar", "urak", "tim", "jor", "vyr", "dor", "thor", "kyl", "lyn", "wyn", "wynn", "lond", "rond", "vond", "dorn", "korn", "morn", "gorn", "thorn", "worn", "norn", "rinn", "dell", "bell", "vell", "fell", "kell", "zell", "nir", "fir", "mir", "tir", "sir", "vir", "zir", "lir", "jyr", "ryl", "rym", "lym", "lyn", "ryn", "myr", "myl", "myn", "ryn"};
    private static final String[] SYLLABLE3 = new String[]{"d", "ed", "ark", "arc", "es", "er", "der", "tron", "med", "ure", "zur", "cred", "mur", "aeus", "th", "vyr", "dor", "morn", "born", "thorn", "fyr", "lyr", "ryth", "ryn", "drin", "dryn", "kyr", "kyn", "lynd", "lind", "lyne", "line", "ryne", "rine", "thyr", "thyre", "vyn", "vin", "vyne", "vine", "rynne", "rinne", "syr", "syrn", "zirn", "zirne", "kyl", "kylle", "dor", "dorne", "lor", "lorne", "morn", "morne", "thorn", "thorne", "vyrn", "vyrne", "wyrm"};
    private static final Random random = new Random();
    private static boolean modNamesInitialized = false;

    public static void initializeModNames() {
        modNamesInitialized = true;
        for (IModInfo info : ModList.get().getMods()) {
            MOD_NAME_TO_ID.put(info.getModId(), info.getDisplayName());
        }
    }

    public static String getModNameForGameObject(@Nonnull Object object) {
        ResourceLocation key;
        if (modNamesInitialized) {
            TextUtil.initializeModNames();
        }
        if (object instanceof Item) {
            key = ForgeRegistries.ITEMS.getKey((Object)((Item)object));
        } else if (object instanceof Block) {
            key = ForgeRegistries.BLOCKS.getKey((Object)((Block)object));
        } else {
            return null;
        }
        String modId = key.m_135827_();
        String lowercaseModId = modId.toLowerCase(Locale.ENGLISH);
        String modName = MOD_NAME_TO_ID.get(lowercaseModId);
        if (modName == null) {
            modName = WordUtils.capitalize((String)modId);
            MOD_NAME_TO_ID.put(lowercaseModId, modName);
        }
        return modName;
    }

    public static String formatDemonName(String name) {
        return ChatFormatting.GOLD.toString() + ChatFormatting.BOLD + name + ChatFormatting.RESET;
    }

    public static MutableComponent formatDemonName(MutableComponent name) {
        return name.m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD});
    }

    public static MutableComponent formatDemonType(Component name, EntityType<?> type) {
        SpawnEggItem egg = ForgeSpawnEggItem.fromEntityType(type);
        int color = egg != null ? egg.m_43211_(0) : 0xFFFFFF;
        int finalColor = color = TextUtil.makeColorLighterForDarkMode(color);
        return Component.m_237119_().m_7220_(name).m_130938_(style -> style.m_178520_(finalColor));
    }

    private static int makeColorLighterForDarkMode(int colorCode) {
        float BRIGHTNESS_THRESHOLD = 0.4f;
        float BRIGHTNESS_INCREASE = 0.4f;
        int r = colorCode >> 16 & 0xFF;
        int g = colorCode >> 8 & 0xFF;
        int b = colorCode & 0xFF;
        float[] hsb = TextUtil.rgbToHsb(r, g, b);
        if (hsb[2] < 0.4f) {
            hsb[2] = hsb[2] + 0.4f;
            hsb[2] = Math.min(hsb[2], 1.0f);
            int[] rgb = TextUtil.hsbToRgb(hsb[0], hsb[1], hsb[2]);
            colorCode = rgb[0] << 16 | rgb[1] << 8 | rgb[2];
        }
        return colorCode;
    }

    private static float[] rgbToHsb(int r, int g, int b) {
        float rf = (float)r / 255.0f;
        float gf = (float)g / 255.0f;
        float bf = (float)b / 255.0f;
        float max = Math.max(rf, Math.max(gf, bf));
        float min = Math.min(rf, Math.min(gf, bf));
        float delta = max - min;
        float h = 0.0f;
        float s = (double)max == 0.0 ? 0.0f : delta / max;
        float v = max;
        if (delta != 0.0f && (h = max == rf ? (gf - bf) / 6.0f / delta : (max == gf ? 0.33333334f + (bf - rf) / 6.0f / delta : 0.6666667f + (rf - gf) / 6.0f / delta)) < 0.0f) {
            h += 1.0f;
        }
        return new float[]{h, s, v};
    }

    private static int[] hsbToRgb(float h, float s, float v) {
        int r = 0;
        int g = 0;
        int b = 0;
        int i = (int)(h * 6.0f);
        float f = h * 6.0f - (float)i;
        float p = v * (1.0f - s);
        float q = v * (1.0f - f * s);
        float t = v * (1.0f - (1.0f - f) * s);
        switch (i % 6) {
            case 0: {
                r = Math.round(v * 255.0f);
                g = Math.round(t * 255.0f);
                b = Math.round(p * 255.0f);
                break;
            }
            case 1: {
                r = Math.round(q * 255.0f);
                g = Math.round(v * 255.0f);
                b = Math.round(p * 255.0f);
                break;
            }
            case 2: {
                r = Math.round(p * 255.0f);
                g = Math.round(v * 255.0f);
                b = Math.round(t * 255.0f);
                break;
            }
            case 3: {
                r = Math.round(p * 255.0f);
                g = Math.round(q * 255.0f);
                b = Math.round(v * 255.0f);
                break;
            }
            case 4: {
                r = Math.round(t * 255.0f);
                g = Math.round(p * 255.0f);
                b = Math.round(v * 255.0f);
                break;
            }
            case 5: {
                r = Math.round(v * 255.0f);
                g = Math.round(p * 255.0f);
                b = Math.round(q * 255.0f);
            }
        }
        return new int[]{r, g, b};
    }

    public static String formatLargeNumber(int number) {
        if ((double)number < Math.pow(10.0, 3.0)) {
            return String.valueOf(number);
        }
        if ((double)number < Math.pow(10.0, 6.0)) {
            int rounded = Math.round((float)number / 1000.0f);
            return rounded + "K";
        }
        if ((double)number < Math.pow(10.0, 9.0)) {
            int rounded = Math.round((float)number / (float)Math.pow(10.0, 6.0));
            return rounded + "M";
        }
        if ((double)number < Math.pow(10.0, 12.0)) {
            int rounded = Math.round((float)number / (float)Math.pow(10.0, 9.0));
            return rounded + "B";
        }
        return Integer.toString(number);
    }

    public static String generateName() {
        boolean usePossibleSpiritNames;
        List possibleSpiritNames = (List)Occultism.SERVER_CONFIG.rituals.possibleSpiritNames.get();
        boolean bl = usePossibleSpiritNames = random.nextDouble() > (Double)Occultism.SERVER_CONFIG.rituals.usePossibleSpiritNamesChance.get();
        if (!possibleSpiritNames.isEmpty() && usePossibleSpiritNames) {
            return random.nextInt(20) == 0 ? EASTER_EGGS[random.nextInt(EASTER_EGGS.length)] : (String)possibleSpiritNames.get(random.nextInt(possibleSpiritNames.size()));
        }
        return random.nextInt(20) == 0 ? EASTER_EGGS[random.nextInt(EASTER_EGGS.length)] : SYLLABLE1[random.nextInt(SYLLABLE1.length)] + SYLLABLE2[random.nextInt(SYLLABLE2.length)] + SYLLABLE3[random.nextInt(SYLLABLE3.length)];
    }
}

