/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.datagen.recipes;

import com.klikli_dev.occultism.datagen.recipes.CrushingRecipeBuilder;
import com.klikli_dev.occultism.datagen.recipes.MinerRecipeBuilder;
import com.klikli_dev.occultism.datagen.recipes.MinerRecipes;
import com.klikli_dev.occultism.datagen.recipes.SpiritFireRecipeBuilder;
import com.klikli_dev.occultism.datagen.recipes.SpiritTradeRecipeBuilder;
import com.klikli_dev.occultism.registry.OccultismBlocks;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.klikli_dev.occultism.registry.OccultismTags;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;

public class OccultismRecipeProvider
extends RecipeProvider {
    public OccultismRecipeProvider(PackOutput pOutput) {
        super(pOutput);
    }

    protected void m_245200_(Consumer<FinishedRecipe> consumer) {
        OccultismRecipeProvider.blastingRecipes(consumer);
        this.craftingRecipes(consumer);
        this.smeltingRecipes(consumer);
        this.crushingRecipes(consumer);
        this.miningRecipes(consumer);
        this.spiritFireRecipes(consumer);
        this.spiritTradeRecipes(consumer);
    }

    private void spiritTradeRecipes(Consumer<FinishedRecipe> consumer) {
        SpiritTradeRecipeBuilder.spiritTradeRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.OTHERWORLD_SAPLING_NATURAL.get()}), new ItemStack((ItemLike)OccultismBlocks.OTHERWORLD_SAPLING.get())).m_126132_("has_otherworld_sapling_natural", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismItems.OTHERWORLD_SAPLING_NATURAL.get()))).m_126140_(consumer, new ResourceLocation("occultism", "spirit_trade/otherworld_sapling"));
        SpiritTradeRecipeBuilder.spiritTradeRecipe(Ingredient.m_204132_((TagKey)Tags.Items.STONE), new ItemStack((ItemLike)OccultismBlocks.OTHERSTONE.get(), 2)).m_126132_("has_stone", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_((TagKey)Tags.Items.STONE)).m_126140_(consumer, new ResourceLocation("occultism", "spirit_trade/stone_to_otherstone"));
        SpiritTradeRecipeBuilder.spiritTradeRecipe(Ingredient.m_204132_((TagKey)Tags.Items.STONE), new ItemStack((ItemLike)OccultismBlocks.OTHERSTONE.get(), 4)).m_126132_("has_stone", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_((TagKey)Tags.Items.STONE)).m_126140_(consumer, new ResourceLocation("occultism", "spirit_trade/test"));
    }

    private void spiritFireRecipes(Consumer<FinishedRecipe> consumer) {
        SpiritFireRecipeBuilder.spiritFireRecipe(Ingredient.m_204132_((TagKey)Tags.Items.FEATHERS), new ItemStack((ItemLike)OccultismItems.AWAKENED_FEATHER.get())).m_126132_("has_feather", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_((TagKey)Tags.Items.FEATHERS)).m_126140_(consumer, new ResourceLocation("occultism", "spirit_fire/awakened_feather"));
        SpiritFireRecipeBuilder.spiritFireRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42614_}), new ItemStack((ItemLike)OccultismItems.BOOK_OF_BINDING_EMPTY.get())).m_126132_("has_writable_book", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)Items.f_42614_)).m_126140_(consumer, new ResourceLocation("occultism", "spirit_fire/book_of_binding_empty"));
        SpiritFireRecipeBuilder.spiritFireRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.CHALK_GOLD_IMPURE.get()}), new ItemStack((ItemLike)OccultismItems.CHALK_GOLD.get())).m_126132_("has_chalk_gold_impure", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismItems.CHALK_GOLD_IMPURE.get()))).m_126140_(consumer, new ResourceLocation("occultism", "spirit_fire/chalk_gold"));
        SpiritFireRecipeBuilder.spiritFireRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.CHALK_PURPLE_IMPURE.get()}), new ItemStack((ItemLike)OccultismItems.CHALK_PURPLE.get())).m_126132_("has_chalk_purple_impure", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismItems.CHALK_PURPLE.get()))).m_126140_(consumer, new ResourceLocation("occultism", "spirit_fire/chalk_purple"));
        SpiritFireRecipeBuilder.spiritFireRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.CHALK_RED_IMPURE.get()}), new ItemStack((ItemLike)OccultismItems.CHALK_RED.get())).m_126132_("has_chalk_red_impure", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismItems.CHALK_RED.get()))).m_126140_(consumer, new ResourceLocation("occultism", "spirit_fire/chalk_red"));
        SpiritFireRecipeBuilder.spiritFireRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()}), new ItemStack((ItemLike)OccultismItems.CHALK_WHITE.get())).m_126132_("has_chalk_white_impure", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismItems.CHALK_WHITE.get()))).m_126140_(consumer, new ResourceLocation("occultism", "spirit_fire/chalk_white"));
        SpiritFireRecipeBuilder.spiritFireRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50334_}), new ItemStack((ItemLike)OccultismBlocks.OTHERSTONE.get())).m_126132_("has_andesite", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)Blocks.f_50334_)).m_126140_(consumer, new ResourceLocation("occultism", "spirit_fire/otherstone"));
        SpiritFireRecipeBuilder.spiritFireRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.OTHERWORLD_LOG.get()}), new ItemStack((ItemLike)OccultismItems.OTHERWORLD_ASHES.get())).m_126132_("has_otherworld_log", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismBlocks.OTHERWORLD_LOG.get()))).m_126140_(consumer, new ResourceLocation("occultism", "spirit_fire/otherworld_ashes"));
        SpiritFireRecipeBuilder.spiritFireRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.DEMONS_DREAM_ESSENCE.get()}), new ItemStack((ItemLike)OccultismItems.OTHERWORLD_ESSENCE.get())).m_126132_("has_demons_dream_essence", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismItems.DEMONS_DREAM_ESSENCE.get()))).m_126140_(consumer, new ResourceLocation("occultism", "spirit_fire/otherworld_essence"));
        SpiritFireRecipeBuilder.spiritFireRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42799_}), new ItemStack((ItemLike)OccultismItems.OTHERWORLD_SAPLING_NATURAL.get())).m_126132_("has_oak_sapling", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)Items.f_42799_)).m_126140_(consumer, new ResourceLocation("occultism", "spirit_fire/otherworld_sapling_natural"));
        SpiritFireRecipeBuilder.spiritFireRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42498_}), new ItemStack((ItemLike)OccultismItems.PURIFIED_INK.get())).m_126132_("has_black_dye", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)Items.f_42498_)).m_126140_(consumer, new ResourceLocation("occultism", "spirit_fire/purified_ink"));
        SpiritFireRecipeBuilder.spiritFireRecipe(Ingredient.m_204132_((TagKey)Tags.Items.GEMS_DIAMOND), new ItemStack((ItemLike)OccultismItems.SPIRIT_ATTUNED_GEM.get())).m_126132_("has_diamond", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_((TagKey)Tags.Items.GEMS_DIAMOND)).m_126140_(consumer, new ResourceLocation("occultism", "spirit_fire/spirit_attuned_gem"));
        SpiritFireRecipeBuilder.spiritFireRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42517_}), new ItemStack((ItemLike)OccultismItems.TABOO_BOOK.get())).m_126132_("has_book", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)Items.f_42517_)).m_126140_(consumer, new ResourceLocation("occultism", "spirit_fire/taboo_book"));
    }

    private void miningRecipes(Consumer<FinishedRecipe> consumer) {
        MinerRecipeBuilder.minerRecipe(Ingredient.m_204132_(OccultismTags.Items.Miners.MASTER), Ingredient.m_204132_(OccultismTags.makeItemTag(new ResourceLocation("forge", "ores/stella_arcanum"))), 100).unlockedBy("has_stella_arcanum_ore", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.makeItemTag(new ResourceLocation("forge", "ores/stella_arcanum")))).m_126140_(consumer, new ResourceLocation("occultism", "miner/master/stella_arcanum"));
        MinerRecipes.basic_resources(consumer);
        MinerRecipes.deeps(consumer);
        MinerRecipes.master_resources(consumer);
        MinerRecipes.ores(consumer);
        MinerRecipeBuilder.minerRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismItems.DEBUG_WAND.get()}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{((Block)OccultismBlocks.OTHERSTONE.get()).m_5456_()}), 200).unlockedBy("has_miner", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get()))).allowEmpty().m_126140_(consumer, new ResourceLocation("occultism", "miner/debug_wand"));
    }

    private void crushingRecipes(Consumer<FinishedRecipe> consumer) {
        CrushingRecipeBuilder.crushingRecipe(Ingredient.m_204132_(OccultismTags.Items.DATURA_CROP), Ingredient.m_204132_(OccultismTags.Items.DATURA_SEEDS), 200).unlockedBy("has_datura", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.Items.DATURA_CROP)).setAllowEmpty(false).setOutputAmount(2).m_126140_(consumer, new ResourceLocation("occultism", "crushing/datura"));
        this.crushingMetalRecipe("allthemodium", consumer);
        this.crushingMetalRecipe("iesnium", consumer);
        this.crushingMetalRecipe("aluminum", consumer);
        this.crushingMetalRecipe("signalum", consumer);
        this.crushingMetalRecipe("uranium", consumer);
        this.crushingMetalRecipe("graphite", consumer);
        this.crushingMetalRecipe("azure_silver", consumer);
        this.crushingMetalRecipe("zinc", consumer);
        this.crushingMetalRecipe("lumium", consumer);
        this.crushingMetalRecipe("osmium", consumer);
        this.crushingMetalRecipe("nickel", consumer);
        this.crushingMetalRecipe("lead", consumer);
        this.crushingMetalRecipe("bronze", consumer);
        this.crushingMetalRecipe("cobalt", consumer);
        this.crushingMetalRecipe("unobtainium", consumer);
        this.crushingMetalRecipe("tungsten", consumer);
        this.crushingMetalRecipe("iridium", consumer);
        this.crushingMetalRecipe("steel", consumer);
        this.crushingMetalRecipe("enderium", consumer);
        this.crushingMetalRecipe("electrum", consumer);
        this.crushingMetalRecipe("constantan", consumer);
        this.crushingMetalRecipe("tin", consumer);
        this.crushingMetalRecipe("netherite", consumer);
        this.crushingMetalRecipe("brass", consumer);
        this.crushingMetalRecipe("crimson_iron", consumer);
        this.crushingMetalRecipe("platinum", consumer);
        this.crushingMetalRecipe("invar", consumer);
        this.crushingMetalRecipe("vibranium", consumer);
        this.crushingMetalRecipe("silver", consumer);
        this.crushingMetalRecipe("copper", consumer);
        this.crushingMetalRecipe("pewter", consumer);
        this.crushingMetalRecipe("mithril", consumer);
        this.crushingMetalRecipe("gold", consumer);
        this.crushingMetalRecipe("quicksilver", consumer);
        this.crushingMetalRecipe("iron", consumer);
        this.crushingGemRecipe("diamond", consumer);
        this.crushingGemRecipe("emerald", consumer);
        this.crushingGemRecipe("lapis", consumer);
        this.crushingGemRecipe("quartz", consumer);
        this.crushingGemRecipe("coal", consumer);
        this.crushingGemRecipe("redstone", consumer);
        this.crushingGemRecipe("apatite", consumer);
        this.crushingGemRecipe("sulfur", consumer);
        this.crushingGemRecipe("fluorite", consumer);
        this.crushingGemRecipe("cinnabar", consumer);
        this.crushingGemRecipe("amber", consumer);
        this.crushingGemRecipe("certus_quartz", consumer);
        this.crushingGemRecipe("charged_certus_quartz", consumer);
        this.crushingGemRecipe("peridot", consumer);
        this.crushingGemRecipe("ruby", consumer);
        this.crushingGemRecipe("sapphire", consumer);
        this.crushingGemRecipe("topaz", consumer);
        this.crushingGemRecipe("arcane_crystal", consumer);
        CrushingRecipeBuilder.crushingRecipe(Ingredient.m_204132_((TagKey)Tags.Items.RODS_BLAZE), Ingredient.m_204132_(OccultismTags.Items.BLAZE_DUST), 200).allowEmpty().unlockedBy("has_blaze_rod", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_((TagKey)Tags.Items.RODS_BLAZE)).m_126140_(consumer, new ResourceLocation("occultism", "crushing/blaze_powder_from_rod"));
        CrushingRecipeBuilder.crushingRecipe(Ingredient.m_204132_((TagKey)Tags.Items.OBSIDIAN), Ingredient.m_204132_(OccultismTags.Items.OBSIDIAN_DUST), 200).allowEmpty().unlockedBy("has_obsidian", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_((TagKey)Tags.Items.OBSIDIAN)).m_126140_(consumer, new ResourceLocation("occultism", "crushing/obsidian_dust"));
        CrushingRecipeBuilder.crushingRecipe(Ingredient.m_204132_((TagKey)Tags.Items.END_STONES), Ingredient.m_204132_(OccultismTags.Items.END_STONE_DUST), 200).allowEmpty().unlockedBy("has_end_stone", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_((TagKey)Tags.Items.END_STONES)).m_126140_(consumer, new ResourceLocation("occultism", "crushing/end_stone_dust"));
    }

    private void crushingGemRecipe(String gemName, Consumer<FinishedRecipe> consumer) {
        CrushingRecipeBuilder.crushingRecipe(OccultismTags.makeItemTag(new ResourceLocation("forge", "ores/" + gemName)), OccultismTags.makeItemTag(new ResourceLocation("forge", "dusts/" + gemName)), 200).unlockedBy("has_" + gemName, (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.makeItemTag(new ResourceLocation("forge", "ores/" + gemName)))).setOutputAmount(4).setAllowEmpty(false).m_126140_(consumer, new ResourceLocation("occultism", "crushing/" + gemName + "_dust"));
        CrushingRecipeBuilder.crushingRecipe(OccultismTags.makeItemTag(new ResourceLocation("forge", "gems/" + gemName)), OccultismTags.makeItemTag(new ResourceLocation("forge", "dusts/" + gemName)), 200).unlockedBy("has_" + gemName + "_gem", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.makeItemTag(new ResourceLocation("forge", "gems/" + gemName)))).setOutputAmount(1).setAllowEmpty(false).m_126140_(consumer, new ResourceLocation("occultism", "crushing/" + gemName + "_dust_from_gem"));
    }

    private void crushingMetalRecipe(String metalName, Consumer<FinishedRecipe> consumer) {
        CrushingRecipeBuilder.crushingRecipe(OccultismTags.makeItemTag(new ResourceLocation("forge", "ores/" + metalName)), OccultismTags.makeItemTag(new ResourceLocation("forge", "dusts/" + metalName)), 200).unlockedBy("has_" + metalName, (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.makeItemTag(new ResourceLocation("forge", "ores/" + metalName)))).setOutputAmount(2).setAllowEmpty(false).m_126140_(consumer, new ResourceLocation("occultism", "crushing/" + metalName + "_dust"));
        CrushingRecipeBuilder.crushingRecipe(OccultismTags.makeItemTag(new ResourceLocation("forge", "raw_materials/" + metalName)), OccultismTags.makeItemTag(new ResourceLocation("forge", "dusts/" + metalName)), 200).unlockedBy("has_raw_" + metalName, (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.makeItemTag(new ResourceLocation("forge", "raw_materials/" + metalName)))).setOutputAmount(2).setAllowEmpty(false).m_126140_(consumer, new ResourceLocation("occultism", "crushing/" + metalName + "_dust_from_raw"));
        CrushingRecipeBuilder.crushingRecipe(OccultismTags.makeItemTag(new ResourceLocation("forge", "storage_blocks/raw_" + metalName)), OccultismTags.makeItemTag(new ResourceLocation("forge", "dusts/" + metalName)), 200).unlockedBy("has_raw_" + metalName + "_block", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.makeItemTag(new ResourceLocation("forge", "storage_blocks/raw_" + metalName)))).setOutputAmount(18).setAllowEmpty(false).m_126140_(consumer, new ResourceLocation("occultism", "crushing/" + metalName + "_dust_from_raw_block"));
        CrushingRecipeBuilder.crushingRecipe(OccultismTags.makeItemTag(new ResourceLocation("forge", "ingots/" + metalName)), OccultismTags.makeItemTag(new ResourceLocation("forge", "dusts/" + metalName)), 200).unlockedBy("has_" + metalName + "_ingot", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.makeItemTag(new ResourceLocation("forge", "ingots/" + metalName)))).setOutputAmount(1).setAllowEmpty(false).setIgnoreCrushingMultiplier(true).m_126140_(consumer, new ResourceLocation("occultism", "crushing/" + metalName + "_dust_from_ingot"));
    }

    private void craftingRecipes(Consumer<FinishedRecipe> consumer) {
        OccultismRecipeProvider.metalRecipes(consumer);
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_EMPTY.get())).m_126209_((ItemLike)OccultismItems.AWAKENED_FEATHER.get()).m_126209_((ItemLike)OccultismItems.PURIFIED_INK.get()).m_126209_((ItemLike)OccultismItems.TABOO_BOOK.get()).m_126132_("has_taboo_book", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismItems.TABOO_BOOK.get()))).m_126140_(consumer, new ResourceLocation("occultism", "crafting/book_of_binding_empty"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_AFRIT.get())).m_126130_("cpf").m_126130_("pbp").m_126130_(" p ").m_206416_(Character.valueOf('p'), Tags.Items.DYES_PURPLE).m_126127_(Character.valueOf('b'), (ItemLike)OccultismItems.TABOO_BOOK.get()).m_126127_(Character.valueOf('c'), (ItemLike)OccultismItems.PURIFIED_INK.get()).m_126127_(Character.valueOf('f'), (ItemLike)OccultismItems.AWAKENED_FEATHER.get()).m_126132_("has_taboo_book", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismItems.TABOO_BOOK.get()))).m_126140_(consumer, new ResourceLocation("occultism", "crafting/book_of_binding_afrit"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_AFRIT.get())).m_126130_(" p ").m_126130_("pbp").m_126130_(" p ").m_206416_(Character.valueOf('p'), Tags.Items.DYES_PURPLE).m_126127_(Character.valueOf('b'), (ItemLike)OccultismItems.BOOK_OF_BINDING_EMPTY.get()).m_126132_("has_taboo_book", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_EMPTY.get()))).m_126140_(consumer, new ResourceLocation("occultism", "crafting/book_of_binding_afrit_from_empty"));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_AFRIT.get())).m_126209_((ItemLike)OccultismItems.BOOK_OF_BINDING_AFRIT.get()).m_126209_((ItemLike)OccultismItems.DICTIONARY_OF_SPIRITS.get()).m_126132_("has_book_of_binding_afrit", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_AFRIT.get()))).m_126140_(consumer, new ResourceLocation("occultism", "crafting/book_of_binding_bound_afrit"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_DJINNI.get())).m_126130_("cgf").m_126130_("gbg").m_126130_(" g ").m_126127_(Character.valueOf('c'), (ItemLike)OccultismItems.PURIFIED_INK.get()).m_126127_(Character.valueOf('b'), (ItemLike)OccultismItems.TABOO_BOOK.get()).m_206416_(Character.valueOf('g'), Tags.Items.DYES_GREEN).m_126127_(Character.valueOf('f'), (ItemLike)OccultismItems.AWAKENED_FEATHER.get()).m_126132_("has_taboo_book", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismItems.TABOO_BOOK.get()))).m_126140_(consumer, new ResourceLocation("occultism", "crafting/book_of_binding_djinni"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_DJINNI.get())).m_126130_(" g ").m_126130_("gbg").m_126130_(" g ").m_206416_(Character.valueOf('g'), Tags.Items.DYES_GREEN).m_126127_(Character.valueOf('b'), (ItemLike)OccultismItems.BOOK_OF_BINDING_EMPTY.get()).m_126132_("has_empty_binding", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_EMPTY.get()))).m_126140_(consumer, new ResourceLocation("occultism", "crafting/book_of_binding_djinni_from_empty"));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get())).m_126209_((ItemLike)OccultismItems.BOOK_OF_BINDING_DJINNI.get()).m_126209_((ItemLike)OccultismItems.DICTIONARY_OF_SPIRITS.get()).m_126132_("has_book_of_binding_djinni", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_DJINNI.get()))).m_126140_(consumer, new ResourceLocation("occultism", "crafting/book_of_binding_bound_djinni"));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get())).m_206419_(OccultismTags.Items.BOOK_OF_CALLING_DJINNI).m_126132_("has_book_of_calling_djinni", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.Items.BOOK_OF_CALLING_DJINNI)).m_126140_(consumer, new ResourceLocation("occultism", "crafting/book_of_binding_bound_djinni_from_calling"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_FOLIOT.get())).m_126130_("cwf").m_126130_("wbw").m_126130_(" w ").m_126127_(Character.valueOf('c'), (ItemLike)OccultismItems.PURIFIED_INK.get()).m_126127_(Character.valueOf('b'), (ItemLike)OccultismItems.TABOO_BOOK.get()).m_206416_(Character.valueOf('w'), Tags.Items.DYES_WHITE).m_126127_(Character.valueOf('f'), (ItemLike)OccultismItems.AWAKENED_FEATHER.get()).m_126132_("has_taboo_book", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismItems.TABOO_BOOK.get()))).m_126140_(consumer, new ResourceLocation("occultism", "crafting/book_of_binding_foliot"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_FOLIOT.get())).m_126130_(" w ").m_126130_("wbw").m_126130_(" w ").m_206416_(Character.valueOf('w'), Tags.Items.DYES_WHITE).m_126127_(Character.valueOf('b'), (ItemLike)OccultismItems.BOOK_OF_BINDING_EMPTY.get()).m_126132_("has_empty_binding", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_EMPTY.get()))).m_126140_(consumer, new ResourceLocation("occultism", "crafting/book_of_binding_foliot_from_empty"));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get())).m_126209_((ItemLike)OccultismItems.BOOK_OF_BINDING_FOLIOT.get()).m_126209_((ItemLike)OccultismItems.DICTIONARY_OF_SPIRITS.get()).m_126132_("has_book_of_binding_foliot", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_FOLIOT.get()))).m_126140_(consumer, new ResourceLocation("occultism", "crafting/book_of_binding_bound_foliot"));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get())).m_206419_(OccultismTags.Items.BOOK_OF_CALLING_FOLIOT).m_126132_("has_book_of_calling_foliot", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.Items.BOOK_OF_CALLING_FOLIOT)).m_126140_(consumer, new ResourceLocation("occultism", "crafting/book_of_binding_bound_foliot_from_calling"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_MARID.get())).m_126130_("cof").m_126130_("pbp").m_126130_(" o ").m_126127_(Character.valueOf('c'), (ItemLike)OccultismItems.PURIFIED_INK.get()).m_126127_(Character.valueOf('b'), (ItemLike)OccultismItems.TABOO_BOOK.get()).m_206416_(Character.valueOf('o'), Tags.Items.DYES_ORANGE).m_206416_(Character.valueOf('p'), Tags.Items.DYES_PURPLE).m_126127_(Character.valueOf('f'), (ItemLike)OccultismItems.AWAKENED_FEATHER.get()).m_126132_("has_taboo_book", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismItems.TABOO_BOOK.get()))).m_126140_(consumer, new ResourceLocation("occultism", "crafting/book_of_binding_marid"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_MARID.get())).m_126130_(" o ").m_126130_("pbp").m_126130_(" o ").m_206416_(Character.valueOf('o'), Tags.Items.DYES_ORANGE).m_206416_(Character.valueOf('p'), Tags.Items.DYES_PURPLE).m_126127_(Character.valueOf('b'), (ItemLike)OccultismItems.BOOK_OF_BINDING_EMPTY.get()).m_126132_("has_empty_binding", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_EMPTY.get()))).m_126140_(consumer, new ResourceLocation("occultism", "crafting/book_of_binding_marid_from_empty"));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_MARID.get())).m_126209_((ItemLike)OccultismItems.BOOK_OF_BINDING_MARID.get()).m_126209_((ItemLike)OccultismItems.DICTIONARY_OF_SPIRITS.get()).m_126132_("has_book_of_binding_marid", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_MARID.get()))).m_126140_(consumer, new ResourceLocation("occultism", "crafting/book_of_binding_bound_marid"));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_CALLING_DJINNI_MANAGE_MACHINE.get())).m_126209_((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()).m_126209_((ItemLike)Items.f_41962_).m_126132_("has_book_of_binding_bound_djinni", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_DJINNI.get()))).m_126140_(consumer, new ResourceLocation("occultism", "crafting/book_of_calling_djinni_manage_machine"));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_CALLING_FOLIOT_CLEANER.get())).m_126209_((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()).m_126209_((ItemLike)OccultismItems.BRUSH.get()).m_126132_("has_book_of_binding_bound_foliot", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).m_126140_(consumer, new ResourceLocation("occultism", "crafting/book_of_calling_foliot_cleaner"));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_CALLING_FOLIOT_LUMBERJACK.get())).m_126209_((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()).m_206419_(OccultismTags.Items.METAL_AXES).m_126132_("has_book_of_binding_bound_foliot", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).m_126140_(consumer, new ResourceLocation("occultism", "crafting/book_of_calling_foliot_lumberjack"));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BOOK_OF_CALLING_FOLIOT_TRANSPORT_ITEMS.get())).m_126209_((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()).m_206419_(Tags.Items.CHESTS).m_126132_("has_book_of_binding_bound_foliot", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismItems.BOOK_OF_BINDING_BOUND_FOLIOT.get()))).m_126140_(consumer, new ResourceLocation("occultism", "crafting/book_of_calling_foliot_transport_items"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BRUSH.get())).m_126130_("ppp").m_126130_("wws").m_206416_(Character.valueOf('p'), ItemTags.f_13168_).m_206416_(Character.valueOf('w'), ItemTags.f_13167_).m_206416_(Character.valueOf('s'), Tags.Items.STRING).m_126132_("has_wool", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_((TagKey)ItemTags.f_13167_)).m_126140_(consumer, new ResourceLocation("occultism", "crafting/brush"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)OccultismItems.BUTCHER_KNIFE.get())).m_126130_(" is").m_126130_("is ").m_126130_("s  ").m_206416_(Character.valueOf('i'), Tags.Items.INGOTS_IRON).m_206416_(Character.valueOf('s'), Tags.Items.RODS_WOODEN).m_126132_("has_iron_ingot", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_((TagKey)Tags.Items.INGOTS_IRON)).m_126140_(consumer, new ResourceLocation("occultism", "crafting/butcher_knife"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)OccultismBlocks.CANDLE_WHITE.get())).m_126130_("s").m_126130_("t").m_206416_(Character.valueOf('s'), Tags.Items.STRING).m_206416_(Character.valueOf('t'), OccultismTags.Items.TALLOW).m_126132_("has_tallow", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.Items.TALLOW)).m_126140_(consumer, new ResourceLocation("occultism", "crafting/candle"));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.CHALK_GOLD_IMPURE.get())).m_126209_((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()).m_206419_(OccultismTags.Items.GOLD_DUST).m_206419_(Tags.Items.DUSTS_GLOWSTONE).m_126132_("has_chalk_white", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()))).m_126140_(consumer, new ResourceLocation("occultism", "crafting/chalk_gold_impure"));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.CHALK_PURPLE_IMPURE.get())).m_126209_((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()).m_206419_(OccultismTags.Items.END_STONE_DUST).m_206419_(OccultismTags.Items.OBSIDIAN_DUST).m_206419_(OccultismTags.Items.OBSIDIAN_DUST).m_126132_("has_chalk_white", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()))).m_126140_(consumer, new ResourceLocation("occultism", "crafting/chalk_purple_impure"));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.CHALK_RED_IMPURE.get())).m_126209_((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()).m_126209_((ItemLike)OccultismItems.AFRIT_ESSENCE.get()).m_126209_((ItemLike)Items.f_42593_).m_126132_("has_chalk_white", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get()))).m_126140_(consumer, new ResourceLocation("occultism", "crafting/chalk_red_impure"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.CHALK_WHITE_IMPURE.get())).m_126130_("xy").m_126130_("xy").m_126130_("xy").m_126127_(Character.valueOf('x'), (ItemLike)OccultismItems.BURNT_OTHERSTONE.get()).m_126127_(Character.valueOf('y'), (ItemLike)OccultismItems.OTHERWORLD_ASHES.get()).m_126132_("has_ashes", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismItems.OTHERWORLD_ASHES.get()))).m_126140_(consumer, new ResourceLocation("occultism", "crafting/chalk_white_impure"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)OccultismItems.DEMONS_DREAM_ESSENCE.get())).m_126130_("ppp").m_126130_("ppp").m_126130_("ppp").m_206416_(Character.valueOf('p'), OccultismTags.Items.DATURA_CROP).m_126132_("has_datura", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.Items.DATURA_CROP)).m_126140_(consumer, new ResourceLocation("occultism", "crafting/demons_dream_essence_from_fruit"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)OccultismItems.DEMONS_DREAM_ESSENCE.get())).m_126130_("ppp").m_126130_("ppp").m_126130_("ppp").m_206416_(Character.valueOf('p'), OccultismTags.Items.DATURA_SEEDS).m_126132_("has_datura", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.Items.DATURA_SEEDS)).m_126140_(consumer, new ResourceLocation("occultism", "crafting/demons_dream_essence_from_seeds"));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.DICTIONARY_OF_SPIRITS.get())).m_206419_(OccultismTags.Items.DATURA_SEEDS).m_206419_(OccultismTags.Items.BOOKS).m_126132_("has_datura", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.Items.DATURA_SEEDS)).m_126140_(consumer, new ResourceLocation("occultism", "crafting/dictionary_of_spirits"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)OccultismItems.DIVINATION_ROD.get())).m_126130_("xyx").m_126130_("x x").m_126130_(" x ").m_206416_(Character.valueOf('x'), Tags.Items.RODS_WOODEN).m_126127_(Character.valueOf('y'), (ItemLike)OccultismItems.SPIRIT_ATTUNED_GEM.get()).m_126132_("has_spirit_attuned_gem", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismItems.SPIRIT_ATTUNED_GEM.get()))).m_126140_(consumer, new ResourceLocation("occultism", "crafting/divination_rod"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)OccultismItems.OTHERWORLD_GOGGLES.get())).m_126130_(" l ").m_126130_("lil").m_126130_(" f ").m_206416_(Character.valueOf('l'), Tags.Items.LEATHER).m_126127_(Character.valueOf('i'), (ItemLike)OccultismItems.INFUSED_LENSES.get()).m_126127_(Character.valueOf('f'), (ItemLike)OccultismItems.LENS_FRAME.get()).m_126132_("has_infused_lenses", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismItems.INFUSED_LENSES.get()))).m_126140_(consumer, new ResourceLocation("occultism", "crafting/goggles"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismBlocks.GOLDEN_SACRIFICIAL_BOWL.get())).m_126130_("ggg").m_126130_("gbg").m_126130_("ggg").m_206416_(Character.valueOf('g'), Tags.Items.INGOTS_GOLD).m_126127_(Character.valueOf('b'), (ItemLike)OccultismBlocks.SACRIFICIAL_BOWL.get()).m_126132_("has_sacrificial_bowl", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismBlocks.SACRIFICIAL_BOWL.get()))).m_126140_(consumer, new ResourceLocation("occultism", "crafting/golden_sacrificial_bowl"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)OccultismItems.IESNIUM_PICKAXE.get())).m_126130_("iii").m_126130_(" s ").m_126130_(" s ").m_206416_(Character.valueOf('i'), OccultismTags.Items.IESNIUM_INGOT).m_206416_(Character.valueOf('s'), Tags.Items.RODS_WOODEN).m_126132_("has_iesnium_ingot", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.Items.IESNIUM_INGOT)).m_126140_(consumer, new ResourceLocation("occultism", "crafting/iesnium_pickaxe"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.LENS_FRAME.get())).m_126130_("ooo").m_126130_("s s").m_126130_("ooo").m_126127_(Character.valueOf('o'), (ItemLike)OccultismBlocks.OTHERSTONE.get()).m_206416_(Character.valueOf('s'), OccultismTags.Items.SILVER_INGOT).m_126132_("has_silver_ingot", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.Items.SILVER_INGOT)).m_126140_(consumer, new ResourceLocation("occultism", "crafting/lens_frame"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.LENSES.get())).m_126130_("ppp").m_126130_("pgp").m_126130_("ppp").m_206416_(Character.valueOf('p'), Tags.Items.GLASS_PANES).m_126127_(Character.valueOf('g'), (ItemLike)OccultismItems.SPIRIT_ATTUNED_GEM.get()).m_126132_("has_spirit_attuned_gem", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismItems.SPIRIT_ATTUNED_GEM.get()))).m_126140_(consumer, new ResourceLocation("occultism", "crafting/lenses"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.MAGIC_LAMP_EMPTY.get())).m_126130_(" s ").m_126130_("sis").m_126130_(" ss").m_206416_(Character.valueOf('s'), OccultismTags.Items.SILVER_INGOT).m_206416_(Character.valueOf('i'), OccultismTags.Items.IESNIUM_INGOT).m_126132_("has_silver_ingot", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.Items.SILVER_INGOT)).m_126140_(consumer, new ResourceLocation("occultism", "crafting/magic_lamp_empty"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.OTHERSTONE_FRAME.get())).m_126130_("ooo").m_126130_("o o").m_126130_("ooo").m_126127_(Character.valueOf('o'), (ItemLike)OccultismBlocks.OTHERSTONE.get()).m_126132_("has_otherstone", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismBlocks.OTHERSTONE.get()))).m_126140_(consumer, new ResourceLocation("occultism", "crafting/otherstone_frame"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)OccultismBlocks.OTHERSTONE_PEDESTAL.get())).m_126130_("s s").m_126130_(" o ").m_126130_("sss").m_126127_(Character.valueOf('s'), (ItemLike)OccultismBlocks.OTHERSTONE_SLAB.get()).m_126127_(Character.valueOf('o'), (ItemLike)OccultismBlocks.OTHERSTONE.get()).m_126132_("has_otherstone", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismBlocks.OTHERSTONE.get()))).m_126140_(consumer, new ResourceLocation("occultism", "crafting/otherstone_pedestal"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)OccultismBlocks.OTHERSTONE_SLAB.get()), (int)6).m_126130_("ooo").m_126127_(Character.valueOf('o'), (ItemLike)OccultismBlocks.OTHERSTONE.get()).m_126132_("has_otherstone", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismBlocks.OTHERSTONE.get()))).m_126140_(consumer, new ResourceLocation("occultism", "crafting/otherstone_slab"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)OccultismItems.OTHERSTONE_TABLET.get())).m_126130_("sss").m_126130_("sss").m_126130_("sss").m_126127_(Character.valueOf('s'), (ItemLike)OccultismBlocks.OTHERSTONE_SLAB.get()).m_126132_("has_otherstone_slab", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismBlocks.OTHERSTONE_SLAB.get()))).m_126140_(consumer, new ResourceLocation("occultism", "crafting/otherstone_tablet"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)OccultismBlocks.SACRIFICIAL_BOWL.get())).m_126130_("o o").m_126130_("ooo").m_126127_(Character.valueOf('o'), (ItemLike)OccultismBlocks.OTHERSTONE.get()).m_126132_("has_otherstone", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismBlocks.OTHERSTONE.get()))).m_126140_(consumer, new ResourceLocation("occultism", "crafting/sacrificial_bowl"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismBlocks.SPIRIT_ATTUNED_CRYSTAL.get())).m_126130_("gg").m_126130_("gg").m_126127_(Character.valueOf('g'), (ItemLike)OccultismItems.SPIRIT_ATTUNED_GEM.get()).m_126132_("has_spirit_attuned_gem", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismItems.SPIRIT_ATTUNED_GEM.get()))).m_126140_(consumer, new ResourceLocation("occultism", "crafting/spirit_attuned_crystal"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.SPIRIT_ATTUNED_PICKAXE_HEAD.get())).m_126130_("ggg").m_126127_(Character.valueOf('g'), (ItemLike)OccultismItems.SPIRIT_ATTUNED_GEM.get()).m_126132_("has_spirit_attuned_gem", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismItems.SPIRIT_ATTUNED_GEM.get()))).m_126140_(consumer, new ResourceLocation("occultism", "crafting/spirit_attuned_pickaxe_head"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismBlocks.SPIRIT_CAMPFIRE.get())).m_126130_(" S ").m_126130_("S#S").m_126130_("LLL").m_206416_(Character.valueOf('S'), Tags.Items.RODS_WOODEN).m_206416_(Character.valueOf('L'), ItemTags.f_13182_).m_206416_(Character.valueOf('#'), OccultismTags.Items.DATURA_CROP).m_126132_("has_datura", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.Items.DATURA_CROP)).m_126140_(consumer, new ResourceLocation("occultism", "crafting/spirit_campfire"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)OccultismBlocks.SPIRIT_LANTERN.get())).m_126130_("XXX").m_126130_("X#X").m_126130_("XXX").m_206416_(Character.valueOf('X'), Tags.Items.NUGGETS_IRON).m_126127_(Character.valueOf('#'), (ItemLike)OccultismBlocks.SPIRIT_TORCH.get()).m_126132_("has_spirit_torch", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismBlocks.SPIRIT_TORCH.get()))).m_126140_(consumer, new ResourceLocation("occultism", "crafting/spirit_lantern"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)OccultismBlocks.SPIRIT_TORCH.get())).m_126130_("X").m_126130_("#").m_126130_("S").m_206416_(Character.valueOf('X'), ItemTags.f_13160_).m_206416_(Character.valueOf('#'), OccultismTags.Items.DATURA_CROP).m_206416_(Character.valueOf('S'), Tags.Items.RODS_WOODEN).m_126132_("has_datura", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.Items.DATURA_CROP)).m_126140_(consumer, new ResourceLocation("occultism", "crafting/spirit_torch"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismBlocks.STORAGE_CONTROLLER.get())).m_126130_("d").m_126130_("b").m_126127_(Character.valueOf('d'), (ItemLike)OccultismItems.DIMENSIONAL_MATRIX.get()).m_126127_(Character.valueOf('b'), (ItemLike)OccultismBlocks.STORAGE_CONTROLLER_BASE.get()).m_126132_("has_dimensional_matrix", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismItems.DIMENSIONAL_MATRIX.get()))).m_126140_(consumer, new ResourceLocation("occultism", "crafting/storage_controller"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)OccultismItems.STORAGE_REMOTE_INERT.get())).m_126130_("gtg").m_126130_("bgb").m_126130_("bbb").m_126127_(Character.valueOf('t'), (ItemLike)OccultismItems.OTHERSTONE_TABLET.get()).m_206416_(Character.valueOf('b'), ItemTags.f_279629_).m_206416_(Character.valueOf('g'), Tags.Items.INGOTS_GOLD).m_126132_("has_otherstone_tablet", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismItems.OTHERSTONE_TABLET.get()))).m_126140_(consumer, new ResourceLocation("occultism", "crafting/storage_remote_inert"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.WORMHOLE_FRAME.get())).m_126130_(" g ").m_126130_("gog").m_126130_(" g ").m_206416_(Character.valueOf('g'), Tags.Items.INGOTS_GOLD).m_126127_(Character.valueOf('o'), (ItemLike)OccultismItems.OTHERSTONE_FRAME.get()).m_126132_("has_otherstone_frame", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismItems.OTHERSTONE_FRAME.get()))).m_126140_(consumer, new ResourceLocation("occultism", "crafting/wormhole_frame"));
    }

    private static void metalRecipes(Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)OccultismBlocks.IESNIUM_BLOCK.get())).m_126130_("ppp").m_126130_("ppp").m_126130_("ppp").m_206416_(Character.valueOf('p'), OccultismTags.Items.IESNIUM_INGOT).m_126132_("has_iesnium_ingot", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.Items.IESNIUM_INGOT)).m_126140_(consumer, new ResourceLocation("occultism", "crafting/iesnium_block"));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.IESNIUM_INGOT.get()), (int)9).m_206419_(OccultismTags.Items.STORAGE_BLOCK_IESNIUM).m_126132_("has_iesnium_block", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.Items.STORAGE_BLOCK_IESNIUM)).m_126140_(consumer, new ResourceLocation("occultism", "crafting/iesnium_ingot_from_block"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.IESNIUM_INGOT.get())).m_126130_("ppp").m_126130_("ppp").m_126130_("ppp").m_206416_(Character.valueOf('p'), OccultismTags.Items.IESNIUM_NUGGET).m_126132_("has_iesnium_nugget", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.Items.IESNIUM_NUGGET)).m_126140_(consumer, new ResourceLocation("occultism", "crafting/iesnium_ingot_from_nuggets"));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.IESNIUM_NUGGET.get()), (int)9).m_206419_(OccultismTags.Items.IESNIUM_INGOT).m_126132_("has_iesnium_ingot", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.Items.IESNIUM_INGOT)).m_126140_(consumer, new ResourceLocation("occultism", "crafting/iesnium_nugget"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismBlocks.RAW_IESNIUM_BLOCK.get())).m_126130_("ppp").m_126130_("ppp").m_126130_("ppp").m_206416_(Character.valueOf('p'), OccultismTags.Items.RAW_IESNIUM).m_126132_("has_raw_iesnium", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.Items.RAW_IESNIUM)).m_126140_(consumer, new ResourceLocation("occultism", "crafting/raw_iesnium_block"));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.RAW_IESNIUM.get()), (int)9).m_206419_(OccultismTags.Items.STORAGE_BLOCK_RAW_IESNIUM).m_126132_("has_raw_iesnium_block", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.Items.STORAGE_BLOCK_RAW_IESNIUM)).m_126140_(consumer, new ResourceLocation("occultism", "crafting/raw_iesnium_ingot_from_block"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)OccultismBlocks.SILVER_BLOCK.get())).m_126130_("ppp").m_126130_("ppp").m_126130_("ppp").m_206416_(Character.valueOf('p'), OccultismTags.Items.SILVER_INGOT).m_126132_("has_silver_ingot", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.Items.SILVER_INGOT)).m_126140_(consumer, new ResourceLocation("occultism", "crafting/silver_block"));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.SILVER_INGOT.get()), (int)9).m_206419_(OccultismTags.Items.STORAGE_BLOCK_SILVER).m_126132_("has_silver_block", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.Items.STORAGE_BLOCK_SILVER)).m_126140_(consumer, new ResourceLocation("occultism", "crafting/silver_ingot_from_block"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.SILVER_INGOT.get())).m_126130_("ppp").m_126130_("ppp").m_126130_("ppp").m_206416_(Character.valueOf('p'), OccultismTags.Items.SILVER_NUGGET).m_126132_("has_silver_nugget", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.Items.SILVER_NUGGET)).m_126140_(consumer, new ResourceLocation("occultism", "crafting/silver_ingot_from_nuggets"));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.SILVER_NUGGET.get()), (int)9).m_206419_(OccultismTags.Items.SILVER_INGOT).m_126132_("has_silver_ingot", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.Items.SILVER_INGOT)).m_126140_(consumer, new ResourceLocation("occultism", "crafting/silver_nugget"));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismBlocks.RAW_SILVER_BLOCK.get())).m_126130_("ppp").m_126130_("ppp").m_126130_("ppp").m_206416_(Character.valueOf('p'), OccultismTags.Items.RAW_SILVER).m_126132_("has_raw_silver", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.Items.RAW_SILVER)).m_126140_(consumer, new ResourceLocation("occultism", "crafting/raw_silver_block"));
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.RAW_SILVER.get()), (int)9).m_206419_(OccultismTags.Items.STORAGE_BLOCK_RAW_SILVER).m_126132_("has_raw_silver_block", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.Items.STORAGE_BLOCK_RAW_SILVER)).m_126140_(consumer, new ResourceLocation("occultism", "crafting/raw_silver_ingot_from_block"));
    }

    private void smeltingRecipes(Consumer<FinishedRecipe> consumer) {
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)OccultismBlocks.OTHERSTONE.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.BURNT_OTHERSTONE.get()), (float)0.15f, (int)200).m_126132_("has_otherstone", (CriterionTriggerInstance)OccultismRecipeProvider.m_125977_((ItemLike)((ItemLike)OccultismBlocks.OTHERSTONE.get()))).m_126140_(consumer, new ResourceLocation("occultism", "smelting/burnt_otherstone"));
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_204132_(OccultismTags.Items.COPPER_DUST), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.f_151052_, (float)0.7f, (int)200).m_126132_("has_copper_dust", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.Items.COPPER_DUST)).m_126140_(consumer, new ResourceLocation("occultism", "smelting/copper_ingot_from_dust"));
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_204132_(OccultismTags.Items.GOLD_DUST), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.f_42417_, (float)0.7f, (int)200).m_126132_("has_gold_dust", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.Items.GOLD_DUST)).m_126140_(consumer, new ResourceLocation("occultism", "smelting/gold_ingot_from_dust"));
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_204132_(OccultismTags.Items.IESNIUM_ORE), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.IESNIUM_INGOT.get()), (float)0.7f, (int)200).m_126132_("has_iesnium_ore", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.Items.IESNIUM_ORE)).m_126140_(consumer, new ResourceLocation("occultism", "smelting/iesnium_ingot"));
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_204132_(OccultismTags.Items.IESNIUM_DUST), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.IESNIUM_INGOT.get()), (float)0.7f, (int)200).m_126132_("has_iesnium_dust", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.Items.IESNIUM_DUST)).m_126140_(consumer, new ResourceLocation("occultism", "smelting/iesnium_ingot_from_dust"));
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_204132_(OccultismTags.Items.RAW_IESNIUM), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.IESNIUM_INGOT.get()), (float)0.7f, (int)200).m_126132_("has_raw_iesnium", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.Items.RAW_IESNIUM)).m_126140_(consumer, new ResourceLocation("occultism", "smelting/iesnium_ingot_from_raw"));
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_204132_(OccultismTags.Items.IRON_DUST), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.f_42416_, (float)0.7f, (int)200).m_126132_("has_iron_dust", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.Items.IRON_DUST)).m_126140_(consumer, new ResourceLocation("occultism", "smelting/iron_ingot_from_dust"));
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_204132_(OccultismTags.Items.SILVER_ORE), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.SILVER_INGOT.get()), (float)0.7f, (int)200).m_126132_("has_silver_ore", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.Items.SILVER_ORE)).m_126140_(consumer, new ResourceLocation("occultism", "smelting/silver_ingot"));
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_204132_(OccultismTags.Items.SILVER_DUST), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.SILVER_INGOT.get()), (float)0.7f, (int)200).m_126132_("has_silver_dust", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.Items.SILVER_DUST)).m_126140_(consumer, new ResourceLocation("occultism", "smelting/silver_ingot_from_dust"));
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_204132_(OccultismTags.Items.RAW_SILVER), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.SILVER_INGOT.get()), (float)0.7f, (int)200).m_126132_("has_raw_silver", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.Items.RAW_SILVER)).m_126140_(consumer, new ResourceLocation("occultism", "smelting/silver_ingot_from_raw"));
    }

    private static void blastingRecipes(Consumer<FinishedRecipe> consumer) {
        SimpleCookingRecipeBuilder.m_245681_((Ingredient)Ingredient.m_204132_(OccultismTags.Items.COPPER_DUST), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.f_151052_, (float)0.7f, (int)100).m_126132_("has_copper_dust", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.Items.COPPER_DUST)).m_126140_(consumer, new ResourceLocation("occultism", "blasting/copper_ingot_from_dust"));
        SimpleCookingRecipeBuilder.m_245681_((Ingredient)Ingredient.m_204132_(OccultismTags.Items.GOLD_DUST), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.f_42417_, (float)0.7f, (int)100).m_126132_("has_gold_dust", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.Items.GOLD_DUST)).m_126140_(consumer, new ResourceLocation("occultism", "blasting/gold_ingot_from_dust"));
        SimpleCookingRecipeBuilder.m_245681_((Ingredient)Ingredient.m_204132_(OccultismTags.Items.IESNIUM_ORE), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.IESNIUM_INGOT.get()), (float)0.7f, (int)100).m_126132_("has_iesnium_ore", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.Items.IESNIUM_ORE)).m_126140_(consumer, new ResourceLocation("occultism", "blasting/iesnium_ingot"));
        SimpleCookingRecipeBuilder.m_245681_((Ingredient)Ingredient.m_204132_(OccultismTags.Items.IESNIUM_DUST), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.IESNIUM_INGOT.get()), (float)0.7f, (int)100).m_126132_("has_iesnium_dust", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.Items.IESNIUM_DUST)).m_126140_(consumer, new ResourceLocation("occultism", "blasting/iesnium_ingot_from_dust"));
        SimpleCookingRecipeBuilder.m_245681_((Ingredient)Ingredient.m_204132_(OccultismTags.Items.RAW_IESNIUM), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.IESNIUM_INGOT.get()), (float)0.7f, (int)100).m_126132_("has_raw_iesnium", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.Items.RAW_IESNIUM)).m_126140_(consumer, new ResourceLocation("occultism", "blasting/iesnium_ingot_from_raw"));
        SimpleCookingRecipeBuilder.m_245681_((Ingredient)Ingredient.m_204132_(OccultismTags.Items.IRON_DUST), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.f_42416_, (float)0.7f, (int)100).m_126132_("has_iron_dust", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.Items.IRON_DUST)).m_126140_(consumer, new ResourceLocation("occultism", "blasting/iron_ingot_from_dust"));
        SimpleCookingRecipeBuilder.m_245681_((Ingredient)Ingredient.m_204132_(OccultismTags.Items.SILVER_ORE), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.SILVER_INGOT.get()), (float)0.7f, (int)100).m_126132_("has_silver_ore", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.Items.SILVER_ORE)).m_126140_(consumer, new ResourceLocation("occultism", "blasting/silver_ingot"));
        SimpleCookingRecipeBuilder.m_245681_((Ingredient)Ingredient.m_204132_(OccultismTags.Items.SILVER_DUST), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.SILVER_INGOT.get()), (float)0.7f, (int)100).m_126132_("has_silver_dust", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.Items.SILVER_DUST)).m_126140_(consumer, new ResourceLocation("occultism", "blasting/silver_ingot_from_dust"));
        SimpleCookingRecipeBuilder.m_245681_((Ingredient)Ingredient.m_204132_(OccultismTags.Items.RAW_SILVER), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)OccultismItems.SILVER_INGOT.get()), (float)0.7f, (int)100).m_126132_("has_raw_silver", (CriterionTriggerInstance)OccultismRecipeProvider.m_206406_(OccultismTags.Items.RAW_SILVER)).m_126140_(consumer, new ResourceLocation("occultism", "blasting/silver_ingot_from_raw"));
    }
}

