/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.ai.behaviour;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.common.entity.ai.behaviour.DepositItemsBehaviour;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.exceptions.ItemHandlerMissingException;
import com.klikli_dev.occultism.network.MessageSelectBlock;
import com.klikli_dev.occultism.network.OccultismPackets;
import com.klikli_dev.occultism.registry.OccultismMemoryTypes;
import com.klikli_dev.occultism.util.StorageUtil;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class SetWalkTargetToDepositBehaviour<E extends SpiritEntity>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED), Pair.of(OccultismMemoryTypes.DEPOSIT_POSITION.get(), (Object)MemoryStatus.VALUE_PRESENT), Pair.of(OccultismMemoryTypes.DEPOSIT_FACING.get(), (Object)MemoryStatus.VALUE_PRESENT)});

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        return StorageUtil.getFirstFilledSlot((IItemHandler)((SpiritEntity)entity).itemStackHandler.orElseThrow(ItemHandlerMissingException::new)) != -1;
    }

    protected void start(E entity) {
        BlockPos depositPos = (BlockPos)BrainUtils.getMemory(entity, OccultismMemoryTypes.DEPOSIT_POSITION.get());
        if (entity.m_20238_(Vec3.m_82512_((Vec3i)depositPos)) < DepositItemsBehaviour.DEPOSIT_ITEM_RANGE_SQUARE) {
            BrainUtils.clearMemory(entity, (MemoryModuleType)MemoryModuleType.f_26370_);
        } else {
            BlockPos walkPos = null;
            Set unreachableWalkTargets = (Set)BrainUtils.memoryOrDefault(entity, OccultismMemoryTypes.UNREACHABLE_WALK_TARGETS.get(), HashSet::new);
            for (Direction facing : Direction.Plane.HORIZONTAL) {
                BlockPos pos = depositPos.m_121945_(facing);
                if (!entity.m_9236_().m_46859_(pos) || unreachableWalkTargets.contains(pos)) continue;
                walkPos = pos;
                break;
            }
            if (walkPos != null) {
                BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26371_, (Object)new BlockPosTracker(walkPos));
                BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26370_, (Object)new WalkTarget(walkPos, 1.0f, 1));
                if (Occultism.DEBUG.debugAI) {
                    OccultismPackets.sendToTracking(entity, new MessageSelectBlock(depositPos, 5000, 0xFF00FF));
                    OccultismPackets.sendToTracking(entity, new MessageSelectBlock(walkPos, 5000, 65280));
                }
            } else {
                BrainUtils.clearMemory(entity, (MemoryModuleType)MemoryModuleType.f_26370_);
                if (Occultism.DEBUG.debugAI) {
                    OccultismPackets.sendToTracking(entity, new MessageSelectBlock(depositPos, 50000, 0xFF0000));
                }
            }
        }
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }
}

