/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.mowlib.Recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mowmaster.mowlib.Items.BaseUseInteractionItem;
import com.mowmaster.mowlib.Registry.DeferredRegisterItems;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ObjectHolder;
import org.jetbrains.annotations.Nullable;

public class ToolSwapCrafting
implements Recipe<Container> {
    @ObjectHolder(registryName="forge:recipe_serializer", value="mowlib:toolswapcrafting")
    private final String group;
    private final ResourceLocation id;
    private final Ingredient mainhandTool;
    private final ItemStack resultTool;

    public ToolSwapCrafting(ResourceLocation id, String group, @Nullable Ingredient mainhandTool, ItemStack resultTool) {
        this.group = group;
        this.id = id;
        this.mainhandTool = mainhandTool;
        this.resultTool = resultTool;
    }

    public boolean m_5598_() {
        return true;
    }

    public static Collection<ToolSwapCrafting> getAllRecipes(Level world) {
        return world.m_7465_().m_44013_((RecipeType)Type.INSTANCE);
    }

    public String m_6076_() {
        return this.group;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList allIngredients = NonNullList.m_122779_();
        allIngredients.add((Object)(this.mainhandTool != null ? this.mainhandTool : Ingredient.f_43901_));
        return allIngredients;
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        if (inv.m_6643_() < 1) {
            return false;
        }
        if (Arrays.stream(this.mainhandTool.m_43908_()).anyMatch(stack -> !(stack.m_41720_() instanceof BaseUseInteractionItem))) {
            return false;
        }
        if (!(inv.m_8020_(0).m_41720_() instanceof BaseUseInteractionItem)) {
            return false;
        }
        return this.mainhandTool.test(inv.m_8020_(0));
    }

    public ItemStack m_5874_(Container p_44001_, RegistryAccess p_267165_) {
        return this.assemble(p_44001_);
    }

    public ItemStack assemble(Container inv) {
        return this.getResultItem().m_41777_();
    }

    public ItemStack m_8043_(RegistryAccess p_267052_) {
        return this.getResultItem();
    }

    public ItemStack getResultItem() {
        return this.resultTool;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)DeferredRegisterItems.ICON_HAND.get());
    }

    public Ingredient getPattern() {
        return this.mainhandTool != null ? this.mainhandTool : Ingredient.f_43901_;
    }

    public static class Type
    implements RecipeType<ToolSwapCrafting> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "toolswapcrafting";

        private Type() {
        }
    }

    public static class Serializer
    implements RecipeSerializer<ToolSwapCrafting> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("mowlib", "toolswapcrafting");

        protected ToolSwapCrafting createRecipe(ResourceLocation recipeId, String group, Ingredient mainhandTool, ItemStack result) {
            return new ToolSwapCrafting(recipeId, group, mainhandTool, result);
        }

        public ToolSwapCrafting fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            Ingredient mainhandTool = json.has("mainhandTool") ? CraftingHelper.getIngredient((JsonElement)json.get("mainhandTool"), (boolean)false) : null;
            ItemStack result = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (boolean)true);
            return this.createRecipe(recipeId, group, mainhandTool, result);
        }

        public ToolSwapCrafting fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(Short.MAX_VALUE);
            boolean hasMainHandTool = buffer.readBoolean();
            Ingredient mainhandTool = hasMainHandTool ? Ingredient.m_43940_((FriendlyByteBuf)buffer) : null;
            ItemStack result = buffer.m_130267_();
            return this.createRecipe(recipeId, group, mainhandTool, result);
        }

        public void toNetwork(FriendlyByteBuf buffer, ToolSwapCrafting recipe) {
            buffer.m_130070_(recipe.group);
            boolean hasMainHandTool = recipe.mainhandTool != null;
            buffer.writeBoolean(hasMainHandTool);
            if (hasMainHandTool) {
                recipe.mainhandTool.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.resultTool);
        }

        public RecipeSerializer<?> setRegistryName(ResourceLocation name) {
            return INSTANCE;
        }

        @Nullable
        public ResourceLocation getRegistryName() {
            return ID;
        }

        public Class<RecipeSerializer<?>> getRegistryType() {
            return Serializer.castClass(RecipeSerializer.class);
        }

        private static <G> Class<G> castClass(Class<?> cls) {
            return cls;
        }
    }
}

