/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.mowlib.Recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mowmaster.mowlib.Registry.DeferredRegisterItems;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ObjectHolder;
import org.jetbrains.annotations.Nullable;

public class MachineBlockRenderItemsRecipe
implements Recipe<Container> {
    @ObjectHolder(registryName="forge:recipe_serializer", value="mowlib:machine_render_items")
    private final String group;
    private final ResourceLocation id;
    @Nullable
    private final Ingredient input;
    private final ItemStack output;
    private final float transitionX;
    private final float transitionY;
    private final float transitionZ;
    private final float scaleX;
    private final float scaleY;
    private final float scaleZ;
    private final float angle;
    private final boolean renderItem;
    private final boolean renderAsBlock;

    public MachineBlockRenderItemsRecipe(ResourceLocation id, String group, @Nullable Ingredient input, ItemStack output, float transitionX, float transitionY, float transitionZ, float scaleX, float scaleY, float scaleZ, float angle, boolean renderItem, boolean renderAsBlock) {
        this.group = group;
        this.id = id;
        this.input = input;
        this.output = output;
        this.transitionX = transitionX;
        this.transitionY = transitionY;
        this.transitionZ = transitionZ;
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.scaleZ = scaleZ;
        this.angle = angle;
        this.renderItem = renderItem;
        this.renderAsBlock = renderAsBlock;
    }

    public boolean m_5598_() {
        return true;
    }

    public static Collection<MachineBlockRenderItemsRecipe> getAllRecipes(Level world) {
        return world.m_7465_().m_44013_((RecipeType)Type.INSTANCE);
    }

    public String m_6076_() {
        return this.group;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList allIngredients = NonNullList.m_122779_();
        allIngredients.add((Object)(this.input != null ? this.input : Ingredient.f_43901_));
        return allIngredients;
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        ItemStack inputStackMachine = inv.m_8020_(0);
        ItemStack inputStackItem = inv.m_8020_(1);
        return this.input.test(inputStackMachine) && this.input.test(inputStackItem);
    }

    public ItemStack m_5874_(Container p_44001_, RegistryAccess p_267165_) {
        return this.m_8043_(p_267165_).m_41777_();
    }

    public ItemStack m_8043_(RegistryAccess p_267052_) {
        return this.output;
    }

    public ItemStack getResultItemJEI() {
        return this.output;
    }

    public List<Float> getResultList() {
        return Arrays.asList(Float.valueOf(this.transitionX), Float.valueOf(this.transitionY), Float.valueOf(this.transitionZ), Float.valueOf(this.scaleX), Float.valueOf(this.scaleY), Float.valueOf(this.scaleZ), Float.valueOf(this.angle));
    }

    public boolean getResultRenderItem() {
        return this.renderItem;
    }

    public boolean getResultRenderAsBlock() {
        return this.renderAsBlock;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)DeferredRegisterItems.COLOR_APPLICATOR.get());
    }

    public Ingredient getPattern() {
        return this.input != null ? this.input : Ingredient.f_43901_;
    }

    public static class Type
    implements RecipeType<MachineBlockRenderItemsRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "machine_render_items";

        private Type() {
        }
    }

    public static class Serializer
    implements RecipeSerializer<MachineBlockRenderItemsRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("mowlib", "machine_render_items");

        protected MachineBlockRenderItemsRecipe createRecipe(ResourceLocation recipeId, String group, Ingredient input, ItemStack result, float transitionX, float transitionY, float transitionZ, float scaleX, float scaleY, float scaleZ, float angle, boolean renderItem, boolean renderAsBlock) {
            return new MachineBlockRenderItemsRecipe(recipeId, group, input, result, transitionX, transitionY, transitionZ, scaleX, scaleY, scaleZ, angle, renderItem, renderAsBlock);
        }

        public MachineBlockRenderItemsRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            Ingredient input = json.has("input") ? CraftingHelper.getIngredient((JsonElement)json.get("input"), (boolean)false) : null;
            ItemStack result = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (boolean)true);
            float transitionX = json.has("transitionX") ? GsonHelper.m_13915_((JsonObject)json, (String)"transitionX") : 0.0f;
            float transitionY = json.has("transitionY") ? GsonHelper.m_13915_((JsonObject)json, (String)"transitionY") : 0.0f;
            float transitionZ = json.has("transitionZ") ? GsonHelper.m_13915_((JsonObject)json, (String)"transitionZ") : 0.0f;
            float scaleX = json.has("scaleX") ? GsonHelper.m_13915_((JsonObject)json, (String)"scaleX") : 0.0f;
            float scaleY = json.has("scaleY") ? GsonHelper.m_13915_((JsonObject)json, (String)"scaleY") : 0.0f;
            float scaleZ = json.has("scaleZ") ? GsonHelper.m_13915_((JsonObject)json, (String)"scaleZ") : 0.0f;
            float angle = json.has("angle") ? GsonHelper.m_13915_((JsonObject)json, (String)"angle") : 0.0f;
            boolean renderItem = json.has("renderItem") ? GsonHelper.m_13912_((JsonObject)json, (String)"renderItem") : false;
            boolean renderAsBlock = json.has("renderAsBlock") ? GsonHelper.m_13912_((JsonObject)json, (String)"renderAsBlock") : false;
            return this.createRecipe(recipeId, group, input, result, transitionX, transitionY, transitionZ, scaleX, scaleY, scaleZ, angle, renderItem, renderAsBlock);
        }

        public MachineBlockRenderItemsRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(Short.MAX_VALUE);
            boolean hasInput = buffer.readBoolean();
            Ingredient input = hasInput ? Ingredient.m_43940_((FriendlyByteBuf)buffer) : null;
            ItemStack result = buffer.m_130267_();
            float transitionX = buffer.readFloat();
            float transitionY = buffer.readFloat();
            float transitionZ = buffer.readFloat();
            float scaleX = buffer.readFloat();
            float scaleY = buffer.readFloat();
            float scaleZ = buffer.readFloat();
            float angle = buffer.readFloat();
            boolean renderItem = buffer.readBoolean();
            boolean renderAsBlock = buffer.readBoolean();
            return this.createRecipe(recipeId, group, input, result, transitionX, transitionY, transitionZ, scaleX, scaleY, scaleZ, angle, renderItem, renderAsBlock);
        }

        public void toNetwork(FriendlyByteBuf buffer, MachineBlockRenderItemsRecipe recipe) {
            buffer.m_130070_(recipe.group);
            boolean hasInput = recipe.input != null;
            buffer.writeBoolean(hasInput);
            if (hasInput) {
                recipe.input.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.output);
            buffer.writeFloat(recipe.transitionX);
            buffer.writeFloat(recipe.transitionY);
            buffer.writeFloat(recipe.transitionZ);
            buffer.writeFloat(recipe.scaleX);
            buffer.writeFloat(recipe.scaleY);
            buffer.writeFloat(recipe.scaleZ);
            buffer.writeFloat(recipe.angle);
            buffer.writeBoolean(recipe.renderItem);
            buffer.writeBoolean(recipe.renderAsBlock);
        }

        public RecipeSerializer<?> setRegistryName(ResourceLocation name) {
            return INSTANCE;
        }

        @Nullable
        public ResourceLocation getRegistryName() {
            return ID;
        }

        public Class<RecipeSerializer<?>> getRegistryType() {
            return Serializer.castClass(RecipeSerializer.class);
        }

        private static <G> Class<G> castClass(Class<?> cls) {
            return cls;
        }
    }
}

