/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.mowlib.Recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mowmaster.mowlib.MowLibUtils.MowLibCompoundTagUtils;
import com.mowmaster.mowlib.Registry.DeferredRegisterItems;
import java.util.Collection;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ObjectHolder;
import org.jetbrains.annotations.Nullable;

public class InWorldDualHandedCrafting
implements Recipe<Container> {
    @ObjectHolder(registryName="forge:recipe_serializer", value="mowlib:dualhandedcrafting")
    private final String group;
    private final ResourceLocation id;
    @Nullable
    private final Ingredient blockTarget;
    private final Ingredient offhandTool;
    private final Ingredient mainhandTool;
    private final ItemStack resultStack;
    private final Boolean consumeOffhandItem;
    private final Boolean consumeMainhandItem;
    private final Boolean modifyMainhandItem;
    private final Boolean modifyOffhandItem;
    private final String resultNBTName;
    private final int resultNBTValue;
    private final int resultNBTMinValue;
    private final int resultNBTMaxValue;

    public InWorldDualHandedCrafting(ResourceLocation id, String group, @Nullable Ingredient blockTarget, @Nullable Ingredient mainhandTool, @Nullable Boolean consumeMainhandItem, @Nullable Ingredient offhandTool, @Nullable Boolean consumeOffhandItem, @Nullable ItemStack resultStack, @Nullable Boolean modifyMainhandItem, @Nullable Boolean modifyOffhandItem, @Nullable String resultNBTName, @Nullable int resultNBTValue, @Nullable int resultNBTMinValue, @Nullable int resultNBTMaxValue) {
        this.group = group;
        this.id = id;
        this.blockTarget = blockTarget;
        this.mainhandTool = mainhandTool;
        this.consumeMainhandItem = consumeMainhandItem;
        this.offhandTool = offhandTool;
        this.consumeOffhandItem = consumeOffhandItem;
        this.resultStack = resultStack;
        this.modifyMainhandItem = modifyMainhandItem;
        this.modifyOffhandItem = modifyOffhandItem;
        this.resultNBTName = resultNBTName;
        this.resultNBTValue = resultNBTValue;
        this.resultNBTMinValue = resultNBTMinValue;
        this.resultNBTMaxValue = resultNBTMaxValue;
    }

    public boolean m_5598_() {
        return true;
    }

    public static Collection<InWorldDualHandedCrafting> getAllRecipes(Level world) {
        return world.m_7465_().m_44013_((RecipeType)Type.INSTANCE);
    }

    public String m_6076_() {
        return this.group;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList allIngredients = NonNullList.m_122779_();
        allIngredients.add((Object)(this.blockTarget != null ? this.blockTarget : Ingredient.f_43901_));
        allIngredients.add((Object)(this.mainhandTool != null ? this.mainhandTool : Ingredient.f_43901_));
        allIngredients.add((Object)(this.offhandTool != null ? this.offhandTool : Ingredient.f_43901_));
        return allIngredients;
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        if (inv.m_6643_() < 3) {
            return false;
        }
        return this.offhandTool.test(inv.m_8020_(2)) && this.mainhandTool.test(inv.m_8020_(1)) && this.blockTarget.test(inv.m_8020_(0));
    }

    public ItemStack m_5874_(Container p_44001_, RegistryAccess p_267165_) {
        return this.assemble(p_44001_);
    }

    public ItemStack assemble(Container inv) {
        if (this.resultStack == null || this.resultStack.m_41619_()) {
            if (this.modifyMainHand().booleanValue()) {
                ItemStack main = inv.m_8020_(1).m_41777_();
                if (this.getResultModificationName() != null && this.getResultModificationName() != "") {
                    if (this.mainhandTool.test(main)) {
                        if (this.getNBTModifiedItem(main, true)) {
                            this.getNBTModifiedItem(main, false);
                            return main;
                        }
                        return main;
                    }
                    return main;
                }
                return main;
            }
            if (this.modifyOffHand().booleanValue()) {
                ItemStack off = inv.m_8020_(2).m_41777_();
                if (this.getResultModificationName() != null && this.getResultModificationName() != "") {
                    if (this.offhandTool.test(off)) {
                        if (this.getNBTModifiedItem(off, true)) {
                            this.getNBTModifiedItem(off, false);
                            return off;
                        }
                        return off;
                    }
                    return off;
                }
                return off;
            }
        }
        return this.getResultItem().m_41777_();
    }

    public boolean getNBTModifiedItem(ItemStack inputUpgradeStack, boolean simulate) {
        if ((this.resultStack == null || this.resultStack.m_41619_()) && this.getResultModificationName() != null && this.getResultModificationName() != "") {
            int value = MowLibCompoundTagUtils.readIntegerFromNBT(inputUpgradeStack.m_41784_(), this.getResultModificationName());
            if (value >= this.getResultModificationMaxAmount()) {
                return false;
            }
            if (value < this.getResultModificationMinAmount()) {
                return false;
            }
            int newValue = value + this.getResultModificationAmount();
            if (newValue > this.getResultModificationMaxAmount()) {
                newValue = this.getResultModificationMaxAmount();
            }
            if (!simulate) {
                MowLibCompoundTagUtils.writeIntegerToNBT(inputUpgradeStack.m_41784_(), newValue, this.getResultModificationName());
            }
            return true;
        }
        return false;
    }

    public ItemStack m_8043_(RegistryAccess p_267052_) {
        return this.getResultItem();
    }

    public ItemStack getResultItem() {
        return this.resultStack.m_41619_() || this.resultStack == null ? ItemStack.f_41583_ : this.resultStack;
    }

    public Boolean consumeMainHand() {
        return this.consumeMainhandItem;
    }

    public Boolean consumeOffHand() {
        return this.consumeOffhandItem;
    }

    public Boolean modifyMainHand() {
        return this.modifyMainhandItem;
    }

    public Boolean modifyOffHand() {
        return this.modifyOffhandItem;
    }

    public String getResultModificationName() {
        return this.resultNBTName;
    }

    public int getResultModificationAmount() {
        return this.resultNBTValue;
    }

    public int getResultModificationMinAmount() {
        return this.resultNBTMinValue;
    }

    public int getResultModificationMaxAmount() {
        return this.resultNBTMaxValue;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)DeferredRegisterItems.ICON_HAND.get());
    }

    public Ingredient getPattern() {
        return this.blockTarget != null ? this.blockTarget : Ingredient.f_43901_;
    }

    public static class Type
    implements RecipeType<InWorldDualHandedCrafting> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "dualhandedcrafting";

        private Type() {
        }
    }

    public static class Serializer
    implements RecipeSerializer<InWorldDualHandedCrafting> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("mowlib", "dualhandedcrafting");

        protected InWorldDualHandedCrafting createRecipe(ResourceLocation recipeId, String group, @Nullable Ingredient blockTarget, @Nullable Ingredient mainhandTool, @Nullable Boolean consumeMainhandItem, @Nullable Ingredient offhandTool, @Nullable Boolean consumeOffhandItem, @Nullable ItemStack resultStack, @Nullable Boolean modifyMainhandItem, @Nullable Boolean modifyOffhandItem, @Nullable String resultNBTName, @Nullable int resultNBTValue, @Nullable int resultNBTMinValue, @Nullable int resultNBTMaxValue) {
            return new InWorldDualHandedCrafting(recipeId, group, blockTarget, mainhandTool, consumeMainhandItem, offhandTool, consumeOffhandItem, resultStack, modifyMainhandItem, modifyOffhandItem, resultNBTName, resultNBTValue, resultNBTMinValue, resultNBTMaxValue);
        }

        public InWorldDualHandedCrafting fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            Ingredient blockTarget = json.has("blockTarget") ? CraftingHelper.getIngredient((JsonElement)json.get("blockTarget"), (boolean)false) : null;
            Ingredient mainhandTool = json.has("mainhandTool") ? CraftingHelper.getIngredient((JsonElement)json.get("mainhandTool"), (boolean)false) : null;
            Boolean consumeMainhandItem = json.has("consumeMainhandItem") ? GsonHelper.m_13912_((JsonObject)json, (String)"consumeMainhandItem") : true;
            Ingredient offhandTool = json.has("offhandTool") ? CraftingHelper.getIngredient((JsonElement)json.get("offhandTool"), (boolean)false) : null;
            Boolean consumeOffhandItem = json.has("consumeOffhandItem") ? GsonHelper.m_13912_((JsonObject)json, (String)"consumeOffhandItem") : true;
            ItemStack resultStack = json.has("result") ? CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"), (boolean)true) : ItemStack.f_41583_;
            Boolean modifyMainhandItem = json.has("modifyMainhandItem") ? GsonHelper.m_13912_((JsonObject)json, (String)"modifyMainhandItem") : false;
            Boolean modifyOffhandItem = json.has("modifyOffhandItem") ? GsonHelper.m_13912_((JsonObject)json, (String)"modifyOffhandItem") : false;
            String resultNBTName = json.has("resultNBTName") ? GsonHelper.m_13851_((JsonObject)json, (String)"resultNBTName", (String)"") : "";
            int resultNBTValue = json.has("resultNBTValue") ? GsonHelper.m_13927_((JsonObject)json, (String)"resultNBTValue") : 0;
            int resultNBTMinValue = json.has("resultNBTMinValue") ? GsonHelper.m_13927_((JsonObject)json, (String)"resultNBTMinValue") : 0;
            int resultNBTMaxValue = json.has("resultNBTMaxValue") ? GsonHelper.m_13927_((JsonObject)json, (String)"resultNBTMaxValue") : 0;
            return this.createRecipe(recipeId, group, blockTarget, mainhandTool, consumeMainhandItem, offhandTool, consumeOffhandItem, resultStack, modifyMainhandItem, modifyOffhandItem, resultNBTName, resultNBTValue, resultNBTMinValue, resultNBTMaxValue);
        }

        public InWorldDualHandedCrafting fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(Short.MAX_VALUE);
            boolean hasInput = buffer.readBoolean();
            Ingredient blockTarget = hasInput ? Ingredient.m_43940_((FriendlyByteBuf)buffer) : null;
            boolean hasMainHandTool = buffer.readBoolean();
            Ingredient mainhandTool = hasMainHandTool ? Ingredient.m_43940_((FriendlyByteBuf)buffer) : null;
            boolean consumeMainhandItem = buffer.readBoolean();
            boolean hasOffHandTool = buffer.readBoolean();
            Ingredient offhandTool = hasOffHandTool ? Ingredient.m_43940_((FriendlyByteBuf)buffer) : null;
            boolean consumeOffhandItem = buffer.readBoolean();
            ItemStack result = buffer.m_130267_();
            boolean modifyMainhandItem = buffer.readBoolean();
            boolean modifyOffhandItem = buffer.readBoolean();
            String resultNBTName = buffer.m_130136_(Short.MAX_VALUE);
            int resultNBTValue = buffer.readInt();
            int resultNBTMinValue = buffer.readInt();
            int resultNBTMaxValue = buffer.readInt();
            return this.createRecipe(recipeId, group, blockTarget, mainhandTool, consumeMainhandItem, offhandTool, consumeOffhandItem, result, modifyMainhandItem, modifyOffhandItem, resultNBTName, resultNBTValue, resultNBTMinValue, resultNBTMaxValue);
        }

        public void toNetwork(FriendlyByteBuf buffer, InWorldDualHandedCrafting recipe) {
            buffer.m_130070_(recipe.group);
            boolean hasInput = recipe.blockTarget != null;
            buffer.writeBoolean(hasInput);
            if (hasInput) {
                recipe.blockTarget.m_43923_(buffer);
            }
            boolean hasMainHandTool = recipe.mainhandTool != null;
            buffer.writeBoolean(hasMainHandTool);
            if (hasMainHandTool) {
                recipe.mainhandTool.m_43923_(buffer);
            }
            buffer.writeBoolean(recipe.consumeMainhandItem.booleanValue());
            boolean hasOffHandTool = recipe.offhandTool != null;
            buffer.writeBoolean(hasOffHandTool);
            if (hasOffHandTool) {
                recipe.offhandTool.m_43923_(buffer);
            }
            buffer.writeBoolean(recipe.consumeOffhandItem.booleanValue());
            buffer.m_130055_(recipe.resultStack);
            buffer.writeBoolean(recipe.modifyMainhandItem.booleanValue());
            buffer.writeBoolean(recipe.modifyOffhandItem.booleanValue());
            buffer.m_130070_(recipe.resultNBTName);
            buffer.writeInt(recipe.resultNBTValue);
            buffer.writeInt(recipe.resultNBTMinValue);
            buffer.writeInt(recipe.resultNBTMaxValue);
        }

        public RecipeSerializer<?> setRegistryName(ResourceLocation name) {
            return INSTANCE;
        }

        @Nullable
        public ResourceLocation getRegistryName() {
            return ID;
        }

        public Class<RecipeSerializer<?>> getRegistryType() {
            return Serializer.castClass(RecipeSerializer.class);
        }

        private static <G> Class<G> castClass(Class<?> cls) {
            return cls;
        }
    }
}

