/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.mowlib.Recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ObjectHolder;
import org.jetbrains.annotations.Nullable;

public class BaseBlockEntityFilter
implements Recipe<Container> {
    @ObjectHolder(registryName="forge:recipe_serializer", value="mowlib:entity_filter")
    private final String group;
    private final ResourceLocation id;
    @Nullable
    private final Ingredient input;
    private final String entityString;
    private final int type;
    private final boolean isbaby;

    public BaseBlockEntityFilter(ResourceLocation id, String group, @Nullable Ingredient input, String entityString, int type, boolean isbaby) {
        this.group = group;
        this.id = id;
        this.input = input;
        this.entityString = entityString;
        this.type = type;
        this.isbaby = isbaby;
    }

    public boolean m_5598_() {
        return true;
    }

    public static Collection<BaseBlockEntityFilter> getAllRecipes(Level world) {
        return world.m_7465_().m_44013_((RecipeType)Type.INSTANCE);
    }

    public String m_6076_() {
        return this.group;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess p_267052_) {
        return new ItemStack((ItemLike)Items.f_42127_);
    }

    public ItemStack getResultItemJEI() {
        return new ItemStack((ItemLike)Items.f_42127_);
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList allIngredients = NonNullList.m_122779_();
        allIngredients.add((Object)(this.input != null ? this.input : Ingredient.f_43901_));
        return allIngredients;
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        ItemStack inputStack = inv.m_8020_(0);
        return this.input.test(inputStack);
    }

    public ItemStack m_5874_(Container p_44001_, RegistryAccess p_267165_) {
        return this.m_8043_(p_267165_).m_41777_();
    }

    public String getResultEntityString() {
        return this.getEntityString();
    }

    public int getResultMobType() {
        return this.getMobType();
    }

    public boolean getResultBaby() {
        return this.getBaby();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)Items.f_42679_.m_5456_());
    }

    public String getEntityString() {
        return this.entityString;
    }

    public int getMobType() {
        return this.type;
    }

    public boolean getBaby() {
        return this.isbaby;
    }

    public Ingredient getPattern() {
        return this.input != null ? this.input : Ingredient.f_43901_;
    }

    public static class Type
    implements RecipeType<BaseBlockEntityFilter> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "entity_filter";

        private Type() {
        }
    }

    public static class Serializer
    implements RecipeSerializer<BaseBlockEntityFilter> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("mowlib", "entity_filter");

        protected BaseBlockEntityFilter createRecipe(ResourceLocation recipeId, String group, Ingredient input, String entityString, int type, boolean isbaby) {
            return new BaseBlockEntityFilter(recipeId, group, input, entityString, type, isbaby);
        }

        public BaseBlockEntityFilter fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            Ingredient input = json.has("input") ? CraftingHelper.getIngredient((JsonElement)json.get("input"), (boolean)false) : null;
            String entityString = json.has("entityString") ? GsonHelper.m_13906_((JsonObject)json, (String)"entityString") : "";
            int mobType = json.has("mobType") ? GsonHelper.m_13927_((JsonObject)json, (String)"mobType") : 1;
            boolean isBaby = json.has("isBaby") ? GsonHelper.m_13912_((JsonObject)json, (String)"isBaby") : false;
            return this.createRecipe(recipeId, group, input, entityString, mobType, isBaby);
        }

        public BaseBlockEntityFilter fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(Short.MAX_VALUE);
            boolean hasInput = buffer.readBoolean();
            Ingredient input = hasInput ? Ingredient.m_43940_((FriendlyByteBuf)buffer) : null;
            String entityString = buffer.m_130136_(Short.MAX_VALUE);
            int mobType = buffer.readInt();
            boolean isBaby = buffer.readBoolean();
            return this.createRecipe(recipeId, group, input, entityString, mobType, isBaby);
        }

        public void toNetwork(FriendlyByteBuf buffer, BaseBlockEntityFilter recipe) {
            buffer.m_130070_(recipe.group);
            boolean hasInput = recipe.input != null;
            buffer.writeBoolean(hasInput);
            if (hasInput) {
                recipe.input.m_43923_(buffer);
            }
            buffer.m_130070_(recipe.entityString);
            buffer.writeInt(recipe.type);
            buffer.writeBoolean(recipe.isbaby);
        }

        public RecipeSerializer<?> setRegistryName(ResourceLocation name) {
            return INSTANCE;
        }

        @Nullable
        public ResourceLocation getRegistryName() {
            return ID;
        }

        public Class<RecipeSerializer<?>> getRegistryType() {
            return Serializer.castClass(RecipeSerializer.class);
        }

        private static <G> Class<G> castClass(Class<?> cls) {
            return cls;
        }
    }
}

