/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.mowlib.Networking;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.joml.Vector3f;

public class MowLibPacketParticles {
    private final EffectType type;
    private final double x;
    private final double y;
    private final double z;
    private final int[] args;

    public MowLibPacketParticles(EffectType type, double x, double y, double z, int ... args) {
        this.type = type;
        this.x = x;
        this.y = y;
        this.z = z;
        this.args = args;
    }

    public MowLibPacketParticles(EffectType type, BlockPos pos, int ... args) {
        this(type, pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), args);
    }

    public static MowLibPacketParticles decode(FriendlyByteBuf buf) {
        EffectType type = EffectType.values()[buf.readByte()];
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        int[] args = new int[type.argCount];
        for (int i = 0; i < args.length; ++i) {
            args[i] = buf.m_130242_();
        }
        return new MowLibPacketParticles(type, x, y, z, args);
    }

    public static void encode(MowLibPacketParticles msg, FriendlyByteBuf buf) {
        buf.writeByte(msg.type.ordinal());
        buf.writeDouble(msg.x);
        buf.writeDouble(msg.y);
        buf.writeDouble(msg.z);
        for (int i = 0; i < msg.type.argCount; ++i) {
            buf.m_130130_(msg.args[i]);
        }
    }

    public static enum EffectType {
        ANY_COLOR(3),
        ANY_COLOR_CENTERED(3),
        ANY_COLOR_BEAM(3);

        private final int argCount;

        private EffectType(int argCount) {
            this.argCount = argCount;
        }
    }

    public static class Handler {
        public static void handle(final MowLibPacketParticles message, Supplier<NetworkEvent.Context> ctx) {
            if (ctx.get().getDirection().getReceptionSide().isServer()) {
                ctx.get().setPacketHandled(true);
                return;
            }
            ctx.get().enqueueWork(new Runnable(){

                @Override
                public void run() {
                    Minecraft mc = Minecraft.m_91087_();
                    ClientLevel world = mc.f_91073_;
                    switch (message.type) {
                        case ANY_COLOR: {
                            for (int i = 0; i < 10; ++i) {
                                double d0 = message.x;
                                double d1 = message.y;
                                double d2 = message.z;
                                float red = (float)message.args[0] / 255.0f;
                                float green = (float)message.args[1] / 255.0f;
                                float blue = (float)message.args[2] / 255.0f;
                                world.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(red, green, blue), 1.0f), d0, d1, d2, ((double)(world.f_46441_.m_188501_() * 1.0f) - 0.5) / 3.0, ((double)(world.f_46441_.m_188501_() * 1.0f) - 0.5) / 3.0, ((double)(world.f_46441_.m_188501_() * 1.0f) - 0.5) / 3.0);
                            }
                            break;
                        }
                        case ANY_COLOR_CENTERED: {
                            for (int i = 0; i < 10; ++i) {
                                double d0 = message.x + 0.5;
                                double d1 = message.y;
                                double d2 = message.z + 0.5;
                                float red = (float)message.args[0] / 255.0f;
                                float green = (float)message.args[1] / 255.0f;
                                float blue = (float)message.args[2] / 255.0f;
                                world.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(red, green, blue), 1.0f), d0, d1, d2, ((double)(world.f_46441_.m_188501_() * 1.0f) - 0.5) / 3.0, ((double)(world.f_46441_.m_188501_() * 1.0f) - 0.5) / 3.0, ((double)(world.f_46441_.m_188501_() * 1.0f) - 0.5) / 3.0);
                            }
                            break;
                        }
                        case ANY_COLOR_BEAM: {
                            for (int z = 0; z < 10; ++z) {
                                double x1 = message.x;
                                double y1 = message.y;
                                double z1 = message.z;
                                double x2 = message.args[0];
                                double y2 = message.args[1];
                                double z2 = message.args[2];
                                double x3 = x2 - x1;
                                double y3 = y2 - y1;
                                double z3 = z2 - z1;
                                BlockPos pos = new BlockPos((int)x1, (int)y1, (int)z1);
                                Random rand = new Random();
                                world.m_7106_((ParticleOptions)ParticleTypes.f_123809_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.25, (double)pos.m_123343_() + 0.5, (double)((float)x3 + rand.nextFloat()) - 0.5, (double)((float)y3 - rand.nextFloat()), (double)((float)z3 + rand.nextFloat()) - 0.5);
                            }
                            break;
                        }
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

