/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.mowlib.MowLibUtils;

import com.mowmaster.mowlib.BlockEntities.MowLibBaseFilterableBlockEntity;
import com.mowmaster.mowlib.Items.WorkCards.WorkCardArea;
import com.mowmaster.mowlib.Items.WorkCards.WorkCardBE;
import com.mowmaster.mowlib.Items.WorkCards.WorkCardBase;
import com.mowmaster.mowlib.Items.WorkCards.WorkCardLocations;
import com.mowmaster.mowlib.MowLibUtils.MowLibBlockPosUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class MowLibWorkCardUtil {
    public static void resetCachedValidWorkCardPositions(String modid, ItemStack upgrade) {
        MowLibBlockPosUtils.removeBlockListCustomNBTTags(modid, "_validlist", upgrade);
    }

    public static List<BlockPos> getValidWorkCardPositions(MowLibBaseFilterableBlockEntity filterableBlockEntity, ItemStack upgrade, int workCardType, int getUpgradeRange, String modid) {
        List<Object> cached = MowLibBlockPosUtils.readBlockPosListCustomFromNBT(modid, "_validlist", upgrade);
        if (cached.size() == 0 && !MowLibBlockPosUtils.hasBlockListCustomNBTTags(modid, "_validlist", upgrade) && filterableBlockEntity.hasWorkCard()) {
            ItemStack workCardItemStack = filterableBlockEntity.getWorkCardInPedestal();
            Item item = workCardItemStack.m_41720_();
            if (item instanceof WorkCardBase) {
                WorkCardBase baseCard = (WorkCardBase)item;
                int supportedWorkCardTypesForThisUpgrade = workCardType;
                int insertedWorkCardType = baseCard.getWorkCardType();
                if (insertedWorkCardType == supportedWorkCardTypesForThisUpgrade || supportedWorkCardTypesForThisUpgrade == 0 && (insertedWorkCardType == 1 || insertedWorkCardType == 2)) {
                    cached = switch (baseCard.getWorkCardType()) {
                        case 1 -> WorkCardArea.getPositionsInRangeOfUpgrade(workCardItemStack, filterableBlockEntity, getUpgradeRange);
                        case 2 -> WorkCardLocations.getPositionsInRangeOfUpgrade(workCardItemStack, filterableBlockEntity, getUpgradeRange);
                        case 3 -> WorkCardBE.getPositionsInRangeOfUpgrade(workCardItemStack, filterableBlockEntity, getUpgradeRange);
                        default -> List.of();
                    };
                }
            }
            MowLibBlockPosUtils.saveBlockPosListCustomToNBT(modid, "_validlist", upgrade, cached);
        }
        return cached;
    }
}

