/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.mowlib.MowLibUtils;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.mowmaster.mowlib.BlockEntities.MowLibBaseBlockEntity;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class MowLibRenderUtils {
    public static void renderItemRotating(Level worldIn, PoseStack p_112309_, MultiBufferSource p_112310_, ItemStack itemStack, int p_112311_, int p_112312_) {
        if (!itemStack.m_41619_()) {
            p_112309_.m_85836_();
            p_112309_.m_85837_(0.5, 1.0, 0.5);
            p_112309_.m_85841_(0.75f, 0.75f, 0.75f);
            long time = System.currentTimeMillis();
            float angle = time / 25L % 360L;
            p_112309_.m_252781_(Axis.f_252436_.m_252977_(angle));
            ItemRenderer renderer = Minecraft.m_91087_().m_91291_();
            BakedModel baked = renderer.m_174264_(itemStack, worldIn, null, 0);
            renderer.m_115143_(itemStack, ItemDisplayContext.GROUND, true, p_112309_, p_112310_, p_112311_, p_112312_, baked);
            p_112309_.m_85849_();
        }
    }

    public static void renderItemRotatingModified(Level level, PoseStack posStack, MultiBufferSource buffers, ItemStack itemStack, int light, int overlay) {
        if (!itemStack.m_41619_()) {
            long time = System.currentTimeMillis();
            float angle = time / 25L % 360L;
            MowLibRenderUtils.renderStaticSingleItemStack(level, itemStack, posStack, buffers, light, overlay, 0.5, 1.0, 0.5, 0.75f, 0.75f, 0.75f, 0.0f, angle, 0.0f, ItemDisplayContext.GROUND);
        }
    }

    public static void renderMultipleItemsRotating(Level level, PoseStack posStack, MultiBufferSource buffers, List<ItemStack> listed, int light, int overlay) {
        int stacks = listed.size();
        if (stacks > 1) {
            posStack.m_85836_();
            int items = stacks;
            float[] angles = new float[stacks];
            float anglePer = 360.0f / (float)items;
            float totalAngle = 0.0f;
            for (int i = 0; i < angles.length; ++i) {
                angles[i] = totalAngle += anglePer;
            }
            double time = level.m_46467_();
            float sized = 1.25f;
            float sizedd = 0.25f;
            if (stacks <= 4) {
                sized = 0.25f;
                sizedd = 0.05f;
            }
            if (stacks <= 8 && stacks > 4) {
                sized = 0.5f;
                sizedd = 0.1f;
            }
            if (stacks <= 12 && stacks > 8) {
                sized = 0.75f;
                sizedd = 0.15f;
            }
            if (stacks <= 16 && stacks > 12) {
                sized = 1.0f;
                sizedd = 0.2f;
            }
            for (int i = 0; i < stacks; ++i) {
                posStack.m_85836_();
                posStack.m_252880_(0.5f, 0.75f, 0.5f);
                posStack.m_252781_(Axis.f_252436_.m_252977_(angles[i] + (float)time));
                posStack.m_252880_(sized, 0.0f, sizedd);
                posStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                posStack.m_85837_(0.0, 0.075 * Math.sin((time + (double)(i * 10)) / 5.0), 0.0);
                ItemStack stack = listed.get(i);
                Minecraft mc = Minecraft.m_91087_();
                if (!stack.m_41619_()) {
                    mc.m_91291_().m_269128_(stack, ItemDisplayContext.GROUND, light, overlay, posStack, buffers, level, 0);
                }
                posStack.m_85849_();
            }
            posStack.m_85849_();
        } else if (stacks == 1) {
            posStack.m_85836_();
            posStack.m_85837_(0.5, 1.0, 0.5);
            posStack.m_85841_(0.75f, 0.75f, 0.75f);
            long time = System.currentTimeMillis();
            float angle = time / 25L % 360L;
            posStack.m_252781_(Axis.f_252436_.m_252977_(angle));
            ItemRenderer renderer = Minecraft.m_91087_().m_91291_();
            BakedModel baked = renderer.m_174264_(listed.get(0), level, null, 0);
            renderer.m_115143_(listed.get(0), ItemDisplayContext.GROUND, true, posStack, buffers, light, overlay, baked);
            posStack.m_85849_();
        }
    }

    public static void renderMultipleItemsRotatingModified(Level level, PoseStack posStack, MultiBufferSource buffers, List<ItemStack> listed, int light, int overlay) {
        int stacks = listed.size();
        if (stacks > 1) {
            posStack.m_85836_();
            int items = stacks;
            float[] angles = new float[stacks];
            float anglePer = 360.0f / (float)items;
            float totalAngle = 0.0f;
            for (int i = 0; i < angles.length; ++i) {
                angles[i] = totalAngle += anglePer;
            }
            double time = level.m_46467_();
            float sized = 1.25f;
            float sizedd = 0.25f;
            if (stacks <= 4) {
                sized = 0.25f;
                sizedd = 0.05f;
            }
            if (stacks <= 8 && stacks > 4) {
                sized = 0.5f;
                sizedd = 0.1f;
            }
            if (stacks <= 12 && stacks > 8) {
                sized = 0.75f;
                sizedd = 0.15f;
            }
            if (stacks <= 16 && stacks > 12) {
                sized = 1.0f;
                sizedd = 0.2f;
            }
            for (int i = 0; i < stacks; ++i) {
                posStack.m_85836_();
                posStack.m_252880_(0.5f, 0.75f, 0.5f);
                posStack.m_252781_(Axis.f_252436_.m_252977_(angles[i] + (float)time));
                posStack.m_252880_(sized, 0.0f, sizedd);
                posStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                posStack.m_85837_(0.0, 0.075 * Math.sin((time + (double)(i * 10)) / 5.0), 0.0);
                ItemStack stack = listed.get(i);
                Minecraft mc = Minecraft.m_91087_();
                if (!stack.m_41619_()) {
                    mc.m_91291_().m_269128_(stack, ItemDisplayContext.GROUND, light, overlay, posStack, buffers, level, 0);
                }
                posStack.m_85849_();
            }
            posStack.m_85849_();
        } else if (stacks == 1) {
            long time = System.currentTimeMillis();
            float angleY = time / 25L % 360L;
            MowLibRenderUtils.renderStaticSingleItemStack(level, listed.get(0), posStack, buffers, light, overlay, 0.5, 1.0, 0.5, 0.75f, 0.75f, 0.75f, 0.0f, angleY, 0.0f, ItemDisplayContext.GROUND);
        }
    }

    public static void renderStaticSingleItemStack(Level worldIn, ItemStack itemTool, PoseStack p_112309_, MultiBufferSource p_112310_, int p_112311_, int p_112312_, double moveX, double moveY, double moveZ, float scaleX, float scaleY, float scaleZ, float angleX, float angleY, float angleZ, ItemDisplayContext context) {
        if (!itemTool.m_41619_()) {
            p_112309_.m_85836_();
            p_112309_.m_85837_(moveX, moveY, moveZ);
            p_112309_.m_85841_(scaleX, scaleY, scaleZ);
            if (angleX <= 0.0f) {
                p_112309_.m_252781_(Axis.f_252529_.m_252977_(angleX));
            }
            if (angleY <= 0.0f) {
                p_112309_.m_252781_(Axis.f_252436_.m_252977_(angleY));
            }
            if (angleZ <= 0.0f) {
                p_112309_.m_252781_(Axis.f_252403_.m_252977_(angleZ));
            }
            ItemRenderer renderer = Minecraft.m_91087_().m_91291_();
            BakedModel baked = renderer.m_174264_(itemTool, worldIn, null, 0);
            renderer.m_115143_(itemTool, context, true, p_112309_, p_112310_, p_112311_, p_112312_, baked);
            p_112309_.m_85849_();
        }
    }

    public static void renderBoundingBox(BlockPos pos, AABB aabb, PoseStack matrixStack, VertexConsumer buffer, MowLibBaseBlockEntity blockEntity, float red, float green, float blue, float alpha) {
        Matrix4f matrix4f = matrixStack.m_85850_().m_252922_();
        Matrix3f matrix3f = matrixStack.m_85850_().m_252943_();
        float minX = (float)(aabb.f_82288_ - (double)pos.m_123341_());
        float minY = (float)(aabb.f_82289_ - (double)pos.m_123342_());
        float minZ = (float)(aabb.f_82290_ - (double)pos.m_123343_());
        float maxX = (float)(aabb.f_82291_ - (double)pos.m_123341_());
        float maxY = (float)(aabb.f_82292_ - (double)pos.m_123342_());
        float maxZ = (float)(aabb.f_82293_ - (double)pos.m_123343_());
        buffer.m_252986_(matrix4f, minX, minY, maxZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, minY, maxZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, minY, minZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, minY, minZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, minY, minZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, minY, maxZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, minY, minZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, minY, maxZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, maxY, maxZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, maxY, maxZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, maxY, minZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, maxY, minZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, maxY, minZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, maxY, maxZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, maxY, minZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, maxY, maxZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, minY, minZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, maxY, minZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, minY, maxZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, maxY, maxZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, minY, maxZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, maxY, maxZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, minY, minZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, maxY, minZ).m_85950_(red, green, blue, alpha).m_252939_(matrix3f, 0.0f, 0.0f, -1.0f).m_5752_();
    }

    public static void renderFaces(TextureAtlasSprite sprite, BlockPos pos, AABB aabb, PoseStack matrixStack, VertexConsumer buffer, MowLibBaseBlockEntity blockEntity, float red, float green, float blue, float alpha) {
        Matrix4f matrix4f = matrixStack.m_85850_().m_252922_();
        float minX = (float)(aabb.f_82288_ - (double)pos.m_123341_());
        float minY = (float)(aabb.f_82289_ - (double)pos.m_123342_());
        float minZ = (float)(aabb.f_82290_ - (double)pos.m_123343_());
        float maxX = (float)(aabb.f_82291_ - (double)pos.m_123341_());
        float maxY = (float)(aabb.f_82292_ - (double)pos.m_123342_());
        float maxZ = (float)(aabb.f_82293_ - (double)pos.m_123343_());
        float minU = sprite.m_118409_();
        float maxU = sprite.m_118410_();
        float minV = sprite.m_118411_();
        float maxV = sprite.m_118412_();
        int uvBrightness = 240;
        buffer.m_252986_(matrix4f, minX - 0.01f, minY, maxZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX - 0.01f, maxY, maxZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX - 0.01f, maxY, minZ).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX - 0.01f, minY, minZ).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX + 0.01f, minY, minZ).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX + 0.01f, maxY, minZ).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX + 0.01f, maxY, maxZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX + 0.01f, minY, maxZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX + 0.01f, minY, minZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX + 0.01f, maxY, minZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX + 0.01f, maxY, maxZ).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX + 0.01f, minY, maxZ).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX - 0.01f, minY, maxZ).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX - 0.01f, maxY, maxZ).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX - 0.01f, maxY, minZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX - 0.01f, minY, minZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, maxY, minZ - 0.01f).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, maxY, minZ - 0.01f).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, minY, minZ - 0.01f).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, minY, minZ - 0.01f).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, minY, minZ + 0.01f).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, minY, minZ + 0.01f).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, maxY, minZ + 0.01f).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, maxY, minZ + 0.01f).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, minY, maxZ + 0.01f).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, minY, maxZ + 0.01f).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, maxY, maxZ + 0.01f).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, maxY, maxZ + 0.01f).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, maxY, maxZ - 0.01f).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, maxY, maxZ - 0.01f).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, minY, maxZ - 0.01f).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, minY, maxZ - 0.01f).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, minY - 0.01f, minZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, minY - 0.01f, maxZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, minY - 0.01f, maxZ).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, minY - 0.01f, minZ).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, minY + 0.01f, minZ).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, minY + 0.01f, maxZ).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, minY + 0.01f, maxZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, minY + 0.01f, minZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, maxY + 0.01f, minZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, maxY + 0.01f, maxZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, maxY + 0.01f, maxZ).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, maxY + 0.01f, minZ).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, maxY - 0.01f, minZ).m_85950_(red, green, blue, alpha).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, maxX, maxY - 0.01f, maxZ).m_85950_(red, green, blue, alpha).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, maxY - 0.01f, maxZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
        buffer.m_252986_(matrix4f, minX, maxY - 0.01f, minZ).m_85950_(red, green, blue, alpha).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(uvBrightness).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
    }

    public static void renderHUD(PoseStack posStack, MultiBufferSource buffer, List<String> messages, float moveX, float moveY, float moveZ, float scaleX, float scaleY, float scaleZ, int angleX, int angleY, int angleZ) {
        posStack.m_85836_();
        posStack.m_252880_(moveX, moveY, moveZ);
        posStack.m_85841_(scaleX, scaleY, scaleZ);
        if (angleX <= 0) {
            posStack.m_252781_(Axis.f_252529_.m_252977_((float)angleX));
        }
        if (angleY <= 0) {
            posStack.m_252781_(Axis.f_252436_.m_252977_((float)angleY));
        }
        if (angleZ <= 0) {
            posStack.m_252781_(Axis.f_252403_.m_252977_((float)angleZ));
        }
        Font fontrenderer = Minecraft.m_91087_().f_91062_;
        int lines = 11;
        float xHeight = 1.0f;
        float yHeight = 7.0f;
        float additionalHeight = 10.0f;
        int logsize = messages.size();
        int i = 0;
        for (String s : messages) {
            if (i >= logsize - lines && yHeight + additionalHeight <= 124.0f) {
                String prefix = "";
                MutableComponent comp = Component.m_237119_();
                fontrenderer.m_271703_(fontrenderer.m_92834_(prefix + s, 115), xHeight, yHeight, 7, false, posStack.m_85850_().m_252922_(), buffer, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
                yHeight += additionalHeight;
            }
            ++i;
        }
        posStack.m_85849_();
    }
}

