/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.mowlib.MowLibUtils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mowmaster.mowlib.MowLibUtils.MowLibCompoundTagUtils;
import com.mowmaster.mowlib.Recipes.Ingredients.FluidTagIngredient;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class MowLibRecipeUtils {
    public static void resetCachedAbstractCooking(String modID, ItemStack stackToStoreNBT) {
        CompoundTag tag = stackToStoreNBT.m_41784_();
        MowLibCompoundTagUtils.removeCustomTagFromNBT(modID, tag, "cook_ingredient");
        MowLibCompoundTagUtils.removeCustomTagFromNBT(modID, tag, "cook_result");
        MowLibCompoundTagUtils.removeCustomTagFromNBT(modID, tag, "cook_time");
        MowLibCompoundTagUtils.removeCustomTagFromNBT(modID, tag, "cook_xp_gain");
        MowLibCompoundTagUtils.removeCustomTagFromNBT(modID, tag, "cook_cached");
    }

    private static boolean hasCachedAbstractCooking(String modID, ItemStack stackToStoreNBT) {
        return MowLibCompoundTagUtils.readBooleanFromNBT(modID, stackToStoreNBT.m_41784_(), "cook_cached");
    }

    private static boolean cachedAbstractCookingHasSameInput(String modID, ItemStack stackToStoreNBT, ItemStack input) {
        ItemStack cachedInput = MowLibCompoundTagUtils.readItemStackFromNBT(modID, stackToStoreNBT.m_41784_(), "cook_ingredient");
        return ItemHandlerHelper.canItemStacksStack((ItemStack)input, (ItemStack)cachedInput) || input.m_41619_() && cachedInput.m_41619_();
    }

    private static <T extends AbstractCookingRecipe> ItemStack getAndCacheAbstractCookingResult(String modID, Level level, ItemStack stackToStoreNBT, ItemStack input, RecipeType<T> recipeType) {
        SimpleContainer container = new SimpleContainer(new ItemStack[]{input});
        RecipeManager recipeManager = level.m_7465_();
        Optional result = recipeManager.m_44015_(recipeType, (Container)container, level);
        if (result.isPresent()) {
            AbstractCookingRecipe recipe = (AbstractCookingRecipe)result.get();
            ItemStack resultItem = recipe.m_8043_(level.m_9598_());
            CompoundTag tag = stackToStoreNBT.m_41784_();
            MowLibCompoundTagUtils.writeItemStackToNBT(modID, tag, input, "cook_ingredient");
            MowLibCompoundTagUtils.writeItemStackToNBT(modID, tag, resultItem, "cook_result");
            MowLibCompoundTagUtils.writeIntegerToNBT(modID, tag, recipe.m_43753_(), "cook_time");
            MowLibCompoundTagUtils.writeIntegerToNBT(modID, tag, Math.round(recipe.m_43750_()), "cook_xp_gain");
            MowLibCompoundTagUtils.writeBooleanToNBT(modID, tag, true, "cook_cached");
            return resultItem;
        }
        MowLibCompoundTagUtils.writeBooleanToNBT(modID, stackToStoreNBT.m_41784_(), false, "cook_cached");
        return ItemStack.f_41583_;
    }

    public static <T extends AbstractCookingRecipe> ItemStack getAbstractCookingResult(String modID, Level level, ItemStack stackToStoreNBT, ItemStack ingredient, RecipeType<T> recipeType) {
        if (MowLibRecipeUtils.hasCachedAbstractCooking(modID, stackToStoreNBT) && MowLibRecipeUtils.cachedAbstractCookingHasSameInput(modID, stackToStoreNBT, ingredient)) {
            return MowLibCompoundTagUtils.readItemStackFromNBT(modID, stackToStoreNBT.m_41784_(), "cook_result");
        }
        return MowLibRecipeUtils.getAndCacheAbstractCookingResult(modID, level, stackToStoreNBT, ingredient, recipeType);
    }

    public static int getXpGainFromCachedRecipe(String modID, ItemStack stackToStoreNBT) {
        return MowLibCompoundTagUtils.readIntegerFromNBT(modID, stackToStoreNBT.m_41784_(), "cook_xp_gain");
    }

    public static int getCookTimeRequired(String modID, ItemStack stackToStoreNBT) {
        return MowLibCompoundTagUtils.readIntegerFromNBT(modID, stackToStoreNBT.m_41784_(), "cook_time");
    }

    public static int getCookTimeElapsed(String modID, ItemStack stackToStoreNBT) {
        return MowLibCompoundTagUtils.readIntegerFromNBT(modID, stackToStoreNBT.m_41784_(), "cook_time_elapsed");
    }

    public static void setCookTimeElapsed(String modID, ItemStack stackToStoreNBT, int timeElapsed) {
        MowLibCompoundTagUtils.writeIntegerToNBT(modID, stackToStoreNBT.m_41784_(), timeElapsed, "cook_time_elapsed");
    }

    public static boolean matchFluid(FluidStack tileFluid, FluidTagIngredient ing) {
        TagKey ft;
        if (tileFluid == null || tileFluid.isEmpty()) {
            return false;
        }
        if (ing.hasFluid() && tileFluid.getFluid() == ing.getFluidStack().getFluid()) {
            return true;
        }
        return ing.hasTag() && (ft = FluidTags.create((ResourceLocation)new ResourceLocation(ing.getTag()))) != null && tileFluid.getFluid() != null && tileFluid.getFluid().m_205067_(ft);
    }

    public static FluidTagIngredient parseFluid(JsonObject json, String key) {
        JsonObject mix = json.get(key).getAsJsonObject();
        int count = mix.get("count").getAsInt();
        if (count < 1) {
            count = 1;
        }
        FluidStack fluidstack = FluidStack.EMPTY;
        if (mix.has("fluid")) {
            String fluidId = mix.get("fluid").getAsString();
            ResourceLocation resourceLocation = new ResourceLocation(fluidId);
            Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(resourceLocation);
            fluidstack = fluid == null ? FluidStack.EMPTY : new FluidStack(fluid, count);
        }
        String ftag = mix.has("tag") ? mix.get("tag").getAsString() : "";
        return new FluidTagIngredient(fluidstack, ftag, count);
    }

    public static NonNullList<Ingredient> getIngredientsArray(JsonObject obj) {
        JsonArray array = GsonHelper.m_13933_((JsonObject)obj, (String)"ingredients");
        NonNullList nonnulllist = NonNullList.m_122779_();
        for (int i = 0; i < array.size(); ++i) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)array.get(i));
            if (ingredient.m_43947_()) continue;
            nonnulllist.add((Object)ingredient);
        }
        return nonnulllist;
    }

    public static FluidStack getFluid(JsonObject fluidJson) {
        if (fluidJson.has("fluidTag")) {
            // empty if block
        }
        String fluidId = GsonHelper.m_13906_((JsonObject)fluidJson, (String)"fluid");
        ResourceLocation resourceLocation = new ResourceLocation(fluidId);
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(resourceLocation);
        int count = fluidJson.get("count").getAsInt();
        if (count < 1) {
            count = 1;
        }
        return new FluidStack(fluid, count);
    }
}

