/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.mowlib.MowLibUtils;

import com.mowmaster.mowlib.MowLibUtils.MowLibColorReference;
import com.mowmaster.mowlib.MowLibUtils.MowLibContainerUtils;
import com.mowmaster.mowlib.Recipes.MobEffectColorRecipe;
import com.mowmaster.mowlib.Recipes.MobEffectColorRecipeCorrupted;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class MowLibEffectUtils {
    @Nullable
    protected static MobEffectColorRecipe getRecipeMobEffectColor(Level level, ItemStack stackIn) {
        Container container = MowLibContainerUtils.getContainer(1);
        container.m_6836_(-1, stackIn);
        List recipes = level.m_7465_().m_44056_((RecipeType)MobEffectColorRecipe.Type.INSTANCE, container, level);
        return recipes.size() > 0 ? (MobEffectColorRecipe)level.m_7465_().m_44056_((RecipeType)MobEffectColorRecipe.Type.INSTANCE, container, level).get(0) : null;
    }

    protected static String getProcessResultMobEffectColorRecipe(MobEffectColorRecipe recipe) {
        return recipe == null ? "" : recipe.getResultEffectName();
    }

    protected static int getProcessResultEffectColorRecipe(MobEffectColorRecipe recipe) {
        return recipe == null ? 0xFFFFFF : recipe.getResultEffectColor();
    }

    protected static int getProcessResultEffectInstantDurationRecipe(MobEffectColorRecipe recipe) {
        return recipe == null ? 1 : recipe.getResultInstantTickDuration();
    }

    @Nullable
    protected static MobEffectColorRecipeCorrupted getRecipeMobEffectColorCorrupted(Level level, ItemStack stackIn) {
        Container container = MowLibContainerUtils.getContainer(1);
        container.m_6836_(-1, stackIn);
        List recipes = level.m_7465_().m_44056_((RecipeType)MobEffectColorRecipeCorrupted.Type.INSTANCE, container, level);
        return recipes.size() > 0 ? (MobEffectColorRecipeCorrupted)level.m_7465_().m_44056_((RecipeType)MobEffectColorRecipeCorrupted.Type.INSTANCE, container, level).get(0) : null;
    }

    protected static String getProcessResultMobEffectColorRecipeCorrupted(MobEffectColorRecipeCorrupted recipe) {
        return recipe == null ? "" : recipe.getResultEffectName();
    }

    protected static int getProcessResultEffectColorRecipeCorrupted(MobEffectColorRecipeCorrupted recipe) {
        return recipe == null ? 0xFFFFFF : recipe.getResultEffectColor();
    }

    protected static int getProcessResultEffectInstantDurationRecipeCorrupted(MobEffectColorRecipeCorrupted recipe) {
        return recipe == null ? 1 : recipe.getResultInstantTickDuration();
    }

    public static MobEffect getEffectForColor(Level level, ItemStack colorableCrystal, boolean corruption, int currentColor) {
        ItemStack stack;
        ResourceLocation location;
        if (corruption) {
            ItemStack stack2 = MowLibColorReference.addColorToItemStack(colorableCrystal, currentColor);
            ResourceLocation location2 = new ResourceLocation(MowLibEffectUtils.getProcessResultMobEffectColorRecipeCorrupted(MowLibEffectUtils.getRecipeMobEffectColorCorrupted(level, stack2)));
            if (ForgeRegistries.MOB_EFFECTS.containsKey(location2)) {
                return (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(location2);
            }
        } else if (!corruption && ForgeRegistries.MOB_EFFECTS.containsKey(location = new ResourceLocation(MowLibEffectUtils.getProcessResultMobEffectColorRecipe(MowLibEffectUtils.getRecipeMobEffectColor(level, stack = MowLibColorReference.addColorToItemStack(colorableCrystal, currentColor)))))) {
            return (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(location);
        }
        return MowLibEffectUtils.getRandomNegativeEffect();
    }

    public static int getColorForEffect(Level level, ItemStack colorableCrystal, boolean corruption, int currentColor) {
        if (corruption) {
            ItemStack stack = MowLibColorReference.addColorToItemStack(colorableCrystal, currentColor);
            return MowLibEffectUtils.getProcessResultEffectColorRecipeCorrupted(MowLibEffectUtils.getRecipeMobEffectColorCorrupted(level, stack));
        }
        if (!corruption) {
            ItemStack stack = MowLibColorReference.addColorToItemStack(colorableCrystal, currentColor);
            return MowLibEffectUtils.getProcessResultEffectColorRecipe(MowLibEffectUtils.getRecipeMobEffectColor(level, stack));
        }
        return 0xFFFFFF;
    }

    public static int getInstantDuration(Level level, ItemStack colorableCrystal, boolean corruption, int currentColor) {
        if (corruption) {
            ItemStack stack = MowLibColorReference.addColorToItemStack(colorableCrystal, currentColor);
            return MowLibEffectUtils.getProcessResultEffectInstantDurationRecipeCorrupted(MowLibEffectUtils.getRecipeMobEffectColorCorrupted(level, stack));
        }
        if (!corruption) {
            ItemStack stack = MowLibColorReference.addColorToItemStack(colorableCrystal, currentColor);
            return MowLibEffectUtils.getProcessResultEffectInstantDurationRecipe(MowLibEffectUtils.getRecipeMobEffectColor(level, stack));
        }
        return 0xFFFFFF;
    }

    public static MobEffect getRandomNegativeEffect() {
        Random rand = new Random();
        Map NEGEFFECT = Map.ofEntries(Map.entry(0, MobEffects.f_19594_), Map.entry(1, MobEffects.f_19610_), Map.entry(2, MobEffects.f_19619_), Map.entry(3, MobEffects.f_19612_), Map.entry(4, MobEffects.f_19602_), Map.entry(5, MobEffects.f_19620_), Map.entry(6, MobEffects.f_19599_), Map.entry(7, MobEffects.f_19604_), Map.entry(8, MobEffects.f_19614_), Map.entry(9, MobEffects.f_19597_), Map.entry(10, MobEffects.f_19590_), Map.entry(11, MobEffects.f_19613_), Map.entry(12, MobEffects.f_19615_));
        return NEGEFFECT.getOrDefault(rand.nextInt(13), MobEffects.f_19612_);
    }
}

