/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.mowlib.MowLibUtils;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class MowLibCompoundTagUtils {
    public static CompoundTag writeItemHandlerToNBT(String ModID, @Nullable CompoundTag inputNBT, LazyOptional<ItemStackHandler> handler, String identifier) {
        CompoundTag compound = inputNBT != null ? inputNBT : new CompoundTag();
        handler.ifPresent(h -> {
            CompoundTag compoundStorage = (CompoundTag)h.serializeNBT();
            compound.m_128365_(ModID + identifier, (Tag)compoundStorage);
        });
        return compound;
    }

    public static List<ItemStack> readItemHandlerFromNBT(String ModID, CompoundTag inputNBT, String identifier) {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        if (inputNBT == null) {
            return stackList;
        }
        if (inputNBT.m_128441_(ModID + identifier)) {
            CompoundTag invTag = inputNBT.m_128469_(ModID + identifier);
            ItemStackHandler handler = new ItemStackHandler();
            handler.deserializeNBT((Tag)invTag);
            for (int i = 0; i < handler.getSlots(); ++i) {
                stackList.add(handler.getStackInSlot(i));
            }
            return stackList;
        }
        return stackList;
    }

    public static CompoundTag readItemHandlerTagFromNBT(String ModID, CompoundTag inputNBT, String identifier) {
        if (inputNBT == null) {
            return null;
        }
        if (inputNBT.m_128441_(ModID + identifier)) {
            CompoundTag invTag = inputNBT.m_128469_(ModID + identifier);
            return invTag;
        }
        return null;
    }

    public static CompoundTag writeItemStackListToNBT(String ModID, @Nullable CompoundTag inputNBT, List<ItemStack> listIn, String identifier) {
        CompoundTag compound = inputNBT != null ? inputNBT : new CompoundTag();
        CompoundTag compoundStorage = new CompoundTag();
        if (listIn.size() > 0) {
            ItemStackHandler handler = new ItemStackHandler();
            handler.setSize(listIn.size());
            for (int i = 0; i < handler.getSlots(); ++i) {
                handler.setStackInSlot(i, listIn.get(i));
            }
            compoundStorage = handler.serializeNBT();
        }
        compound.m_128365_(ModID + identifier, (Tag)compoundStorage);
        return compound;
    }

    public static List<ItemStack> readItemStackListFromNBT(String ModID, CompoundTag inputNBT, String identifier) {
        if (inputNBT == null) {
            return null;
        }
        if (inputNBT.m_128441_(ModID + identifier)) {
            ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
            CompoundTag invTag = inputNBT.m_128469_(ModID + identifier);
            ItemStackHandler handler = new ItemStackHandler();
            handler.deserializeNBT((Tag)invTag);
            for (int i = 0; i < handler.getSlots(); ++i) {
                stackList.add(handler.getStackInSlot(i));
            }
            return stackList;
        }
        return null;
    }

    public static CompoundTag writeItemStackToNBT(String ModID, @Nullable CompoundTag inputNBT, ItemStack stackIn, String identifier) {
        CompoundTag compound = inputNBT != null ? inputNBT : new CompoundTag();
        CompoundTag compoundStorage = new CompoundTag();
        ArrayList<ItemStack> listIn = new ArrayList<ItemStack>();
        listIn.add(stackIn);
        if (!stackIn.m_41619_()) {
            ItemStackHandler handler = new ItemStackHandler();
            handler.setSize(listIn.size());
            for (int i = 0; i < handler.getSlots(); ++i) {
                handler.setStackInSlot(i, (ItemStack)listIn.get(i));
            }
            compoundStorage = handler.serializeNBT();
        }
        compound.m_128365_(ModID + identifier, (Tag)compoundStorage);
        return compound;
    }

    public static ItemStack readItemStackFromNBT(String ModID, CompoundTag inputNBT, String identifier) {
        ItemStack returnerStack = ItemStack.f_41583_;
        if (inputNBT == null) {
            return returnerStack;
        }
        if (inputNBT.m_128441_(ModID + identifier)) {
            ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
            CompoundTag invTag = inputNBT.m_128469_(ModID + identifier);
            ItemStackHandler handler = new ItemStackHandler();
            handler.deserializeNBT((Tag)invTag);
            for (int i = 0; i < handler.getSlots(); ++i) {
                stackList.add(handler.getStackInSlot(i));
            }
            return stackList.stream().findFirst().orElse(ItemStack.f_41583_);
        }
        return returnerStack;
    }

    public static CompoundTag writeFluidStackToNBT(String ModID, @Nullable CompoundTag inputNBT, FluidStack fluidStack, String identifier) {
        CompoundTag compound;
        CompoundTag compoundTag = compound = inputNBT != null ? inputNBT : new CompoundTag();
        if (fluidStack.isEmpty()) {
            return compound;
        }
        compound.m_128365_(ModID + identifier, (Tag)fluidStack.writeToNBT(new CompoundTag()));
        return compound;
    }

    public static FluidStack readFluidStackFromNBT(String ModID, CompoundTag inputNBT, String identifier) {
        FluidStack fluidStack = FluidStack.EMPTY;
        if (inputNBT.m_128441_(ModID + identifier)) {
            return FluidStack.loadFluidStackFromNBT((CompoundTag)inputNBT.m_128469_(ModID + identifier));
        }
        return fluidStack;
    }

    public static ItemStack writeIntegerCompoundTagToItemStack(ItemStack stackIn, String ModID, String compoundIntString, int intValue) {
        CompoundTag tagOnStack = stackIn.m_41784_();
        tagOnStack.m_128405_(ModID + compoundIntString, intValue);
        stackIn.m_41751_(tagOnStack);
        return stackIn;
    }

    public static int getCompoundTagFromItemStack(ItemStack stackIn, String ModID, String compoundIntString) {
        CompoundTag tagOnStack = stackIn.m_41784_();
        if (tagOnStack.m_128441_(ModID + compoundIntString)) {
            int intValue = tagOnStack.m_128451_(ModID + compoundIntString);
            return intValue;
        }
        return 0;
    }

    public static ItemStack writeIntegerCompoundTagToItemStack(ItemStack stackIn, String compoundIntStringWithModID, int intValue) {
        CompoundTag tagOnStack = stackIn.m_41784_();
        tagOnStack.m_128405_(compoundIntStringWithModID, intValue);
        stackIn.m_41751_(tagOnStack);
        return stackIn;
    }

    public static int getCompoundTagFromItemStack(ItemStack stackIn, String compoundIntStringWithModID) {
        CompoundTag tagOnStack = stackIn.m_41784_();
        if (tagOnStack.m_128441_(compoundIntStringWithModID)) {
            int intValue = tagOnStack.m_128451_(compoundIntStringWithModID);
            return intValue;
        }
        return 0;
    }

    public static CompoundTag writeIntegerToNBT(String ModID, @Nullable CompoundTag inputNBT, int input, String intName) {
        CompoundTag compound = inputNBT != null ? inputNBT : new CompoundTag();
        compound.m_128405_(ModID + intName, input);
        return compound;
    }

    public static int readIntegerFromNBT(String ModID, CompoundTag inputNBT, String intName) {
        if (inputNBT.m_128441_(ModID + intName)) {
            return inputNBT.m_128451_(ModID + intName);
        }
        return 0;
    }

    public static CompoundTag writeIntegerToNBT(@Nullable CompoundTag inputNBT, int input, String nbtName) {
        CompoundTag compound = inputNBT != null ? inputNBT : new CompoundTag();
        compound.m_128405_(nbtName, input);
        return compound;
    }

    public static int readIntegerFromNBT(CompoundTag inputNBT, String nbtName) {
        if (inputNBT.m_128441_(nbtName)) {
            return inputNBT.m_128451_(nbtName);
        }
        return 0;
    }

    public static boolean readBooleanFromNBT(String ModID, CompoundTag tag, String identifier) {
        return tag.m_128441_(ModID + identifier) ? tag.m_128471_(ModID + identifier) : false;
    }

    public static CompoundTag writeBooleanToNBT(String ModID, @Nullable CompoundTag tag, boolean value, String identifier) {
        CompoundTag compound = tag != null ? tag : new CompoundTag();
        compound.m_128379_(ModID + identifier, value);
        return compound;
    }

    public static String readStringFromNBT(String ModID, CompoundTag tag, String identifier) {
        return tag.m_128441_(ModID + identifier) ? tag.m_128461_(ModID + identifier) : "";
    }

    public static CompoundTag writeStringToNBT(String ModID, @javax.annotation.Nullable CompoundTag tag, String value, String identifier) {
        CompoundTag compound = tag != null ? tag : new CompoundTag();
        compound.m_128359_(ModID + identifier, value);
        return compound;
    }

    public static void removeCustomTagFromNBT(String ModID, CompoundTag tag, String identifier) {
        if (tag.m_128441_(ModID + identifier)) {
            tag.m_128473_(ModID + identifier);
        }
    }
}

