/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.mowlib.MowLibUtils;

import com.mowmaster.mowlib.BlockEntities.MowLibBaseBlockEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class MowLibBlockPosUtils {
    public static boolean arePositionsInRange(BlockPos posOne, BlockPos posTwo, int range) {
        BlockPos distanceVector = posOne.m_121996_((Vec3i)posTwo);
        return Math.abs(distanceVector.m_123341_()) <= range && Math.abs(distanceVector.m_123342_()) <= range && Math.abs(distanceVector.m_123343_()) <= range;
    }

    public static BlockPos getPosOfBlockBelow(Level level, BlockPos posOfPedestal, int numBelow) {
        BlockState state = level.m_8055_(posOfPedestal);
        Direction enumfacing = state.m_61138_((Property)BlockStateProperties.f_61372_) ? (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_) : Direction.UP;
        BlockPos blockBelow = posOfPedestal;
        switch (enumfacing) {
            case UP: {
                return blockBelow.m_7918_(0, -numBelow, 0);
            }
            case DOWN: {
                return blockBelow.m_7918_(0, numBelow, 0);
            }
            case NORTH: {
                return blockBelow.m_7918_(0, 0, numBelow);
            }
            case SOUTH: {
                return blockBelow.m_7918_(0, 0, -numBelow);
            }
            case EAST: {
                return blockBelow.m_7918_(-numBelow, 0, 0);
            }
            case WEST: {
                return blockBelow.m_7918_(numBelow, 0, 0);
            }
        }
        return blockBelow;
    }

    public static boolean addBlockPosToList(String ModID, String identifier, ItemStack upgrade, BlockPos posOfBlock) {
        List<BlockPos> currentList = MowLibBlockPosUtils.readBlockPosListFromNBT(ModID, identifier, upgrade);
        if (currentList.contains(posOfBlock)) {
            currentList.remove(posOfBlock);
            MowLibBlockPosUtils.saveBlockPosListCustomToNBT(ModID, identifier, upgrade, currentList);
            return false;
        }
        currentList.add(posOfBlock);
        MowLibBlockPosUtils.saveBlockPosListCustomToNBT(ModID, identifier, upgrade, currentList);
        return true;
    }

    public static List<BlockPos> readBlockPosListFromNBT(String ModID, String identifier, ItemStack upgrade) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        if (upgrade.m_41782_()) {
            String tagX = ModID + identifier + "_X";
            String tagY = ModID + identifier + "_Y";
            String tagZ = ModID + identifier + "_Z";
            CompoundTag getCompound = upgrade.m_41783_();
            if (upgrade.m_41783_().m_128441_(tagX) && upgrade.m_41783_().m_128441_(tagY) && upgrade.m_41783_().m_128441_(tagZ)) {
                int[] storedIX = getCompound.m_128465_(tagX);
                int[] storedIY = getCompound.m_128465_(tagY);
                int[] storedIZ = getCompound.m_128465_(tagZ);
                for (int i = 0; i < storedIX.length; ++i) {
                    BlockPos gotPos = new BlockPos(storedIX[i], storedIY[i], storedIZ[i]);
                    posList.add(gotPos);
                }
            }
        }
        return posList;
    }

    public static void saveBlockPosListCustomToNBT(String ModID, String identifier, ItemStack upgrade, List<BlockPos> posListToSave) {
        CompoundTag compound = new CompoundTag();
        if (upgrade.m_41782_()) {
            compound = upgrade.m_41783_();
        }
        ArrayList<Integer> storedX = new ArrayList<Integer>();
        ArrayList<Integer> storedY = new ArrayList<Integer>();
        ArrayList<Integer> storedZ = new ArrayList<Integer>();
        for (int i = 0; i < posListToSave.size(); ++i) {
            storedX.add(posListToSave.get(i).m_123341_());
            storedY.add(posListToSave.get(i).m_123342_());
            storedZ.add(posListToSave.get(i).m_123343_());
        }
        compound.m_128408_(ModID + identifier + "_X", storedX);
        compound.m_128408_(ModID + identifier + "_Y", storedY);
        compound.m_128408_(ModID + identifier + "_Z", storedZ);
        upgrade.m_41751_(compound);
    }

    public static List<BlockPos> readBlockPosListCustomFromNBT(String ModID, String identifier, ItemStack upgrade) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        if (upgrade.m_41782_()) {
            String tagX = ModID + identifier + "_X";
            String tagY = ModID + identifier + "_Y";
            String tagZ = ModID + identifier + "_Z";
            CompoundTag getCompound = upgrade.m_41783_();
            if (upgrade.m_41783_().m_128441_(tagX) && upgrade.m_41783_().m_128441_(tagY) && upgrade.m_41783_().m_128441_(tagZ)) {
                int[] storedIX = getCompound.m_128465_(tagX);
                int[] storedIY = getCompound.m_128465_(tagY);
                int[] storedIZ = getCompound.m_128465_(tagZ);
                for (int i = 0; i < storedIX.length; ++i) {
                    BlockPos gotPos = new BlockPos(storedIX[i], storedIY[i], storedIZ[i]);
                    posList.add(gotPos);
                }
            }
        }
        return posList;
    }

    public static void removeBlockListCustomNBTTags(String ModID, String identifier, ItemStack upgrade) {
        String tagX = ModID + identifier + "_X";
        String tagY = ModID + identifier + "_Y";
        String tagZ = ModID + identifier + "_Z";
        CompoundTag getTags = upgrade.m_41783_();
        if (getTags.m_128441_(tagX)) {
            getTags.m_128473_(tagX);
        }
        if (getTags.m_128441_(tagY)) {
            getTags.m_128473_(tagY);
        }
        if (getTags.m_128441_(tagZ)) {
            getTags.m_128473_(tagZ);
        }
        upgrade.m_41751_(getTags);
    }

    public static boolean hasBlockListCustomNBTTags(String ModID, String identifier, ItemStack upgrade) {
        String tagX = ModID + identifier + "_X";
        String tagY = ModID + identifier + "_Y";
        String tagZ = ModID + identifier + "_Z";
        CompoundTag getTags = upgrade.m_41783_();
        return getTags.m_128441_(tagX) && getTags.m_128441_(tagY) && getTags.m_128441_(tagZ);
    }

    public static void saveBlockPosToNBT(String ModID, String identifier, ItemStack upgrade, int num, BlockPos posToSave) {
        CompoundTag compound = new CompoundTag();
        if (upgrade.m_41782_()) {
            compound = upgrade.m_41783_();
        }
        ArrayList<Integer> listed = new ArrayList<Integer>();
        listed.add(posToSave.m_123341_());
        listed.add(posToSave.m_123342_());
        listed.add(posToSave.m_123343_());
        compound.m_128408_(ModID + identifier + num, listed);
        upgrade.m_41751_(compound);
    }

    public static BlockPos readBlockPosFromNBT(String ModID, String identifier, ItemStack upgrade, int num) {
        if (upgrade.m_41782_()) {
            int[] listed;
            String tag = ModID + identifier + num;
            CompoundTag getCompound = upgrade.m_41783_();
            if (upgrade.m_41783_().m_128441_(tag) && (listed = getCompound.m_128465_(tag)).length >= 3) {
                return new BlockPos(listed[0], listed[1], listed[2]);
            }
        }
        return BlockPos.f_121853_;
    }

    public static BlockPos getBlockPosOnUpgrade(String ModID, String identifier, ItemStack stack, int num) {
        return MowLibBlockPosUtils.readBlockPosFromNBT(ModID, identifier, stack, num);
    }

    public static boolean addBlockPosToList(ItemStack upgrade, BlockPos posOfBlock) {
        List<BlockPos> currentList = MowLibBlockPosUtils.readBlockPosListFromNBT(upgrade);
        if (currentList.contains(posOfBlock)) {
            currentList.remove(posOfBlock);
            MowLibBlockPosUtils.saveBlockPosListToNBT(upgrade, currentList);
            return false;
        }
        currentList.add(posOfBlock);
        MowLibBlockPosUtils.saveBlockPosListToNBT(upgrade, currentList);
        return true;
    }

    public static void saveBlockPosListToNBT(ItemStack upgrade, List<BlockPos> posListToSave) {
        CompoundTag compound = new CompoundTag();
        if (upgrade.m_41782_()) {
            compound = upgrade.m_41783_();
        }
        ArrayList<Integer> storedX = new ArrayList<Integer>();
        ArrayList<Integer> storedY = new ArrayList<Integer>();
        ArrayList<Integer> storedZ = new ArrayList<Integer>();
        for (int i = 0; i < posListToSave.size(); ++i) {
            storedX.add(posListToSave.get(i).m_123341_());
            storedY.add(posListToSave.get(i).m_123342_());
            storedZ.add(posListToSave.get(i).m_123343_());
        }
        compound.m_128408_("mowlib_intArrayXPos", storedX);
        compound.m_128408_("mowlib_intArrayYPos", storedY);
        compound.m_128408_("mowlib_intArrayZPos", storedZ);
        upgrade.m_41751_(compound);
    }

    public static List<BlockPos> readBlockPosListFromNBT(ItemStack upgrade) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        if (upgrade.m_41782_()) {
            String tagX = "mowlib_intArrayXPos";
            String tagY = "mowlib_intArrayYPos";
            String tagZ = "mowlib_intArrayZPos";
            CompoundTag getCompound = upgrade.m_41783_();
            if (upgrade.m_41783_().m_128441_(tagX) && upgrade.m_41783_().m_128441_(tagY) && upgrade.m_41783_().m_128441_(tagZ)) {
                int[] storedIX = getCompound.m_128465_(tagX);
                int[] storedIY = getCompound.m_128465_(tagY);
                int[] storedIZ = getCompound.m_128465_(tagZ);
                for (int i = 0; i < storedIX.length; ++i) {
                    BlockPos gotPos = new BlockPos(storedIX[i], storedIY[i], storedIZ[i]);
                    posList.add(gotPos);
                }
            }
        }
        return posList;
    }

    public static void saveStringToNBT(ItemStack upgrade, String nbtTag, String string) {
        CompoundTag compound = new CompoundTag();
        if (upgrade.m_41782_()) {
            compound = upgrade.m_41783_();
        }
        compound.m_128359_(nbtTag, string);
        upgrade.m_41751_(compound);
    }

    public static void saveBlockPosToNBT(ItemStack upgrade, int num, BlockPos posToSave) {
        CompoundTag compound = new CompoundTag();
        if (upgrade.m_41782_()) {
            compound = upgrade.m_41783_();
        }
        ArrayList<Integer> listed = new ArrayList<Integer>();
        listed.add(posToSave.m_123341_());
        listed.add(posToSave.m_123342_());
        listed.add(posToSave.m_123343_());
        compound.m_128408_("mowlib_upgrade_blockpos_" + num, listed);
        upgrade.m_41751_(compound);
    }

    public static BlockPos readBlockPosFromNBT(ItemStack upgrade, int num) {
        if (upgrade.m_41782_()) {
            int[] listed;
            String tag = "mowlib_upgrade_blockpos_" + num;
            CompoundTag getCompound = upgrade.m_41783_();
            if (upgrade.m_41783_().m_128441_(tag) && (listed = getCompound.m_128465_(tag)).length >= 3) {
                return new BlockPos(listed[0], listed[1], listed[2]);
            }
        }
        return BlockPos.f_121853_;
    }

    public static boolean isNewBlockPosSmallerThanExisting(ItemStack stack, BlockPos posTwo) {
        BlockPos posOne = MowLibBlockPosUtils.getExistingSingleBlockPos(stack);
        BlockPos toCompare = new BlockPos(Math.min(posOne.m_123341_(), posTwo.m_123341_()), Math.min(posOne.m_123342_(), posTwo.m_123342_()), Math.min(posOne.m_123343_(), posTwo.m_123343_()));
        return posTwo.equals((Object)toCompare);
    }

    public static boolean hasTwoPointsSelected(ItemStack stack) {
        return !MowLibBlockPosUtils.readBlockPosFromNBT(stack, 1).equals((Object)BlockPos.f_121853_) && !MowLibBlockPosUtils.readBlockPosFromNBT(stack, 2).equals((Object)BlockPos.f_121853_);
    }

    public static BlockPos getExistingSingleBlockPos(ItemStack stack) {
        return !MowLibBlockPosUtils.readBlockPosFromNBT(stack, 1).equals((Object)BlockPos.f_121853_) ? MowLibBlockPosUtils.readBlockPosFromNBT(stack, 1) : MowLibBlockPosUtils.readBlockPosFromNBT(stack, 2);
    }

    public static BlockPos getBlockPosOnUpgrade(ItemStack stack, int num) {
        return MowLibBlockPosUtils.readBlockPosFromNBT(stack, num);
    }

    public static boolean hasOneBlockPos(ItemStack stack) {
        return !MowLibBlockPosUtils.readBlockPosFromNBT(stack, 1).equals((Object)BlockPos.f_121853_) || !MowLibBlockPosUtils.readBlockPosFromNBT(stack, 2).equals((Object)BlockPos.f_121853_);
    }

    public static boolean isSelectionInRange(MowLibBaseBlockEntity baseBlockEntity, BlockPos pos, int rangeFromBlock) {
        int range = rangeFromBlock;
        return MowLibBlockPosUtils.arePositionsInRange(pos, baseBlockEntity.getPos(), range);
    }

    public static boolean selectedAreaWithinRange(MowLibBaseBlockEntity baseBlockEntity, int getRange) {
        return MowLibBlockPosUtils.isSelectionInRange(baseBlockEntity, MowLibBlockPosUtils.readBlockPosFromNBT(baseBlockEntity.getWorkCard(), 1), getRange) && MowLibBlockPosUtils.isSelectionInRange(baseBlockEntity, MowLibBlockPosUtils.readBlockPosFromNBT(baseBlockEntity.getWorkCard(), 2), getRange);
    }

    public static boolean selectedPointWithinRange(MowLibBaseBlockEntity baseBlockEntity, BlockPos posPoint, int getRange) {
        return MowLibBlockPosUtils.isSelectionInRange(baseBlockEntity, posPoint, getRange);
    }

    public static BlockPos getHigherByFacing(BlockPos atLocation, Direction facing) {
        BlockPos higherPos = atLocation;
        switch (facing) {
            default: {
                higherPos = atLocation.m_7918_(1, 1, 1);
                break;
            }
            case EAST: {
                higherPos = atLocation.m_7918_(0, 1, 1);
                break;
            }
            case SOUTH: {
                higherPos = atLocation.m_7918_(1, 1, 0);
                break;
            }
            case UP: {
                higherPos = atLocation.m_7918_(1, 0, 1);
            }
        }
        return higherPos;
    }

    public static BlockPos getLowerByFacing(BlockPos atLocation, Direction facing) {
        BlockPos lowerPos = atLocation;
        switch (facing) {
            default: {
                break;
            }
            case EAST: {
                lowerPos = atLocation.m_7918_(-1, 0, 0);
                break;
            }
            case SOUTH: {
                lowerPos = atLocation.m_7918_(0, 0, -1);
                break;
            }
            case UP: {
                lowerPos = atLocation.m_7918_(0, -1, 0);
            }
        }
        return lowerPos;
    }

    public static Direction getLastClickedDirectionFromUpgrade(ItemStack stack) {
        Direction dir = Direction.UP;
        if (stack.m_41782_() && stack.m_41783_().m_128441_("mowlib_string_last_clicked_direction")) {
            String direction = stack.m_41783_().m_128461_("mowlib_string_last_clicked_direction");
            if (direction == "down") {
                return Direction.DOWN;
            }
            if (direction == "up") {
                return Direction.UP;
            }
            if (direction == "north") {
                return Direction.NORTH;
            }
            if (direction == "south") {
                return Direction.SOUTH;
            }
            if (direction == "west") {
                return Direction.WEST;
            }
            if (direction == "east") {
                return Direction.EAST;
            }
        }
        return dir;
    }

    public static int getDistanceBetweenPoints(BlockPos pointOne, BlockPos posToCompare) {
        int x = pointOne.m_123341_();
        int y = pointOne.m_123342_();
        int z = pointOne.m_123343_();
        int x1 = posToCompare.m_123341_();
        int y1 = posToCompare.m_123342_();
        int z1 = posToCompare.m_123343_();
        int xF = Math.abs(Math.subtractExact(x, x1));
        int yF = Math.abs(Math.subtractExact(y, y1));
        int zF = Math.abs(Math.subtractExact(z, z1));
        return Math.max(Math.max(xF, yF), zF);
    }

    public static BlockPos offsetBasedOnDirection(Direction enumfacing, BlockPos posOfPedestal, double x, double y, double z) {
        BlockPos blockBelow = posOfPedestal;
        switch (enumfacing) {
            case UP: {
                return new BlockPos((int)((double)blockBelow.m_123341_() + x), (int)((double)blockBelow.m_123342_() + y), (int)((double)blockBelow.m_123343_() + z));
            }
            case DOWN: {
                return new BlockPos((int)((double)blockBelow.m_123341_() + x), (int)((double)blockBelow.m_123342_() + y + 1.0), (int)((double)blockBelow.m_123343_() + z));
            }
            case NORTH: {
                return new BlockPos((int)((double)blockBelow.m_123341_() + x), (int)((double)blockBelow.m_123342_() + z), (int)((double)blockBelow.m_123343_() + y));
            }
            case SOUTH: {
                return new BlockPos((int)((double)blockBelow.m_123341_() + x), (int)((double)blockBelow.m_123342_() + z), (int)((double)blockBelow.m_123343_() + y));
            }
            case EAST: {
                return new BlockPos((int)((double)blockBelow.m_123341_() + y), (int)((double)blockBelow.m_123342_() + x), (int)((double)blockBelow.m_123343_() + z));
            }
            case WEST: {
                return new BlockPos((int)((double)blockBelow.m_123341_() + y), (int)((double)blockBelow.m_123342_() + x), (int)((double)blockBelow.m_123343_() + z));
            }
        }
        return blockBelow;
    }

    public static BlockPos getPosBelowBlockEntity(Level world, BlockPos pos, int numBelow) {
        BlockState state = world.m_8055_(pos);
        Direction enumfacing = state.m_61138_((Property)BlockStateProperties.f_61372_) ? (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_) : Direction.UP;
        BlockPos blockBelow = pos;
        switch (enumfacing) {
            case UP: {
                return blockBelow.m_7918_(0, -numBelow, 0);
            }
            case DOWN: {
                return blockBelow.m_7918_(0, numBelow, 0);
            }
            case NORTH: {
                return blockBelow.m_7918_(0, 0, numBelow);
            }
            case SOUTH: {
                return blockBelow.m_7918_(0, 0, -numBelow);
            }
            case EAST: {
                return blockBelow.m_7918_(-numBelow, 0, 0);
            }
            case WEST: {
                return blockBelow.m_7918_(numBelow, 0, 0);
            }
        }
        return blockBelow;
    }

    public static BlockPos getPosBelowBlockEntity(BlockState state, BlockPos pos, int numBelow) {
        Direction enumfacing = state.m_61138_((Property)BlockStateProperties.f_61372_) ? (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_) : Direction.UP;
        BlockPos blockBelow = pos;
        switch (enumfacing) {
            case UP: {
                return blockBelow.m_7918_(0, -numBelow, 0);
            }
            case DOWN: {
                return blockBelow.m_7918_(0, numBelow, 0);
            }
            case NORTH: {
                return blockBelow.m_7918_(0, 0, numBelow);
            }
            case SOUTH: {
                return blockBelow.m_7918_(0, 0, -numBelow);
            }
            case EAST: {
                return blockBelow.m_7918_(-numBelow, 0, 0);
            }
            case WEST: {
                return blockBelow.m_7918_(numBelow, 0, 0);
            }
        }
        return blockBelow;
    }
}

