/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.mowlib.Items.WorkCards;

import com.mowmaster.mowlib.BlockEntities.MowLibBaseBlock;
import com.mowmaster.mowlib.Items.BaseUseInteractionItem;
import com.mowmaster.mowlib.MowLibUtils.MowLibBlockPosUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibComponentUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibMessageUtils;
import com.mowmaster.mowlib.Networking.MowLibPacketHandler;
import com.mowmaster.mowlib.Networking.MowLibPacketParticles;
import com.mowmaster.mowlib.api.DefineLocations.ISelectableArea;
import com.mowmaster.mowlib.api.DefineLocations.ISelectablePoints;
import com.mowmaster.mowlib.api.DefineLocations.IWorkCard;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;

public class WorkCardBase
extends BaseUseInteractionItem
implements IWorkCard {
    public WorkCardBase(Item.Properties p_41383_) {
        super(p_41383_);
    }

    public int getWorkCardType() {
        return -1;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        MowLibBlockPosUtils.saveBlockPosToNBT(stack, 10, context.m_8083_());
        MowLibBlockPosUtils.saveStringToNBT(stack, "mowlib_string_last_clicked_direction", context.m_43719_().toString());
        return super.onItemUseFirst(stack, context);
    }

    @Override
    public InteractionResultHolder interactTargetBlock(Level level, Player player, InteractionHand hand, ItemStack itemStackInHand, HitResult result) {
        BlockPos atLocation = MowLibBlockPosUtils.readBlockPosFromNBT(itemStackInHand, 10);
        if (itemStackInHand.m_41720_() instanceof ISelectablePoints) {
            if (this.getWorkCardType() == 3 && !(level.m_8055_(atLocation).m_60734_() instanceof MowLibBaseBlock)) {
                return InteractionResultHolder.m_19100_((Object)itemStackInHand);
            }
            boolean added = MowLibBlockPosUtils.addBlockPosToList(itemStackInHand, atLocation);
            MowLibMessageUtils.messagePopup(player, added ? ChatFormatting.WHITE : ChatFormatting.BLACK, added ? "mowlib.workcard_blockpos_added" : "mowlib.workcard_blockpos_removed");
            MowLibPacketHandler.sendToNearby(level, player.m_20097_(), (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, atLocation.m_123341_(), (double)atLocation.m_123342_() + 1.0, (double)atLocation.m_123343_(), 0, added ? 200 : 0, 0));
        } else if (itemStackInHand.m_41720_() instanceof ISelectableArea) {
            if (!MowLibBlockPosUtils.hasOneBlockPos(itemStackInHand)) {
                MowLibBlockPosUtils.saveBlockPosToNBT(itemStackInHand, 1, atLocation);
                player.m_21008_(hand, itemStackInHand);
                MowLibMessageUtils.messagePopup(player, ChatFormatting.WHITE, "mowlib.workcard_blockpos_first");
            } else if (!MowLibBlockPosUtils.hasTwoPointsSelected(itemStackInHand)) {
                MowLibBlockPosUtils.saveBlockPosToNBT(itemStackInHand, 2, atLocation);
                player.m_21008_(hand, itemStackInHand);
                MowLibMessageUtils.messagePopup(player, ChatFormatting.WHITE, "mowlib.workcard_blockpos_second");
            }
        }
        return super.interactTargetBlock(level, player, hand, itemStackInHand, result);
    }

    @Override
    public InteractionResultHolder interactTargetAir(Level level, Player player, InteractionHand hand, ItemStack itemStackInHand, HitResult result) {
        if (itemStackInHand.m_41720_() instanceof ISelectablePoints && MowLibBlockPosUtils.readBlockPosListFromNBT(itemStackInHand).size() > 0 || itemStackInHand.m_41720_() instanceof ISelectableArea && MowLibBlockPosUtils.hasOneBlockPos(itemStackInHand)) {
            itemStackInHand.m_41751_(new CompoundTag());
            MowLibMessageUtils.messagePopup(player, ChatFormatting.WHITE, "mowlib.workcard_blockpos_clear");
        }
        return super.interactTargetAir(level, player, hand, itemStackInHand, result);
    }

    @Override
    public InteractionResultHolder interactCrouchingTargetBlock(Level level, Player player, InteractionHand hand, ItemStack itemStackInHand, HitResult result) {
        BlockPos atLocation = MowLibBlockPosUtils.readBlockPosFromNBT(itemStackInHand, 10);
        if (itemStackInHand.m_41720_() instanceof ISelectablePoints) {
            if (this.getWorkCardType() == 3 && !(level.m_8055_(atLocation).m_60734_() instanceof MowLibBaseBlock)) {
                return InteractionResultHolder.m_19100_((Object)itemStackInHand);
            }
            boolean added = MowLibBlockPosUtils.addBlockPosToList(itemStackInHand, atLocation);
            MowLibMessageUtils.messagePopup(player, added ? ChatFormatting.WHITE : ChatFormatting.BLACK, added ? "mowlib.workcard_blockpos_added" : "mowlib.workcard_blockpos_removed");
            MowLibPacketHandler.sendToNearby(level, player.m_20097_(), (Object)new MowLibPacketParticles(MowLibPacketParticles.EffectType.ANY_COLOR_CENTERED, atLocation.m_123341_(), (double)atLocation.m_123342_() + 1.0, (double)atLocation.m_123343_(), 0, added ? 200 : 0, 0));
        } else if (itemStackInHand.m_41720_() instanceof ISelectableArea) {
            if (!MowLibBlockPosUtils.hasOneBlockPos(itemStackInHand)) {
                MowLibBlockPosUtils.saveBlockPosToNBT(itemStackInHand, 1, atLocation);
                player.m_21008_(hand, itemStackInHand);
                MowLibMessageUtils.messagePopup(player, ChatFormatting.WHITE, "mowlib.workcard_blockpos_first");
            } else if (!MowLibBlockPosUtils.hasTwoPointsSelected(itemStackInHand)) {
                MowLibBlockPosUtils.saveBlockPosToNBT(itemStackInHand, 2, atLocation);
                player.m_21008_(hand, itemStackInHand);
                MowLibMessageUtils.messagePopup(player, ChatFormatting.WHITE, "mowlib.workcard_blockpos_second");
            }
        }
        return super.interactCrouchingTargetBlock(level, player, hand, itemStackInHand, result);
    }

    @Override
    public InteractionResultHolder interactCrouchingTargetAir(Level level, Player player, InteractionHand hand, ItemStack itemStackInHand, HitResult result) {
        if (itemStackInHand.m_41720_() instanceof ISelectablePoints && MowLibBlockPosUtils.readBlockPosListFromNBT(itemStackInHand).size() > 0 || itemStackInHand.m_41720_() instanceof ISelectableArea && MowLibBlockPosUtils.hasOneBlockPos(itemStackInHand)) {
            itemStackInHand.m_41751_(new CompoundTag());
            MowLibMessageUtils.messagePopup(player, ChatFormatting.WHITE, "mowlib.workcard_blockpos_clear");
        }
        return super.interactCrouchingTargetAir(level, player, hand, itemStackInHand, result);
    }

    public void m_7373_(ItemStack p_41421_, @Nullable Level p_41422_, List<Component> p_41423_, TooltipFlag p_41424_) {
        List<BlockPos> getList;
        super.m_7373_(p_41421_, p_41422_, p_41423_, p_41424_);
        if (Screen.m_96638_() && Screen.m_96639_()) {
            p_41423_.add((Component)Component.m_237113_((String)""));
        }
        if (p_41421_.m_41720_() instanceof WorkCardBase && p_41421_.m_41720_() instanceof ISelectableArea && MowLibBlockPosUtils.hasOneBlockPos(p_41421_)) {
            if (!Screen.m_96638_()) {
                MutableComponent base = Component.m_237115_((String)"mowlib.workcard_tooltip_shift");
                base.m_130940_(ChatFormatting.WHITE);
                p_41423_.add((Component)base);
            } else {
                MutableComponent posTitle = Component.m_237115_((String)"mowlib.workcard_tooltip_blockpos_title");
                posTitle.m_130940_(ChatFormatting.GOLD);
                p_41423_.add((Component)posTitle);
                MutableComponent separator = Component.m_237115_((String)"mowlib.text.separator.horizontal_rule_large.equals");
                p_41423_.add((Component)separator);
                MutableComponent posOne = Component.m_237115_((String)"mowlib.workcard_tooltip_blockpos_one");
                BlockPos blockPosOne = MowLibBlockPosUtils.readBlockPosFromNBT(p_41421_, 1);
                MutableComponent posOnePos = Component.m_237113_((String)(blockPosOne.m_123341_() + "x " + blockPosOne.m_123342_() + "y " + blockPosOne.m_123343_() + "z"));
                posOnePos.m_130940_(ChatFormatting.GRAY);
                posOne.m_7220_((Component)Component.m_237115_((String)"mowlib.text.separator.colon_space"));
                posOne.m_7220_((Component)posOnePos);
                p_41423_.add((Component)posOne);
                MutableComponent posTwo = Component.m_237115_((String)"mowlib.workcard_tooltip_blockpos_two");
                BlockPos blockPosTwo = MowLibBlockPosUtils.readBlockPosFromNBT(p_41421_, 2);
                MutableComponent posTwoPos = Component.m_237113_((String)(blockPosTwo.m_123341_() + "x " + blockPosTwo.m_123342_() + "y " + blockPosTwo.m_123343_() + "z"));
                posTwoPos.m_130940_(ChatFormatting.GRAY);
                posTwo.m_7220_((Component)Component.m_237115_((String)"mowlib.text.separator.colon_space"));
                posTwo.m_7220_((Component)posTwoPos);
                p_41423_.add((Component)posTwo);
            }
        }
        if (p_41421_.m_41720_() instanceof WorkCardBase && p_41421_.m_41720_() instanceof ISelectablePoints && !MowLibBlockPosUtils.hasTwoPointsSelected(p_41421_) && (getList = MowLibBlockPosUtils.readBlockPosListFromNBT(p_41421_)).size() > 0) {
            if (!Screen.m_96638_()) {
                MutableComponent base = Component.m_237115_((String)"mowlib.workcard_tooltip_shift");
                base.m_130940_(ChatFormatting.WHITE);
                p_41423_.add((Component)base);
            } else {
                MutableComponent posTitle = Component.m_237115_((String)"mowlib.workcard_tooltip_blockpos_title");
                posTitle.m_130940_(ChatFormatting.GOLD);
                p_41423_.add((Component)posTitle);
                MutableComponent separator = Component.m_237115_((String)"mowlib.text.separator.horizontal_rule_large.equals");
                p_41423_.add((Component)separator);
                for (BlockPos pos : getList) {
                    MutableComponent formattedPos = MowLibComponentUtils.getBlockPosFormatted(pos);
                    formattedPos.m_130940_(ChatFormatting.GRAY);
                    p_41423_.add((Component)formattedPos);
                }
            }
        }
    }
}

