/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.mowlib.Items.Filters;

import com.mowmaster.mowlib.BlockEntities.MowLibBaseBlockEntity;
import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.MowLibUtils.MowLibColorReference;
import com.mowmaster.mowlib.MowLibUtils.MowLibItemUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibMessageUtils;
import com.mowmaster.mowlib.api.TransportAndStorage.IFilterItem;
import com.mowmaster.mowlib.api.TransportAndStorage.ITransferMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class MowLibBaseFilter
extends Item
implements IFilterItem {
    public boolean filterType = false;
    public IFilterItem.FilterDirection filterableDirection;

    public MowLibBaseFilter(Item.Properties p_41383_, IFilterItem.FilterDirection direction) {
        super(p_41383_);
        this.filterableDirection = direction;
    }

    @Override
    public IFilterItem.FilterDirection getFilterDirection() {
        return this.filterableDirection;
    }

    @Override
    public ITransferMode.ItemTransferMode getItemTransportMode(ItemStack stackIn) {
        return ITransferMode.ItemTransferMode.ITEMS.getTransferModeFromStack(stackIn);
    }

    public static int getFilterModeForRender(ItemStack stackIn) {
        return ITransferMode.ItemTransferMode.getTransferModeIntFromStack(stackIn);
    }

    public boolean doItemsMatch(ItemStack stackPedestal, ItemStack itemStackIn) {
        return ItemHandlerHelper.canItemStacksStack((ItemStack)stackPedestal, (ItemStack)itemStackIn);
    }

    public boolean canModeUseInventoryAsFilter(ITransferMode.ItemTransferMode mode) {
        return mode.ordinal() <= 1;
    }

    public boolean canSetFilterMode(ITransferMode.ItemTransferMode mode) {
        return true;
    }

    public boolean canSetFilterType(ITransferMode.ItemTransferMode mode) {
        return true;
    }

    public void setFilterType(Player player, ItemStack heldItem) {
        this.setFilterTypeCustom(player, heldItem, ".filter_type_blacklist", ".filter_type_whitelist", ChatFormatting.BLACK, ChatFormatting.WHITE, ".filter_type_changed");
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level p_41432_, Player p_41433_, InteractionHand p_41434_) {
        Level world = p_41432_;
        Player player = p_41433_;
        InteractionHand hand = p_41434_;
        ItemStack itemInMainhand = player.m_21205_();
        ItemStack itemInOffhand = player.m_21206_();
        HitResult result = player.m_19907_(5.0, 0.0f, false);
        if (!world.m_5776_()) {
            if (itemInOffhand.m_41720_() instanceof IFilterItem && !(itemInMainhand.m_41720_() instanceof IFilterItem)) {
                UseOnContext context;
                BlockHitResult res;
                BlockPos posBlock;
                List<ItemStack> buildQueue;
                if (result.m_6662_().equals((Object)HitResult.Type.MISS)) {
                    if (player.m_6047_()) {
                        if (this.canSetFilterMode(this.getItemTransportMode(itemInOffhand))) {
                            this.setFilterMode(player, itemInOffhand, InteractionHand.OFF_HAND);
                        }
                    } else if (this.canSetFilterType(this.getItemTransportMode(itemInOffhand))) {
                        this.setFilterType(player, itemInOffhand);
                    }
                } else if (result.m_6662_().equals((Object)HitResult.Type.BLOCK) && player.m_6047_() && (buildQueue = this.buildFilterQueue(world, posBlock = (res = new BlockHitResult((context = new UseOnContext(player, hand, (BlockHitResult)result)).m_43720_(), context.m_8125_(), context.m_8083_(), false)).m_82425_())).size() > 0 && this.canModeUseInventoryAsFilter(this.getItemTransportMode(itemInOffhand))) {
                    this.writeFilterQueueToNBT(itemInOffhand, buildQueue, this.getItemTransportMode(itemInOffhand));
                    MowLibMessageUtils.messagePopup(player, this.getItemTransportMode(itemInOffhand).getModeColorFormat(), "mowlib.filter_changed");
                }
            } else if (itemInOffhand.m_41720_() instanceof IFilterItem && itemInMainhand.m_41720_() instanceof IFilterItem) {
                MowLibMessageUtils.messagePopup(player, ChatFormatting.RED, "mowlib.filter.message_twohanded");
            }
        }
        return super.m_7203_(p_41432_, p_41433_, p_41434_);
    }

    public void setFilterTypeCustom(Player player, ItemStack heldItem, String firstLocalization, String secondLocalization, ChatFormatting firstColor, ChatFormatting secondColor, String chatLocalization) {
        Item item = heldItem.m_41720_();
        if (item instanceof MowLibBaseFilter) {
            MowLibBaseFilter filterItem;
            boolean getCurrentType = (filterItem = (MowLibBaseFilter)item).getFilterType(heldItem, this.getItemTransportMode(heldItem));
            filterItem.setFilterType(heldItem, !getCurrentType);
            String second = "mowlib" + secondLocalization;
            String first = "mowlib" + firstLocalization;
            ArrayList<String> listed = new ArrayList<String>();
            listed.add(!getCurrentType ? first : second);
            MowLibMessageUtils.messagePopupWithAppend("mowlib", player, !getCurrentType ? firstColor : secondColor, "mowlib" + chatLocalization, listed);
        }
    }

    public void setFilterMode(Player player, ItemStack heldItem, InteractionHand hand) {
        Item item = heldItem.m_41720_();
        if (item instanceof MowLibBaseFilter) {
            MowLibBaseFilter filterItem = (MowLibBaseFilter)item;
            this.getItemTransportMode(heldItem).iterateTransferMode(heldItem);
            MowLibColorReference.addColorToItemStack(heldItem, filterItem.getFilterTypeColor(heldItem));
            player.m_21008_(hand, heldItem);
            MowLibMessageUtils.messagePopup(player, this.getItemTransportMode(heldItem).componentTransferMode(), this.getItemTransportMode(heldItem).getModeColorFormat());
        }
    }

    @Override
    public boolean getFilterType() {
        return this.filterType;
    }

    @Override
    public boolean getFilterType(ItemStack filterItem) {
        this.getFilterTypeFromNBT(filterItem, this.getItemTransportMode(filterItem));
        return this.getFilterType();
    }

    public boolean getFilterType(ItemStack filterItem, ITransferMode.ItemTransferMode mode) {
        this.getFilterTypeFromNBT(filterItem, mode);
        return this.getFilterType();
    }

    @Override
    public void setFilterType(ItemStack filterItem, boolean filterSet) {
        this.filterType = filterSet;
        if (filterSet) {
            MowLibColorReference.addColorToItemStack(filterItem, 0x2A2A2A);
        } else {
            MowLibColorReference.addColorToItemStack(filterItem, 0xFFFFFF);
        }
        this.writeFilterTypeToNBT(filterItem, this.getItemTransportMode(filterItem));
    }

    public int getFilterTypeColor(ItemStack filterItem) {
        return this.getFilterType(filterItem) ? 0x2A2A2A : 0xFFFFFF;
    }

    @Override
    public boolean canAcceptItems(ItemStack filter, ItemStack incomingStack) {
        return !this.getFilterType(filter, ITransferMode.ItemTransferMode.ITEMS);
    }

    @Override
    public boolean canAcceptFluids(ItemStack filter, FluidStack incomingFluidStack) {
        return !this.getFilterType(filter, ITransferMode.ItemTransferMode.FLUIDS);
    }

    @Override
    public boolean canAcceptEnergy(ItemStack filter, int incomingAmount) {
        return !this.getFilterType(filter, ITransferMode.ItemTransferMode.ENERGY);
    }

    @Override
    public boolean canAcceptExperience(ItemStack filter, int incomingAmount) {
        return !this.getFilterType(filter, ITransferMode.ItemTransferMode.EXPERIENCE);
    }

    @Override
    public boolean canAcceptDust(ItemStack filter, DustMagic incomingDust) {
        return !this.getFilterType(filter, ITransferMode.ItemTransferMode.DUST);
    }

    @Override
    public boolean canSendItem(MowLibBaseBlockEntity pedestal) {
        return true;
    }

    @Override
    public int canAcceptCountItems(MowLibBaseBlockEntity filterableBlockEntity, ItemStack filterStack, int maxSpaceSize, int spaceAvailable, ItemStack itemStackIncoming) {
        return 0;
    }

    @Override
    public int canAcceptCountFluids(MowLibBaseBlockEntity filterableBlockEntity, ItemStack filterStack, int maxSpaceSize, int spaceAvailable, FluidStack incomingFluidStack) {
        return 0;
    }

    @Override
    public int canAcceptCountEnergy(MowLibBaseBlockEntity filterableBlockEntity, ItemStack filterStack, int maxSpaceSize, int spaceAvailable, int incomingEnergyAmount) {
        return 0;
    }

    @Override
    public int canAcceptCountExperience(MowLibBaseBlockEntity filterableBlockEntity, ItemStack filterStack, int maxSpaceSize, int spaceAvailable, int incomingExperienceAmount) {
        return 0;
    }

    @Override
    public int canAcceptCountDust(MowLibBaseBlockEntity filterableBlockEntity, ItemStack filterStack, int maxSpaceSize, int spaceAvailable, DustMagic incomingDust) {
        return 0;
    }

    @Override
    public void removeFilterQueueHandler(ItemStack filterStack) {
        CompoundTag compound = new CompoundTag();
        if (filterStack.m_41782_()) {
            compound = filterStack.m_41783_();
            for (int i = 0; i < 4; ++i) {
                if (!compound.m_128441_(this.getItemTransportMode(filterStack).stringTransferMode() + "_filterqueue")) continue;
                compound.m_128473_(this.getItemTransportMode(filterStack).stringTransferMode() + "_filterqueue");
                filterStack.m_41751_(compound);
            }
        }
    }

    @Override
    public int filterQueueSize(ItemStack filterStack, ITransferMode.ItemTransferMode mode) {
        CompoundTag getCompound;
        int filterQueueSize = 0;
        if (filterStack.m_41782_() && (getCompound = filterStack.m_41783_()).m_128441_(mode.stringTransferMode() + "_filterqueue")) {
            getCompound.m_128423_(mode.stringTransferMode() + "_filterqueue");
            ItemStackHandler handler = new ItemStackHandler();
            handler.deserializeNBT(getCompound);
            return handler.getSlots();
        }
        return filterQueueSize;
    }

    @Override
    public List<ItemStack> buildFilterQueue(Level world, BlockPos invBlock) {
        IItemHandler handler;
        ArrayList<ItemStack> filterQueue = new ArrayList<ItemStack>();
        LazyOptional<IItemHandler> cap = MowLibItemUtils.findItemHandlerAtPos(world, invBlock, true);
        if (cap.isPresent() && (handler = (IItemHandler)cap.orElse(null)) != null) {
            int range = handler.getSlots();
            for (int i = 0; i < range; ++i) {
                ItemStack stackInSlot = handler.getStackInSlot(i);
                if (stackInSlot.m_41619_()) continue;
                filterQueue.add(stackInSlot);
            }
        }
        return filterQueue;
    }

    @Override
    public void writeFilterQueueToNBT(ItemStack filterStack, List<ItemStack> builtFilterQueueList, ITransferMode.ItemTransferMode mode) {
        CompoundTag compound = new CompoundTag();
        CompoundTag compoundStorage = new CompoundTag();
        if (filterStack.m_41782_()) {
            compound = filterStack.m_41783_();
        }
        ItemStackHandler handler = new ItemStackHandler();
        handler.setSize(builtFilterQueueList.size());
        for (int i = 0; i < handler.getSlots(); ++i) {
            handler.setStackInSlot(i, builtFilterQueueList.get(i));
        }
        compoundStorage = handler.serializeNBT();
        compound.m_128365_(mode.stringTransferMode() + "_filterqueue", (Tag)compoundStorage);
        filterStack.m_41751_(compound);
    }

    @Override
    public List<ItemStack> readFilterQueueFromNBT(ItemStack filterStack, ITransferMode.ItemTransferMode mode) {
        CompoundTag getCompound;
        ArrayList<ItemStack> filterQueue = new ArrayList<ItemStack>();
        if (filterStack.m_41782_() && (getCompound = filterStack.m_41783_()).m_128441_(mode.stringTransferMode() + "_filterqueue")) {
            CompoundTag invTag = getCompound.m_128469_(mode.stringTransferMode() + "_filterqueue");
            ItemStackHandler handler = new ItemStackHandler();
            handler.deserializeNBT((Tag)invTag);
            for (int i = 0; i < handler.getSlots(); ++i) {
                filterQueue.add(handler.getStackInSlot(i));
            }
        }
        return filterQueue;
    }

    @Override
    public void writeFilterTypeToNBT(ItemStack filterStack, ITransferMode.ItemTransferMode mode) {
        CompoundTag compound = new CompoundTag();
        if (filterStack.m_41782_()) {
            compound = filterStack.m_41783_();
        }
        compound.m_128379_(mode.stringTransferMode() + "_filter_type", this.filterType);
        filterStack.m_41751_(compound);
    }

    @Override
    public boolean getFilterTypeFromNBT(ItemStack filterStack, ITransferMode.ItemTransferMode mode) {
        if (filterStack.m_41782_()) {
            CompoundTag getCompound = filterStack.m_41783_();
            this.filterType = getCompound.m_128471_(mode.stringTransferMode() + "_filter_type");
        }
        return this.filterType;
    }

    public boolean showFilterDirection() {
        return true;
    }

    @Override
    public void chatDetails(Player player, MowLibBaseBlockEntity pedestal, ItemStack filterStack) {
    }

    @NotNull
    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        List<ItemStack> stackCurrent = this.readFilterQueueFromNBT(stack, this.getItemTransportMode(stack));
        NonNullList nonnulllist = NonNullList.m_122779_();
        stackCurrent.forEach(arg_0 -> nonnulllist.add(arg_0));
        return Optional.of(new BundleTooltip(nonnulllist, nonnulllist.size() - 1));
    }

    public Component filterTypeTooltip(ITransferMode.ItemTransferMode mode, boolean filterType) {
        MutableComponent filterList = Component.m_237115_((String)"mowlib.filter_type");
        MutableComponent white = Component.m_237115_((String)"mowlib.filter_type_whitelist");
        MutableComponent black = Component.m_237115_((String)"mowlib.filter_type_blacklist");
        filterList.m_7220_((Component)(filterType ? black : white));
        filterList.m_130940_(ChatFormatting.WHITE);
        return filterList;
    }

    public Component filterModeTooltip(ITransferMode.ItemTransferMode mode, boolean filterType) {
        MutableComponent changed = Component.m_237115_((String)"mowlib.tooltip_mode");
        Component modeComponent = mode.componentTransferMode();
        changed.m_130940_(ChatFormatting.GOLD);
        changed.m_7220_(modeComponent);
        return changed;
    }

    public void m_7373_(ItemStack p_41421_, @Nullable Level p_41422_, List<Component> p_41423_, TooltipFlag p_41424_) {
        super.m_7373_(p_41421_, p_41422_, p_41423_, p_41424_);
        if (this.showFilterDirection()) {
            MutableComponent filterDirection = Component.m_237115_((String)"mowlib.filter.tooltip_filterdirection");
            filterDirection.m_7220_(this.getFilterDirection().componentDirection());
            p_41423_.add((Component)filterDirection);
        }
        boolean filterType = this.getFilterType(p_41421_, this.getItemTransportMode(p_41421_));
        if (this.canSetFilterType(this.getItemTransportMode(p_41421_))) {
            p_41423_.add(this.filterTypeTooltip(this.getItemTransportMode(p_41421_), filterType));
        }
        if (this.canSetFilterMode(this.getItemTransportMode(p_41421_))) {
            p_41423_.add(this.filterModeTooltip(this.getItemTransportMode(p_41421_), filterType));
        }
    }
}

