/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.mowlib.Items.Filters;

import com.mowmaster.mowlib.BlockEntities.MowLibBaseBlockEntity;
import com.mowmaster.mowlib.Items.Filters.BaseFilter;
import com.mowmaster.mowlib.Items.Filters.TagGetterItem;
import com.mowmaster.mowlib.MowLibUtils.MowLibMessageUtils;
import com.mowmaster.mowlib.Registry.DeferredRegisterItems;
import com.mowmaster.mowlib.api.TransportAndStorage.IFilterItem;
import com.mowmaster.mowlib.api.TransportAndStorage.ITransferMode;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class FilterTag
extends BaseFilter {
    public FilterTag(Item.Properties p_41383_) {
        super(p_41383_, IFilterItem.FilterDirection.INSERT);
    }

    @Override
    public boolean canModeUseInventoryAsFilter(ITransferMode.ItemTransferMode mode) {
        switch (mode) {
            case ITEMS: {
                return true;
            }
            case FLUIDS: {
                return true;
            }
            case ENERGY: {
                return false;
            }
            case EXPERIENCE: {
                return false;
            }
            case DUST: {
                return false;
            }
        }
        return false;
    }

    private static String[] decompose(String p_135833_, char p_135834_) {
        String[] astring = new String[]{"minecraft", p_135833_};
        int i = p_135833_.indexOf(p_135834_);
        if (i >= 0) {
            astring[1] = p_135833_.substring(i + 1, p_135833_.length());
            if (i >= 1) {
                astring[0] = p_135833_.substring(0, i);
            }
        }
        return astring;
    }

    protected ResourceLocation getLocationFromStringName(String input) {
        String strung = input.substring(1, input.length() - 1);
        return new ResourceLocation(strung);
    }

    @Override
    public boolean canAcceptItems(ItemStack filter, ItemStack incomingStack) {
        boolean filterBool = super.canAcceptItems(filter, incomingStack);
        List<ItemStack> stackCurrent = this.readFilterQueueFromNBT(filter, ITransferMode.ItemTransferMode.ITEMS);
        int range = stackCurrent.size();
        ItemStack itemFromInv = ItemStack.f_41583_;
        itemFromInv = IntStream.range(0, range).mapToObj(stackCurrent::get).filter(itemStack -> itemStack.m_41720_() instanceof TagGetterItem).filter(itemStack -> {
            TagGetterItem cfr_ignored_0 = (TagGetterItem)itemStack.m_41720_();
            return TagGetterItem.getSelectedTagString(itemStack) != "";
        }).filter(itemStack -> {
            TagGetterItem cfr_ignored_0 = (TagGetterItem)itemStack.m_41720_();
            return ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation(TagGetterItem.getSelectedTagString(itemStack)))).stream().toList().contains(incomingStack.m_41720_());
        }).findFirst().orElse(ItemStack.f_41583_);
        if (!itemFromInv.m_41619_()) {
            return filterBool;
        }
        return !filterBool;
    }

    @Override
    public boolean canAcceptFluids(ItemStack filter, FluidStack incomingFluidStack) {
        boolean filterBool = super.canAcceptFluids(filter, incomingFluidStack);
        List<ItemStack> stackCurrent = this.readFilterQueueFromNBT(filter, ITransferMode.ItemTransferMode.FLUIDS);
        int range = stackCurrent.size();
        ItemStack itemFromInv = ItemStack.f_41583_;
        itemFromInv = IntStream.range(0, range).mapToObj(stackCurrent::get).filter(itemStack -> itemStack.m_41720_() instanceof TagGetterItem).filter(itemStack -> {
            TagGetterItem cfr_ignored_0 = (TagGetterItem)itemStack.m_41720_();
            return TagGetterItem.getSelectedTagString(itemStack) != "";
        }).filter(itemStack -> {
            TagGetterItem cfr_ignored_0 = (TagGetterItem)itemStack.m_41720_();
            return ForgeRegistries.FLUIDS.tags().getTag(FluidTags.create((ResourceLocation)new ResourceLocation(TagGetterItem.getSelectedTagString(itemStack)))).stream().toList().contains(incomingFluidStack.getFluid());
        }).findFirst().orElse(ItemStack.f_41583_);
        if (!itemFromInv.m_41619_()) {
            return filterBool;
        }
        return !filterBool;
    }

    @Override
    public void chatDetails(Player player, MowLibBaseBlockEntity pedestal, ItemStack filterStack) {
        if (!filterStack.m_41720_().equals(DeferredRegisterItems.FILTER_BASE.get())) {
            MowLibMessageUtils.messagePlayerChatText(player, ChatFormatting.GOLD, filterStack.m_41611_().getString());
            for (ITransferMode.ItemTransferMode mode : ITransferMode.ItemTransferMode.values()) {
                List<ItemStack> filterQueue = this.readFilterQueueFromNBT(filterStack, mode);
                if (filterQueue.size() <= 0) continue;
                MowLibMessageUtils.messagePlayerChat(player, ChatFormatting.LIGHT_PURPLE, "mowlib.filters.tooltip_filterlist");
                for (int j = 0; j < filterQueue.size(); ++j) {
                    if (filterQueue.get(j).m_41619_()) continue;
                    MowLibMessageUtils.messagePlayerChatText(player, ChatFormatting.GRAY, filterQueue.get(j).m_41611_().getString());
                }
            }
        }
    }
}

