/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.mowlib.Items.Filters;

import com.mowmaster.mowlib.BlockEntities.MowLibBaseBlockEntity;
import com.mowmaster.mowlib.Items.Filters.BaseFilter;
import com.mowmaster.mowlib.MowLibUtils.MowLibFluidUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibMessageUtils;
import com.mowmaster.mowlib.Registry.DeferredRegisterItems;
import com.mowmaster.mowlib.api.TransportAndStorage.IFilterItem;
import com.mowmaster.mowlib.api.TransportAndStorage.ITransferMode;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class FilterMod
extends BaseFilter {
    public FilterMod(Item.Properties p_41383_) {
        super(p_41383_, IFilterItem.FilterDirection.INSERT);
    }

    @Override
    public boolean canModeUseInventoryAsFilter(ITransferMode.ItemTransferMode mode) {
        switch (mode) {
            case ITEMS: {
                return true;
            }
            case FLUIDS: {
                return true;
            }
            case ENERGY: {
                return false;
            }
            case EXPERIENCE: {
                return false;
            }
            case DUST: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean canAcceptItems(ItemStack filter, ItemStack incomingStack) {
        boolean filterBool = super.canAcceptItems(filter, incomingStack);
        List<ItemStack> stackCurrent = this.readFilterQueueFromNBT(filter, ITransferMode.ItemTransferMode.ITEMS);
        int range = stackCurrent.size();
        ItemStack itemFromInv = ItemStack.f_41583_;
        itemFromInv = IntStream.range(0, range).mapToObj(stackCurrent::get).filter(itemStack -> ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_()).m_135827_() == ForgeRegistries.ITEMS.getKey((Object)incomingStack.m_41720_()).m_135827_()).findFirst().orElse(ItemStack.f_41583_);
        if (!itemFromInv.m_41619_()) {
            return filterBool;
        }
        return !filterBool;
    }

    @Override
    public boolean canAcceptFluids(ItemStack filter, FluidStack incomingFluidStack) {
        boolean filterBool = super.canAcceptFluids(filter, incomingFluidStack);
        List<ItemStack> stackCurrent = this.readFilterQueueFromNBT(filter, ITransferMode.ItemTransferMode.FLUIDS);
        int range = stackCurrent.size();
        ItemStack itemFromInv = ItemStack.f_41583_;
        itemFromInv = IntStream.range(0, range).mapToObj(stackCurrent::get).filter(itemStack -> ForgeRegistries.FLUIDS.getKey((Object)MowLibFluidUtils.getFluidStackFromItemStack(itemStack).getFluid()).m_135827_() == ForgeRegistries.FLUIDS.getKey((Object)incomingFluidStack.getFluid()).m_135827_()).findFirst().orElse(ItemStack.f_41583_);
        if (!itemFromInv.m_41619_()) {
            return filterBool;
        }
        return !filterBool;
    }

    @Override
    public void chatDetails(Player player, MowLibBaseBlockEntity pedestal, ItemStack filterStack) {
        if (!filterStack.m_41720_().equals(DeferredRegisterItems.FILTER_BASE.get())) {
            MowLibMessageUtils.messagePlayerChatText(player, ChatFormatting.GOLD, filterStack.m_41611_().getString());
            for (ITransferMode.ItemTransferMode mode : ITransferMode.ItemTransferMode.values()) {
                List<ItemStack> filterQueue = this.readFilterQueueFromNBT(filterStack, mode);
                if (filterQueue.size() <= 0) continue;
                MowLibMessageUtils.messagePlayerChat(player, ChatFormatting.LIGHT_PURPLE, "mowlib.filters.tooltip_filterlist");
                for (int j = 0; j < filterQueue.size(); ++j) {
                    if (filterQueue.get(j).m_41619_()) continue;
                    MutableComponent enchants = Component.m_237113_((String)ForgeRegistries.ITEMS.getKey((Object)filterQueue.get(j).m_41720_()).m_135827_());
                    enchants.m_130940_(ChatFormatting.GRAY);
                    player.m_5661_((Component)enchants, false);
                }
            }
        }
    }
}

