/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.mowlib.Items.Filters;

import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.Items.Filters.BaseFilter;
import com.mowmaster.mowlib.MowLibUtils.MowLibFluidUtils;
import com.mowmaster.mowlib.api.TransportAndStorage.IFilterItem;
import com.mowmaster.mowlib.api.TransportAndStorage.ITransferMode;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class FilterItemMachine
extends BaseFilter {
    public FilterItemMachine(Item.Properties p_41383_) {
        super(p_41383_, IFilterItem.FilterDirection.NEUTRAL);
    }

    @Override
    public boolean canModeUseInventoryAsFilter(ITransferMode.ItemTransferMode mode) {
        switch (mode) {
            case ITEMS: {
                return true;
            }
            case FLUIDS: {
                return true;
            }
            case ENERGY: {
                return false;
            }
            case EXPERIENCE: {
                return false;
            }
            case DUST: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canAcceptItems(ItemStack filter, ItemStack incomingStack) {
        boolean filterBool = super.canAcceptItems(filter, incomingStack);
        List<ItemStack> stackCurrent = this.readFilterQueueFromNBT(filter, ITransferMode.ItemTransferMode.ITEMS);
        int range = stackCurrent.size();
        ItemStack itemFromInv = ItemStack.f_41583_;
        itemFromInv = IntStream.range(0, range).mapToObj(stackCurrent::get).filter(itemStack -> itemStack.m_41720_().equals(incomingStack.m_41720_())).findFirst().orElse(ItemStack.f_41583_);
        if (!itemFromInv.m_41619_()) {
            return filterBool;
        }
        return !filterBool;
    }

    @Override
    public boolean canAcceptFluids(ItemStack filter, FluidStack incomingFluidStack) {
        boolean filterBool = super.canAcceptFluids(filter, incomingFluidStack);
        List<ItemStack> stackCurrent = this.readFilterQueueFromNBT(filter, ITransferMode.ItemTransferMode.FLUIDS);
        int range = stackCurrent.size();
        ItemStack itemFromInv = ItemStack.f_41583_;
        itemFromInv = IntStream.range(0, range).mapToObj(stackCurrent::get).filter(itemStack -> !MowLibFluidUtils.getFluidStackFromItemStack(itemStack).isEmpty()).filter(itemStack -> MowLibFluidUtils.getFluidStackFromItemStack(itemStack).getFluid().equals(incomingFluidStack.getFluid())).findFirst().orElse(ItemStack.f_41583_);
        if (!itemFromInv.m_41619_()) {
            return filterBool;
        }
        return !filterBool;
    }

    @Override
    public boolean canAcceptDust(ItemStack filter, DustMagic incomingDust) {
        boolean filterBool = super.canAcceptDust(filter, incomingDust);
        List<ItemStack> stackCurrent = this.readFilterQueueFromNBT(filter, ITransferMode.ItemTransferMode.DUST);
        int range = stackCurrent.size();
        ItemStack itemFromInv = ItemStack.f_41583_;
        itemFromInv = IntStream.range(0, range).mapToObj(stackCurrent::get).filter(itemStack -> !DustMagic.getDustMagicInItemStack(itemStack).isEmpty()).filter(itemStack -> DustMagic.getDustMagicInItemStack(itemStack).isDustEqual(incomingDust)).findFirst().orElse(ItemStack.f_41583_);
        if (!itemFromInv.m_41619_()) {
            return filterBool;
        }
        return !filterBool;
    }
}

