/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.mowlib.Items.Filters;

import com.mowmaster.mowlib.BlockEntities.MowLibBaseBlockEntity;
import com.mowmaster.mowlib.Items.Filters.BaseFilter;
import com.mowmaster.mowlib.MowLibUtils.MowLibMessageUtils;
import com.mowmaster.mowlib.api.TransportAndStorage.IFilterItem;
import com.mowmaster.mowlib.api.TransportAndStorage.ITransferMode;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class FilterEnchantedFuzzy
extends BaseFilter {
    public FilterEnchantedFuzzy(Item.Properties p_41383_) {
        super(p_41383_, IFilterItem.FilterDirection.INSERT);
    }

    @Override
    public boolean canModeUseInventoryAsFilter(ITransferMode.ItemTransferMode mode) {
        switch (mode) {
            case ITEMS: {
                return true;
            }
            case FLUIDS: {
                return false;
            }
            case ENERGY: {
                return false;
            }
            case EXPERIENCE: {
                return false;
            }
            case DUST: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean canAcceptItems(ItemStack filter, ItemStack incomingStack) {
        boolean filterBool = super.canAcceptItems(filter, incomingStack);
        if (incomingStack.m_41793_() || incomingStack.m_41720_().equals(Items.f_42690_)) {
            List<ItemStack> stackCurrent = this.readFilterQueueFromNBT(filter, ITransferMode.ItemTransferMode.ITEMS);
            int range = stackCurrent.size();
            Map mapIncomming = EnchantmentHelper.m_44831_((ItemStack)incomingStack);
            for (Map.Entry entry : mapIncomming.entrySet()) {
                Enchantment enchantment = (Enchantment)entry.getKey();
                ItemStack itemFromInv = ItemStack.f_41583_;
                itemFromInv = IntStream.range(0, range).mapToObj(stackCurrent::get).filter(itemStack -> itemStack.m_41793_() || itemStack.m_41720_().equals(Items.f_42690_)).filter(itemStack -> EnchantmentHelper.m_44831_((ItemStack)itemStack).containsKey(enchantment)).findFirst().orElse(ItemStack.f_41583_);
                if (itemFromInv.m_41619_()) continue;
                return filterBool;
            }
        }
        return !filterBool;
    }

    @Override
    public void chatDetails(Player player, MowLibBaseBlockEntity pedestal, ItemStack filterStack) {
        MowLibMessageUtils.messagePlayerChatText(player, ChatFormatting.GOLD, filterStack.m_41611_().getString());
        List<ItemStack> filterQueue = this.readFilterQueueFromNBT(filterStack, this.getItemTransportMode(filterStack));
        if (filterQueue.size() > 0) {
            MowLibMessageUtils.messagePlayerChat(player, ChatFormatting.LIGHT_PURPLE, "mowlib.filters.tooltip_filterlist");
            for (int i = 0; i < filterQueue.size(); ++i) {
                if (!filterQueue.get(i).m_41619_()) {
                    Map mapIncomming = EnchantmentHelper.m_44831_((ItemStack)filterQueue.get(i));
                    for (Map.Entry entry : mapIncomming.entrySet()) {
                        MutableComponent enchants = Component.m_237113_((String)((Enchantment)entry.getKey()).m_44704_());
                        enchants.m_130940_(ChatFormatting.GRAY);
                        player.m_5661_((Component)enchants, false);
                    }
                }
                MutableComponent enchants = Component.m_237113_((String)"--------------------");
                enchants.m_130940_(ChatFormatting.GRAY);
                player.m_5661_((Component)enchants, false);
            }
        }
    }
}

