/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.mowlib.Items.Filters;

import com.mowmaster.mowlib.BlockEntities.MowLibBaseBlockEntity;
import com.mowmaster.mowlib.Items.Filters.BaseFilter;
import com.mowmaster.mowlib.MowLibUtils.MowLibMessageUtils;
import com.mowmaster.mowlib.api.TransportAndStorage.IFilterItem;
import com.mowmaster.mowlib.api.TransportAndStorage.ITransferMode;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class FilterEnchantCount
extends BaseFilter {
    public FilterEnchantCount(Item.Properties p_41383_) {
        super(p_41383_, IFilterItem.FilterDirection.INSERT);
    }

    @Override
    public boolean canModeUseInventoryAsFilter(ITransferMode.ItemTransferMode mode) {
        switch (mode) {
            case ITEMS: {
                return true;
            }
            case FLUIDS: {
                return false;
            }
            case ENERGY: {
                return false;
            }
            case EXPERIENCE: {
                return false;
            }
            case DUST: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean canAcceptItems(ItemStack filter, ItemStack incomingStack) {
        Map map;
        boolean filterBool = super.canAcceptItems(filter, incomingStack);
        List<ItemStack> stackCurrent = this.readFilterQueueFromNBT(filter, ITransferMode.ItemTransferMode.ITEMS);
        int count = stackCurrent.stream().filter(itemStack -> itemStack.m_41793_() || itemStack.m_41720_().equals(Items.f_42690_)).map(itemStack -> EnchantmentHelper.m_44831_((ItemStack)itemStack).size()).collect(Collectors.toList()).stream().reduce(0, (a, b) -> a + b);
        if (count > 0 && (incomingStack.m_41793_() || incomingStack.m_41720_().equals(Items.f_42690_)) && (map = EnchantmentHelper.m_44831_((ItemStack)incomingStack)).size() == count) {
            return filterBool;
        }
        return !filterBool;
    }

    @Override
    public void chatDetails(Player player, MowLibBaseBlockEntity pedestal, ItemStack filterStack) {
        MowLibMessageUtils.messagePlayerChatText(player, ChatFormatting.GOLD, filterStack.m_41611_().getString());
        MowLibMessageUtils.messagePlayerChat(player, ChatFormatting.LIGHT_PURPLE, "mowlib.filters.tooltip_filterlist_count");
        MutableComponent enchants = Component.m_237113_((String)"1");
        List<ItemStack> filterQueue = this.readFilterQueueFromNBT(filterStack, ITransferMode.ItemTransferMode.ITEMS);
        if (filterQueue.size() > 0) {
            int count = filterQueue.stream().filter(itemStack -> itemStack.m_41793_() || itemStack.m_41720_().equals(Items.f_42690_)).map(itemStack -> EnchantmentHelper.m_44831_((ItemStack)itemStack).size()).collect(Collectors.toList()).stream().reduce(0, (a, b) -> a + b);
            enchants = Component.m_237113_((String)("" + (count > 0 ? count : 1)));
        }
        enchants.m_130944_(new ChatFormatting[0]);
        player.m_5661_((Component)enchants, false);
    }
}

