/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.mowlib.Items.Filters;

import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.Items.Filters.BaseFilter;
import com.mowmaster.mowlib.MowLibUtils.MowLibFluidUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibMessageUtils;
import com.mowmaster.mowlib.api.TransportAndStorage.IFilterItem;
import com.mowmaster.mowlib.api.TransportAndStorage.ITransferMode;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.fluids.FluidStack;

public class FilterBlocksByClickFuzzy
extends BaseFilter {
    public FilterBlocksByClickFuzzy(Item.Properties p_41383_) {
        super(p_41383_, IFilterItem.FilterDirection.NEUTRAL);
    }

    @Override
    public boolean canModeUseInventoryAsFilter(ITransferMode.ItemTransferMode mode) {
        return false;
    }

    @Override
    public boolean canSetFilterType(ITransferMode.ItemTransferMode mode) {
        return true;
    }

    @Override
    public boolean canSetFilterMode(ITransferMode.ItemTransferMode mode) {
        return true;
    }

    @Override
    public boolean showFilterDirection() {
        return true;
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level p_41432_, Player p_41433_, InteractionHand p_41434_) {
        ItemStack itemInMainhand = p_41433_.m_21205_();
        ItemStack itemInOffhand = p_41433_.m_21206_();
        HitResult result = p_41433_.m_19907_(5.0, 0.0f, false);
        if (!p_41432_.m_5776_()) {
            if (itemInOffhand.m_41720_() instanceof IFilterItem && !(itemInMainhand.m_41720_() instanceof IFilterItem)) {
                if (result.m_6662_().equals((Object)HitResult.Type.MISS)) {
                    if (p_41433_.m_6144_()) {
                        this.setFilterMode(p_41433_, itemInOffhand, InteractionHand.OFF_HAND);
                    } else {
                        this.setFilterType(p_41433_, itemInOffhand);
                    }
                } else if (result.m_6662_().equals((Object)HitResult.Type.BLOCK) && p_41433_.m_6144_()) {
                    UseOnContext context = new UseOnContext(p_41433_, p_41434_, (BlockHitResult)result);
                    BlockHitResult res = new BlockHitResult(context.m_43720_(), context.m_8125_(), context.m_8083_(), false);
                    BlockPos posBlock = res.m_82425_();
                    ItemStack clickedBlock = p_41432_.m_8055_(posBlock).getCloneItemStack((HitResult)res, (BlockGetter)p_41432_, posBlock, p_41433_);
                    List<ItemStack> currentQueue = this.readFilterQueueFromNBT(itemInOffhand, this.getItemTransportMode(itemInOffhand));
                    int currentQueueSize = currentQueue.size();
                    if (!clickedBlock.m_41619_()) {
                        List<ItemStack> adjustedQueue = this.addNonMatchRemoveMatching(currentQueue, clickedBlock);
                        MowLibMessageUtils.messagePopup(p_41433_, this.getItemTransportMode(itemInOffhand).getModeColorFormat(), currentQueueSize < adjustedQueue.size() ? "mowlib.filter_changed_added" : "mowlib.filter_changed_removed");
                        this.writeFilterQueueToNBT(itemInOffhand, adjustedQueue, this.getItemTransportMode(itemInOffhand));
                    }
                }
            } else if (itemInOffhand.m_41720_() instanceof IFilterItem && itemInMainhand.m_41720_() instanceof IFilterItem) {
                MowLibMessageUtils.messagePopup(p_41433_, ChatFormatting.RED, "mowlib.filter.message_twohanded");
            }
        }
        return InteractionResultHolder.m_19100_((Object)p_41433_.m_21120_(p_41434_));
    }

    private List<ItemStack> addNonMatchRemoveMatching(List<ItemStack> list, ItemStack stackToCheck) {
        boolean canAdd = true;
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).m_41720_().equals(stackToCheck.m_41720_())) continue;
            list.remove(i);
            canAdd = false;
            break;
        }
        if (canAdd) {
            list.add(stackToCheck);
        }
        return list;
    }

    @Override
    public boolean canAcceptItems(ItemStack filter, ItemStack incomingStack) {
        boolean filterBool = super.canAcceptItems(filter, incomingStack);
        List<ItemStack> stackCurrent = this.readFilterQueueFromNBT(filter, ITransferMode.ItemTransferMode.ITEMS);
        int range = stackCurrent.size();
        ItemStack itemFromInv = ItemStack.f_41583_;
        itemFromInv = IntStream.range(0, range).mapToObj(stackCurrent::get).filter(itemStack -> itemStack.m_41720_().equals(incomingStack.m_41720_())).findFirst().orElse(ItemStack.f_41583_);
        if (!itemFromInv.m_41619_()) {
            return filterBool;
        }
        return !filterBool;
    }

    @Override
    public boolean canAcceptFluids(ItemStack filter, FluidStack incomingFluidStack) {
        boolean filterBool = super.canAcceptFluids(filter, incomingFluidStack);
        List<ItemStack> stackCurrent = this.readFilterQueueFromNBT(filter, ITransferMode.ItemTransferMode.FLUIDS);
        int range = stackCurrent.size();
        ItemStack itemFromInv = ItemStack.f_41583_;
        itemFromInv = IntStream.range(0, range).mapToObj(stackCurrent::get).filter(itemStack -> !MowLibFluidUtils.getFluidStackFromItemStack(itemStack).isEmpty()).filter(itemStack -> MowLibFluidUtils.getFluidStackFromItemStack(itemStack).getFluid().equals(incomingFluidStack.getFluid())).findFirst().orElse(ItemStack.f_41583_);
        if (!itemFromInv.m_41619_()) {
            return filterBool;
        }
        return !filterBool;
    }

    @Override
    public boolean canAcceptDust(ItemStack filter, DustMagic incomingDust) {
        boolean filterBool = super.canAcceptDust(filter, incomingDust);
        List<ItemStack> stackCurrent = this.readFilterQueueFromNBT(filter, ITransferMode.ItemTransferMode.DUST);
        int range = stackCurrent.size();
        ItemStack itemFromInv = ItemStack.f_41583_;
        itemFromInv = IntStream.range(0, range).mapToObj(stackCurrent::get).filter(itemStack -> !DustMagic.getDustMagicInItemStack(itemStack).isEmpty()).filter(itemStack -> DustMagic.getDustMagicInItemStack(itemStack).isDustEqual(incomingDust)).findFirst().orElse(ItemStack.f_41583_);
        if (!itemFromInv.m_41619_()) {
            return filterBool;
        }
        return !filterBool;
    }
}

