/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.mowlib.Items.Filters;

import com.mowmaster.mowlib.BlockEntities.MowLibBaseBlockEntity;
import com.mowmaster.mowlib.Capabilities.Dust.DustMagic;
import com.mowmaster.mowlib.Items.Filters.FilterRestricted;
import com.mowmaster.mowlib.Items.Filters.MowLibBaseFilter;
import com.mowmaster.mowlib.MowLibUtils.MowLibMessageUtils;
import com.mowmaster.mowlib.Registry.DeferredRegisterItems;
import com.mowmaster.mowlib.api.TransportAndStorage.IFilterItem;
import com.mowmaster.mowlib.api.TransportAndStorage.ITransferMode;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class BaseFilter
extends MowLibBaseFilter {
    public boolean filterType = false;
    public IFilterItem.FilterDirection filterableDirection;

    public BaseFilter(Item.Properties p_41383_, IFilterItem.FilterDirection direction) {
        super(p_41383_, direction);
        this.filterableDirection = direction;
    }

    @Override
    public int canAcceptCountItems(MowLibBaseBlockEntity filterableBlockEntity, ItemStack filterStack, int maxSpaceSize, int spaceAvailable, ItemStack itemStackIncoming) {
        List<ItemStack> stackCurrent = this.readFilterQueueFromNBT(filterStack, ITransferMode.ItemTransferMode.ITEMS);
        int range = stackCurrent.size();
        ItemStack itemFromInv = ItemStack.f_41583_;
        itemFromInv = IntStream.range(0, range).mapToObj(stackCurrent::get).filter(itemStack -> itemStack.m_41720_() instanceof FilterRestricted).findFirst().orElse(ItemStack.f_41583_);
        if (!itemFromInv.m_41619_()) {
            FilterRestricted filterRestricted = (FilterRestricted)itemFromInv.m_41720_();
            return filterRestricted.canAcceptCountItems(filterableBlockEntity, itemFromInv, itemStackIncoming.m_41741_(), spaceAvailable, itemStackIncoming);
        }
        return Math.min(spaceAvailable, itemStackIncoming.m_41741_());
    }

    @Override
    public int canAcceptCountFluids(MowLibBaseBlockEntity filterableBlockEntity, ItemStack filterStack, int maxSpaceSize, int spaceAvailable, FluidStack incomingFluidStack) {
        List<ItemStack> stackCurrent = this.readFilterQueueFromNBT(filterStack, ITransferMode.ItemTransferMode.FLUIDS);
        int range = stackCurrent.size();
        ItemStack itemFromInv = ItemStack.f_41583_;
        itemFromInv = IntStream.range(0, range).mapToObj(stackCurrent::get).filter(itemStack -> itemStack.m_41720_() instanceof FilterRestricted).findFirst().orElse(ItemStack.f_41583_);
        if (!itemFromInv.m_41619_()) {
            FilterRestricted filterRestricted = (FilterRestricted)itemFromInv.m_41720_();
            return filterRestricted.canAcceptCountFluids(filterableBlockEntity, itemFromInv, maxSpaceSize, spaceAvailable, incomingFluidStack);
        }
        return Math.min(spaceAvailable, incomingFluidStack.getAmount());
    }

    @Override
    public int canAcceptCountEnergy(MowLibBaseBlockEntity filterableBlockEntity, ItemStack filterStack, int maxSpaceSize, int spaceAvailable, int incomingEnergyAmount) {
        List<ItemStack> stackCurrent = this.readFilterQueueFromNBT(filterStack, ITransferMode.ItemTransferMode.ENERGY);
        int range = stackCurrent.size();
        ItemStack itemFromInv = ItemStack.f_41583_;
        itemFromInv = IntStream.range(0, range).mapToObj(stackCurrent::get).filter(itemStack -> itemStack.m_41720_() instanceof FilterRestricted).findFirst().orElse(ItemStack.f_41583_);
        if (!itemFromInv.m_41619_()) {
            FilterRestricted filterRestricted = (FilterRestricted)itemFromInv.m_41720_();
            return filterRestricted.canAcceptCountEnergy(filterableBlockEntity, itemFromInv, maxSpaceSize, spaceAvailable, incomingEnergyAmount);
        }
        return Math.min(spaceAvailable, incomingEnergyAmount);
    }

    @Override
    public int canAcceptCountExperience(MowLibBaseBlockEntity filterableBlockEntity, ItemStack filterStack, int maxSpaceSize, int spaceAvailable, int incomingExperienceAmount) {
        List<ItemStack> stackCurrent = this.readFilterQueueFromNBT(filterStack, ITransferMode.ItemTransferMode.EXPERIENCE);
        int range = stackCurrent.size();
        ItemStack itemFromInv = ItemStack.f_41583_;
        itemFromInv = IntStream.range(0, range).mapToObj(stackCurrent::get).filter(itemStack -> itemStack.m_41720_() instanceof FilterRestricted).findFirst().orElse(ItemStack.f_41583_);
        if (!itemFromInv.m_41619_()) {
            FilterRestricted filterRestricted = (FilterRestricted)itemFromInv.m_41720_();
            return filterRestricted.canAcceptCountExperience(filterableBlockEntity, itemFromInv, maxSpaceSize, spaceAvailable, incomingExperienceAmount);
        }
        return Math.min(spaceAvailable, incomingExperienceAmount);
    }

    @Override
    public int canAcceptCountDust(MowLibBaseBlockEntity filterableBlockEntity, ItemStack filterStack, int maxSpaceSize, int spaceAvailable, DustMagic incomingDust) {
        List<ItemStack> stackCurrent = this.readFilterQueueFromNBT(filterStack, ITransferMode.ItemTransferMode.DUST);
        int range = stackCurrent.size();
        ItemStack itemFromInv = ItemStack.f_41583_;
        itemFromInv = IntStream.range(0, range).mapToObj(stackCurrent::get).filter(itemStack -> itemStack.m_41720_() instanceof FilterRestricted).findFirst().orElse(ItemStack.f_41583_);
        if (!itemFromInv.m_41619_()) {
            FilterRestricted filterRestricted = (FilterRestricted)itemFromInv.m_41720_();
            return filterRestricted.canAcceptCountDust(filterableBlockEntity, itemFromInv, maxSpaceSize, spaceAvailable, incomingDust);
        }
        return Math.min(spaceAvailable, incomingDust.getDustAmount());
    }

    @Override
    public void chatDetails(Player player, MowLibBaseBlockEntity pedestal, ItemStack filterStack) {
        if (!filterStack.m_41720_().equals(DeferredRegisterItems.FILTER_BASE.get())) {
            ArrayList listed = new ArrayList();
            for (ITransferMode.ItemTransferMode mode : ITransferMode.ItemTransferMode.values()) {
                List<ItemStack> filterQueue = this.readFilterQueueFromNBT(filterStack, mode);
                if (filterQueue.size() <= 0) continue;
                MowLibMessageUtils.messagePlayerChat(player, ChatFormatting.LIGHT_PURPLE, "mowlib.filters.tooltip_filterlist");
                ArrayList<String> enchantList = new ArrayList<String>();
                for (int j = 0; j < filterQueue.size(); ++j) {
                    if (filterQueue.get(j).m_41619_()) continue;
                    if (j + 1 >= filterQueue.size()) {
                        enchantList.add(filterQueue.get(j).m_41611_().getString());
                        continue;
                    }
                    enchantList.add(filterQueue.get(j).m_41611_().getString() + ", ");
                }
                MowLibMessageUtils.messagePlayerChatWithAppend("mowlib", player, ChatFormatting.GRAY, filterStack.m_41611_().getString() + " |--->  ", enchantList);
            }
        } else {
            MowLibMessageUtils.messagePlayerChat(player, ChatFormatting.DARK_RED, "mowlib.baseItem");
        }
    }
}

